/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TextEditor {
    Display display;
    Shell shell;
    CoolBar coolBar;
    StyledText styledText;
    Label statusBar;
    ToolItem boldControl;
    ToolItem italicControl;
    ToolItem leftAlignmentItem;
    ToolItem centerAlignmentItem;
    ToolItem rightAlignmentItem;
    ToolItem justifyAlignmentItem;
    ToolItem blockSelectionItem;
    Combo fontNameControl;
    Combo fontSizeControl;
    MenuItem underlineSingleItem;
    MenuItem underlineDoubleItem;
    MenuItem underlineErrorItem;
    MenuItem underlineSquiggleItem;
    MenuItem borderSolidItem;
    MenuItem borderDashItem;
    MenuItem borderDotItem;
    boolean insert = true;
    StyleRange[] selectedRanges;
    int newCharCount;
    int start;
    String fileName = null;
    int styleState;
    String link;
    Image iBold;
    Image iItalic;
    Image iUnderline;
    Image iStrikeout;
    Image iLeftAlignment;
    Image iRightAlignment;
    Image iCenterAlignment;
    Image iJustifyAlignment;
    Image iCopy;
    Image iCut;
    Image iLink;
    Image iPaste;
    Image iSpacing;
    Image iIndent;
    Image iTextForeground;
    Image iTextBackground;
    Image iBaselineUp;
    Image iBaselineDown;
    Image iBulletList;
    Image iNumberedList;
    Image iBlockSelection;
    Image iBorderStyle;
    Font font;
    Font textFont;
    Color textForeground;
    Color textBackground;
    Color strikeoutColor;
    Color underlineColor;
    Color borderColor;
    static final int BULLET_WIDTH = 40;
    static final int MARGIN = 5;
    static final int BOLD = 1;
    static final int ITALIC = 2;
    static final int FONT_STYLE = 3;
    static final int STRIKEOUT = 8;
    static final int FOREGROUND = 16;
    static final int BACKGROUND = 32;
    static final int FONT = 64;
    static final int BASELINE_UP = 128;
    static final int BASELINE_DOWN = 256;
    static final int UNDERLINE_SINGLE = 512;
    static final int UNDERLINE_DOUBLE = 1024;
    static final int UNDERLINE_ERROR = 2048;
    static final int UNDERLINE_SQUIGGLE = 4096;
    static final int UNDERLINE_LINK = 8192;
    static final int UNDERLINE = 15872;
    static final int BORDER_SOLID = 0x800000;
    static final int BORDER_DASH = 0x1000000;
    static final int BORDER_DOT = 0x2000000;
    static final int BORDER = 0x3800000;
    static final boolean SAMPLE_TEXT = false;
    static final boolean USE_BASELINE = false;
    static final String[] FONT_SIZES = new String[]{"6", "8", "9", "10", "11", "12", "14", "24", "36", "48"};
    static final ResourceBundle resources = ResourceBundle.getBundle("examples_texteditor");

    static String getResourceString(String key) {
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        TextEditor editor = new TextEditor();
        Shell shell = editor.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        editor.releaseResources();
        display.dispose();
    }

    public TextEditor() {
    }

    public TextEditor(Display display) {
        this.open(display);
    }

    public Shell open(Display display) {
        this.display = display;
        this.initResources();
        this.shell = new Shell(display);
        this.shell.setText(TextEditor.getResourceString("Window_title"));
        this.styledText = new StyledText((Composite)this.shell, 2816);
        this.createMenuBar();
        this.createToolBar();
        this.createPopup();
        this.statusBar = new Label((Composite)this.shell, 0);
        this.installListeners();
        this.updateToolBar();
        this.updateStatusBar();
        this.shell.setSize(1000, 700);
        this.shell.open();
        return this.shell;
    }

    void addControl(Control control) {
        int offset = this.styledText.getCaretOffset();
        this.styledText.replaceTextRange(offset, 0, "\ufffc");
        StyleRange style = new StyleRange();
        Point size = control.computeSize(-1, -1);
        int ascent = 2 * size.y / 3;
        int descent = size.y - ascent;
        style.metrics = new GlyphMetrics(ascent + 5, descent + 5, size.x + 10);
        style.data = control;
        int[] ranges = new int[]{offset, 1};
        StyleRange[] styles = new StyleRange[]{style};
        this.styledText.setStyleRanges(0, 0, ranges, styles);
        control.setSize(size);
    }

    void addImage(Image image) {
        int offset = this.styledText.getCaretOffset();
        this.styledText.replaceTextRange(offset, 0, "\ufffc");
        StyleRange style = new StyleRange();
        Rectangle rect = image.getBounds();
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        style.data = image;
        int[] ranges = new int[]{offset, 1};
        StyleRange[] styles = new StyleRange[]{style};
        this.styledText.setStyleRanges(0, 0, ranges, styles);
    }

    void adjustFontSize(int increment) {
        int newIndex = this.fontSizeControl.getSelectionIndex() + increment;
        if (newIndex >= 0 && newIndex < this.fontSizeControl.getItemCount()) {
            String name = this.fontNameControl.getText();
            int size = Integer.parseInt(this.fontSizeControl.getItem(newIndex));
            this.disposeResource((Resource)this.textFont);
            this.textFont = new Font((Device)this.display, name, size, 0);
            this.setStyle(64);
            this.updateToolBar();
        }
    }

    void createMenuBar() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem fileItem = new MenuItem(menu, 64);
        Menu fileMenu = new Menu((Decorations)this.shell, 4);
        fileItem.setText(TextEditor.getResourceString("File_menuitem"));
        fileItem.setMenu(fileMenu);
        MenuItem openItem = new MenuItem(fileMenu, 8);
        openItem.setText(TextEditor.getResourceString("Open_menuitem"));
        openItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(TextEditor.this.shell, 4096);
                dialog.setFilterNames(new String[]{TextEditor.getResourceString("Text_Documents")});
                dialog.setFilterExtensions(new String[]{"*.txt"});
                String name = dialog.open();
                if (name == null) {
                    return;
                }
                TextEditor.this.fileName = name;
                FileInputStream file = null;
                try {
                    try {
                        file = new FileInputStream(name);
                        TextEditor.this.styledText.setText(TextEditor.this.openFile(file));
                    }
                    catch (IOException e) {
                        TextEditor.this.showError(TextEditor.getResourceString("Error"), e.getMessage());
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (IOException e2) {
                            TextEditor.this.showError(TextEditor.getResourceString("Error"), e2.getMessage());
                        }
                    }
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (IOException e) {
                        TextEditor.this.showError(TextEditor.getResourceString("Error"), e.getMessage());
                    }
                }
            }
        });
        final MenuItem saveItem = new MenuItem(fileMenu, 8);
        saveItem.setText(TextEditor.getResourceString("Save_menuitem"));
        saveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.saveFile();
            }
        });
        fileMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                saveItem.setEnabled(TextEditor.this.fileName != null);
            }
        });
        MenuItem saveAsItem = new MenuItem(fileMenu, 8);
        saveAsItem.setText(TextEditor.getResourceString("SaveAs_menuitem"));
        saveAsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String name;
                FileDialog dialog = new FileDialog(TextEditor.this.shell, 8192);
                dialog.setFilterNames(new String[]{TextEditor.getResourceString("Text_Documents")});
                dialog.setFilterExtensions(new String[]{"*.txt"});
                if (TextEditor.this.fileName != null) {
                    dialog.setFileName(TextEditor.this.fileName);
                }
                if ((name = dialog.open()) != null) {
                    TextEditor.this.fileName = name;
                    TextEditor.this.saveFile();
                }
            }
        });
        new MenuItem(fileMenu, 2);
        MenuItem exitItem = new MenuItem(fileMenu, 8);
        exitItem.setText(TextEditor.getResourceString("Exit_menuitem"));
        exitItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.shell.dispose();
            }
        });
        MenuItem editItem = new MenuItem(menu, 64);
        final Menu editMenu = new Menu((Decorations)this.shell, 4);
        editItem.setText(TextEditor.getResourceString("Edit_menuitem"));
        editItem.setMenu(editMenu);
        final MenuItem cutItem = new MenuItem(editMenu, 8);
        cutItem.setText(TextEditor.getResourceString("Cut_menuitem"));
        cutItem.setImage(this.iCut);
        cutItem.setAccelerator(SWT.MOD1 | 0x78);
        cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.cut();
            }
        });
        final MenuItem copyItem = new MenuItem(editMenu, 8);
        copyItem.setText(TextEditor.getResourceString("Copy_menuitem"));
        copyItem.setImage(this.iCopy);
        copyItem.setAccelerator(SWT.MOD1 | 0x63);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.copy();
            }
        });
        MenuItem pasteItem = new MenuItem(editMenu, 8);
        pasteItem.setText(TextEditor.getResourceString("Paste_menuitem"));
        pasteItem.setImage(this.iPaste);
        pasteItem.setAccelerator(SWT.MOD1 | 0x76);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.paste();
            }
        });
        new MenuItem(editMenu, 2);
        final MenuItem selectAllItem = new MenuItem(editMenu, 8);
        selectAllItem.setText(TextEditor.getResourceString("SelectAll_menuitem"));
        selectAllItem.setAccelerator(SWT.MOD1 | 0x61);
        selectAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.selectAll();
            }
        });
        editMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                int selectionCount = TextEditor.this.styledText.getSelectionCount();
                cutItem.setEnabled(selectionCount > 0);
                copyItem.setEnabled(selectionCount > 0);
                selectAllItem.setEnabled(selectionCount < TextEditor.this.styledText.getCharCount());
            }
        });
        MenuItem wrapItem = new MenuItem(editMenu, 32);
        wrapItem.setText(TextEditor.getResourceString("Wrap_menuitem"));
        wrapItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem item = (MenuItem)event.widget;
                boolean enabled = item.getSelection();
                TextEditor.this.styledText.setWordWrap(enabled);
                editMenu.getItem(6).setEnabled(enabled);
                editMenu.getItem(8).setEnabled(enabled);
                TextEditor.this.leftAlignmentItem.setEnabled(enabled);
                TextEditor.this.centerAlignmentItem.setEnabled(enabled);
                TextEditor.this.rightAlignmentItem.setEnabled(enabled);
                TextEditor.this.justifyAlignmentItem.setEnabled(enabled);
                TextEditor.this.blockSelectionItem.setEnabled(!enabled);
            }
        });
        MenuItem justifyItem = new MenuItem(editMenu, 32);
        justifyItem.setText(TextEditor.getResourceString("Justify_menuitem"));
        justifyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem item = (MenuItem)event.widget;
                TextEditor.this.styledText.setJustify(item.getSelection());
                TextEditor.this.updateToolBar();
            }
        });
        justifyItem.setEnabled(false);
        MenuItem setFontItem = new MenuItem(editMenu, 8);
        setFontItem.setText(TextEditor.getResourceString("SetFont_menuitem"));
        setFontItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog fontDialog = new FontDialog(TextEditor.this.shell);
                fontDialog.setFontList(TextEditor.this.styledText.getFont().getFontData());
                FontData data = fontDialog.open();
                if (data != null) {
                    Font newFont = new Font((Device)TextEditor.this.display, data);
                    TextEditor.this.styledText.setFont(newFont);
                    if (TextEditor.this.font != null) {
                        TextEditor.this.font.dispose();
                    }
                    TextEditor.this.font = newFont;
                    TextEditor.this.updateToolBar();
                }
            }
        });
        MenuItem alignmentItem = new MenuItem(editMenu, 64);
        alignmentItem.setText(TextEditor.getResourceString("Alignment_menuitem"));
        Menu alignmentMenu = new Menu((Decorations)this.shell, 4);
        alignmentItem.setMenu(alignmentMenu);
        MenuItem leftAlignmentItem = new MenuItem(alignmentMenu, 16);
        leftAlignmentItem.setText(TextEditor.getResourceString("Left_menuitem"));
        leftAlignmentItem.setSelection(true);
        leftAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.setAlignment(16384);
                TextEditor.this.updateToolBar();
            }
        });
        alignmentItem.setEnabled(false);
        MenuItem centerAlignmentItem = new MenuItem(alignmentMenu, 16);
        centerAlignmentItem.setText(TextEditor.getResourceString("Center_menuitem"));
        centerAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.setAlignment(0x1000000);
                TextEditor.this.updateToolBar();
            }
        });
        MenuItem rightAlignmentItem = new MenuItem(alignmentMenu, 16);
        rightAlignmentItem.setText(TextEditor.getResourceString("Right_menuitem"));
        rightAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.setAlignment(131072);
                TextEditor.this.updateToolBar();
            }
        });
        MenuItem editOrientationItem = new MenuItem(editMenu, 64);
        editOrientationItem.setText(TextEditor.getResourceString("Orientation_menuitem"));
        Menu editOrientationMenu = new Menu((Decorations)this.shell, 4);
        editOrientationItem.setMenu(editOrientationMenu);
        MenuItem leftToRightItem = new MenuItem(editOrientationMenu, 16);
        leftToRightItem.setText(TextEditor.getResourceString("LeftToRight_menuitem"));
        leftToRightItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.setOrientation(0x2000000);
            }
        });
        leftToRightItem.setSelection(true);
        MenuItem rightToLeftItem = new MenuItem(editOrientationMenu, 16);
        rightToLeftItem.setText(TextEditor.getResourceString("RightToLeft_menuitem"));
        rightToLeftItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.setOrientation(0x4000000);
            }
        });
        new MenuItem(editMenu, 2);
        MenuItem insertObjectItem = new MenuItem(editMenu, 64);
        insertObjectItem.setText(TextEditor.getResourceString("InsertObject_menuitem"));
        Menu insertObjectMenu = new Menu((Decorations)this.shell, 4);
        insertObjectItem.setMenu(insertObjectMenu);
        MenuItem insertControlItem = new MenuItem(insertObjectMenu, 64);
        insertControlItem.setText(TextEditor.getResourceString("Controls_menuitem"));
        Menu controlChoice = new Menu((Decorations)this.shell, 4);
        insertControlItem.setMenu(controlChoice);
        MenuItem buttonItem = new MenuItem(controlChoice, 8);
        buttonItem.setText(TextEditor.getResourceString("Button_menuitem"));
        MenuItem comboItem = new MenuItem(controlChoice, 8);
        comboItem.setText(TextEditor.getResourceString("Combo_menuitem"));
        buttonItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = new Button((Composite)TextEditor.this.styledText, 8);
                button.setText(TextEditor.getResourceString("Button_menuitem"));
                TextEditor.this.addControl((Control)button);
            }
        });
        comboItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Combo combo = new Combo((Composite)TextEditor.this.styledText, 0);
                combo.setText(TextEditor.getResourceString("Combo_menuitem"));
                TextEditor.this.addControl((Control)combo);
            }
        });
        MenuItem insertImageItem = new MenuItem(insertObjectMenu, 8);
        insertImageItem.setText(TextEditor.getResourceString("Image_menuitem"));
        insertImageItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(TextEditor.this.shell, 4096);
                String fileName = fileDialog.open();
                if (fileName != null) {
                    try {
                        Image image = new Image((Device)TextEditor.this.display, fileName);
                        TextEditor.this.addImage(image);
                    }
                    catch (Exception e) {
                        TextEditor.this.showError(TextEditor.getResourceString("Bad_image"), e.getMessage());
                    }
                }
            }
        });
    }

    void createPopup() {
        Menu menu = new Menu((Control)this.styledText);
        final MenuItem cutItem = new MenuItem(menu, 8);
        cutItem.setText(TextEditor.getResourceString("Cut_menuitem"));
        cutItem.setImage(this.iCut);
        cutItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TextEditor.this.styledText.cut();
            }
        });
        final MenuItem copyItem = new MenuItem(menu, 8);
        copyItem.setText(TextEditor.getResourceString("Copy_menuitem"));
        copyItem.setImage(this.iCopy);
        copyItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TextEditor.this.styledText.copy();
            }
        });
        MenuItem pasteItem = new MenuItem(menu, 8);
        pasteItem.setText(TextEditor.getResourceString("Paste_menuitem"));
        pasteItem.setImage(this.iPaste);
        pasteItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TextEditor.this.styledText.paste();
            }
        });
        new MenuItem(menu, 2);
        final MenuItem selectAllItem = new MenuItem(menu, 8);
        selectAllItem.setText(TextEditor.getResourceString("SelectAll_menuitem"));
        selectAllItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TextEditor.this.styledText.selectAll();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                int selectionCount = TextEditor.this.styledText.getSelectionCount();
                cutItem.setEnabled(selectionCount > 0);
                copyItem.setEnabled(selectionCount > 0);
                selectAllItem.setEnabled(selectionCount < TextEditor.this.styledText.getCharCount());
            }
        });
        this.styledText.setMenu(menu);
    }

    void createToolBar() {
        this.coolBar = new CoolBar((Composite)this.shell, 0x800000);
        ToolBar styleToolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.boldControl = new ToolItem(styleToolBar, 32);
        this.boldControl.setImage(this.iBold);
        this.boldControl.setToolTipText(TextEditor.getResourceString("Bold"));
        this.boldControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.setStyle(1);
            }
        });
        this.italicControl = new ToolItem(styleToolBar, 32);
        this.italicControl.setImage(this.iItalic);
        this.italicControl.setToolTipText(TextEditor.getResourceString("Italic"));
        this.italicControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.setStyle(2);
            }
        });
        final Menu underlineMenu = new Menu((Decorations)this.shell, 8);
        this.underlineSingleItem = new MenuItem(underlineMenu, 16);
        this.underlineSingleItem.setText(TextEditor.getResourceString("Single_menuitem"));
        this.underlineSingleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditor.this.underlineSingleItem.getSelection()) {
                    TextEditor.this.setStyle(512);
                }
            }
        });
        this.underlineSingleItem.setSelection(true);
        this.underlineDoubleItem = new MenuItem(underlineMenu, 16);
        this.underlineDoubleItem.setText(TextEditor.getResourceString("Double_menuitem"));
        this.underlineDoubleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditor.this.underlineDoubleItem.getSelection()) {
                    TextEditor.this.setStyle(1024);
                }
            }
        });
        this.underlineSquiggleItem = new MenuItem(underlineMenu, 16);
        this.underlineSquiggleItem.setText(TextEditor.getResourceString("Squiggle_menuitem"));
        this.underlineSquiggleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditor.this.underlineSquiggleItem.getSelection()) {
                    TextEditor.this.setStyle(4096);
                }
            }
        });
        this.underlineErrorItem = new MenuItem(underlineMenu, 16);
        this.underlineErrorItem.setText(TextEditor.getResourceString("Error_menuitem"));
        this.underlineErrorItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditor.this.underlineErrorItem.getSelection()) {
                    TextEditor.this.setStyle(2048);
                }
            }
        });
        MenuItem underlineColorItem = new MenuItem(underlineMenu, 8);
        underlineColorItem.setText(TextEditor.getResourceString("Color_menuitem"));
        underlineColorItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dialog = new ColorDialog(TextEditor.this.shell);
                RGB rgb = TextEditor.this.underlineColor != null ? TextEditor.this.underlineColor.getRGB() : null;
                dialog.setRGB(rgb);
                RGB newRgb = dialog.open();
                if (newRgb != null) {
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditor.this.disposeResource((Resource)TextEditor.this.underlineColor);
                        TextEditor.this.underlineColor = new Color((Device)TextEditor.this.display, newRgb);
                    }
                    if (TextEditor.this.underlineSingleItem.getSelection()) {
                        TextEditor.this.setStyle(512);
                    } else if (TextEditor.this.underlineDoubleItem.getSelection()) {
                        TextEditor.this.setStyle(1024);
                    } else if (TextEditor.this.underlineErrorItem.getSelection()) {
                        TextEditor.this.setStyle(2048);
                    } else if (TextEditor.this.underlineSquiggleItem.getSelection()) {
                        TextEditor.this.setStyle(4096);
                    }
                }
            }
        });
        final ToolItem underlineControl = new ToolItem(styleToolBar, 4);
        underlineControl.setImage(this.iUnderline);
        underlineControl.setToolTipText(TextEditor.getResourceString("Underline"));
        underlineControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    Rectangle rect = underlineControl.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    underlineMenu.setLocation(TextEditor.this.display.map((Control)underlineControl.getParent(), null, pt));
                    underlineMenu.setVisible(true);
                } else if (TextEditor.this.underlineSingleItem.getSelection()) {
                    TextEditor.this.setStyle(512);
                } else if (TextEditor.this.underlineDoubleItem.getSelection()) {
                    TextEditor.this.setStyle(1024);
                } else if (TextEditor.this.underlineErrorItem.getSelection()) {
                    TextEditor.this.setStyle(2048);
                } else if (TextEditor.this.underlineSquiggleItem.getSelection()) {
                    TextEditor.this.setStyle(4096);
                }
            }
        });
        ToolItem strikeoutControl = new ToolItem(styleToolBar, 4);
        strikeoutControl.setImage(this.iStrikeout);
        strikeoutControl.setToolTipText(TextEditor.getResourceString("Strikeout"));
        strikeoutControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    ColorDialog dialog = new ColorDialog(TextEditor.this.shell);
                    RGB rgb = TextEditor.this.strikeoutColor != null ? TextEditor.this.strikeoutColor.getRGB() : null;
                    dialog.setRGB(rgb);
                    RGB newRgb = dialog.open();
                    if (newRgb == null) {
                        return;
                    }
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditor.this.disposeResource((Resource)TextEditor.this.strikeoutColor);
                        TextEditor.this.strikeoutColor = new Color((Device)TextEditor.this.display, newRgb);
                    }
                }
                TextEditor.this.setStyle(8);
            }
        });
        final Menu borderMenu = new Menu((Decorations)this.shell, 8);
        this.borderSolidItem = new MenuItem(borderMenu, 16);
        this.borderSolidItem.setText(TextEditor.getResourceString("Solid"));
        this.borderSolidItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditor.this.borderSolidItem.getSelection()) {
                    TextEditor.this.setStyle(0x800000);
                }
            }
        });
        this.borderSolidItem.setSelection(true);
        this.borderDashItem = new MenuItem(borderMenu, 16);
        this.borderDashItem.setText(TextEditor.getResourceString("Dash"));
        this.borderDashItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditor.this.borderDashItem.getSelection()) {
                    TextEditor.this.setStyle(0x1000000);
                }
            }
        });
        this.borderDotItem = new MenuItem(borderMenu, 16);
        this.borderDotItem.setText(TextEditor.getResourceString("Dot"));
        this.borderDotItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditor.this.borderDotItem.getSelection()) {
                    TextEditor.this.setStyle(0x2000000);
                }
            }
        });
        MenuItem borderColorItem = new MenuItem(borderMenu, 8);
        borderColorItem.setText(TextEditor.getResourceString("Color_menuitem"));
        borderColorItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dialog = new ColorDialog(TextEditor.this.shell);
                RGB rgb = TextEditor.this.borderColor != null ? TextEditor.this.borderColor.getRGB() : null;
                dialog.setRGB(rgb);
                RGB newRgb = dialog.open();
                if (newRgb != null) {
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditor.this.disposeResource((Resource)TextEditor.this.borderColor);
                        TextEditor.this.borderColor = new Color((Device)TextEditor.this.display, newRgb);
                    }
                    if (TextEditor.this.borderDashItem.getSelection()) {
                        TextEditor.this.setStyle(0x1000000);
                    } else if (TextEditor.this.borderDotItem.getSelection()) {
                        TextEditor.this.setStyle(0x2000000);
                    } else if (TextEditor.this.borderSolidItem.getSelection()) {
                        TextEditor.this.setStyle(0x800000);
                    }
                }
            }
        });
        final ToolItem borderControl = new ToolItem(styleToolBar, 4);
        borderControl.setImage(this.iBorderStyle);
        borderControl.setToolTipText(TextEditor.getResourceString("Box"));
        borderControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    Rectangle rect = borderControl.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    borderMenu.setLocation(TextEditor.this.display.map((Control)borderControl.getParent(), null, pt));
                    borderMenu.setVisible(true);
                } else if (TextEditor.this.borderDashItem.getSelection()) {
                    TextEditor.this.setStyle(0x1000000);
                } else if (TextEditor.this.borderDotItem.getSelection()) {
                    TextEditor.this.setStyle(0x2000000);
                } else if (TextEditor.this.borderSolidItem.getSelection()) {
                    TextEditor.this.setStyle(0x800000);
                }
            }
        });
        ToolItem foregroundItem = new ToolItem(styleToolBar, 4);
        foregroundItem.setImage(this.iTextForeground);
        foregroundItem.setToolTipText(TextEditor.getResourceString("TextForeground"));
        foregroundItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4 || TextEditor.this.textForeground == null) {
                    ColorDialog dialog = new ColorDialog(TextEditor.this.shell);
                    RGB rgb = TextEditor.this.textForeground != null ? TextEditor.this.textForeground.getRGB() : null;
                    dialog.setRGB(rgb);
                    RGB newRgb = dialog.open();
                    if (newRgb == null) {
                        return;
                    }
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditor.this.disposeResource((Resource)TextEditor.this.textForeground);
                        TextEditor.this.textForeground = new Color((Device)TextEditor.this.display, newRgb);
                    }
                }
                TextEditor.this.setStyle(16);
            }
        });
        ToolItem backgroundItem = new ToolItem(styleToolBar, 4);
        backgroundItem.setImage(this.iTextBackground);
        backgroundItem.setToolTipText(TextEditor.getResourceString("TextBackground"));
        backgroundItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4 || TextEditor.this.textBackground == null) {
                    ColorDialog dialog = new ColorDialog(TextEditor.this.shell);
                    RGB rgb = TextEditor.this.textBackground != null ? TextEditor.this.textBackground.getRGB() : null;
                    dialog.setRGB(rgb);
                    RGB newRgb = dialog.open();
                    if (newRgb == null) {
                        return;
                    }
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditor.this.disposeResource((Resource)TextEditor.this.textBackground);
                        TextEditor.this.textBackground = new Color((Device)TextEditor.this.display, newRgb);
                    }
                }
                TextEditor.this.setStyle(32);
            }
        });
        ToolItem baselineUpItem = new ToolItem(styleToolBar, 8);
        baselineUpItem.setImage(this.iBaselineUp);
        String tooltip = "IncreaseFont";
        baselineUpItem.setToolTipText(TextEditor.getResourceString(tooltip));
        baselineUpItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.adjustFontSize(1);
            }
        });
        ToolItem baselineDownItem = new ToolItem(styleToolBar, 8);
        baselineDownItem.setImage(this.iBaselineDown);
        tooltip = "DecreaseFont";
        baselineDownItem.setToolTipText(TextEditor.getResourceString(tooltip));
        baselineDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.adjustFontSize(-1);
            }
        });
        ToolItem linkItem = new ToolItem(styleToolBar, 8);
        linkItem.setImage(this.iLink);
        linkItem.setToolTipText(TextEditor.getResourceString("Link"));
        linkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.setLink();
            }
        });
        CoolItem coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl((Control)styleToolBar);
        Composite composite = new Composite((Composite)this.coolBar, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 1;
        composite.setLayout((Layout)layout);
        this.fontNameControl = new Combo(composite, 12);
        this.fontNameControl.setItems(this.getFontNames());
        this.fontNameControl.setVisibleItemCount(12);
        this.fontSizeControl = new Combo(composite, 12);
        this.fontSizeControl.setItems(FONT_SIZES);
        this.fontSizeControl.setVisibleItemCount(8);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String name = TextEditor.this.fontNameControl.getText();
                int size = Integer.parseInt(TextEditor.this.fontSizeControl.getText());
                TextEditor.this.disposeResource((Resource)TextEditor.this.textFont);
                TextEditor.this.textFont = new Font((Device)TextEditor.this.display, name, size, 0);
                TextEditor.this.setStyle(64);
            }
        };
        this.fontSizeControl.addSelectionListener((SelectionListener)adapter);
        this.fontNameControl.addSelectionListener((SelectionListener)adapter);
        coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl((Control)composite);
        ToolBar alignmentToolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.blockSelectionItem = new ToolItem(alignmentToolBar, 32);
        this.blockSelectionItem.setImage(this.iBlockSelection);
        this.blockSelectionItem.setToolTipText(TextEditor.getResourceString("BlockSelection"));
        this.blockSelectionItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.styledText.invokeAction(0x100000A);
            }
        });
        this.leftAlignmentItem = new ToolItem(alignmentToolBar, 16);
        this.leftAlignmentItem.setImage(this.iLeftAlignment);
        this.leftAlignmentItem.setToolTipText(TextEditor.getResourceString("AlignLeft"));
        this.leftAlignmentItem.setSelection(true);
        this.leftAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Point selection = TextEditor.this.styledText.getSelection();
                int lineStart = TextEditor.this.styledText.getLineAtOffset(selection.x);
                int lineEnd = TextEditor.this.styledText.getLineAtOffset(selection.y);
                TextEditor.this.styledText.setLineAlignment(lineStart, lineEnd - lineStart + 1, 16384);
            }
        });
        this.leftAlignmentItem.setEnabled(false);
        this.centerAlignmentItem = new ToolItem(alignmentToolBar, 16);
        this.centerAlignmentItem.setImage(this.iCenterAlignment);
        this.centerAlignmentItem.setToolTipText(TextEditor.getResourceString("Center_menuitem"));
        this.centerAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Point selection = TextEditor.this.styledText.getSelection();
                int lineStart = TextEditor.this.styledText.getLineAtOffset(selection.x);
                int lineEnd = TextEditor.this.styledText.getLineAtOffset(selection.y);
                TextEditor.this.styledText.setLineAlignment(lineStart, lineEnd - lineStart + 1, 0x1000000);
            }
        });
        this.centerAlignmentItem.setEnabled(false);
        this.rightAlignmentItem = new ToolItem(alignmentToolBar, 16);
        this.rightAlignmentItem.setImage(this.iRightAlignment);
        this.rightAlignmentItem.setToolTipText(TextEditor.getResourceString("AlignRight"));
        this.rightAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Point selection = TextEditor.this.styledText.getSelection();
                int lineStart = TextEditor.this.styledText.getLineAtOffset(selection.x);
                int lineEnd = TextEditor.this.styledText.getLineAtOffset(selection.y);
                TextEditor.this.styledText.setLineAlignment(lineStart, lineEnd - lineStart + 1, 131072);
            }
        });
        this.rightAlignmentItem.setEnabled(false);
        this.justifyAlignmentItem = new ToolItem(alignmentToolBar, 32);
        this.justifyAlignmentItem.setImage(this.iJustifyAlignment);
        this.justifyAlignmentItem.setToolTipText(TextEditor.getResourceString("Justify"));
        this.justifyAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Point selection = TextEditor.this.styledText.getSelection();
                int lineStart = TextEditor.this.styledText.getLineAtOffset(selection.x);
                int lineEnd = TextEditor.this.styledText.getLineAtOffset(selection.y);
                TextEditor.this.styledText.setLineJustify(lineStart, lineEnd - lineStart + 1, TextEditor.this.justifyAlignmentItem.getSelection());
            }
        });
        this.justifyAlignmentItem.setEnabled(false);
        ToolItem bulletListItem = new ToolItem(alignmentToolBar, 8);
        bulletListItem.setImage(this.iBulletList);
        bulletListItem.setToolTipText(TextEditor.getResourceString("BulletList"));
        bulletListItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.setBullet(1);
            }
        });
        ToolItem numberedListItem = new ToolItem(alignmentToolBar, 8);
        numberedListItem.setImage(this.iNumberedList);
        numberedListItem.setToolTipText(TextEditor.getResourceString("NumberedList"));
        numberedListItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.setBullet(18);
            }
        });
        coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl((Control)alignmentToolBar);
        composite = new Composite((Composite)this.coolBar, 0);
        layout = new GridLayout(4, false);
        layout.marginHeight = 1;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(TextEditor.getResourceString("Indent"));
        Spinner indent = new Spinner(composite, 2048);
        indent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Spinner spinner = (Spinner)event.widget;
                TextEditor.this.styledText.setIndent(spinner.getSelection());
            }
        });
        label = new Label(composite, 0);
        label.setText(TextEditor.getResourceString("Spacing"));
        Spinner spacing = new Spinner(composite, 2048);
        spacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Spinner spinner = (Spinner)event.widget;
                TextEditor.this.styledText.setLineSpacing(spinner.getSelection());
            }
        });
        coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl((Control)composite);
        CoolItem[] coolItems = this.coolBar.getItems();
        int i = 0;
        while (i < coolItems.length) {
            CoolItem item = coolItems[i];
            Control control = item.getControl();
            Point size = control.computeSize(-1, -1);
            item.setMinimumSize(size);
            size = item.computeSize(size.x, size.y);
            item.setPreferredSize(size);
            item.setSize(size);
            ++i;
        }
        this.coolBar.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TextEditor.this.handleResize(event);
            }
        });
    }

    void disposeRanges(StyleRange[] ranges) {
        StyleRange[] allRanges = this.styledText.getStyleRanges(0, this.styledText.getCharCount(), false);
        int i = 0;
        while (i < ranges.length) {
            Object data;
            StyleRange style = ranges[i];
            boolean disposeFg = true;
            boolean disposeBg = true;
            boolean disposeStrike = true;
            boolean disposeUnder = true;
            boolean disposeBorder = true;
            boolean disposeFont = true;
            int j = 0;
            while (j < allRanges.length) {
                StyleRange s = allRanges[j];
                if (disposeFont && style.font == s.font) {
                    disposeFont = false;
                }
                if (disposeFg && style.foreground == s.foreground) {
                    disposeFg = false;
                }
                if (disposeBg && style.background == s.background) {
                    disposeBg = false;
                }
                if (disposeStrike && style.strikeoutColor == s.strikeoutColor) {
                    disposeStrike = false;
                }
                if (disposeUnder && style.underlineColor == s.underlineColor) {
                    disposeUnder = false;
                }
                if (disposeBorder && style.borderColor == s.borderColor) {
                    disposeBorder = false;
                }
                ++j;
            }
            if (disposeFont && style.font != this.textFont && style.font != null) {
                style.font.dispose();
            }
            if (disposeFg && style.foreground != this.textForeground && style.foreground != null) {
                style.foreground.dispose();
            }
            if (disposeBg && style.background != this.textBackground && style.background != null) {
                style.background.dispose();
            }
            if (disposeStrike && style.strikeoutColor != this.strikeoutColor && style.strikeoutColor != null) {
                style.strikeoutColor.dispose();
            }
            if (disposeUnder && style.underlineColor != this.underlineColor && style.underlineColor != null) {
                style.underlineColor.dispose();
            }
            if (disposeBorder && style.borderColor != this.borderColor && style.borderColor != null) {
                style.borderColor.dispose();
            }
            if ((data = style.data) != null) {
                if (data instanceof Image) {
                    ((Image)data).dispose();
                }
                if (data instanceof Control) {
                    ((Control)data).dispose();
                }
            }
            ++i;
        }
    }

    void disposeResource(Resource resource) {
        if (resource == null) {
            return;
        }
        StyleRange[] styles = this.styledText.getStyleRanges(0, this.styledText.getCharCount(), false);
        int index = 0;
        while (index < styles.length) {
            if (styles[index].font == resource || styles[index].foreground == resource || styles[index].background == resource || styles[index].strikeoutColor == resource || styles[index].underlineColor == resource || styles[index].borderColor == resource) break;
            ++index;
        }
        if (index == styles.length) {
            resource.dispose();
        }
    }

    String[] getFontNames() {
        FontData[] fontNames = this.display.getFontList(null, true);
        String[] names = new String[fontNames.length];
        int count = 0;
        int i = 0;
        while (i < fontNames.length) {
            block5: {
                String fontName = fontNames[i].getName();
                if (!fontName.startsWith("@")) {
                    int j = 0;
                    while (j < count) {
                        if (!names[j].equals(fontName)) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    names[count++] = fontName;
                }
            }
            ++i;
        }
        if (count < names.length) {
            String[] newNames = new String[count];
            System.arraycopy(names, 0, newNames, 0, count);
            names = newNames;
        }
        return names;
    }

    StyleRange[] getStyles(InputStream stream) {
        try {
            String line;
            StyleRange[] styles = new StyleRange[256];
            int count = 0;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                int blue;
                int green;
                int red;
                StringTokenizer tokenizer = new StringTokenizer(line, ";", false);
                StyleRange range = new StyleRange();
                range.start = Integer.parseInt(tokenizer.nextToken());
                range.length = Integer.parseInt(tokenizer.nextToken());
                range.fontStyle = Integer.parseInt(tokenizer.nextToken());
                range.strikeout = tokenizer.nextToken().equals("true");
                range.underline = tokenizer.nextToken().equals("true");
                if (tokenizer.hasMoreTokens()) {
                    red = Integer.parseInt(tokenizer.nextToken());
                    green = Integer.parseInt(tokenizer.nextToken());
                    blue = Integer.parseInt(tokenizer.nextToken());
                    range.foreground = new Color((Device)this.display, red, green, blue);
                }
                if (tokenizer.hasMoreTokens()) {
                    red = Integer.parseInt(tokenizer.nextToken());
                    green = Integer.parseInt(tokenizer.nextToken());
                    blue = Integer.parseInt(tokenizer.nextToken());
                    range.background = new Color((Device)this.display, red, green, blue);
                }
                if (count >= styles.length) {
                    StyleRange[] newStyles = new StyleRange[styles.length + 256];
                    System.arraycopy(styles, 0, newStyles, 0, styles.length);
                    styles = newStyles;
                }
                styles[count++] = range;
            }
            if (count < styles.length) {
                StyleRange[] newStyles = new StyleRange[count];
                System.arraycopy(styles, 0, newStyles, 0, count);
                styles = newStyles;
            }
            return styles;
        }
        catch (IOException e) {
            this.showError(TextEditor.getResourceString("Error"), e.getMessage());
            return null;
        }
    }

    void handleKeyDown(Event event) {
        if (event.keyCode == 0x1000009) {
            this.insert = !this.insert;
        }
    }

    void handleModify(ModifyEvent event) {
        if (this.newCharCount > 0 && this.start >= 0) {
            int borderStyle;
            int underlineStyle;
            StyleRange style = new StyleRange();
            if (this.textFont != null && !this.textFont.equals((Object)this.styledText.getFont())) {
                style.font = this.textFont;
            } else {
                style.fontStyle = 0;
                if (this.boldControl.getSelection()) {
                    style.fontStyle |= 1;
                }
                if (this.italicControl.getSelection()) {
                    style.fontStyle |= 2;
                }
            }
            if ((this.styleState & 0x10) != 0) {
                style.foreground = this.textForeground;
            }
            if ((this.styleState & 0x20) != 0) {
                style.background = this.textBackground;
            }
            if ((underlineStyle = this.styleState & 0x3E00) != 0) {
                style.underline = true;
                style.underlineColor = this.underlineColor;
                switch (underlineStyle) {
                    case 512: {
                        style.underlineStyle = 0;
                        break;
                    }
                    case 1024: {
                        style.underlineStyle = 1;
                        break;
                    }
                    case 4096: {
                        style.underlineStyle = 3;
                        break;
                    }
                    case 2048: {
                        style.underlineStyle = 2;
                        break;
                    }
                    case 8192: {
                        style.underlineColor = null;
                        if (this.link != null && this.link.length() > 0) {
                            style.underlineStyle = 4;
                            style.data = this.link;
                            break;
                        }
                        style.underline = false;
                    }
                }
            }
            if ((this.styleState & 8) != 0) {
                style.strikeout = true;
                style.strikeoutColor = this.strikeoutColor;
            }
            if ((borderStyle = this.styleState & 0x3800000) != 0) {
                style.borderColor = this.borderColor;
                switch (borderStyle) {
                    case 0x1000000: {
                        style.borderStyle = 2;
                        break;
                    }
                    case 0x2000000: {
                        style.borderStyle = 4;
                        break;
                    }
                    case 0x800000: {
                        style.borderStyle = 1;
                    }
                }
            }
            int[] ranges = new int[]{this.start, this.newCharCount};
            StyleRange[] styles = new StyleRange[]{style};
            this.styledText.setStyleRanges(this.start, this.newCharCount, ranges, styles);
        }
        this.disposeRanges(this.selectedRanges);
    }

    void handleMouseUp(Event event) {
        if (this.link != null) {
            StyleRange range;
            int offset = this.styledText.getCaretOffset();
            StyleRange styleRange = range = offset > 0 ? this.styledText.getStyleRangeAtOffset(offset - 1) : null;
            if (range != null && this.link == range.data) {
                Shell dialog = new Shell(this.shell);
                dialog.setLayout((Layout)new FillLayout());
                dialog.setText(TextEditor.getResourceString("Browser"));
                Browser browser = new Browser((Composite)dialog, 0);
                browser.setUrl(this.link);
                dialog.open();
            }
        }
    }

    void handlePaintObject(PaintObjectEvent event) {
        GC gc = event.gc;
        StyleRange style = event.style;
        Object data = style.data;
        if (data instanceof Image) {
            Image image = (Image)data;
            int x = event.x;
            int y = event.y + event.ascent - style.metrics.ascent;
            gc.drawImage(image, x, y);
        }
        if (data instanceof Control) {
            Control control = (Control)data;
            Point pt = control.getSize();
            int x = event.x + 5;
            int y = event.y + event.ascent - 2 * pt.y / 3;
            control.setLocation(x, y);
        }
    }

    void handleResize(ControlEvent event) {
        Rectangle rect = this.shell.getClientArea();
        Point cSize = this.coolBar.computeSize(rect.width, -1);
        Point sSize = this.statusBar.computeSize(-1, -1);
        int statusMargin = 2;
        this.coolBar.setBounds(rect.x, rect.y, cSize.x, cSize.y);
        this.styledText.setBounds(rect.x, rect.y + cSize.y, rect.width, rect.height - cSize.y - (sSize.y + 2 * statusMargin));
        this.statusBar.setBounds(rect.x + statusMargin, rect.y + rect.height - sSize.y - statusMargin, rect.width - 2 * statusMargin, sSize.y);
    }

    void handleVerifyText(VerifyEvent event) {
        this.start = event.start;
        this.newCharCount = event.text.length();
        int replaceCharCount = event.end - this.start;
        this.selectedRanges = this.styledText.getStyleRanges(this.start, replaceCharCount, false);
    }

    void initResources() {
        this.iBold = this.loadImage(this.display, "bold");
        this.iItalic = this.loadImage(this.display, "italic");
        this.iUnderline = this.loadImage(this.display, "underline");
        this.iStrikeout = this.loadImage(this.display, "strikeout");
        this.iBlockSelection = this.loadImage(this.display, "fullscrn");
        this.iBorderStyle = this.loadImage(this.display, "resize");
        this.iLeftAlignment = this.loadImage(this.display, "left");
        this.iRightAlignment = this.loadImage(this.display, "right");
        this.iCenterAlignment = this.loadImage(this.display, "center");
        this.iJustifyAlignment = this.loadImage(this.display, "justify");
        this.iCut = this.loadImage(this.display, "cut");
        this.iCopy = this.loadImage(this.display, "copy");
        this.iPaste = this.loadImage(this.display, "paste");
        this.iTextForeground = this.loadImage(this.display, "textForeground");
        this.iTextBackground = this.loadImage(this.display, "textBackground");
        this.iBaselineUp = this.loadImage(this.display, "font_big");
        this.iBaselineDown = this.loadImage(this.display, "font_sml");
        this.iBulletList = this.loadImage(this.display, "para_bul");
        this.iNumberedList = this.loadImage(this.display, "para_num");
        this.iLink = new Image((Device)this.display, this.getClass().getResourceAsStream("link_obj.gif"));
    }

    void installListeners() {
        this.styledText.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                TextEditor.this.updateStatusBar();
                TextEditor.this.updateToolBar();
            }
        });
        this.styledText.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                TextEditor.this.handleMouseUp(event);
            }
        });
        this.styledText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                TextEditor.this.handleKeyDown(event);
            }
        });
        this.styledText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                TextEditor.this.handleVerifyText(event);
            }
        });
        this.styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextEditor.this.handleModify(event);
            }
        });
        this.styledText.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                TextEditor.this.handlePaintObject(event);
            }
        });
        this.styledText.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                StyleRange[] styles = TextEditor.this.styledText.getStyleRanges(0, TextEditor.this.styledText.getCharCount(), false);
                int i = 0;
                while (i < styles.length) {
                    Object data = styles[i].data;
                    if (data != null) {
                        if (data instanceof Image) {
                            ((Image)data).dispose();
                        }
                        if (data instanceof Control) {
                            ((Control)data).dispose();
                        }
                    }
                    ++i;
                }
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TextEditor.this.handleResize(event);
            }
        });
    }

    Image loadImage(Display display, String fileName) {
        Image image = null;
        try {
            InputStream sourceStream = this.getClass().getResourceAsStream(String.valueOf(fileName) + ".ico");
            ImageData source = new ImageData(sourceStream);
            ImageData mask = source.getTransparencyMask();
            image = new Image((Device)display, source, mask);
            sourceStream.close();
        }
        catch (IOException e) {
            this.showError(TextEditor.getResourceString("Error"), e.getMessage());
        }
        return image;
    }

    void loadProfile(int profile) {
        try {
            switch (profile) {
                case 1: {
                    String text = this.openFile(TextEditor.class.getResourceAsStream("text.txt"));
                    StyleRange[] styles = this.getStyles(TextEditor.class.getResourceAsStream("styles.txt"));
                    this.styledText.setText(text);
                    if (styles == null) break;
                    this.styledText.setStyleRanges(styles);
                    break;
                }
                case 2: {
                    this.styledText.setText(TextEditor.getResourceString("Profile2"));
                    break;
                }
                case 3: {
                    String text = this.openFile(TextEditor.class.getResourceAsStream("text4.txt"));
                    this.styledText.setText(text);
                    break;
                }
                case 4: {
                    this.styledText.setText(TextEditor.getResourceString("Profile4"));
                }
            }
            this.updateToolBar();
        }
        catch (Exception e) {
            this.showError(TextEditor.getResourceString("Error"), e.getMessage());
        }
    }

    String openFile(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuffer buffer = new StringBuffer();
        String lineDelimiter = this.styledText.getLineDelimiter();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append(lineDelimiter);
        }
        return buffer.toString();
    }

    void releaseResources() {
        this.iBold.dispose();
        this.iBold = null;
        this.iItalic.dispose();
        this.iItalic = null;
        this.iUnderline.dispose();
        this.iUnderline = null;
        this.iStrikeout.dispose();
        this.iStrikeout = null;
        this.iBorderStyle.dispose();
        this.iBorderStyle = null;
        this.iBlockSelection.dispose();
        this.iBlockSelection = null;
        this.iLeftAlignment.dispose();
        this.iLeftAlignment = null;
        this.iRightAlignment.dispose();
        this.iRightAlignment = null;
        this.iCenterAlignment.dispose();
        this.iCenterAlignment = null;
        this.iJustifyAlignment.dispose();
        this.iJustifyAlignment = null;
        this.iCut.dispose();
        this.iCut = null;
        this.iCopy.dispose();
        this.iCopy = null;
        this.iPaste.dispose();
        this.iPaste = null;
        this.iTextForeground.dispose();
        this.iTextForeground = null;
        this.iTextBackground.dispose();
        this.iTextBackground = null;
        this.iBaselineUp.dispose();
        this.iBaselineUp = null;
        this.iBaselineDown.dispose();
        this.iBaselineDown = null;
        this.iBulletList.dispose();
        this.iBulletList = null;
        this.iNumberedList.dispose();
        this.iNumberedList = null;
        this.iLink.dispose();
        this.iLink = null;
        if (this.textFont != null) {
            this.textFont.dispose();
        }
        this.textFont = null;
        if (this.textForeground != null) {
            this.textForeground.dispose();
        }
        this.textForeground = null;
        if (this.textBackground != null) {
            this.textBackground.dispose();
        }
        this.textBackground = null;
        if (this.strikeoutColor != null) {
            this.strikeoutColor.dispose();
        }
        this.strikeoutColor = null;
        if (this.underlineColor != null) {
            this.underlineColor.dispose();
        }
        this.underlineColor = null;
        if (this.borderColor != null) {
            this.borderColor.dispose();
        }
        this.borderColor = null;
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = null;
    }

    void saveFile() {
        if (this.fileName != null) {
            FileWriter file = null;
            try {
                try {
                    file = new FileWriter(this.fileName);
                    file.write(this.styledText.getText());
                    file.close();
                }
                catch (IOException e) {
                    this.showError(TextEditor.getResourceString("Error"), e.getMessage());
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (IOException e2) {
                        this.showError(TextEditor.getResourceString("Error"), e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (IOException e) {
                    this.showError(TextEditor.getResourceString("Error"), e.getMessage());
                }
            }
        }
    }

    void setBullet(int type) {
        Point selection = this.styledText.getSelection();
        int lineStart = this.styledText.getLineAtOffset(selection.x);
        int lineEnd = this.styledText.getLineAtOffset(selection.y);
        StyleRange styleRange = new StyleRange();
        styleRange.metrics = new GlyphMetrics(0, 0, 40);
        Bullet bullet = new Bullet(type, styleRange);
        bullet.text = ".";
        int lineIndex = lineStart;
        while (lineIndex <= lineEnd) {
            Bullet oldBullet = this.styledText.getLineBullet(lineIndex);
            this.styledText.setLineBullet(lineIndex, 1, oldBullet != null ? null : bullet);
            ++lineIndex;
        }
    }

    void setLink() {
        final Shell dialog = new Shell(this.shell, 66800);
        dialog.setLayout((Layout)new GridLayout(2, false));
        dialog.setText(TextEditor.getResourceString("SetLink"));
        Label label = new Label((Composite)dialog, 0);
        label.setText(TextEditor.getResourceString("URL"));
        final Text text = new Text((Composite)dialog, 4);
        text.setLayoutData((Object)new GridData(200, -1));
        if (this.link != null) {
            text.setText(this.link);
            text.selectAll();
        }
        final Button okButton = new Button((Composite)dialog, 8);
        okButton.setText(TextEditor.getResourceString("Ok"));
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText(TextEditor.getResourceString("Cancel"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == okButton) {
                    TextEditor.this.link = text.getText();
                    TextEditor.this.setStyle(8192);
                }
                dialog.dispose();
            }
        };
        okButton.addListener(13, listener);
        cancelButton.addListener(13, listener);
        dialog.setDefaultButton(okButton);
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    void setStyle(int style) {
        int[] ranges = this.styledText.getSelectionRanges();
        int i = 0;
        while (i < ranges.length) {
            this.setStyle(style, ranges[i++], ranges[i++]);
        }
        this.updateStyleState(style, 16);
        this.updateStyleState(style, 32);
        this.updateStyleState(style, 15872);
        this.updateStyleState(style, 8);
        this.updateStyleState(style, 0x3800000);
    }

    void setStyle(int style, int start, int length) {
        if (length == 0) {
            return;
        }
        StyleRange newRange = new StyleRange();
        if ((style & 0x40) != 0) {
            newRange.font = this.textFont;
        }
        if ((style & 3) != 0) {
            newRange.fontStyle = style & 3;
        }
        if ((style & 0x10) != 0) {
            newRange.foreground = this.textForeground;
        }
        if ((style & 0x20) != 0) {
            newRange.background = this.textBackground;
        }
        if ((style & 0x80) != 0) {
            newRange.rise = newRange.rise + 1;
        }
        if ((style & 0x100) != 0) {
            newRange.rise = newRange.rise - 1;
        }
        if ((style & 8) != 0) {
            newRange.strikeout = true;
            newRange.strikeoutColor = this.strikeoutColor;
        }
        if ((style & 0x3E00) != 0) {
            newRange.underline = true;
            newRange.underlineColor = this.underlineColor;
            switch (style & 0x3E00) {
                case 512: {
                    newRange.underlineStyle = 0;
                    break;
                }
                case 1024: {
                    newRange.underlineStyle = 1;
                    break;
                }
                case 2048: {
                    newRange.underlineStyle = 2;
                    break;
                }
                case 4096: {
                    newRange.underlineStyle = 3;
                    break;
                }
                case 8192: {
                    newRange.underlineColor = null;
                    if (this.link != null && this.link.length() > 0) {
                        newRange.underlineStyle = 4;
                        newRange.data = this.link;
                        break;
                    }
                    newRange.underline = false;
                }
            }
        }
        if ((style & 0x3800000) != 0) {
            switch (style & 0x3800000) {
                case 0x1000000: {
                    newRange.borderStyle = 2;
                    break;
                }
                case 0x2000000: {
                    newRange.borderStyle = 4;
                    break;
                }
                case 0x800000: {
                    newRange.borderStyle = 1;
                }
            }
            newRange.borderColor = this.borderColor;
        }
        int newRangeStart = start;
        int newRangeLength = length;
        int[] ranges = this.styledText.getRanges(start, length);
        StyleRange[] styles = this.styledText.getStyleRanges(start, length, false);
        int maxCount = ranges.length * 2 + 2;
        int[] newRanges = new int[maxCount];
        StyleRange[] newStyles = new StyleRange[maxCount / 2];
        int count = 0;
        int i = 0;
        while (i < ranges.length) {
            int rangeStart = ranges[i];
            int rangeLength = ranges[i + 1];
            StyleRange range = styles[i / 2];
            if (rangeStart > newRangeStart) {
                newRangeLength = rangeStart - newRangeStart;
                newRanges[count] = newRangeStart;
                newRanges[count + 1] = newRangeLength;
                newStyles[count / 2] = newRange;
                count += 2;
            }
            newRangeStart = rangeStart + rangeLength;
            newRangeLength = start + length - newRangeStart;
            StyleRange mergedRange = new StyleRange((TextStyle)range);
            mergedRange.fontStyle = range.fontStyle;
            if ((style & 0x40) != 0) {
                mergedRange.font = newRange.font;
            }
            if ((style & 3) != 0) {
                mergedRange.fontStyle = range.fontStyle ^ newRange.fontStyle;
            }
            if (mergedRange.font != null && ((style & 0x40) != 0 || (style & 3) != 0)) {
                boolean change = false;
                FontData[] fds = mergedRange.font.getFontData();
                int j = 0;
                while (j < fds.length) {
                    FontData fd = fds[j];
                    if (fd.getStyle() != mergedRange.fontStyle) {
                        fds[j].setStyle(mergedRange.fontStyle);
                        change = true;
                    }
                    ++j;
                }
                if (change) {
                    mergedRange.font = new Font((Device)this.display, fds);
                }
            }
            if ((style & 0x10) != 0) {
                Color color = mergedRange.foreground = newRange.foreground != range.foreground ? newRange.foreground : null;
            }
            if ((style & 0x20) != 0) {
                Color color = mergedRange.background = newRange.background != range.background ? newRange.background : null;
            }
            if ((style & 0x80) != 0) {
                mergedRange.rise = mergedRange.rise + 1;
            }
            if ((style & 0x100) != 0) {
                mergedRange.rise = mergedRange.rise - 1;
            }
            if ((style & 8) != 0) {
                mergedRange.strikeout = !range.strikeout || range.strikeoutColor != newRange.strikeoutColor;
                Color color = mergedRange.strikeoutColor = mergedRange.strikeout ? newRange.strikeoutColor : null;
            }
            if ((style & 0x3E00) != 0) {
                if ((style & 0x2000) != 0) {
                    mergedRange.underline = this.link != null && this.link.length() > 0 ? !range.underline || range.underlineStyle != newRange.underlineStyle || range.data != newRange.data : false;
                    mergedRange.underlineColor = null;
                } else {
                    mergedRange.underline = !range.underline || range.underlineStyle != newRange.underlineStyle || range.underlineColor != newRange.underlineColor;
                    mergedRange.underlineColor = mergedRange.underline ? newRange.underlineColor : null;
                }
                mergedRange.underlineStyle = mergedRange.underline ? newRange.underlineStyle : 0;
                Object object = mergedRange.data = mergedRange.underline ? newRange.data : null;
            }
            if ((style & 0x3800000) != 0) {
                if (range.borderStyle != newRange.borderStyle || range.borderColor != newRange.borderColor) {
                    mergedRange.borderStyle = newRange.borderStyle;
                    mergedRange.borderColor = newRange.borderColor;
                } else {
                    mergedRange.borderStyle = 0;
                    mergedRange.borderColor = null;
                }
            }
            newRanges[count] = rangeStart;
            newRanges[count + 1] = rangeLength;
            newStyles[count / 2] = mergedRange;
            count += 2;
            i += 2;
        }
        if (newRangeLength > 0) {
            newRanges[count] = newRangeStart;
            newRanges[count + 1] = newRangeLength;
            newStyles[count / 2] = newRange;
            count += 2;
        }
        if (count > 0 && count < maxCount) {
            int[] tmpRanges = new int[count];
            StyleRange[] tmpStyles = new StyleRange[count / 2];
            System.arraycopy(newRanges, 0, tmpRanges, 0, count);
            System.arraycopy(newStyles, 0, tmpStyles, 0, count / 2);
            newRanges = tmpRanges;
            newStyles = tmpStyles;
        }
        this.styledText.setStyleRanges(start, length, newRanges, newStyles);
        this.disposeRanges(styles);
    }

    void showError(String title, String message) {
        MessageBox messageBox = new MessageBox(this.shell, 65);
        messageBox.setText(title);
        messageBox.setMessage(message);
        messageBox.open();
    }

    void updateStatusBar() {
        int offset = this.styledText.getCaretOffset();
        int lineIndex = this.styledText.getLineAtOffset(offset);
        String insertLabel = TextEditor.getResourceString(this.insert ? "Insert" : "Overwrite");
        this.statusBar.setText(String.valueOf(TextEditor.getResourceString("Offset")) + offset + " " + TextEditor.getResourceString("Line") + lineIndex + "\t" + insertLabel);
    }

    void updateStyleState(int style, int changingStyle) {
        if ((style & changingStyle) != 0) {
            if ((style & changingStyle) == (this.styleState & changingStyle)) {
                this.styleState &= ~changingStyle;
            } else {
                this.styleState &= ~changingStyle;
                this.styleState |= style;
            }
        }
    }

    void updateToolBar() {
        StyleRange range;
        this.styleState = 0;
        this.link = null;
        boolean bold = false;
        boolean italic = false;
        Font font = null;
        int offset = this.styledText.getCaretOffset();
        StyleRange styleRange = range = offset > 0 ? this.styledText.getStyleRangeAtOffset(offset - 1) : null;
        if (range != null) {
            if (range.font != null) {
                font = range.font;
                FontData[] fds = font.getFontData();
                int i = 0;
                while (i < fds.length) {
                    int fontStyle = fds[i].getStyle();
                    if (!bold && (fontStyle & 1) != 0) {
                        bold = true;
                    }
                    if (!italic && (fontStyle & 2) != 0) {
                        italic = true;
                    }
                    ++i;
                }
            } else {
                bold = (range.fontStyle & 1) != 0;
                boolean bl = italic = (range.fontStyle & 2) != 0;
            }
            if (range.foreground != null) {
                this.styleState |= 0x10;
                if (this.textForeground != range.foreground) {
                    this.disposeResource((Resource)this.textForeground);
                    this.textForeground = range.foreground;
                }
            }
            if (range.background != null) {
                this.styleState |= 0x20;
                if (this.textBackground != range.background) {
                    this.disposeResource((Resource)this.textBackground);
                    this.textBackground = range.background;
                }
            }
            if (range.underline) {
                switch (range.underlineStyle) {
                    case 0: {
                        this.styleState |= 0x200;
                        break;
                    }
                    case 1: {
                        this.styleState |= 0x400;
                        break;
                    }
                    case 3: {
                        this.styleState |= 0x1000;
                        break;
                    }
                    case 2: {
                        this.styleState |= 0x800;
                        break;
                    }
                    case 4: {
                        this.styleState |= 0x2000;
                        this.link = (String)range.data;
                    }
                }
                if (range.underlineStyle != 4) {
                    this.underlineSingleItem.setSelection((this.styleState & 0x200) != 0);
                    this.underlineDoubleItem.setSelection((this.styleState & 0x400) != 0);
                    this.underlineErrorItem.setSelection((this.styleState & 0x800) != 0);
                    this.underlineSquiggleItem.setSelection((this.styleState & 0x1000) != 0);
                    this.disposeResource((Resource)this.underlineColor);
                    this.underlineColor = range.underlineColor;
                }
            }
            if (range.strikeout) {
                this.styleState |= 8;
                this.disposeResource((Resource)this.strikeoutColor);
                this.strikeoutColor = range.strikeoutColor;
            }
            if (range.borderStyle != 0) {
                switch (range.borderStyle) {
                    case 1: {
                        this.styleState |= 0x800000;
                        break;
                    }
                    case 2: {
                        this.styleState |= 0x1000000;
                        break;
                    }
                    case 4: {
                        this.styleState |= 0x2000000;
                    }
                }
                this.borderSolidItem.setSelection((this.styleState & 0x800000) != 0);
                this.borderDashItem.setSelection((this.styleState & 0x1000000) != 0);
                this.borderDotItem.setSelection((this.styleState & 0x2000000) != 0);
                this.disposeResource((Resource)this.borderColor);
                this.borderColor = range.borderColor;
            }
        }
        this.boldControl.setSelection(bold);
        this.italicControl.setSelection(italic);
        FontData fontData = font != null ? font.getFontData()[0] : this.styledText.getFont().getFontData()[0];
        int index = 0;
        int count = this.fontNameControl.getItemCount();
        String fontName = fontData.getName();
        while (index < count) {
            if (this.fontNameControl.getItem(index).equals(fontName)) {
                this.fontNameControl.select(index);
                break;
            }
            ++index;
        }
        index = 0;
        count = this.fontSizeControl.getItemCount();
        int fontSize = fontData.getHeight();
        while (index < count) {
            int size = Integer.parseInt(this.fontSizeControl.getItem(index));
            if (fontSize == size) {
                this.fontSizeControl.select(index);
                break;
            }
            if (size > fontSize) {
                this.fontSizeControl.add(String.valueOf(fontSize), index);
                this.fontSizeControl.select(index);
                break;
            }
            ++index;
        }
        this.disposeResource((Resource)this.textFont);
        this.textFont = font;
        int lineIndex = this.styledText.getLineAtOffset(offset);
        int alignment = this.styledText.getLineAlignment(lineIndex);
        this.leftAlignmentItem.setSelection((alignment & 0x4000) != 0);
        this.centerAlignmentItem.setSelection((alignment & 0x1000000) != 0);
        this.rightAlignmentItem.setSelection((alignment & 0x20000) != 0);
        boolean justify = this.styledText.getLineJustify(lineIndex);
        this.justifyAlignmentItem.setSelection(justify);
    }
}

