/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.handlers;

import java.util.List;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Program;
import org.eclipse.apogy.core.invocator.ProgramRuntimeState;
import org.eclipse.apogy.core.invocator.ProgramSettings;
import org.eclipse.apogy.core.invocator.ui.handlers.AbstractProgramRuntimeHandler;
import org.eclipse.apogy.core.invocator.ui.parts.ProgramPart;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StepOverProgramRuntimeHandler
extends AbstractProgramRuntimeHandler {
    @Execute
    public void execute(MPart part, ECommandService commandService, EHandlerService handlerService) {
        ProgramPart programPart = (ProgramPart)((Object)((PartImpl)part).getObject());
        Program program = programPart.getSelectedProgram();
        List<AbstractProgramRuntime> runtimes = programPart.getRuntimes();
        if (runtimes.size() > 0) {
            int i = runtimes.size() - 1;
            while (i >= 0) {
                AbstractProgramRuntime runtime = runtimes.get(i);
                if (runtime.getProgram() == program) {
                    runtime.stepOver();
                    break;
                }
                --i;
            }
        } else {
            ProgramSettings programSettings = null;
            AbstractProgramRuntime programRuntime = this.createAbstractProgramRuntime(program, programSettings);
            if (programRuntime != null) {
                programPart.newRuntime(programRuntime);
                programRuntime.init();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)programRuntime, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.SUSPENDED);
                programRuntime.stepOver();
            }
        }
    }

    @Override
    @CanExecute
    public boolean canExecute(MPart part) {
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() == null || ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment() == null || ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getActiveContext() == null || !ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getActiveContext().isVariablesInstantiated()) {
            return false;
        }
        if (part instanceof PartImpl && ((PartImpl)part).getObject() instanceof ProgramPart) {
            ProgramPart programPart = (ProgramPart)((Object)((PartImpl)part).getObject());
            Program program = programPart.getSelectedProgram();
            return program != null;
        }
        return false;
    }
}

