/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.handlers;

import java.util.List;
import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Program;
import org.eclipse.apogy.core.invocator.ProgramRuntimeState;
import org.eclipse.apogy.core.invocator.ui.handlers.AbstractProgramRuntimeHandler;
import org.eclipse.apogy.core.invocator.ui.parts.ProgramPart;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartImpl;

public class TerminateProgramRuntimeHandler
extends AbstractProgramRuntimeHandler {
    @Execute
    public void execute(MPart part) {
        ProgramPart programPart = (ProgramPart)((Object)((PartImpl)part).getObject());
        Program program = programPart.getSelectedProgram();
        List<AbstractProgramRuntime> runtimes = programPart.getRuntimes();
        if (runtimes.size() > 0) {
            int i = runtimes.size() - 1;
            while (i >= 0) {
                AbstractProgramRuntime runtime = runtimes.get(i);
                if (runtime.getProgram() == program) {
                    runtime.terminate();
                    break;
                }
                --i;
            }
        }
    }

    @Override
    @CanExecute
    public boolean canExecute(MPart part) {
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() == null) {
            return false;
        }
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList() == null) {
            return false;
        }
        if (part instanceof PartImpl && ((PartImpl)part).getObject() instanceof ProgramPart) {
            ProgramPart programPart = (ProgramPart)((Object)((PartImpl)part).getObject());
            Program program = programPart.getSelectedProgram();
            if (program == null) {
                return false;
            }
            for (AbstractProgramRuntime runtime : programPart.getRuntimes()) {
                if (programPart.getRuntimes().indexOf(runtime) != programPart.getRuntimes().size() - 1 || runtime.getProgram() != program || runtime.getState() == ProgramRuntimeState.RUNNING_TERMINATED) continue;
                return true;
            }
        }
        return false;
    }
}

