/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.parts.AbstractEObjectSelectionPart;
import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.core.invocator.OperationCallsListProgramRuntime;
import org.eclipse.apogy.core.invocator.Program;
import org.eclipse.apogy.core.invocator.ProgramRuntimeState;
import org.eclipse.apogy.core.invocator.ui.ProgramUIFactoriesRegistry;
import org.eclipse.apogy.core.invocator.ui.ProgramUIFactory;
import org.eclipse.apogy.core.invocator.ui.composites.OperationCallsListComposite;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public class ProgramPart
extends AbstractEObjectSelectionPart
implements org.eclipse.ui.ISelectionListener {
    List<AbstractProgramRuntime> runtimes;
    private Adapter runtimeAdapter;
    @Inject
    private IEventBroker broker;
    private Program selectedProgram = null;
    private Composite top;

    protected void createContentComposite(Composite parent, int style) {
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)new FillLayout());
    }

    protected void setCompositeContents(EObject eObject) {
        if (this.runtimes != null) {
            for (AbstractProgramRuntime runtime : this.runtimes) {
                runtime.eAdapters().remove((Object)this.getRuntimeAdapter());
            }
        }
        this.runtimes.clear();
        if (!this.top.isDisposed()) {
            Control[] controlArray = this.top.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++n2;
            }
        }
        if (eObject instanceof Program) {
            this.selectedProgram = (Program)eObject;
            ProgramUIFactory programUIFactory = ProgramUIFactoriesRegistry.INSTANCE.getFactory(this.selectedProgram.eClass());
            if (programUIFactory != null) {
                programUIFactory.createProgramComposite(this.top, (Program)eObject, this);
                if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList() == null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__PROGRAM_RUNTIMES_LIST, (Object)ApogyCoreInvocatorFactory.eINSTANCE.createProgramRuntimesList());
                }
                for (AbstractProgramRuntime runtime : ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList().getProgramRuntimes()) {
                    if (runtime.getProgram() != eObject) continue;
                    this.newRuntime(runtime);
                }
                if (!this.runtimes.isEmpty()) {
                    AbstractProgramRuntime runtime;
                    runtime = this.runtimes.get(this.runtimes.size() - 1);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)runtime, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)runtime.getState());
                }
            } else {
                this.setEObject(null);
            }
        } else {
            this.selectedProgram = null;
        }
        this.top.layout();
    }

    protected HashMap<String, ISelectionListener> getSelectionProvidersIdsToSelectionListeners() {
        HashMap<String, ISelectionListener> selectionProvidersIdsToSelectionListeners = new HashMap<String, ISelectionListener>();
        selectionProvidersIdsToSelectionListeners.put("org.eclipse.apogy.core.invocator.ui.part.scriptBasedProgramsList", this.DEFAULT_LISTENER);
        return selectionProvidersIdsToSelectionListeners;
    }

    public void userPostConstruct(MPart mPart) {
        this.runtimes = new ArrayList<AbstractProgramRuntime>();
        super.userPostConstruct(mPart);
    }

    public void newRuntime(AbstractProgramRuntime runtime) {
        this.runtimes.add(runtime);
        runtime.eAdapters().add((Object)this.getRuntimeAdapter());
    }

    public List<AbstractProgramRuntime> getRuntimes() {
        return this.runtimes;
    }

    public Program getSelectedProgram() {
        return this.selectedProgram;
    }

    private Adapter getRuntimeAdapter() {
        if (this.runtimeAdapter == null) {
            this.runtimeAdapter = new AdapterImpl(){

                public void notifyChanged(final Notification msg) {
                    if (msg.getNotifier() == ProgramPart.this.runtimes.get(ProgramPart.this.runtimes.size() - 1)) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (msg.getFeature() == ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE) {
                                    ProgramPart.this.broker.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
                                    if (msg.getNewValue() == ProgramRuntimeState.TERMINATED) {
                                        if (ProgramPart.this.getActualComposite() instanceof OperationCallsListComposite) {
                                            ((OperationCallsListComposite)ProgramPart.this.getActualComposite()).setBackgroudColor(Collections.EMPTY_MAP);
                                        }
                                        AbstractProgramRuntime runtime = (AbstractProgramRuntime)msg.getNotifier();
                                        runtime.eAdapters().remove((Object)this);
                                        (this).ProgramPart.this.runtimes.remove(runtime);
                                    }
                                }
                                if (ProgramPart.this.getActualComposite() instanceof OperationCallsListComposite) {
                                    OperationCallsListComposite composite = (OperationCallsListComposite)ProgramPart.this.getActualComposite();
                                    if (msg.getFeature() == ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE || msg.getFeature() == ApogyCoreInvocatorPackage.Literals.OPERATION_CALLS_LIST_PROGRAM_RUNTIME__INDEX_CURRENTLY_EXECUTED || msg.getFeature() == ApogyCoreInvocatorPackage.Literals.OPERATION_CALLS_LIST_PROGRAM_RUNTIME__INDEX_LAST_EXECUTED) {
                                        HashMap<OperationCall, Integer> map = new HashMap<OperationCall, Integer>();
                                        OperationCallsListProgramRuntime runtime = (OperationCallsListProgramRuntime)msg.getNotifier();
                                        EList opsCall = composite.getOperationCallsList().getOperationCalls();
                                        if (runtime.getState() == ProgramRuntimeState.RUNNING || runtime.getState() == ProgramRuntimeState.RUNNING_SUSPENDED || runtime.getState() == ProgramRuntimeState.RUNNING_TERMINATED) {
                                            if (runtime.getIndexCurrentlyExecuted() != -1) {
                                                map.put((OperationCall)opsCall.get(runtime.getIndexCurrentlyExecuted()), 5);
                                            }
                                        } else if (runtime.getState() == ProgramRuntimeState.SUSPENDED && runtime.getIndexLastExecuted() != -1 && runtime.getIndexLastExecuted() + 1 != opsCall.size()) {
                                            map.put((OperationCall)opsCall.get(runtime.getIndexLastExecuted() + 1), 7);
                                        }
                                        composite.setBackgroudColor(map);
                                    }
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.runtimeAdapter;
    }

    public void userPreDestroy(MPart mPart) {
        if (this.runtimes != null) {
            for (AbstractProgramRuntime runtime : this.runtimes) {
                runtime.eAdapters().remove((Object)this.getRuntimeAdapter());
            }
        }
        super.userPreDestroy(mPart);
    }

    public void selectionChanged(IWorkbenchPart arg0, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
            this.selectionService.setSelection(iStructuredSelection.getFirstElement());
        }
    }
}

