/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.wizards;

import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.core.invocator.ui.composites.ArgumentsComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ArgumentsWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.invocator.ui.wizards.ArgumentsWizardPage";
    private ArgumentsComposite argumentsComposite;
    private Adapter adapter;
    private OperationCall operationCall;

    public ArgumentsWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("Arguments");
        this.setDescription("Please complete the arguments.");
    }

    public ArgumentsWizardPage(OperationCall operationCall) {
        this();
        this.setOperationCall(operationCall);
    }

    public void setOperationCall(OperationCall operationCall) {
        if (this.operationCall != null) {
            this.operationCall.eAdapters().remove((Object)this.getAdapter());
        }
        this.operationCall = operationCall;
        operationCall.eAdapters().add((Object)this.getAdapter());
        if (this.argumentsComposite != null) {
            this.argumentsComposite.setOperationCall(operationCall);
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    ArgumentsWizardPage.this.validate();
                }
            };
        }
        return this.adapter;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.argumentsComposite = new ArgumentsComposite(container, 0, true);
        this.argumentsComposite.setOperationCall(this.operationCall);
        this.argumentsComposite.setLayoutData(new GridData(4, 4, true, true));
        this.setControl((Control)container);
        this.validate();
    }

    public void dispose() {
        super.dispose();
        if (this.operationCall != null) {
            this.operationCall.eAdapters().remove((Object)this.getAdapter());
        }
    }

    protected void validate() {
        Diagnostic diagnosticContext;
        String errorArgumentStr = null;
        if (this.operationCall.getArgumentsList() != null && (diagnosticContext = Diagnostician.INSTANCE.validate((EObject)this.operationCall.getArgumentsList())).getSeverity() != 0) {
            errorArgumentStr = "Please enter a value for each argument";
        }
        this.setErrorMessage(errorArgumentStr);
        this.setPageComplete(errorArgumentStr == null);
    }
}

