/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.AbstractFeatureListNode;
import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.AbstractRootNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ListFeatureNode;
import org.eclipse.apogy.common.emf.ListRootNode;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.AbstractResult;
import org.eclipse.apogy.core.invocator.AbstractResultValue;
import org.eclipse.apogy.core.invocator.AbstractType;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Argument;
import org.eclipse.apogy.core.invocator.ArgumentsList;
import org.eclipse.apogy.core.invocator.AttributeResultValue;
import org.eclipse.apogy.core.invocator.AttributeValue;
import org.eclipse.apogy.core.invocator.BooleanEDataTypeArgument;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.DataProductsList;
import org.eclipse.apogy.core.invocator.EClassArgument;
import org.eclipse.apogy.core.invocator.EDataTypeArgument;
import org.eclipse.apogy.core.invocator.EEnumArgument;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.IVariableListener;
import org.eclipse.apogy.core.invocator.InitialConditions;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.LocalTypesList;
import org.eclipse.apogy.core.invocator.NumericEDataTypeArgument;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.invocator.OperationCallsList;
import org.eclipse.apogy.core.invocator.OperationCallsListProgramRuntime;
import org.eclipse.apogy.core.invocator.Program;
import org.eclipse.apogy.core.invocator.ProgramRuntimeState;
import org.eclipse.apogy.core.invocator.ProgramsGroup;
import org.eclipse.apogy.core.invocator.ProgramsList;
import org.eclipse.apogy.core.invocator.ReferenceResultValue;
import org.eclipse.apogy.core.invocator.ScriptBasedProgram;
import org.eclipse.apogy.core.invocator.StringEDataTypeArgument;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.invocator.TypeMemberImplementation;
import org.eclipse.apogy.core.invocator.TypeMemberInitialConditions;
import org.eclipse.apogy.core.invocator.TypeMemberReferenceListElement;
import org.eclipse.apogy.core.invocator.TypeMemberReferenceTreeElement;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.VariableImplementation;
import org.eclipse.apogy.core.invocator.VariableImplementationsList;
import org.eclipse.apogy.core.invocator.VariableInitialConditions;
import org.eclipse.apogy.core.invocator.VariableListenerEventType;
import org.eclipse.apogy.core.invocator.VariablesList;
import org.eclipse.apogy.core.invocator.delegates.InvocatorDelegate;
import org.eclipse.apogy.core.invocator.delegates.InvocatorDelegateRegistry;
import org.eclipse.apogy.core.invocator.impl.ApogyCoreInvocatorFacadeImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCoreInvocatorFacadeCustomImpl
extends ApogyCoreInvocatorFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCoreInvocatorFacadeImpl.class);
    private HashSet<IVariableListener> variableListenersSet;
    public static final String ARROW_STRING = "\u2192";

    @Override
    public OperationCallResult exec(OperationCall operationCall, boolean saveResult) {
        Variable variable = operationCall.getVariable();
        Type variableType = variable.getVariableType();
        if (operationCall.getTypeMemberReferenceListElement() != null) {
            variableType = operationCall.getTypeMemberReferenceListElement().getLeafElement().getTypeMember().getMemberType();
        }
        InvocatorDelegate delegate = InvocatorDelegateRegistry.getInstance().getInvocatorDelegate(variableType.getClass());
        EObject instance = this.getInstance(operationCall);
        if (instance == null) {
            Logger.error("The instance (or sub-instance) of variable <" + operationCall.getVariable().getName() + "> is null.");
        } else if (delegate == null) {
            Logger.error("Cannot find an InvocatorDelegate for instance of type <" + instance.getClass() + ">.");
        } else {
            return delegate.execute(instance, operationCall, saveResult);
        }
        return null;
    }

    @Override
    public OperationCallsListProgramRuntime exec(OperationCallsList operationCallsList, boolean stepByStep) {
        if (this.getActiveInvocatorSession() != null) {
            if (this.getActiveInvocatorSession().getProgramRuntimesList() == null) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.getActiveInvocatorSession(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__PROGRAM_RUNTIMES_LIST, (Object)ApogyCoreInvocatorFactory.eINSTANCE.createProgramRuntimesList(), true);
            }
            final OperationCallsListProgramRuntime runtime = ApogyCoreInvocatorFactory.eINSTANCE.createOperationCallsListProgramRuntime();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)runtime, (EStructuralFeature)ApogyCommonEMFPackage.Literals.NAMED__NAME, (Object)ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)this.getActiveInvocatorSession().getProgramRuntimesList(), (EObject)runtime, (ETypedElement)ApogyCoreInvocatorPackage.Literals.PROGRAM_RUNTIMES_LIST__PROGRAM_RUNTIMES), true);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)runtime, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__PROGRAM, (Object)operationCallsList, true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.getActiveInvocatorSession().getProgramRuntimesList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.PROGRAM_RUNTIMES_LIST__PROGRAM_RUNTIMES, (Object)runtime, true);
            runtime.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE && msg.getNewValue() == ProgramRuntimeState.TERMINATED) {
                        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)ApogyCoreInvocatorFacadeCustomImpl.this.getActiveInvocatorSession().getProgramRuntimesList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.PROGRAM_RUNTIMES_LIST__PROGRAM_RUNTIMES, (Object)runtime, true);
                        ((AbstractProgramRuntime)msg.getNotifier()).eAdapters().remove((Object)this);
                    }
                }
            });
            runtime.init();
            if (stepByStep) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)runtime, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.SUSPENDED);
                runtime.stepOver();
            } else {
                runtime.resume();
            }
            return runtime;
        }
        return null;
    }

    @Override
    public OperationCallResult exec(OperationCall operationCall) {
        return this.exec(operationCall, true);
    }

    @Override
    public Object getValue(OperationCallResult operationCallResult) {
        Object value = null;
        AbstractResultValue abstractValue = operationCallResult.getResultValue();
        if (abstractValue instanceof AttributeResultValue) {
            AttributeResultValue attributeResultValue = (AttributeResultValue)abstractValue;
            if (attributeResultValue.getValue() != null) {
                value = attributeResultValue.getValue().getObject();
            }
        } else if (abstractValue instanceof ReferenceResultValue) {
            value = ((ReferenceResultValue)abstractValue).getValue();
        }
        return value;
    }

    @Override
    public AbstractResultValue createAbstractResultValue(Object value) {
        if (value instanceof EObject && value != null) {
            ReferenceResultValue resultValue = ApogyCoreInvocatorFactory.eINSTANCE.createReferenceResultValue();
            resultValue.setValue((EObject)value);
            return resultValue;
        }
        if (value instanceof Object || value == null) {
            AttributeValue attributeValue = ApogyCoreInvocatorFactory.eINSTANCE.createAttributeValue();
            attributeValue.setObject(value);
            AttributeResultValue resultValue = ApogyCoreInvocatorFactory.eINSTANCE.createAttributeResultValue();
            resultValue.setValue(attributeValue);
            return resultValue;
        }
        return null;
    }

    @Override
    public EObject getInstance(Variable variable) {
        Context context;
        EObject eObject = null;
        Environment environment = variable.getEnvironment();
        if (environment != null && (context = environment.getActiveContext()) != null) {
            VariableImplementation variableImplementation = context.getVariableImplementationsList().getVariableImplementation(variable);
            eObject = variableImplementation == null ? null : variableImplementation.getInstance();
        }
        return eObject;
    }

    @Override
    public EClass getInstanceClass(Variable variable) {
        return variable.getVariableType().getInterfaceClass();
    }

    @Override
    public TypeApiAdapter getTypeApiAdapter(VariableFeatureReference variableFeatureReference) {
        TypeApiAdapter typeApiAdapter = null;
        Variable variable = variableFeatureReference.getVariable();
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        if (variable != null && environment != null && context != null) {
            if (variableFeatureReference.getFeatureRoot() == null && variableFeatureReference.getTypeMemberReferenceListElement() == null) {
                typeApiAdapter = this.getTypeApiAdapterForNullFeatureRootAndNullTypeMember(variableFeatureReference);
            } else if (variableFeatureReference.getFeatureRoot() != null && variableFeatureReference.getTypeMemberReferenceListElement() == null) {
                typeApiAdapter = this.getTypeApiAdapterForFeatureRootAndNullTypeMember(variableFeatureReference);
            } else if (variableFeatureReference.getFeatureRoot() == null && variableFeatureReference.getTypeMemberReferenceListElement() != null) {
                typeApiAdapter = this.getTypeApiAdapterForNullFeatureRootAndTypeMember(variableFeatureReference);
            } else if (variableFeatureReference.getFeatureRoot() != null && variableFeatureReference.getTypeMemberReferenceListElement() != null) {
                typeApiAdapter = this.getTypeApiAdapterForFeatureRootAndTypeMember(variableFeatureReference);
            }
        }
        return typeApiAdapter;
    }

    @Override
    public AbstractTypeImplementation findAbstractTypeImplementation(EObject eObjectInstance) {
        Context context;
        VariableImplementationsList variableImplementationsList;
        Iterator varImplIt;
        AbstractTypeImplementation result = null;
        InvocatorSession invocatorSession = this.getActiveInvocatorSession();
        if (invocatorSession != null && invocatorSession.getEnvironment().getActiveContext() != null && (varImplIt = (variableImplementationsList = (context = invocatorSession.getEnvironment().getActiveContext()).getVariableImplementationsList()).getVariableImplementations().iterator()).hasNext() && result == null) {
            VariableImplementation variableImplementation = (VariableImplementation)varImplIt.next();
            if (variableImplementation.getInstance() == eObjectInstance) {
                return variableImplementation;
            }
            return this.recursivefindAbstractTypeImplementation(variableImplementation, eObjectInstance);
        }
        return result;
    }

    private AbstractTypeImplementation recursivefindAbstractTypeImplementation(AbstractTypeImplementation abstractTypeImplementation, EObject eObjectInstance) {
        AbstractTypeImplementation result = null;
        if (abstractTypeImplementation.getInstance() == eObjectInstance) {
            return abstractTypeImplementation;
        }
        Iterator typeMembersIterator = abstractTypeImplementation.getTypeMemberImplementations().iterator();
        while (typeMembersIterator.hasNext() && result == null) {
            result = this.recursivefindAbstractTypeImplementation((AbstractTypeImplementation)typeMembersIterator.next(), eObjectInstance);
        }
        return result;
    }

    private TypeApiAdapter getTypeApiAdapterForNullFeatureRootAndNullTypeMember(VariableFeatureReference variableFeatureReference) {
        TypeApiAdapter typeApiAdapter = null;
        Variable variable = variableFeatureReference.getVariable();
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        try {
            typeApiAdapter = context.getVariableImplementationsList().getVariableImplementation(variable).getAdapterInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return typeApiAdapter;
    }

    private TypeApiAdapter getTypeApiAdapterForFeatureRootAndNullTypeMember(VariableFeatureReference variableFeatureReference) {
        ListRootNode rootNode;
        TypeApiAdapter typeApiAdapter = null;
        Variable variable = variableFeatureReference.getVariable();
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        typeApiAdapter = context.getVariableImplementationsList().getVariableImplementation(variable).getAdapterInstance();
        EObject sourceEObject = this.getInstance(variable);
        VariableImplementation rootATI = context.getVariableImplementationsList().getVariableImplementation(variable);
        ListRootNode currentNode = rootNode = variableFeatureReference.getFeatureRoot();
        while (currentNode != null) {
            Object object = ApogyCommonEMFFacade.INSTANCE.resolve(sourceEObject, (AbstractFeatureNode)currentNode);
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                for (AbstractTypeImplementation ati : rootATI.getTypeMemberImplementations()) {
                    if (ati.getInstance() != eObject || ati.getAdapterInstance() == null) continue;
                    typeApiAdapter = ati.getAdapterInstance();
                }
            }
            currentNode = currentNode.getChild();
        }
        return typeApiAdapter;
    }

    private TypeApiAdapter getTypeApiAdapterForNullFeatureRootAndTypeMember(VariableFeatureReference variableFeatureReference) {
        VariableImplementation variableImplementation;
        VariableImplementationsList variableImplementationsList;
        TypeApiAdapter typeApiAdapter = null;
        Variable variable = variableFeatureReference.getVariable();
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        TypeMemberReferenceListElement currentTypeMemberReferenceListElement = variableFeatureReference.getTypeMemberReferenceListElement();
        AbstractTypeImplementation currentTypeMemberImplementation = null;
        if (context != null && (variableImplementationsList = context.getVariableImplementationsList()) != null && (variableImplementation = variableImplementationsList.getVariableImplementation(variable)) != null) {
            currentTypeMemberImplementation = variableImplementation.getTypeMemberImplementation(currentTypeMemberReferenceListElement.getTypeMember());
        }
        if (currentTypeMemberImplementation != null) {
            TypeApiAdapter currentTypeApiAdapter = currentTypeMemberImplementation.getAdapterInstance();
            if (currentTypeApiAdapter != null) {
                typeApiAdapter = currentTypeApiAdapter;
            }
            while (!currentTypeMemberReferenceListElement.isLeaf()) {
                currentTypeApiAdapter = (currentTypeMemberImplementation = currentTypeMemberImplementation.getTypeMemberImplementation((currentTypeMemberReferenceListElement = currentTypeMemberReferenceListElement.getChild()).getTypeMember())).getAdapterInstance();
                if (currentTypeApiAdapter == null) continue;
                typeApiAdapter = currentTypeApiAdapter;
            }
        }
        return typeApiAdapter;
    }

    private TypeApiAdapter getTypeApiAdapterForFeatureRootAndTypeMember(VariableFeatureReference variableFeatureReference) {
        TypeApiAdapter typeApiAdapter = null;
        Variable variable = variableFeatureReference.getVariable();
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        EObject sourceEObject = null;
        TypeMemberReferenceListElement currentTypeMemberReferenceListElement = variableFeatureReference.getTypeMemberReferenceListElement();
        TypeMemberImplementation currentTypeMemberImplementation = context.getVariableImplementationsList().getVariableImplementation(variable).getTypeMemberImplementation(currentTypeMemberReferenceListElement.getTypeMember());
        TypeApiAdapter currentTypeApiAdapter = currentTypeMemberImplementation.getAdapterInstance();
        if (currentTypeApiAdapter != null) {
            typeApiAdapter = currentTypeApiAdapter;
            sourceEObject = typeApiAdapter.getInstance();
        }
        while (!currentTypeMemberReferenceListElement.isLeaf()) {
            currentTypeApiAdapter = (currentTypeMemberImplementation = currentTypeMemberImplementation.getTypeMemberImplementation((currentTypeMemberReferenceListElement = currentTypeMemberReferenceListElement.getChild()).getTypeMember())).getAdapterInstance();
            if (currentTypeApiAdapter == null) continue;
            typeApiAdapter = currentTypeApiAdapter;
            sourceEObject = typeApiAdapter.getInstance();
        }
        if (sourceEObject != null) {
            ListRootNode rootNode;
            VariableImplementation rootATI = context.getVariableImplementationsList().getVariableImplementation(variable);
            ListRootNode currentNode = rootNode = variableFeatureReference.getFeatureRoot();
            while (currentNode != null) {
                Object object = ApogyCommonEMFFacade.INSTANCE.resolve(sourceEObject, (AbstractFeatureNode)currentNode);
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    for (AbstractTypeImplementation ati : rootATI.getTypeMemberImplementations()) {
                        if (ati.getInstance() != eObject || ati.getAdapterInstance() == null) continue;
                        typeApiAdapter = ati.getAdapterInstance();
                    }
                }
                currentNode = currentNode.getChild();
            }
        }
        return typeApiAdapter;
    }

    @Override
    public EObject getInstance(VariableFeatureReference variableFeatureReference) {
        EObject eObjectInstance = null;
        if (variableFeatureReference.getVariable() != null) {
            Object tmpObject;
            Variable variable = variableFeatureReference.getVariable();
            eObjectInstance = variableFeatureReference.getTypeMemberReferenceListElement() != null ? this.getTypeMemberInstance(variableFeatureReference) : this.getInstance(variable);
            if (eObjectInstance != null && variableFeatureReference.getFeatureRoot() != null && (tmpObject = ApogyCommonEMFFacade.INSTANCE.resolve(eObjectInstance, (AbstractFeatureNode)ApogyCommonEMFFacade.INSTANCE.getLeaf(variableFeatureReference.getFeatureRoot()))) instanceof EObject) {
                eObjectInstance = (EObject)tmpObject;
            }
        }
        return eObjectInstance;
    }

    @Override
    public EObject getTypeMemberInstance(VariableFeatureReference variableFeatureReference) {
        EObject typeMemberInstance = null;
        if (variableFeatureReference.getTypeMemberReferenceListElement() != null) {
            VariableImplementation variableImplementation;
            VariableImplementationsList variableImplementationsList;
            Context context;
            Variable variable = variableFeatureReference.getVariable();
            TypeMemberReferenceListElement currentTypeMemberReferenceListElement = variableFeatureReference.getTypeMemberReferenceListElement();
            Environment environment = variable.getEnvironment();
            if (environment != null && (context = environment.getActiveContext()) != null && (variableImplementationsList = context.getVariableImplementationsList()) != null && (variableImplementation = variableImplementationsList.getVariableImplementation(variable)) != null && currentTypeMemberReferenceListElement != null) {
                TypeMemberImplementation currentTypeMemberImplementation = variableImplementation.getTypeMemberImplementation(currentTypeMemberReferenceListElement.getTypeMember());
                while (!currentTypeMemberReferenceListElement.isLeaf()) {
                    currentTypeMemberReferenceListElement = currentTypeMemberReferenceListElement.getChild();
                    currentTypeMemberImplementation = currentTypeMemberImplementation.getTypeMemberImplementation(currentTypeMemberReferenceListElement.getTypeMember());
                }
                typeMemberInstance = currentTypeMemberImplementation.getInstance();
            }
        }
        return typeMemberInstance;
    }

    @Override
    public Object getEMFFeatureValue(VariableFeatureReference variableFeatureReference) {
        Object featureValue = null;
        if (variableFeatureReference.getVariable() != null && variableFeatureReference.getFeatureRoot() != null) {
            Variable variable = variableFeatureReference.getVariable();
            EObject eObject = this.getTypeMemberInstance(variableFeatureReference);
            if (eObject == null) {
                eObject = this.getInstance(variable);
            }
            if (eObject != null) {
                featureValue = ApogyCommonEMFFacade.INSTANCE.resolve(eObject, (AbstractFeatureNode)ApogyCommonEMFFacade.INSTANCE.getLeaf(variableFeatureReference.getFeatureRoot()));
            }
        }
        return featureValue;
    }

    @Override
    public EClass getInstanceClass(VariableFeatureReference variableFeatureReference) {
        AbstractFeatureSpecifier featureSpecifier;
        EClassifier eClassifier;
        EClass eClass = null;
        Variable variable = variableFeatureReference.getVariable();
        TypeMemberReferenceListElement currentTypeMemberReferenceListElement = variableFeatureReference.getTypeMemberReferenceListElement();
        AbstractFeatureListNode featureNode = ApogyCommonEMFFacade.INSTANCE.getLeaf(variableFeatureReference.getFeatureRoot());
        if (featureNode != null && featureNode instanceof AbstractFeatureSpecifier && (eClassifier = (featureSpecifier = (AbstractFeatureSpecifier)featureNode).getStructuralFeature().getEType()) instanceof EClass) {
            eClass = (EClass)eClassifier;
        }
        if (eClass == null && currentTypeMemberReferenceListElement != null && currentTypeMemberReferenceListElement.getLeafElement() != null && currentTypeMemberReferenceListElement.getLeafElement().getTypeMember() != null && currentTypeMemberReferenceListElement.getLeafElement().getTypeMember().getMemberType() != null) {
            eClass = currentTypeMemberReferenceListElement.getLeafElement().getTypeMember().getMemberType().getInterfaceClass();
        }
        if (eClass == null) {
            eClass = this.getInstanceClass(variable);
        }
        return eClass;
    }

    @Override
    public AbstractTypeImplementation getTypeImplementation(OperationCall operationCall) {
        AbstractTypeImplementation result = null;
        Variable variable = operationCall.getVariable();
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        TypeMemberReferenceListElement currentTypeMemberReferenceListElement = operationCall.getTypeMemberReferenceListElement();
        if (currentTypeMemberReferenceListElement == null) {
            AbstractTypeImplementation ati;
            if (operationCall.getFeatureRoot() != null && (ati = this.getAbstractTypeImplementationForTypeAttribute(operationCall)) != null) {
                return ati;
            }
            result = context.getVariableImplementationsList().getVariableImplementation(variable);
        } else {
            TypeMemberImplementation currentTypeMemberImplementation = context.getVariableImplementationsList().getVariableImplementation(variable).getTypeMemberImplementation(currentTypeMemberReferenceListElement.getTypeMember());
            while (!currentTypeMemberReferenceListElement.isLeaf()) {
                currentTypeMemberReferenceListElement = currentTypeMemberReferenceListElement.getChild();
                currentTypeMemberImplementation = currentTypeMemberImplementation.getTypeMemberImplementation(currentTypeMemberReferenceListElement.getTypeMember());
            }
            result = currentTypeMemberImplementation;
        }
        return result;
    }

    private AbstractTypeImplementation getAbstractTypeImplementationForTypeAttribute(OperationCall operationCall) {
        ListRootNode rootNode;
        Variable variable = operationCall.getVariable();
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        AbstractTypeImplementation result = context.getVariableImplementationsList().getVariableImplementation(variable);
        EObject source = this.getInstance(variable);
        ListRootNode currentNode = rootNode = operationCall.getFeatureRoot();
        VariableImplementation vi = context.getVariableImplementationsList().getVariableImplementation(variable);
        while (currentNode != null) {
            EObject eObject;
            AbstractTypeImplementation ati;
            Object object = ApogyCommonEMFFacade.INSTANCE.resolve(source, (AbstractFeatureNode)currentNode);
            if (object instanceof EObject && (ati = this.findAbstractTypeImplementation(vi, eObject = (EObject)object)) != null) {
                result = ati;
            }
            currentNode = currentNode.getChild();
        }
        return result;
    }

    protected AbstractTypeImplementation findAbstractTypeImplementation(AbstractTypeImplementation typeImplementation, EObject eObjectInstance) {
        if (typeImplementation.getInstance() == eObjectInstance) {
            return typeImplementation;
        }
        AbstractTypeImplementation result = null;
        Iterator it = typeImplementation.getTypeMemberImplementations().iterator();
        while (result == null && it.hasNext()) {
            AbstractTypeImplementation ti = (AbstractTypeImplementation)it.next();
            result = this.findAbstractTypeImplementation(ti, eObjectInstance);
        }
        return result;
    }

    @Override
    public AbstractTypeImplementation getTypeImplementation(Variable variable, AbstractType elementType) {
        AbstractTypeImplementation result = null;
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        VariableImplementation variableImplementation = context.getVariableImplementationsList().getVariableImplementation(variable);
        result = variableImplementation.getHandlingType() == elementType ? variableImplementation : this.getTypeMemberImplementation(variableImplementation.getTypeMemberImplementations().iterator(), elementType);
        return result;
    }

    @Override
    public AbstractTypeImplementation getTypeImplementation(Variable variable) {
        Environment environment = variable.getEnvironment();
        Context context = environment.getActiveContext();
        if (context != null) {
            return context.getVariableImplementationsList().getVariableImplementation(variable);
        }
        return null;
    }

    @Override
    public List<Variable> getVariableByName(InvocatorSession session, String name) {
        VariablesList variablesList;
        ArrayList<Variable> result = new ArrayList<Variable>();
        Environment environment = session.getEnvironment();
        if (environment != null && (variablesList = environment.getVariablesList()) != null) {
            for (Variable variable : variablesList.getVariables()) {
                if (!variable.getName().equals(name)) continue;
                result.add(variable);
            }
        }
        return result;
    }

    public Variable getVariableByName(String name) {
        Variable variable = null;
        InvocatorSession session = this.getActiveInvocatorSession();
        if (session != null) {
            Iterator variables = session.getEnvironment().getVariablesList().getVariables().iterator();
            while (variables.hasNext() && variable == null) {
                Variable current = (Variable)variables.next();
                if (!current.getName().equals(name)) continue;
                variable = current;
            }
        }
        return variable;
    }

    @Override
    public TypeMemberReferenceListElement createTypeMemberReferences(TypeMember[] typeMembers) {
        TypeMemberReferenceListElement currentElement = null;
        int i = 0;
        while (i < typeMembers.length) {
            TypeMemberReferenceListElement newElement = ApogyCoreInvocatorFactory.eINSTANCE.createTypeMemberReferenceListElement();
            newElement.setTypeMember(typeMembers[i]);
            if (currentElement != null) {
                currentElement.setChild(newElement);
            }
            currentElement = newElement;
            ++i;
        }
        return currentElement.getRootElement();
    }

    @Override
    public AbstractTypeImplementation getTypeImplementation(Environment environment, String fullyQualifiedName) {
        VariableImplementationsList variableImplementationsList;
        VariableImplementation result = null;
        String[] tokens = fullyQualifiedName.split("\\.");
        VariableImplementation variableImplementation = null;
        if (environment.getActiveContext() != null && (variableImplementationsList = environment.getActiveContext().getVariableImplementationsList()) != null) {
            String variableName = tokens.length == 0 ? fullyQualifiedName : tokens[0];
            variableImplementation = variableImplementationsList.getVariableImplementation(variableName);
        }
        if (variableImplementation != null && tokens.length == 0) {
            result = variableImplementation;
        } else {
            int tokenCounter = 1;
            AbstractTypeImplementation currentTypeImplementation = variableImplementation;
            while (tokenCounter < tokens.length && currentTypeImplementation != null) {
                currentTypeImplementation = currentTypeImplementation.getTypeMemberImplementation(tokens[tokenCounter]);
                ++tokenCounter;
            }
            if (currentTypeImplementation != null && tokenCounter == tokens.length) {
                result = currentTypeImplementation;
            }
        }
        return result;
    }

    protected TypeMemberImplementation getTypeMemberImplementation(Iterator<TypeMemberImplementation> typeMemberImplementations, AbstractType elementType) {
        TypeMemberImplementation result = null;
        while (typeMemberImplementations.hasNext() && result == null) {
            TypeMemberImplementation typeMemberImplementation = typeMemberImplementations.next();
            result = typeMemberImplementation.getTypeMember() == elementType ? typeMemberImplementation : this.getTypeMemberImplementation(typeMemberImplementation.getTypeMemberImplementations().iterator(), elementType);
        }
        return result;
    }

    @Override
    public String getFullyQualifiedName(TypeMemberReferenceTreeElement typeMemberReferenceTreeElement) {
        if (typeMemberReferenceTreeElement != null) {
            String fullyQualifiedName = new String();
            ArrayList<TypeMemberReferenceTreeElement> lineage = new ArrayList<TypeMemberReferenceTreeElement>();
            TypeMemberReferenceTreeElement t = typeMemberReferenceTreeElement;
            while (t != null) {
                lineage.add(0, t);
                t = t.getParent();
            }
            Iterator it = lineage.iterator();
            while (it.hasNext()) {
                TypeMemberReferenceTreeElement element = (TypeMemberReferenceTreeElement)it.next();
                fullyQualifiedName = String.valueOf(fullyQualifiedName) + element.getTypeMember().getName();
                if (!it.hasNext()) continue;
                fullyQualifiedName = String.valueOf(fullyQualifiedName) + ".";
            }
            return fullyQualifiedName;
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName(AbstractFeatureNode abstractFeatureNode) {
        if (abstractFeatureNode != null) {
            String fullyQualifiedName = new String();
            AbstractRootNode root = ApogyCommonEMFFacade.INSTANCE.getFeatureRoot(abstractFeatureNode);
            if (root.eContainer() instanceof TypeMemberReferenceTreeElement) {
                TypeMemberReferenceTreeElement typeMemberReferenceTreeElement = (TypeMemberReferenceTreeElement)root.eContainer();
                fullyQualifiedName = this.getFullyQualifiedName(typeMemberReferenceTreeElement);
                fullyQualifiedName = String.valueOf(fullyQualifiedName) + "." + ApogyCommonEMFFacade.INSTANCE.getAncestriesString(abstractFeatureNode);
            }
            return fullyQualifiedName;
        }
        return null;
    }

    @Override
    public List<TypeMemberImplementation> createTypeMemberImplementations(Type variableType) {
        ArrayList<TypeMemberImplementation> typeMemberImplementations = new ArrayList<TypeMemberImplementation>();
        for (TypeMember typeMember : variableType.getMembers()) {
            List<TypeMemberImplementation> subTypeMemberImplementations;
            TypeMemberImplementation typeMemberImplementation = ApogyCoreInvocatorFactory.eINSTANCE.createTypeMemberImplementation();
            typeMemberImplementation.setTypeMember(typeMember);
            List eClasses = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(typeMemberImplementation.getHandlingType().getInterfaceClass());
            if (!eClasses.isEmpty()) {
                typeMemberImplementation.setImplementationClass((EClass)eClasses.get(0));
            }
            if (!(subTypeMemberImplementations = this.createTypeMemberImplementations(typeMember.getMemberType())).isEmpty()) {
                typeMemberImplementation.getTypeMemberImplementations().addAll(subTypeMemberImplementations);
            }
            typeMemberImplementations.add(typeMemberImplementation);
        }
        return typeMemberImplementations;
    }

    @Override
    public void initVariableInstances() {
        this.disposeVariableInstances();
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null) {
            Environment environment = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment();
            for (Variable variable : environment.getVariablesList().getVariables()) {
                InvocatorDelegate invocatorDelegate = InvocatorDelegateRegistry.getInstance().getInvocatorDelegate(variable.getVariableType().getClass());
                invocatorDelegate.newInstance(environment, variable);
                this.notifyVariableListeners(variable, VariableListenerEventType.NEW);
            }
            Date date = new Date(System.currentTimeMillis());
            environment.getActiveContext().setInstancesCreationDate(date);
            this.setInitVariableInstancesDate(date);
            environment.getActiveContext().setInstancesDisposalDate(null);
            environment.getActiveContext().setVariablesInstantiated(true);
        }
    }

    @Override
    public void disposeVariableInstances() {
        if (this.getActiveInvocatorSession() != null && this.getActiveInvocatorSession().getEnvironment() != null && this.getActiveInvocatorSession().getEnvironment().getActiveContext() != null && this.getActiveInvocatorSession().getEnvironment().getActiveContext().isVariablesInstantiated()) {
            Environment environment = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment();
            ApogyCommonEMFFacade.INSTANCE.stopAllStartables((EObject)this.getActiveInvocatorSession());
            for (Variable variable : environment.getVariablesList().getVariables()) {
                InvocatorDelegate invocatorDelegate = InvocatorDelegateRegistry.getInstance().getInvocatorDelegate(variable.getVariableType().getClass());
                invocatorDelegate.dispose(environment, variable);
                this.notifyVariableListeners(variable, VariableListenerEventType.CLEAR);
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)environment.getActiveContext(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_DISPOSAL_DATE, (Object)new Date());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)environment.getActiveContext(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.CONTEXT__VARIABLES_INSTANTIATED, (Object)false);
            this.setDisposedVariableInstancesDate(new Date());
        }
    }

    @Override
    public OperationCall getOperationCallContainer(TypeMemberReferenceListElement typeMemberReferenceListElement) {
        EObject container;
        OperationCall operationCall = null;
        if (typeMemberReferenceListElement.isRoot() && (container = typeMemberReferenceListElement.eContainer()) != null & container instanceof OperationCall) {
            operationCall = (OperationCall)container;
        }
        return operationCall;
    }

    @Override
    public InitialConditions collectInitialConditions(Environment environment) throws Exception {
        InitialConditions initialConditions = ApogyCoreInvocatorFactory.eINSTANCE.createInitialConditions();
        this.collectInitialConditions(environment, initialConditions);
        return initialConditions;
    }

    @Override
    public void collectInitialConditions(Environment environment, InitialConditions initialConditions) throws Exception {
        EList<VariableInitialConditions> toClear = initialConditions.getVariableInitialConditions();
        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)initialConditions, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS__VARIABLE_INITIAL_CONDITIONS, toClear, true);
        for (Variable variable : environment.getVariablesList().getVariables()) {
            VariableInitialConditions variableInitialConditions = this.collectInitialConditions(variable);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)initialConditions, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS__VARIABLE_INITIAL_CONDITIONS, (Object)variableInitialConditions);
        }
    }

    @Override
    public VariableInitialConditions collectInitialConditions(Variable variable) throws Exception {
        VariableInitialConditions variableInitialConditions = ApogyCoreInvocatorFactory.eINSTANCE.createVariableInitialConditions();
        variableInitialConditions.setVariable(variable);
        VariableFeatureReference variableFeatureReference = ApogyCoreInvocatorFactory.eINSTANCE.createVariableFeatureReference();
        variableFeatureReference.setVariable(variable);
        TypeApiAdapter variableTypeApiAdapter = this.getTypeApiAdapter(variableFeatureReference);
        AbstractInitializationData abstractInitializationData = variableTypeApiAdapter.createInitializationData();
        variableTypeApiAdapter.collect(abstractInitializationData);
        variableInitialConditions.setAbstractInitializationData(abstractInitializationData);
        VariableImplementation variableImplementation = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getActiveContext().getVariableImplementationsList().getVariableImplementation(variable);
        for (TypeMember typeMember : variable.getVariableType().getMembers()) {
            try {
                TypeMemberInitialConditions typeMemberInitialConditions = this.collectTypeMemberInitialConditions(variableImplementation, typeMember);
                variableInitialConditions.getTypeMembersInitialConditions().add((Object)typeMemberInitialConditions);
            }
            catch (Throwable t) {
                Logger.error("Failed to collect initial condition for type member <" + typeMember.getName() + "> of Variable <" + variable.getName() + ">.", t);
            }
        }
        return variableInitialConditions;
    }

    private TypeMemberInitialConditions collectTypeMemberInitialConditions(VariableImplementation variableImplementation, TypeMember typeMember) throws Exception {
        TypeMemberInitialConditions typeMemberInitialConditions = ApogyCoreInvocatorFactory.eINSTANCE.createTypeMemberInitialConditions();
        typeMemberInitialConditions.setTypeMember(typeMember);
        TypeMemberImplementation typeMemberImplementation = this.getTypeMemberImplementation(variableImplementation, typeMember);
        TypeApiAdapter typeApiAdapter = typeMemberImplementation.getAdapterInstance();
        if (typeApiAdapter != null) {
            try {
                Logger.info("Collecting initial condition for type member <" + typeMember.getName() + "> starts.");
                AbstractInitializationData abstractInitializationData = typeApiAdapter.createInitializationData();
                typeApiAdapter.collect(abstractInitializationData);
                typeMemberInitialConditions.setAbstractInitializationData(abstractInitializationData);
                Logger.info("Collecting initial condition for type member <" + typeMember.getName() + "> completed.");
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
                Logger.error("Failed to collect initial condition for type member <" + typeMember.getName() + ">.", t);
            }
        }
        if (typeMember.getMemberType() != null) {
            for (TypeMember subTypeMember : typeMember.getMemberType().getMembers()) {
                try {
                    TypeMemberInitialConditions subTypeMemberInitialConditions = this.collectTypeMemberInitialConditions(variableImplementation, subTypeMember);
                    typeMemberInitialConditions.getTypeMembersInitialConditions().add((Object)subTypeMemberInitialConditions);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                    Logger.error("Failed to collect initial condition for type member <" + subTypeMember.getName() + "> of Type Member <" + typeMember.getName() + ">.", t);
                }
            }
        }
        return typeMemberInitialConditions;
    }

    private TypeMemberImplementation getTypeMemberImplementation(VariableImplementation variableImplementation, TypeMember typeMember) {
        TypeMemberImplementation typeMemberImplementation = null;
        Iterator it = variableImplementation.getTypeMemberImplementations().iterator();
        while (it.hasNext() && typeMemberImplementation == null) {
            TypeMemberImplementation tmi = (TypeMemberImplementation)it.next();
            typeMemberImplementation = tmi.getTypeMember() == typeMember ? tmi : this.getTypeMemberImplementation(tmi, typeMember);
        }
        return typeMemberImplementation;
    }

    private TypeMemberImplementation getTypeMemberImplementation(TypeMemberImplementation rootTypeMember, TypeMember typeMember) {
        TypeMemberImplementation typeMemberImplementation = null;
        Iterator it = rootTypeMember.getTypeMemberImplementations().iterator();
        while (it.hasNext() && typeMemberImplementation == null) {
            TypeMemberImplementation tmi = (TypeMemberImplementation)it.next();
            typeMemberImplementation = tmi.getTypeMember() == typeMember ? tmi : this.getTypeMemberImplementation(tmi, typeMember);
        }
        return typeMemberImplementation;
    }

    @Override
    public void applyInitialConditions(Environment environment, InitialConditions initialConditions, IProgressMonitor progressMonitor) throws Exception {
        IProgressMonitor internalProgressMonitor = progressMonitor;
        if (internalProgressMonitor == null) {
            internalProgressMonitor = new NullProgressMonitor();
        }
        internalProgressMonitor.beginTask("Apply Variables Initial Conditions", environment.getVariablesList().getVariables().size());
        Logger.info("Applying Initial Conditions <" + initialConditions.getName() + "> starts.");
        for (Variable variable : environment.getVariablesList().getVariables()) {
            Logger.info("Applying Initial Conditions to Variable <" + variable.getName() + "> starts.");
            VariableInitialConditions variableInitialConditions = initialConditions.getVariableInitialConditionsFor(variable);
            if (variableInitialConditions != null) {
                try {
                    this.applyVariableInitialConditions(environment, variableInitialConditions, internalProgressMonitor);
                    Logger.info("Applying Initial Conditions to Variable <" + variable.getName() + "> completed.");
                }
                catch (Throwable t) {
                    Logger.error("Error occured while applying initial conditions for Variable <" + variable.getName() + ">.", t);
                }
            } else {
                Logger.warn("No initial conditions found for Variable <" + variable.getName() + ">.");
            }
            internalProgressMonitor.worked(1);
        }
        Logger.info("Applying Initial Conditions <" + initialConditions.getName() + "> completed.");
    }

    @Override
    public void applyVariableInitialConditions(Environment environment, VariableInitialConditions variableInitialConditions, IProgressMonitor progressMonitor) throws Exception {
        IProgressMonitor internalProgressMonitor = progressMonitor;
        if (internalProgressMonitor == null) {
            internalProgressMonitor = new NullProgressMonitor();
        }
        Variable variable = variableInitialConditions.getVariable();
        Context activeContext = environment.getActiveContext();
        VariableImplementation variableImplementation = activeContext.getVariableImplementationsList().getVariableImplementation(variable);
        variableImplementation.getAdapterInstance().apply(variableInitialConditions.getAbstractInitializationData());
        internalProgressMonitor.subTask("Applying initial conditions to Variable <" + variable.getName() + ">.");
        for (TypeMember typeMember : variable.getVariableType().getMembers()) {
            TypeMemberInitialConditions typeMemberInitialConditions = variableInitialConditions.getTypeMemberInitialConditionsFor(typeMember);
            if (typeMemberInitialConditions == null) continue;
            try {
                Logger.info("Applying initial conditions for Type Member <" + typeMember.getName() + "> of Variable <" + variable.getName() + "> starts.");
                this.applyTypeMemberInitialConditions(variableImplementation, typeMemberInitialConditions);
                Logger.info("Applying initial conditions for Type Member <" + typeMember.getName() + "> of Variable <" + variable.getName() + "> completed.");
            }
            catch (Throwable t) {
                Logger.error("Error occured while applying initial conditions for Type Member <" + typeMember.getName() + "> of Vraiable <" + variable.getName() + ">!", t);
                Logger.error(t.getMessage(), t);
            }
        }
    }

    private void applyTypeMemberInitialConditions(VariableImplementation variableImplementation, TypeMemberInitialConditions typeMemberInitialConditions) {
        TypeMember typeMember = typeMemberInitialConditions.getTypeMember();
        TypeMemberImplementation typeMemberImplementation = variableImplementation.getTypeMemberImplementation(typeMember);
        TypeApiAdapter typeApiAdapter = typeMemberImplementation.getAdapterInstance();
        if (typeApiAdapter != null) {
            try {
                typeApiAdapter.apply(typeMemberInitialConditions.getAbstractInitializationData());
            }
            catch (Throwable t) {
                Logger.error("Error occured while applying initial conditions for Type Member <" + typeMember.getName() + ">.", t);
            }
        }
        if (typeMember.getMemberType() != null) {
            for (TypeMember subTypeMember : typeMember.getMemberType().getMembers()) {
                try {
                    TypeMemberInitialConditions tmic = typeMemberInitialConditions.getTypeMemberInitialConditionsFor(subTypeMember);
                    if (tmic == null) continue;
                    this.applyTypeMemberInitialConditionsRecursive(variableImplementation, tmic);
                }
                catch (Throwable t) {
                    Logger.error("Error occured while applying initial conditions for Sub Type Member <" + subTypeMember.getName() + "> of Member <" + typeMember.getName() + ">.", t);
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    private void applyTypeMemberInitialConditionsRecursive(VariableImplementation variableImplementation, TypeMemberInitialConditions rootTypeMemberInitialConditions) {
        try {
            TypeMember rootTypeMember = rootTypeMemberInitialConditions.getTypeMember();
            TypeMemberImplementation rootTypeMemberImplementation = this.getTypeMemberImplementation(variableImplementation, rootTypeMember);
            TypeApiAdapter rootTypeApiAdapter = rootTypeMemberImplementation.getAdapterInstance();
            rootTypeApiAdapter.apply(rootTypeMemberInitialConditions.getAbstractInitializationData());
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        for (TypeMemberInitialConditions tmic : rootTypeMemberInitialConditions.getTypeMembersInitialConditions()) {
            try {
                TypeMember typeMember = tmic.getTypeMember();
                TypeMemberInitialConditions typeMemberInitialConditions = rootTypeMemberInitialConditions.getTypeMemberInitialConditionsFor(typeMember);
                this.applyTypeMemberInitialConditionsRecursive(variableImplementation, typeMemberInitialConditions);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    public void loadRegisteredTypes(InvocatorSession session) {
    }

    public List<Type> getAllTypes(Environment environment) {
        ArrayList<Type> types = new ArrayList<Type>();
        LocalTypesList localTypesList = environment.getLocalTypesList();
        if (localTypesList != null) {
            types.addAll((Collection<Type>)localTypesList.getTypes());
        }
        return types;
    }

    public void addVariableListener(IVariableListener listener) {
        this.getVariableListenersSet().add(listener);
    }

    private HashSet<IVariableListener> getVariableListenersSet() {
        if (this.variableListenersSet == null) {
            this.variableListenersSet = new HashSet();
        }
        return this.variableListenersSet;
    }

    public void removeVariableListener(IVariableListener listener) {
        this.getVariableListenersSet().remove(listener);
    }

    public void notifyVariableListeners(Variable variable, VariableListenerEventType event) {
        for (IVariableListener listener : this.getVariableListenersSet()) {
            listener.variableListenerNotification(variable, event);
        }
    }

    @Override
    public InvocatorSession loadInvocatorSession(String uri) throws Exception {
        URI sessionURI = URI.createURI((String)uri);
        EList contents = ApogyCommonEMFFacade.INSTANCE.getContent(sessionURI);
        InvocatorSession invocatorSession = (InvocatorSession)contents.get(0);
        return invocatorSession;
    }

    @Override
    public DataProductsList getDataProductsByName(InvocatorSession invocatorSession, String name) {
        for (DataProductsList dataProductsList : invocatorSession.getDataProductsListContainer().getDataProductsList()) {
            if (!dataProductsList.getName().equals(name)) continue;
            return dataProductsList;
        }
        return null;
    }

    @Override
    public Program getProgramByName(InvocatorSession invocatorSession, String name) {
        for (ProgramsGroup programsGroup : invocatorSession.getProgramsList().getProgramsGroups()) {
            for (Program program : programsGroup.getPrograms()) {
                if (!program.getName().equals(name)) continue;
                return program;
            }
        }
        return null;
    }

    @Override
    public Context getContextByName(InvocatorSession invocatorSession, String name) {
        for (Context context : invocatorSession.getEnvironment().getContextsList().getContexts()) {
            if (!context.getName().equals(name)) continue;
            return context;
        }
        return null;
    }

    @Override
    public List<Program> getAllScriptBasedPrograms(ProgramsList programsList) {
        ArrayList<Program> list = new ArrayList<Program>();
        for (ProgramsGroup programsGroup : programsList.getProgramsGroups()) {
            for (Program program : programsGroup.getPrograms()) {
                if (!(program instanceof ScriptBasedProgram)) continue;
                list.add(program);
            }
        }
        return list;
    }

    @Override
    public Context createContext(InvocatorSession invocatorSession) {
        Context context = ApogyCoreInvocatorFactory.eINSTANCE.createContext();
        VariableImplementationsList variableImplementationsList = ApogyCoreInvocatorFactory.eINSTANCE.createVariableImplementationsList();
        context.setVariableImplementationsList(variableImplementationsList);
        for (Variable variable : invocatorSession.getEnvironment().getVariablesList().getVariables()) {
            VariableImplementation variableImplementation = ApogyCoreInvocatorFactory.eINSTANCE.createVariableImplementation();
            variableImplementation.setVariable(variable);
            List eClasses = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(variableImplementation.getHandlingType().getInterfaceClass());
            if (!eClasses.isEmpty()) {
                variableImplementation.setImplementationClass((EClass)eClasses.get(0));
            }
            variableImplementation.getTypeMemberImplementations().addAll(ApogyCoreInvocatorFacade.INSTANCE.createTypeMemberImplementations(variable.getVariableType()));
            variableImplementationsList.getVariableImplementations().add((Object)variableImplementation);
        }
        return context;
    }

    @Override
    public void addVariable(VariablesList variablesList, Variable variable) {
        variablesList.getVariables().add((Object)variable);
    }

    @Override
    public void deleteVariable(VariablesList variablesList, Variable variable) {
        variablesList.getVariables().remove((Object)variable);
    }

    @Override
    public String getOperationCallString(OperationCall operationCall) {
        return this.getOperationCallString(operationCall, false);
    }

    @Override
    public String getOperationCallString(OperationCall operationCall, boolean hideEParamaters) {
        String str = "";
        if (operationCall.getVariable() != null) {
            str = String.valueOf(str) + operationCall.getVariable().getName();
        }
        str = String.valueOf(str) + this.getSubTypeFeatureString(operationCall.getTypeMemberReferenceListElement(), operationCall.getFeatureRoot());
        if (operationCall.getEOperation() != null) {
            if (hideEParamaters) {
                str = String.valueOf(str) + this.getEOperationString(null, operationCall.getEOperation());
                str = str.substring(0, str.length() - 2);
            } else {
                str = String.valueOf(str) + this.getEOperationString(operationCall.getArgumentsList(), operationCall.getEOperation());
            }
        }
        return str;
    }

    @Override
    public String getVariableFeatureReferenceString(VariableFeatureReference variableFeatureReference) {
        String str = "";
        if (variableFeatureReference.getVariable() != null) {
            str = String.valueOf(str) + variableFeatureReference.getVariable().getName();
        }
        str = String.valueOf(str) + this.getSubTypeFeatureString(variableFeatureReference.getTypeMemberReferenceListElement(), variableFeatureReference.getFeatureRoot());
        return str;
    }

    @Override
    public String getEOperationString(ArgumentsList argumentList, EOperation eOperation) {
        String str = "#";
        String operation_str = eOperation == null ? "NO_OPERATION" : eOperation.getName();
        String eParamaters_str = null;
        if (argumentList != null && !argumentList.getArguments().isEmpty()) {
            eParamaters_str = "(";
            for (EParameter eParameter : eOperation.getEParameters()) {
                eParamaters_str = String.valueOf(eParamaters_str) + eParameter.getEType().getName() + " ";
                eParamaters_str = String.valueOf(eParamaters_str) + eParameter.getName() + ", ";
            }
            eParamaters_str = eParamaters_str.substring(0, eParamaters_str.length() - 2);
            eParamaters_str = String.valueOf(eParamaters_str) + ")";
        } else {
            eParamaters_str = "()";
        }
        return String.valueOf(str) + operation_str + eParamaters_str;
    }

    @Override
    public String getSubTypeFeatureString(TypeMemberReferenceListElement typeMemberReferenceListElement, ListRootNode listRootNode) {
        AbstractFeatureListNode leaf;
        String typeReference_str = "";
        if (typeMemberReferenceListElement != null) {
            typeReference_str = ARROW_STRING + typeMemberReferenceListElement.getTypeMember().getName();
            TypeMemberReferenceListElement current = typeMemberReferenceListElement.getChild();
            while (current != null) {
                typeReference_str = String.valueOf(typeReference_str) + ARROW_STRING + current.getTypeMember().getName();
                current = current.getChild();
            }
        }
        String feature_str = "";
        if (listRootNode != null && (leaf = ApogyCommonEMFFacade.INSTANCE.getLeaf(listRootNode)) != null) {
            feature_str = "." + ApogyCommonEMFFacade.INSTANCE.getAncestriesString((AbstractFeatureNode)leaf);
        }
        return String.valueOf(typeReference_str) + feature_str;
    }

    @Override
    public ListRootNode createListRootNode(VariableFeatureReference variableFeatureReference, EStructuralFeature[] features) {
        ListRootNode listRootNode = null;
        if (features.length > 0) {
            listRootNode = ApogyCommonEMFFactory.eINSTANCE.createListRootNode();
            listRootNode.setSourceClass(ApogyCoreInvocatorFacade.INSTANCE.getInstanceClass(variableFeatureReference));
            ListRootNode parentNode = listRootNode;
            int i = 0;
            while (i < features.length) {
                ListFeatureNode node = ApogyCommonEMFFactory.eINSTANCE.createListFeatureNode();
                node.setStructuralFeature(features[i]);
                parentNode.setChild((AbstractFeatureListNode)node);
                parentNode = node;
                ++i;
            }
        }
        return listRootNode;
    }

    @Override
    public String getAbstractTypeImplementationName(AbstractTypeImplementation implementation) {
        String str;
        if (implementation instanceof VariableImplementation) {
            VariableImplementation variableImplementation = (VariableImplementation)implementation;
            str = variableImplementation.getVariable().getName();
        } else {
            TypeMemberImplementation typeMemberImplementation = (TypeMemberImplementation)implementation;
            str = typeMemberImplementation.getTypeMember().getName();
        }
        return str;
    }

    @Override
    public String getAbstractTypeImplementationInterfaceName(AbstractTypeImplementation implementation, boolean fullyQualified) {
        String str = "";
        if (implementation instanceof VariableImplementation) {
            VariableImplementation variableImplementation = (VariableImplementation)implementation;
            if (variableImplementation.getVariable().getVariableType().getInterfaceClass() != null) {
                str = fullyQualified ? variableImplementation.getVariable().getVariableType().getInterfaceClass().getInstanceTypeName() : variableImplementation.getVariable().getVariableType().getInterfaceClass().getName();
            }
        } else {
            TypeMemberImplementation typeMemberImplementation = (TypeMemberImplementation)implementation;
            if (typeMemberImplementation.getTypeMember().getMemberType().getInterfaceClass() != null) {
                str = fullyQualified ? typeMemberImplementation.getTypeMember().getMemberType().getInterfaceClass().getInstanceTypeName() : typeMemberImplementation.getTypeMember().getMemberType().getInterfaceClass().getName();
            }
        }
        return str;
    }

    @Override
    public String getAbstractTypeImplementationImplementationName(AbstractTypeImplementation implementation, boolean fullyQualified) {
        String str = "";
        if (implementation.getImplementationClass() != null) {
            str = fullyQualified ? implementation.getImplementationClass().getInstanceTypeName() : implementation.getImplementationClass().getName();
        }
        return str;
    }

    @Override
    public void setEOperationInitArguments(EOperation eOperation, OperationCall operationCall) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        for (EParameter parameter : eOperation.getEParameters()) {
            Object defaultValue;
            Argument argument = null;
            if (parameter.getEType() instanceof EEnum) {
                argument = ApogyCoreInvocatorFactory.eINSTANCE.createEEnumArgument();
                EEnum eEnum = (EEnum)parameter.getEType();
                argument.setEEnum(eEnum);
                defaultValue = (Enum)parameter.getEType().getDefaultValue();
                ((EEnumArgument)argument).setEEnumLiteral(eEnum.getEEnumLiteral(((Enum)defaultValue).name()));
            } else if (parameter.getEType() instanceof EDataType) {
                Class clazz = parameter.getEType().getInstanceClass();
                if (clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(Boolean.class)) {
                    argument = ApogyCoreInvocatorFactory.eINSTANCE.createBooleanEDataTypeArgument();
                } else if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Double.TYPE)) {
                    argument = ApogyCoreInvocatorFactory.eINSTANCE.createNumericEDataTypeArgument();
                } else {
                    argument = ApogyCoreInvocatorFactory.eINSTANCE.createStringEDataTypeArgument();
                    ((StringEDataTypeArgument)argument).setValue("DEFAULT");
                }
                defaultValue = parameter.getEType().getDefaultValue();
                if (defaultValue != null) {
                    ((EDataTypeArgument)argument).setValue(String.valueOf(defaultValue));
                }
            } else {
                argument = ApogyCoreInvocatorFactory.eINSTANCE.createEClassArgument();
            }
            arguments.add(argument);
        }
        if (!arguments.isEmpty()) {
            ArgumentsList argumentsList = ApogyCoreInvocatorFactory.eINSTANCE.createArgumentsList();
            argumentsList.getArguments().addAll(arguments);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)operationCall, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST, (Object)argumentsList, true);
        } else {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)operationCall, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST, null);
        }
    }

    @Override
    public OperationCall createOperationCall(VariableFeatureReference variableFeatureReference, EOperation eOperation, List<Object> parameterValues) {
        VariableFeatureReference copy = this.cloneVariableFeatureReference(variableFeatureReference);
        OperationCall operationCall = ApogyCoreInvocatorFactory.eINSTANCE.createOperationCall();
        operationCall.setVariable(copy.getVariable());
        operationCall.setTypeMemberReferenceListElement(copy.getTypeMemberReferenceListElement());
        operationCall.setFeatureRoot(copy.getFeatureRoot());
        operationCall.setEOperation(eOperation);
        this.setEOperationInitArguments(eOperation, operationCall);
        ArgumentsList argumentList = operationCall.getArgumentsList();
        if (argumentList != null && argumentList.getArguments().size() > 0) {
            int index = 0;
            for (Argument argument : argumentList.getArguments()) {
                if (argument instanceof EEnumArgument) {
                    try {
                        EEnumArgument eEnumArgument = (EEnumArgument)argument;
                        Enumerator enumerator = (Enumerator)parameterValues.get(index);
                        EEnumLiteral eenumLiteral = eEnumArgument.getEEnum().getEEnumLiteral(enumerator.getName());
                        eEnumArgument.setEEnumLiteral(eenumLiteral);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                } else if (argument instanceof BooleanEDataTypeArgument) {
                    BooleanEDataTypeArgument booleanEDataTypeArgument = (BooleanEDataTypeArgument)argument;
                    Boolean bool = (Boolean)parameterValues.get(index);
                    booleanEDataTypeArgument.setValue(bool.toString());
                } else if (argument instanceof NumericEDataTypeArgument) {
                    NumericEDataTypeArgument numericEDataTypeArgument = (NumericEDataTypeArgument)argument;
                    Number number = (Number)parameterValues.get(index);
                    numericEDataTypeArgument.setValue(number.toString());
                } else if (argument instanceof StringEDataTypeArgument) {
                    StringEDataTypeArgument stringEDataTypeArgument = (StringEDataTypeArgument)argument;
                    stringEDataTypeArgument.setValue((String)parameterValues.get(index));
                } else if (argument instanceof EClassArgument) {
                    EClassArgument eClassArgument = (EClassArgument)argument;
                    eClassArgument.setValue((EObject)parameterValues.get(index));
                }
                ++index;
            }
        }
        return operationCall;
    }

    @Override
    public VariableFeatureReference cloneVariableFeatureReference(VariableFeatureReference source) {
        Object dstChild;
        Object srcChild;
        Object dstCurrent;
        Object srcCurrent;
        VariableFeatureReference destination = ApogyCoreInvocatorFactory.eINSTANCE.createVariableFeatureReference();
        destination.setVariable(source.getVariable());
        ListRootNode srcFeatureRoot = source.getFeatureRoot();
        if (srcFeatureRoot != null) {
            ListRootNode dstFeatureRoot = ApogyCommonEMFFactory.eINSTANCE.createListRootNode();
            dstFeatureRoot.setSourceClass(srcFeatureRoot.getSourceClass());
            srcCurrent = srcFeatureRoot;
            dstCurrent = dstFeatureRoot;
            while (srcCurrent.getChild() != null) {
                srcChild = (ListFeatureNode)srcCurrent.getChild();
                dstChild = ApogyCommonEMFFactory.eINSTANCE.createListFeatureNode();
                dstChild.setStructuralFeature(srcChild.getStructuralFeature());
                dstCurrent.setChild((AbstractFeatureListNode)dstChild);
                srcCurrent = srcChild;
                dstCurrent = dstChild;
            }
            destination.setFeatureRoot(dstFeatureRoot);
        }
        if (source.getTypeMemberReferenceListElement() != null) {
            TypeMemberReferenceListElement dstTypeMemberReferenceListElement = ApogyCoreInvocatorFactory.eINSTANCE.createTypeMemberReferenceListElement();
            srcCurrent = source.getTypeMemberReferenceListElement();
            dstCurrent = dstTypeMemberReferenceListElement;
            dstCurrent.setTypeMember(srcCurrent.getTypeMember());
            while (srcCurrent.getChild() != null) {
                srcChild = srcCurrent.getChild();
                dstChild = ApogyCoreInvocatorFactory.eINSTANCE.createTypeMemberReferenceListElement();
                dstChild.setTypeMember(srcChild.getTypeMember());
                dstCurrent.setChild((TypeMemberReferenceListElement)dstChild);
                srcCurrent = srcChild;
                dstCurrent = dstChild;
            }
            destination.setTypeMemberReferenceListElement(dstTypeMemberReferenceListElement);
        }
        return destination;
    }

    @Override
    public VariableFeatureReference createVariableFeatureReference(EObject eOject) {
        Environment environment;
        VariableFeatureReference vfr = null;
        if (this.getActiveInvocatorSession() != null && (environment = this.getActiveInvocatorSession().getEnvironment()) != null) {
            for (Variable variable : environment.getVariablesList().getVariables()) {
                if (this.getInstance(variable) == eOject) {
                    vfr = ApogyCoreInvocatorFactory.eINSTANCE.createVariableFeatureReference();
                    vfr.setVariable(variable);
                    return vfr;
                }
                VariableFeatureReference memberVFR = ApogyCoreInvocatorFactory.eINSTANCE.createVariableFeatureReference();
                memberVFR.setVariable(variable);
                for (TypeMember typeMember : variable.getVariableType().getMembers()) {
                    TypeMemberReferenceListElement tmrle = ApogyCoreInvocatorFactory.eINSTANCE.createTypeMemberReferenceListElement();
                    tmrle.setTypeMember(typeMember);
                    memberVFR.setTypeMemberReferenceListElement(tmrle);
                    if (this.getTypeMemberInstance(memberVFR) != eOject) continue;
                    return memberVFR;
                }
            }
        }
        return vfr;
    }

    @Override
    public Object getResultValue(AbstractResult abstractResult) {
        Object value = null;
        AbstractResultValue abstractResultValue = abstractResult.getResultValue();
        if (abstractResultValue instanceof AttributeResultValue) {
            AttributeResultValue attributeResultValue = (AttributeResultValue)abstractResultValue;
            AttributeValue attributeValue = attributeResultValue.getValue();
            if (attributeValue != null) {
                value = attributeValue.getObject();
            }
        } else if (abstractResultValue instanceof ReferenceResultValue) {
            ReferenceResultValue referenceResultValue = (ReferenceResultValue)abstractResultValue;
            value = referenceResultValue.getValue();
        }
        return value;
    }
}

