/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.listeners;

import org.eclipse.apogy.common.emf.AbstractFeatureListNode;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.ListFeatureNode;
import org.eclipse.apogy.common.emf.ListRootNode;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.TypeMemberReferenceListElement;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;

public class AbstractVariableFeatureReferenceListener {
    protected VariableFeatureReference variableFeatureReference;
    private Adapter variableFeatureReferenceAdapter;
    private Adapter contextAdapter;
    private Adapter environmentAdapter;
    private Adapter listRootNodeAdapter;
    private EObject previousInstance;
    private TypeApiAdapter previousTypeApiAdapterInstance;

    public AbstractVariableFeatureReferenceListener(VariableFeatureReference variableFeatureReference) {
        this.setVariableFeatureReference(variableFeatureReference);
    }

    public void setVariableFeatureReference(VariableFeatureReference newVariableFeatureReference) {
        if (this.variableFeatureReference != null) {
            this.unRegisterFrom(this.variableFeatureReference, this.getVariableFeatureReferenceAdapter());
        }
        this.variableFeatureReference = newVariableFeatureReference;
        if (newVariableFeatureReference != null) {
            this.registerTo(this.variableFeatureReference, this.getVariableFeatureReferenceAdapter());
        }
        this.update();
    }

    protected void contextChanged(Context oldContext, Context newContext) {
    }

    protected void instanceChanged(EObject oldInstance, EObject newInstance) {
    }

    protected void typeApiAdapterChanged(TypeApiAdapter oldTypeApiAdapter, TypeApiAdapter newTypeApiAdapter) {
    }

    protected void variableChanged(Variable oldVariable, Variable newVariable) {
    }

    protected void listRootNodeChanged() {
    }

    private void updateInstance(EObject newInstance) {
        if (this.previousInstance != newInstance) {
            this.instanceChanged(this.previousInstance, newInstance);
        }
        this.previousInstance = newInstance;
    }

    private void updateTypeApiAdapter(TypeApiAdapter newTypeApiAdapter) {
        if (this.previousTypeApiAdapterInstance != newTypeApiAdapter) {
            this.typeApiAdapterChanged(this.previousTypeApiAdapterInstance, newTypeApiAdapter);
            this.previousTypeApiAdapterInstance = newTypeApiAdapter;
        }
    }

    private void update() {
        try {
            if (this.variableFeatureReference != null) {
                EObject newInstance = ApogyCoreInvocatorFacade.INSTANCE.getInstance(this.variableFeatureReference);
                this.updateInstance(newInstance);
                TypeApiAdapter newTypeApiAdapter = ApogyCoreInvocatorFacade.INSTANCE.getTypeApiAdapter(this.variableFeatureReference);
                this.updateTypeApiAdapter(newTypeApiAdapter);
            } else {
                this.updateInstance(null);
                this.updateTypeApiAdapter(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void registerTo(VariableFeatureReference variableFeatureReference, Adapter adapter) {
        if (variableFeatureReference != null) {
            variableFeatureReference.eAdapters().add((Object)adapter);
            if (variableFeatureReference.getVariable() != null) {
                this.registerTo(variableFeatureReference.getVariable(), adapter);
            }
            if (variableFeatureReference.getFeatureRoot() != null) {
                this.registerTo(variableFeatureReference.getFeatureRoot());
            }
            if (variableFeatureReference.getTypeMemberReferenceListElement() != null) {
                this.registerTo(variableFeatureReference.getTypeMemberReferenceListElement(), adapter);
            }
        }
    }

    protected void unRegisterFrom(VariableFeatureReference variableFeatureReference, Adapter adapter) {
        if (variableFeatureReference != null) {
            variableFeatureReference.eAdapters().remove((Object)adapter);
            if (variableFeatureReference.getVariable() != null) {
                this.unRegisterFrom(variableFeatureReference.getVariable(), adapter);
            }
            if (variableFeatureReference.getFeatureRoot() != null) {
                this.unRegisterFrom(variableFeatureReference.getFeatureRoot());
            }
            if (variableFeatureReference.getTypeMemberReferenceListElement() != null) {
                this.unRegisterFrom(variableFeatureReference.getTypeMemberReferenceListElement(), adapter);
            }
        }
    }

    protected void registerTo(Variable variable, Adapter adapter) {
        if (variable != null) {
            variable.eAdapters().add((Object)adapter);
            if (variable.getEnvironment() != null) {
                this.registerTo(variable.getEnvironment());
            }
        }
    }

    protected void unRegisterFrom(Variable variable, Adapter adapter) {
        if (variable != null) {
            variable.eAdapters().remove((Object)adapter);
            if (variable.getEnvironment() != null) {
                this.unRegisterFrom(variable.getEnvironment());
            }
        }
    }

    protected void registerTo(Environment environment) {
        if (environment != null) {
            environment.eAdapters().add((Object)this.getEnvironmentAdapter());
            if (environment.getActiveContext() != null) {
                this.registerTo(environment.getActiveContext());
            }
        }
    }

    protected void unRegisterFrom(Environment environment) {
        if (environment != null) {
            environment.eAdapters().remove((Object)this.getEnvironmentAdapter());
            if (environment.getActiveContext() != null) {
                this.unRegisterFrom(environment.getActiveContext());
            }
        }
    }

    protected void registerTo(Context context) {
        if (context != null) {
            context.eAdapters().add((Object)this.getContextAdapter());
        }
    }

    protected void unRegisterFrom(Context context) {
        if (context != null) {
            context.eAdapters().remove((Object)this.getContextAdapter());
        }
    }

    protected void registerTo(ListRootNode listRootNode) {
        if (listRootNode != null) {
            listRootNode.eAdapters().add((Object)this.getListRootNodeAdapter());
            AbstractFeatureListNode child = listRootNode.getChild();
            while (child != null) {
                child.eAdapters().add((Object)this.getListRootNodeAdapter());
                child = child.getChild();
            }
        }
        this.listRootNodeChanged();
    }

    protected void unRegisterFrom(ListRootNode listRootNode) {
        if (listRootNode != null) {
            listRootNode.eAdapters().remove((Object)this.getListRootNodeAdapter());
            AbstractFeatureListNode child = listRootNode.getChild();
            while (child != null) {
                child.eAdapters().remove((Object)this.getListRootNodeAdapter());
                child = child.getChild();
            }
        }
        this.listRootNodeChanged();
    }

    protected void registerTo(TypeMemberReferenceListElement typeMemberReferenceListElement, Adapter adapter) {
        if (typeMemberReferenceListElement != null) {
            typeMemberReferenceListElement.eAdapters().add((Object)adapter);
            TypeMemberReferenceListElement child = typeMemberReferenceListElement.getChild();
            while (child != null) {
                child.eAdapters().add((Object)adapter);
                child = child.getChild();
            }
        }
    }

    protected void unRegisterFrom(TypeMemberReferenceListElement typeMemberReferenceListElement, Adapter adapter) {
        if (typeMemberReferenceListElement != null) {
            typeMemberReferenceListElement.eAdapters().remove((Object)adapter);
            TypeMemberReferenceListElement child = typeMemberReferenceListElement.getChild();
            while (child != null) {
                child.eAdapters().remove((Object)adapter);
                child = child.getChild();
            }
        }
    }

    private Adapter getContextAdapter() {
        if (this.contextAdapter == null) {
            this.contextAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(Context.class) == 6) {
                        AbstractVariableFeatureReferenceListener.this.update();
                    } else if (msg.getFeatureID(Context.class) == 7) {
                        AbstractVariableFeatureReferenceListener.this.update();
                    }
                }
            };
        }
        return this.contextAdapter;
    }

    private Adapter getEnvironmentAdapter() {
        if (this.environmentAdapter == null) {
            this.environmentAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(Environment.class) == 6) {
                        Context oldContext = null;
                        Context newContext = null;
                        if (msg.getOldValue() instanceof Context) {
                            oldContext = (Context)msg.getOldValue();
                            oldContext.eAdapters().remove((Object)AbstractVariableFeatureReferenceListener.this.getContextAdapter());
                        }
                        AbstractVariableFeatureReferenceListener.this.update();
                        if (msg.getNewValue() instanceof Context) {
                            newContext = (Context)msg.getNewValue();
                            newContext.eAdapters().add((Object)AbstractVariableFeatureReferenceListener.this.getContextAdapter());
                        }
                        AbstractVariableFeatureReferenceListener.this.contextChanged(oldContext, newContext);
                    }
                }
            };
        }
        return this.environmentAdapter;
    }

    private Adapter getListRootNodeAdapter() {
        if (this.listRootNodeAdapter == null) {
            this.listRootNodeAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof AbstractFeatureListNode) {
                        featureID = msg.getFeatureID(AbstractFeatureListNode.class);
                        switch (featureID) {
                            case 1: {
                                if (msg.getOldValue() instanceof ListFeatureNode) {
                                    ((ListFeatureNode)msg.getOldValue()).eAdapters().remove((Object)AbstractVariableFeatureReferenceListener.this.getListRootNodeAdapter());
                                }
                                if (msg.getNewValue() instanceof ListFeatureNode) {
                                    ((ListFeatureNode)msg.getNewValue()).eAdapters().add((Object)AbstractVariableFeatureReferenceListener.this.getListRootNodeAdapter());
                                }
                                AbstractVariableFeatureReferenceListener.this.update();
                                AbstractVariableFeatureReferenceListener.this.listRootNodeChanged();
                            }
                        }
                    }
                    if (msg.getNotifier() instanceof AbstractFeatureSpecifier) {
                        featureID = msg.getFeatureID(AbstractFeatureSpecifier.class);
                        AbstractVariableFeatureReferenceListener.this.update();
                        AbstractVariableFeatureReferenceListener.this.listRootNodeChanged();
                    }
                    if (msg.getNotifier() instanceof ListRootNode) {
                        featureID = msg.getFeatureID(ListRootNode.class);
                        switch (featureID) {
                            case 1: {
                                AbstractVariableFeatureReferenceListener.this.update();
                                AbstractVariableFeatureReferenceListener.this.listRootNodeChanged();
                                break;
                            }
                            default: {
                                AbstractVariableFeatureReferenceListener.this.update();
                            }
                        }
                    }
                }
            };
        }
        return this.listRootNodeAdapter;
    }

    private Adapter getVariableFeatureReferenceAdapter() {
        if (this.variableFeatureReferenceAdapter == null) {
            this.variableFeatureReferenceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof VariableFeatureReference) {
                        int featureId = msg.getFeatureID(VariableFeatureReference.class);
                        switch (featureId) {
                            case 3: {
                                AbstractVariableFeatureReferenceListener.this.unRegisterFrom((ListRootNode)msg.getOldValue());
                                AbstractVariableFeatureReferenceListener.this.registerTo((ListRootNode)msg.getNewValue());
                                EObject newInstance = ApogyCoreInvocatorFacade.INSTANCE.getInstance(AbstractVariableFeatureReferenceListener.this.variableFeatureReference);
                                AbstractVariableFeatureReferenceListener.this.updateInstance(newInstance);
                                break;
                            }
                            case 2: {
                                AbstractVariableFeatureReferenceListener.this.unRegisterFrom((TypeMemberReferenceListElement)msg.getOldValue(), (Adapter)this);
                                AbstractVariableFeatureReferenceListener.this.registerTo((TypeMemberReferenceListElement)msg.getNewValue(), (Adapter)this);
                                TypeApiAdapter newTypeApiAdapter = ApogyCoreInvocatorFacade.INSTANCE.getTypeApiAdapter(AbstractVariableFeatureReferenceListener.this.variableFeatureReference);
                                AbstractVariableFeatureReferenceListener.this.updateTypeApiAdapter(newTypeApiAdapter);
                                break;
                            }
                            case 1: {
                                Variable oldVariable = null;
                                Variable newVariable = null;
                                if (msg.getOldValue() instanceof Variable) {
                                    oldVariable = (Variable)msg.getOldValue();
                                }
                                if (msg.getNewValue() instanceof Variable) {
                                    newVariable = (Variable)msg.getNewValue();
                                }
                                AbstractVariableFeatureReferenceListener.this.variableChanged(oldVariable, newVariable);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.variableFeatureReferenceAdapter;
    }
}

