/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EdgeType implements Enumerator
{
    RISING(0, "RISING", "Rising"),
    FALLING(1, "FALLING", "Falling"),
    BOTH(2, "BOTH", "Both");

    public static final int RISING_VALUE = 0;
    public static final int FALLING_VALUE = 1;
    public static final int BOTH_VALUE = 2;
    private static final EdgeType[] VALUES_ARRAY;
    public static final List<EdgeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EdgeType[]{RISING, FALLING, BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EdgeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeType get(int value) {
        switch (value) {
            case 0: {
                return RISING;
            }
            case 1: {
                return FALLING;
            }
            case 2: {
                return BOTH;
            }
        }
        return null;
    }

    private EdgeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

