/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.parts;

import com.jme3.math.ColorRGBA;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.emf.ui.parts.AbstractEObjectSelectionPart;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFacade;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.apogy.common.topology.ui.viewer.IRenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewer;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewerProvider;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewerRegistry;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.topology.ui.ApogyCoreTopologyUIFacade;
import org.eclipse.apogy.core.topology.ui.DisplayedTopology;
import org.eclipse.apogy.core.topology.ui.DisplayedTopologyChoice;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySystem3dPart
extends AbstractEObjectSelectionPart
implements TopologyViewerProvider {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySystem3dPart.class);
    public static ColorRGBA VIEWER_BACKGROUND_COLOR = new ColorRGBA(0.5686275f, 0.9137255f, 1.0f, 1.0f);
    protected ApogySystem apogySystem;
    protected DisplayedTopology displayedTopology = DisplayedTopology.ASSEMBLY;
    protected TopologyViewer topologyViewer;
    private Adapter topologyTopologyViewerRegistryAdapter = null;
    private Adapter editedApogySystemAssemblyRootAdapter = null;
    private String currentDirectory = System.getProperty("user.dir");
    @Inject
    Shell shell;

    public TopologyViewer getTopologyViewer() {
        return this.topologyViewer;
    }

    public void takeScreenshot() {
        this.getTopologyViewer().takeScreenshot();
        BufferedImage image = this.getTopologyViewer().takeScreenshot();
        if (image != null) {
            EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            eImage.setImageContent(image);
            if (eImage != null) {
                FileDialog fileChooser = new FileDialog(this.shell, 8192);
                fileChooser.setText("Saves image to file");
                fileChooser.setFilterPath(this.currentDirectory);
                fileChooser.setFilterExtensions(new String[]{"*.png;"});
                String filename = fileChooser.open();
                if (filename != null) {
                    try {
                        if (filename.endsWith(".png")) {
                            this.saveImageInJob((AbstractEImage)eImage, filename, 5);
                        } else {
                            String fileExtension = "";
                            if (filename.lastIndexOf(".") > 0) {
                                fileExtension = filename.substring(filename.lastIndexOf("."));
                            }
                            String message = "Failed to save the image. The specified file extension <" + fileExtension + "> is not supported.";
                            Logger.error(message);
                            MessageBox messageBox = new MessageBox(this.shell, 33);
                            messageBox.setMessage(message);
                            messageBox.open();
                        }
                    }
                    catch (Exception e) {
                        Logger.error("Unable to save image to file <" + filename + ">.");
                    }
                    this.currentDirectory = fileChooser.getFilterPath();
                }
            }
        }
    }

    protected void setCompositeContents(EObject eObject) {
        if (eObject instanceof ApogySystem) {
            this.setApogySystem((ApogySystem)eObject);
        } else if (eObject instanceof DisplayedTopologyChoice) {
            DisplayedTopologyChoice displayedTopologyChoice = (DisplayedTopologyChoice)eObject;
            this.setDisplayedTopology(displayedTopologyChoice.getDisplayedTopology());
        }
    }

    protected HashMap<String, ISelectionListener> getSelectionProvidersIdsToSelectionListeners() {
        HashMap<String, ISelectionListener> selectionProvidersIdsToSelectionListeners = new HashMap<String, ISelectionListener>();
        selectionProvidersIdsToSelectionListeners.put("org.eclipse.apogy.core.topology.ui.parts.apogysystemfileeditor", new ISelectionListener(){

            public void selectionChanged(MPart mPart, Object object) {
                if (object != null && object instanceof EObject) {
                    ApogySystem3dPart.this.setEObject((EObject)object);
                }
            }
        });
        selectionProvidersIdsToSelectionListeners.put("org.eclipse.apogy.core.topology.ui.part.apogysystemtopology", new ISelectionListener(){

            public void selectionChanged(MPart mPart, Object object) {
                if (object != null && object instanceof EObject) {
                    ApogySystem3dPart.this.setEObject((EObject)object);
                }
            }
        });
        return selectionProvidersIdsToSelectionListeners;
    }

    public void userPostConstruct(MPart mPart) {
        ApogyCoreTopologyUIFacade.INSTANCE.eAdapters().add((Object)this.getEditedApogySystemAssemblyRootAdapter());
        super.userPostConstruct(mPart);
    }

    public void userPreDestroy(MPart mPart) {
        ApogyCoreTopologyUIFacade.INSTANCE.eAdapters().remove((Object)this.getEditedApogySystemAssemblyRootAdapter());
        super.userPreDestroy(mPart);
    }

    protected void setApogySystem(ApogySystem newApogySystem) {
        if (this.apogySystem != newApogySystem) {
            this.apogySystem = newApogySystem;
            this.updateDisplayedTopology();
        }
    }

    protected void setDisplayedTopology(DisplayedTopology newDisplayedTopology) {
        if (this.displayedTopology != newDisplayedTopology) {
            this.displayedTopology = newDisplayedTopology;
            this.updateDisplayedTopology();
        }
    }

    private void updateDisplayedTopology() {
        Node root = null;
        switch (this.displayedTopology.getValue()) {
            case 2: {
                if (this.apogySystem == null || this.apogySystem.getTopologyRoot() == null) break;
                root = this.apogySystem.getTopologyRoot().getOriginNode();
                break;
            }
            case 1: {
                root = ApogyCoreTopologyUIFacade.INSTANCE.getEditedApogySystemAssemblyRoot();
                break;
            }
        }
        if (root == null) {
            root = ApogyCommonTopologyFactory.eINSTANCE.createAggregateContentNode();
        }
        if (this.topologyViewer != null) {
            GraphicsContext graphicsContext = ApogyCommonTopologyUIFacade.INSTANCE.createGraphicsContext(root);
            this.topologyViewer.setInput((Object)graphicsContext);
        }
    }

    protected void createNoContentComposite(Composite parent, int style) {
        new NoContentComposite(parent, 0){

            protected String getMessage() {
                return "No Apogy System Topology to display.";
            }
        };
    }

    protected void createContentComposite(Composite parent, int style) {
        JME3RenderEngineDelegate jme3RenderEngineDelegate = this.createJME3RenderEngineDelegate();
        this.topologyViewer = new TopologyViewer(parent, (IRenderEngineDelegate)jme3RenderEngineDelegate);
        jme3RenderEngineDelegate.setMaximumFrameRate(this.topologyViewer.getMaximumFrameRate());
        jme3RenderEngineDelegate.setAntiAliasing(this.topologyViewer.isAntiAliasingEnabled());
        jme3RenderEngineDelegate.setShowStatisticsEnabled(this.topologyViewer.isShowStatisticsEnabled());
        jme3RenderEngineDelegate.setAmbientLightEnabled(true);
        Activator.getTopologyViewerRegistry().eAdapters().add((Object)this.getTopologyTopologyViewerRegistryAdapter());
    }

    protected JME3RenderEngineDelegate createJME3RenderEngineDelegate() {
        JME3RenderEngineDelegate engineDelegate = new JME3RenderEngineDelegate(){

            protected JME3Application createJME3Application(Composite parent) {
                JME3Application app = new JME3Application(parent){

                    public void simpleInitApp() {
                        super.simpleInitApp();
                        this.getCamera().setFrustumFar(100.0f);
                        this.getViewPort().setBackgroundColor(VIEWER_BACKGROUND_COLOR);
                    }

                    protected void initLighting() {
                        super.initLighting();
                    }
                };
                app.setJMERenderEngineDelegate((JME3RenderEngineDelegate)this);
                return app;
            }
        };
        return engineDelegate;
    }

    protected Adapter getEditedApogySystemAssemblyRootAdapter() {
        if (this.editedApogySystemAssemblyRootAdapter == null) {
            this.editedApogySystemAssemblyRootAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId;
                    if (msg.getNotifier() instanceof ApogyCoreTopologyUIFacade && (featureId = msg.getFeatureID(ApogyCoreTopologyUIFacade.class)) == 0) {
                        ApogySystem3dPart.this.updateDisplayedTopology();
                    }
                }
            };
        }
        return this.editedApogySystemAssemblyRootAdapter;
    }

    private Adapter getTopologyTopologyViewerRegistryAdapter() {
        if (this.topologyTopologyViewerRegistryAdapter == null) {
            this.topologyTopologyViewerRegistryAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof TopologyViewerRegistry) {
                        int featureId = msg.getFeatureID(TopologyViewerRegistry.class);
                        switch (featureId) {
                            case 1: {
                                if (!(msg.getNewValue() instanceof NodeSelection)) break;
                                NodeSelection nodeSelection = (NodeSelection)msg.getNewValue();
                                ApogySystem3dPart.this.selectionService.setSelection((Object)nodeSelection);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.topologyTopologyViewerRegistryAdapter;
    }

    private void saveImageInJob(final AbstractEImage image, final String fileName, final int fileType) {
        UIJob job = new UIJob("Save Image to file <" + fileName + ">"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (fileType == 4) {
                        EImagesUtilities.INSTANCE.saveImageAsJPEG(fileName, image);
                    } else if (fileType == 5) {
                        EImagesUtilities.INSTANCE.saveImageAsPNG(fileName, image);
                    }
                    Logger.info("Sucessfully saved image to file <" + fileName + ">.");
                    Status status = new Status(0, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)ApogySystem3dPart.this)).getClass()), "Sucessfully saved image to file <" + fileName + ">.");
                    return status;
                }
                catch (Exception e) {
                    String message = "Failed to save the image to file <" + fileName + ">. The following exception was thrown : \n\n " + e.getMessage();
                    Logger.error(message, (Throwable)e);
                    Status status = new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)ApogySystem3dPart.this)).getClass()), message, (Throwable)e);
                    return status;
                }
            }
        };
        job.schedule();
    }
}

