/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.ui.wizards;

import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GenerateJavaClassForROSWizardDestinationPage
extends WizardPage {
    protected static String path = System.getProperty("user.home");
    private Composite container;
    private Button browseButton = null;

    public GenerateJavaClassForROSWizardDestinationPage(String pageName) {
        super(pageName);
        this.setTitle("Generate ROS Java classes Settings.");
        this.setDescription("This wizard generates Java classes for a given ROS package.");
        String message = this.validate();
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getPath() {
        return path;
    }

    public String getROSPackagePath() {
        Map<String, String> env = System.getenv();
        String rosPackagePath = env.get("ROS_PACKAGE_PATH");
        return rosPackagePath;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        this.container.setLayout((Layout)layout);
        Label sourceROSPackagePathLabel = new Label(this.container, 0);
        sourceROSPackagePathLabel.setText("ROS_PACKAGE_PATH = ");
        sourceROSPackagePathLabel.setToolTipText("The current value of the environment variable ROS_PACKAGE_PATH");
        Label sourceROSPackagePathDisplay = new Label(this.container, 0);
        GridData sourceROSPackagePathGridData = new GridData(4, 0x1000000, true, false);
        sourceROSPackagePathDisplay.setLayoutData((Object)sourceROSPackagePathGridData);
        if (this.getROSPackagePath() != null) {
            sourceROSPackagePathDisplay.setText(this.getROSPackagePath());
        } else {
            sourceROSPackagePathDisplay.setText("");
        }
        Label filler = new Label(this.container, 0);
        filler.setText("");
        Label destinationFolderLabel = new Label(this.container, 0);
        destinationFolderLabel.setText("Destination folder:");
        final Label destinationFolderDisplay = new Label(this.container, 0);
        GridData destinationFolderDisplayGridData = new GridData(4, 0x1000000, true, false);
        destinationFolderDisplay.setLayoutData((Object)destinationFolderDisplayGridData);
        destinationFolderDisplay.setText(this.getPath());
        this.browseButton = new Button(this.container, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(GenerateJavaClassForROSWizardDestinationPage.this.getShell(), 0);
                directoryDialog.setFilterPath(path);
                directoryDialog.setMessage("ROS Java class output folder.");
                String newPath = directoryDialog.open();
                if (newPath != null) {
                    path = newPath;
                    destinationFolderDisplay.setText(newPath);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.container);
    }

    private String validate() {
        if (this.getROSPackagePath() == null) {
            return "ROS_PACKAGE_PATH environment variable is not defined !";
        }
        if (this.getPath() == null) {
            return "No destination path specified !";
        }
        return null;
    }
}

