/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.ros.ApogyAddonsROSFactory;
import org.eclipse.apogy.addons.ros.ROSListener;
import org.eclipse.apogy.addons.ros.ROSListenerState;
import org.eclipse.apogy.addons.ros.ROSNode;
import org.eclipse.apogy.addons.ros.impl.ROSTopicLauncherImpl;
import org.ros.internal.message.Message;
import org.ros.message.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROSTopicLauncherCustomImpl
extends ROSTopicLauncherImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ROSTopicLauncherImpl.class);
    public static int MAX_LISTENER_TRIES = 1;
    public static long WAIT_TIME_BETWEEN_TRIES_MS = 1000L;
    private final List<TopicLaunchRunnable> topicLaunchRunnableList = new ArrayList<TopicLaunchRunnable>();

    @Override
    public <M extends Message> void createListener(String topicName, String messageType, MessageListener<M> messageListener) {
        ROSListener<M> listener = ApogyAddonsROSFactory.eINSTANCE.createROSListener();
        listener.setTopicName(topicName);
        listener.setMessageType(messageType);
        listener.setMessageListener(messageListener);
        this.getListenerList().add(listener);
    }

    @Override
    public void launch() {
        String listenerListMsg = "";
        for (ROSListener listener : this.getListenerList()) {
            listenerListMsg = String.valueOf(listenerListMsg) + listener.getTopicName() + "\n";
        }
        Logger.info("Starts launching the following topics : \n" + listenerListMsg);
        for (ROSListener listener : this.getListenerList()) {
            try {
                Logger.info("Launching listener for topic <" + listener.getTopicName() + ">.");
                TopicLaunchRunnable topicLaunchRunnable = new TopicLaunchRunnable(this.getNode(), listener);
                this.topicLaunchRunnableList.add(topicLaunchRunnable);
                Thread thread = new Thread(topicLaunchRunnable);
                thread.start();
            }
            catch (Exception e) {
                Logger.error("Failed to launch listener for topic <" + listener.getTopicName() + ">.", (Throwable)e);
            }
        }
        Logger.info("Topics launch completed.");
        this.setRunning(true);
    }

    @Override
    public void stop() {
        for (TopicLaunchRunnable topicLaunchRunnable : this.topicLaunchRunnableList) {
            topicLaunchRunnable.stop();
        }
        this.topicLaunchRunnableList.clear();
        for (ROSListener listener : this.getListenerList()) {
            listener.stop();
            listener.setListenerState(ROSListenerState.STOPPED);
        }
    }

    @Override
    public void reset() {
        this.stop();
        this.launch();
    }

    protected class TopicLaunchRunnable
    implements Runnable {
        private boolean stopRequested = false;
        private ROSNode rosNode = null;
        private ROSListener<?> listener = null;

        public TopicLaunchRunnable(ROSNode rosNode, ROSListener<?> listener) {
            this.rosNode = rosNode;
            this.listener = listener;
        }

        @Override
        public void run() {
            boolean success = false;
            while (!this.stopRequested && !success) {
                try {
                    this.listener.setListenerState(ROSListenerState.CONNECTING);
                    this.listener.start(this.rosNode);
                    this.listener.setListenerState(ROSListenerState.CONNECTED);
                    success = true;
                    Logger.info("Listener for topic <" + this.listener.getTopicName() + "> is running.");
                }
                catch (Throwable t) {
                    this.listener.setListenerState(ROSListenerState.CONNECTING);
                    success = false;
                    Logger.warn("Failed to launch listener for topic <" + this.listener.getTopicName() + ">, trying again.", t);
                    if (this.stopRequested) continue;
                    try {
                        Thread.sleep(WAIT_TIME_BETWEEN_TRIES_MS);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        public void stop() {
            this.stopRequested = true;
        }
    }
}

