/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Dome;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.fov.ui.FieldOfViewEntry3DTool;
import org.eclipse.apogy.addons.sensors.fov.ui.FieldOfViewEntry3DToolNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldOfViewEntry3DToolNodeJME3Object
extends DefaultJME3SceneObject<FieldOfViewEntry3DToolNode> {
    private static final Logger Logger = LoggerFactory.getLogger(FieldOfViewEntry3DToolNodeJME3Object.class);
    public static final float TIP_BASE_TO_VECTOR_BASE_RATIO = 2.0f;
    public static final float TIP_LENGHT_TO_BASE_RATIO = 4.0f;
    private FieldOfViewEntry3DTool tool = null;
    private Adapter adapter;
    private AssetManager assetManager;
    private com.jme3.scene.Node fromTransformNode;
    private com.jme3.scene.Node vectorBodyNode = null;
    private Geometry vectorBodyGeometry = null;
    private com.jme3.scene.Node tipTransformNode;
    private com.jme3.scene.Node vectorTipNode = null;
    private Geometry vectorTipGeometry = null;
    private ColorRGBA vectorColor = ColorRGBA.Red;

    public FieldOfViewEntry3DToolNodeJME3Object(FieldOfViewEntry3DToolNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.tool = ((FieldOfViewEntry3DToolNode)this.getTopologyNode()).getFieldOfViewEntry3DTool();
        this.assetManager = this.jme3Application.getAssetManager();
        this.vectorColor = JME3Utilities.convertToColorRGBA((RGB)this.convertToRGB(this.tool.getCurrentVectorColor()));
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                FieldOfViewEntry3DToolNodeJME3Object.this.createGeometry();
                FieldOfViewEntry3DToolNodeJME3Object.this.tool.eAdapters().add((Object)FieldOfViewEntry3DToolNodeJME3Object.this.getAdapter());
                return null;
            }
        });
    }

    public void updateGeometry(float tpf) {
        if (this.tool != null) {
            if (this.tool.getFromNode() != null) {
                this.updateDirection();
                this.updateVectorBody();
                this.updateVectorTip();
                this.attachTransformNode();
            } else {
                this.detachTransformNode();
            }
        }
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.vectorBodyGeometry);
        return geometries;
    }

    public void setVisible(final boolean visible) {
        Logger.info("Setting visible to <" + visible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (FieldOfViewEntry3DToolNodeJME3Object.this.fromTransformNode != null) {
                    if (!visible) {
                        FieldOfViewEntry3DToolNodeJME3Object.this.detachTransformNode();
                    } else {
                        FieldOfViewEntry3DToolNodeJME3Object.this.attachTransformNode();
                    }
                }
                return null;
            }
        });
    }

    public void setColor(RGB rgb) {
        if (rgb != null) {
            Logger.info("Setting color to <" + rgb + ">.");
            this.vectorColor = JME3Utilities.convertToColorRGBA((RGB)rgb);
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Material mat;
                    ColorRGBA color;
                    if (FieldOfViewEntry3DToolNodeJME3Object.this.vectorBodyGeometry != null) {
                        color = FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone();
                        color.a = 0.5f;
                        mat = FieldOfViewEntry3DToolNodeJME3Object.this.vectorBodyGeometry.getMaterial();
                        mat.setColor("Diffuse", FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone());
                        mat.setColor("Ambient", FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone());
                        mat.setColor("Specular", FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone());
                    }
                    if (FieldOfViewEntry3DToolNodeJME3Object.this.vectorTipGeometry != null) {
                        color = FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone();
                        color.a = 0.5f;
                        mat = FieldOfViewEntry3DToolNodeJME3Object.this.vectorTipGeometry.getMaterial();
                        mat.setColor("Diffuse", FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone());
                        mat.setColor("Ambient", FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone());
                        mat.setColor("Specular", FieldOfViewEntry3DToolNodeJME3Object.this.vectorColor.clone());
                    }
                    return null;
                }
            });
        }
    }

    public void dispose() {
        if (this.tool != null) {
            this.tool.eAdapters().remove((Object)this.getAdapter());
        }
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                FieldOfViewEntry3DToolNodeJME3Object.this.detachTransformNode();
                return null;
            }
        });
        super.dispose();
    }

    private void createGeometry() {
        this.vectorColor = JME3Utilities.convertToColorRGBA((Color3f)this.tool.getCurrentVectorColor());
        this.fromTransformNode = new com.jme3.scene.Node("Vector From");
        this.attachTransformNode();
        this.tipTransformNode = new com.jme3.scene.Node("Vector Tip");
        this.fromTransformNode.attachChild((Spatial)this.tipTransformNode);
        this.vectorBodyNode = this.createVectorBodyNode();
        this.vectorBodyGeometry = this.createVectorBodyGeometry();
        this.vectorBodyNode.attachChild((Spatial)this.vectorBodyGeometry);
        this.fromTransformNode.attachChild((Spatial)this.vectorBodyNode);
        this.vectorTipNode = this.createVectorTipNode();
        this.vectorTipGeometry = this.createVectorTipGeometry();
        this.vectorTipNode.attachChild((Spatial)this.vectorTipGeometry);
        this.fromTransformNode.attachChild((Spatial)this.vectorTipNode);
        this.updateVectorBody();
        this.updateVectorTip();
    }

    private void attachTransformNode() {
        if (this.fromTransformNode != null && !this.jme3Application.getRootNode().hasChild((Spatial)this.fromTransformNode)) {
            this.jme3Application.getRootNode().attachChild((Spatial)this.fromTransformNode);
        }
    }

    private void detachTransformNode() {
        if (this.fromTransformNode != null) {
            this.jme3Application.getRootNode().detachChild((Spatial)this.fromTransformNode);
        }
    }

    private com.jme3.scene.Node createVectorBodyNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Field Of View Vector");
        return node;
    }

    private Geometry createVectorBodyGeometry() {
        Geometry geometry = new Geometry("Field Of View Vector Body", this.getVectorBodyMesh());
        geometry.setMaterial(this.createMaterial());
        geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(1.5707964f, new Vector3f(0.0f, 1.0f, 0.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Material createMaterial() {
        ColorRGBA color = this.vectorColor.clone();
        color.a = 1.0f;
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Light/Lighting.j3md");
        mat.setColor("Diffuse", color);
        mat.setColor("Ambient", color);
        mat.setColor("Specular", color);
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        return mat;
    }

    private Mesh getVectorBodyMesh() {
        Cylinder cylinder = new Cylinder(4, 10, 1.0f, 1.0f, true);
        return cylinder;
    }

    private void updateVectorBody() {
        if (this.getTopologyNode() != null && this.tool != null) {
            float length = (float)this.tool.getCurrentVectorLength();
            float diameter = (float)this.tool.getVectorDiameter();
            this.vectorBodyGeometry.setLocalScale(diameter, diameter, length);
            this.vectorBodyNode.setLocalTranslation(length / 2.0f, 0.0f, 0.0f);
        }
    }

    private com.jme3.scene.Node createVectorTipNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Vector Tip");
        return node;
    }

    private Geometry createVectorTipGeometry() {
        Geometry geometry = new Geometry("Vector Tip Geometry", this.createVectorTipMesh());
        geometry.setMaterial(this.createMaterial());
        geometry.setLocalScale(1.0f, 1.0f, 1.0f);
        geometry.setLocalTranslation(0.0f, 0.0f, 0.0f);
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(-1.5707964f, new Vector3f(0.0f, 0.0f, 1.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Mesh createVectorTipMesh() {
        Dome dome = new Dome(2, 12, 1.0f);
        return dome;
    }

    private void updateVectorTip() {
        if (this.getTopologyNode() != null && this.tool != null) {
            float length = (float)this.tool.getCurrentVectorLength();
            float diameter = (float)this.tool.getVectorDiameter() * 2.0f;
            this.vectorTipGeometry.setLocalScale(diameter, diameter, diameter);
            this.vectorTipNode.setLocalTranslation(length, 0.0f, 0.0f);
        }
    }

    private void updateDirection() {
        Vector3f v;
        Node fromNode;
        if (this.getTopologyNode() != null && this.tool != null && (fromNode = this.tool.getFromNode()) != null) {
            this.fromTransformNode.setLocalTranslation(JME3Utilities.convertToVector3f((Tuple3d)this.tool.getFromAbsolutePosition().asTuple3d()));
            float tipLenght = (float)(this.tool.getVectorDiameter() * 4.0);
            this.tipTransformNode.setLocalTranslation((float)(this.tool.getCurrentVectorLength() + (double)tipLenght), 0.0f, 0.0f);
        }
        if ((v = this.getVectorDirection()) != null) {
            v = v.normalize();
            Quaternion rot = this.getQuarternionV1ToV2(new Vector3f(1.0f, 0.0f, 0.0f), v);
            this.fromTransformNode.setLocalRotation(rot);
        }
    }

    private Vector3f getVectorDirection() {
        if (this.getTopologyNode() != null && this.tool.getFromNode() != null && this.tool.getToNode() != null && this.tool.getFromAbsolutePosition() != null && this.tool.getToAbsolutePosition() != null) {
            Vector3d from = new Vector3d(this.tool.getFromAbsolutePosition().asTuple3d());
            Vector3d to = new Vector3d(this.tool.getToAbsolutePosition().asTuple3d());
            to.sub((Tuple3d)from);
            return new Vector3f((float)to.x, (float)to.y, (float)to.z);
        }
        return null;
    }

    private Quaternion getQuarternionV1ToV2(Vector3f v1, Vector3f v2) {
        float angle = v2.angleBetween(v1);
        Vector3f axis = v1.cross(v2);
        axis = axis.normalize();
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(angle, axis);
        return q;
    }

    private RGB convertToRGB(Color3f color) {
        int red = Math.round(color.x * 255.0f);
        int green = Math.round(color.y * 255.0f);
        int blue = Math.round(color.z * 255.0f);
        return new RGB(red, green, blue);
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    FieldOfViewEntry3DTool sunVector3DTool;
                    if (!(msg.getNotifier() instanceof FieldOfViewEntry3DToolNode) && msg.getNotifier() instanceof FieldOfViewEntry3DTool && !(sunVector3DTool = (FieldOfViewEntry3DTool)msg.getNotifier()).isDisposed()) {
                        int featureId = msg.getFeatureID(FieldOfViewEntry3DTool.class);
                        switch (featureId) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 27: {
                                FieldOfViewEntry3DToolNodeJME3Object.this.requestUpdate();
                                break;
                            }
                            case 28: {
                                FieldOfViewEntry3DToolNodeJME3Object.this.requestUpdate();
                                break;
                            }
                            case 23: {
                                if (!(msg.getNewValue() instanceof Color3f)) break;
                                Color3f color = (Color3f)msg.getNewValue();
                                FieldOfViewEntry3DToolNodeJME3Object.this.setColor(FieldOfViewEntry3DToolNodeJME3Object.this.convertToRGB(color));
                                break;
                            }
                            case 7: {
                                FieldOfViewEntry3DToolNodeJME3Object.this.setVisible(msg.getNewBooleanValue());
                                break;
                            }
                            case 22: {
                                if (((FieldOfViewEntry3DToolNode)FieldOfViewEntry3DToolNodeJME3Object.this.getTopologyNode()).getFieldOfViewEntry3DTool() != null) {
                                    ((FieldOfViewEntry3DToolNode)FieldOfViewEntry3DToolNodeJME3Object.this.getTopologyNode()).getFieldOfViewEntry3DTool().eAdapters().remove((Object)FieldOfViewEntry3DToolNodeJME3Object.this.getAdapter());
                                }
                                if (msg.getNewValue() != null) break;
                                FieldOfViewEntry3DToolNodeJME3Object.this.dispose();
                                break;
                            }
                            case 5: {
                                FieldOfViewEntry3DToolNodeJME3Object.this.dispose();
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

