/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImageSizePolicy implements Enumerator
{
    FIXED_SIZE(1, "FIXED_SIZE", "Fixed Size"),
    ALLOW_RESIZE_VERTICAL(2, "ALLOW_RESIZE_VERTICAL", "Allow Resize Vertical"),
    ALLOW_RESIZE_HORIZONTAL(3, "ALLOW_RESIZE_HORIZONTAL", "Allow Resize Horizontal"),
    ALLOW_RESIZE_BOTH(4, "ALLOW_RESIZE_BOTH", "Allow Resize Both");

    public static final int FIXED_SIZE_VALUE = 1;
    public static final int ALLOW_RESIZE_VERTICAL_VALUE = 2;
    public static final int ALLOW_RESIZE_HORIZONTAL_VALUE = 3;
    public static final int ALLOW_RESIZE_BOTH_VALUE = 4;
    private static final ImageSizePolicy[] VALUES_ARRAY;
    public static final List<ImageSizePolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ImageSizePolicy[]{FIXED_SIZE, ALLOW_RESIZE_VERTICAL, ALLOW_RESIZE_HORIZONTAL, ALLOW_RESIZE_BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ImageSizePolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImageSizePolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImageSizePolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImageSizePolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImageSizePolicy get(int value) {
        switch (value) {
            case 1: {
                return FIXED_SIZE;
            }
            case 2: {
                return ALLOW_RESIZE_VERTICAL;
            }
            case 3: {
                return ALLOW_RESIZE_HORIZONTAL;
            }
            case 4: {
                return ALLOW_RESIZE_BOTH;
            }
        }
        return null;
    }

    private ImageSizePolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

