/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.mobility.pathplanners.ApogyAddonsMobilityPathplannersPackage;
import org.eclipse.apogy.addons.mobility.pathplanners.MeshWayPointPathPlanner;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.ApogyAddonsMobilityPathplannersGraphFactory;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.DistanceAndSlopesCostFunction;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.SimpleDirectedWeightedGraphBasedMeshWayPointPathPlanner;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehicleFactory;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehiclePackage;
import org.eclipse.apogy.addons.vehicle.PathPlannerToolNode;
import org.eclipse.apogy.addons.vehicle.impl.PathPlannerToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.processors.ApogyCommonProcessorsPackage;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPlannerToolCustomImpl
extends PathPlannerToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PathPlannerToolImpl.class);
    public static int FROM_NODE_INDEX = 0;
    public static int TO_NODE_INDEX = 1;
    private int nextNode = FROM_NODE_INDEX;

    @Override
    public void setMeshLayer(CartesianTriangularMeshMapLayer newMeshLayer) {
        super.setMeshLayer(newMeshLayer);
        if (this.getPathPlanner() != null && newMeshLayer != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.getPathPlanner(), (EStructuralFeature)ApogyAddonsMobilityPathplannersPackage.Literals.MESH_WAY_POINT_PATH_PLANNER__MESH, (Object)newMeshLayer.getCurrentMesh());
        }
    }

    public MeshWayPointPathPlanner getPathPlanner() {
        if (this.pathPlanner == null) {
            SimpleDirectedWeightedGraphBasedMeshWayPointPathPlanner tmp = ApogyAddonsMobilityPathplannersGraphFactory.eINSTANCE.createSimpleDirectedWeightedGraphBasedMeshWayPointPathPlanner();
            DistanceAndSlopesCostFunction das = ApogyAddonsMobilityPathplannersGraphFactory.eINSTANCE.createDistanceAndSlopesCostFunction();
            das.setGravityAxis(CartesianAxis.Z);
            tmp.getCostFunctions().add((Object)das);
            tmp.setEnablePathSimplification(false);
            this.setPathPlanner((MeshWayPointPathPlanner<?>)tmp);
        }
        return this.pathPlanner;
    }

    @Override
    public PathPlannerToolNode getPathPlannerToolNode() {
        PathPlannerToolNode node = super.getPathPlannerToolNode();
        if (node == null) {
            node = ApogyAddonsVehicleFactory.eINSTANCE.createPathPlannerToolNode();
            String nodeID = "PathPlannerToolNode_";
            nodeID = this.getName() != null ? String.valueOf(nodeID) + this.getName() + "_" + ApogyCommonEMFFacade.INSTANCE.getID((EObject)this) : String.valueOf(nodeID) + ApogyCommonEMFFacade.INSTANCE.getID((EObject)this);
            node.setNodeId(nodeID);
            String description = "Node representing the tool named <" + this.getName() + ">";
            if (this.getDescription() != null) {
                description = String.valueOf(description) + ": " + this.getDescription();
            }
            node.setDescription(description);
            this.setPathPlannerToolNode(node);
        }
        return node;
    }

    public void setRootNode(Node newRootNode) {
        if (newRootNode instanceof GroupNode) {
            ((GroupNode)newRootNode).getChildren().add((Object)this.getPathPlannerToolNode());
        } else if (this.getPathPlannerToolNode().getParent() instanceof GroupNode) {
            ((GroupNode)this.getPathPlannerToolNode().getParent()).getChildren().remove((Object)this.getPathPlannerToolNode());
        }
        super.setRootNode(newRootNode);
    }

    public void dispose() {
        if (this.getPathPlannerToolNode() != null && this.getPathPlannerToolNode().getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getPathPlannerToolNode().getParent();
            parent.getChildren().remove((Object)this.getPathPlannerToolNode());
        }
        super.dispose();
    }

    public void selectionChanged(NodeSelection nodeSelection) {
        if (!this.isDisposed()) {
            Node node = nodeSelection.getSelectedNode();
            Tuple3d relativePosition = null;
            if (nodeSelection.getRelativeIntersectionPoint() != null) {
                relativePosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)nodeSelection.getRelativeIntersectionPoint());
            }
            Tuple3d normal = null;
            if (nodeSelection.getAbsoluteIntersectionNormal() != null) {
                normal = ApogyCommonMathFacade.INSTANCE.createTuple3d((double)nodeSelection.getAbsoluteIntersectionNormal().x, (double)nodeSelection.getAbsoluteIntersectionNormal().y, (double)nodeSelection.getAbsoluteIntersectionNormal().z);
            }
            if (this.nextNode == TO_NODE_INDEX) {
                if (!this.isFromNodeLock()) {
                    this.updateFromNode(node, relativePosition, normal);
                } else if (!this.isToNodeLock()) {
                    this.updateToNode(node, relativePosition, normal);
                }
                this.nextNode = FROM_NODE_INDEX;
            } else if (this.nextNode == FROM_NODE_INDEX) {
                if (!this.isToNodeLock()) {
                    this.updateToNode(node, relativePosition, normal);
                } else if (!this.isFromNodeLock()) {
                    this.updateFromNode(node, relativePosition, normal);
                }
                this.nextNode = TO_NODE_INDEX;
            }
        }
    }

    public void pointsRelativePoseChanged(Matrix4d newPose) {
        if (this.getPathPlanner() != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsVehiclePackage.Literals.PATH_PLANNER_TOOL__PLANNED_PATH, null);
            this.planPathInternal();
        }
    }

    @Override
    public boolean planPath() {
        boolean success = false;
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsVehiclePackage.Literals.PATH_PLANNER_TOOL__BUSY, (Object)true);
        try {
            if (this.getPathPlanner() != null && this.getMeshLayer() != null) {
                CartesianPositionCoordinates from = this.getFromCartesianPositionCoordinates();
                CartesianPositionCoordinates to = this.getToCartesianPositionCoordinates();
                if (from != null && to != null) {
                    Logger.info("Planning path from " + from.asPoint3d() + " to " + to.asPoint3d() + "...");
                    if (this.getPathPlanner().getMesh() != this.getMeshLayer().getCurrentMesh()) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.getPathPlanner(), (EStructuralFeature)ApogyAddonsMobilityPathplannersPackage.Literals.MESH_WAY_POINT_PATH_PLANNER__MESH, (Object)this.getMeshLayer().getCurrentMesh());
                    }
                    WayPointPath newPath = this.getPathPlanner().plan(from, to);
                    newPath.setNodeId(String.valueOf(this.getName()) + " Plan Path");
                    newPath.setDescription("Planned Path");
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsVehiclePackage.Literals.PATH_PLANNER_TOOL__PLANNED_PATH, (Object)newPath);
                    if (newPath != null) {
                        success = true;
                        Logger.info("Path planning sucessfully completed.");
                    }
                } else {
                    String message = "Failed to plan path : ";
                    if (from == null) {
                        message = String.valueOf(message) + "Current location is undefined.";
                    }
                    if (to == null) {
                        message = String.valueOf(message) + " Destination is undefined.";
                    }
                    Logger.error(message);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsVehiclePackage.Literals.PATH_PLANNER_TOOL__PLANNED_PATH, null);
                }
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsVehiclePackage.Literals.PATH_PLANNER_TOOL__BUSY, (Object)false);
        return success;
    }

    protected void updateFromNode(Node node, Tuple3d relativePosition, Tuple3d normal) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, (Object)node);
        if (relativePosition != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_RELATIVE_POSITION, (Object)EcoreUtil.copy((EObject)relativePosition));
            if (this.isAutoPathPlanEnabled() && this.getPathPlanner() != null) {
                this.planPathInternal();
            }
        }
    }

    protected void updateToNode(Node node, Tuple3d relativePosition, Tuple3d normal) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE, (Object)node);
        if (relativePosition != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_RELATIVE_POSITION, (Object)EcoreUtil.copy((EObject)relativePosition));
            if (this.isAutoPathPlanEnabled() && this.getPathPlanner() != null) {
                this.planPathInternal();
            }
        }
    }

    private void planPathInternal() {
        if (!this.isBusy()) {
            Job job = new Job("Planning Path"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)PathPlannerToolCustomImpl.this.getPathPlanner(), (EStructuralFeature)ApogyCommonProcessorsPackage.Literals.MONITORABLE__PROGRESS_MONITOR, (Object)monitor);
                        PathPlannerToolCustomImpl.this.planPath();
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            Logger.warn("Path Planner is busy.");
        }
    }

    private CartesianPositionCoordinates getFromCartesianPositionCoordinates() {
        CartesianPositionCoordinates from = null;
        if (this.getFromAbsolutePosition() != null && this.getMeshLayer() != null) {
            Matrix4d meshToWorld = this.getMeshLayer().getMap().getTransformation().asMatrix4d();
            Vector3d fromVector = new Vector3d(this.getFromAbsolutePosition().asTuple3d());
            meshToWorld.transform(fromVector);
            from = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(fromVector.x, fromVector.y, fromVector.z);
        }
        return from;
    }

    private CartesianPositionCoordinates getToCartesianPositionCoordinates() {
        CartesianPositionCoordinates to = null;
        if (this.getToAbsolutePosition() != null && this.getMeshLayer() != null) {
            Matrix4d meshToWorld = this.getMeshLayer().getMap().getTransformation().asMatrix4d();
            Vector3d toVector = new Vector3d(this.getToAbsolutePosition().asTuple3d());
            meshToWorld.transform(toVector);
            to = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(toVector.x, toVector.y, toVector.z);
        }
        return to;
    }
}

