/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColorControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractColorControlSWTRenderer.class);
    private Composite content;
    private ColorSelector selector;
    private Button transparent;
    private IChangeListener changeListener;
    private IPropertyChangeListener propertyChangeListener;

    @Inject
    public AbstractColorControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        this.getModelValue().addChangeListener(this.getChangeListener());
        return new Binding[0];
    }

    protected Control createSWTControl(final Composite parent) throws DatabindingFailedException {
        this.content = new Composite(parent, 0);
        this.content.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractColorControlSWTRenderer.this.changeListener != null) {
                    try {
                        AbstractColorControlSWTRenderer.this.getModelValue().removeChangeListener(AbstractColorControlSWTRenderer.this.getChangeListener());
                    }
                    catch (DatabindingFailedException databindingFailedException) {
                        // empty catch block
                    }
                }
            }
        });
        this.content.setBackground(parent.getBackground());
        this.content.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                AbstractColorControlSWTRenderer.this.content.setBackground(parent.getBackground());
            }
        });
        this.content.setBackgroundMode(2);
        this.content.setLayout((Layout)new GridLayout(2, false));
        this.content.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.initSelector();
        this.transparent = new Button(this.content, 0);
        this.transparent.setText("Clear");
        this.transparent.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.transparent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AbstractColorControlSWTRenderer.this.getModelValue().setValue(AbstractColorControlSWTRenderer.this.getNullObj());
                }
                catch (DatabindingFailedException databindingFailedException) {
                    // empty catch block
                }
            }
        });
        return this.content;
    }

    private void initSelector() {
        this.selector = new ColorSelector(this.content);
        this.selector.getButton().setLayoutData((Object)new GridData(131072, 4, true, true, 1, 1));
        if (this.getValue() != null) {
            this.selector.setColorValue(this.getRGB());
        }
        if (this.transparent != null) {
            this.selector.getButton().moveAbove((Control)this.transparent);
        }
        this.selector.addListener(this.getPropertyChangeListener());
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getNewValue() instanceof RGB) {
                        try {
                            AbstractColorControlSWTRenderer.this.getModelValue().setValue(AbstractColorControlSWTRenderer.this.convert((RGB)event.getNewValue()));
                        }
                        catch (DatabindingFailedException e) {
                            Logger.error("Unable to set the color value");
                        }
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    public IChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    if (AbstractColorControlSWTRenderer.this.getValue() != null) {
                        AbstractColorControlSWTRenderer.this.selector.setColorValue(AbstractColorControlSWTRenderer.this.getRGB());
                    } else if (AbstractColorControlSWTRenderer.this.selector != null) {
                        AbstractColorControlSWTRenderer.this.selector.getButton().dispose();
                        AbstractColorControlSWTRenderer.this.initSelector();
                        AbstractColorControlSWTRenderer.this.content.layout();
                    }
                }
            };
        }
        return this.changeListener;
    }

    protected String getUnsetText() {
        return "Unset";
    }

    protected Object getValue() {
        try {
            Object obj = this.getModelValue().getValue();
            return obj;
        }
        catch (DatabindingFailedException e) {
            Logger.error("Unable to set the RGB value. ");
            return null;
        }
    }

    protected abstract RGB getRGB();

    protected abstract Object convert(RGB var1);

    protected abstract Object getNullObj();
}

