/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.asc.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.DigitalElevationMap;
import org.eclipse.apogy.common.geometry.data3d.DigitalElevationMapMesher;
import org.eclipse.apogy.common.geometry.data3d.DigitalElevationMapSampler;
import org.eclipse.apogy.common.geometry.data3d.asc.ASCHeaderData;
import org.eclipse.apogy.common.geometry.data3d.asc.AltitudeMode;
import org.eclipse.apogy.common.geometry.data3d.asc.ApogyCommonGeometryData3DASCFactory;
import org.eclipse.apogy.common.geometry.data3d.asc.Coordinates2D;
import org.eclipse.apogy.common.geometry.data3d.asc.impl.ASC3DIOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASC3DIOCustomImpl
extends ASC3DIOImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ASC3DIOImpl.class);
    private final String NUMBER_OF_ROW_ID = "nrows";
    private final String NUMBER_OF_COLUMNS_ID = "ncols";
    private final String XLL_CENTER_ID = "xllcenter";
    private final String YLL_CENTER_ID = "yllcenter";
    private final String CELL_SIZE_ID = "cellsize";
    private final String NO_DATA_VALUE_ID = "NODATA_value";

    @Override
    public DigitalElevationMap loadDigitalElevationMap(String file, AltitudeMode altitudeMode) throws Exception {
        return this.internalLoadDigitalElevationMap(file, altitudeMode, null, null);
    }

    @Override
    public DigitalElevationMap loadDigitalElevationMap(String file, AltitudeMode altitudeMode, double targetResolution) throws Exception {
        DigitalElevationMap dem = this.internalLoadDigitalElevationMap(file, altitudeMode, null, null);
        DigitalElevationMapSampler sampler = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMapSampler();
        sampler.setTargetResolution(targetResolution);
        return (DigitalElevationMap)sampler.process((Object)dem);
    }

    @Override
    public DigitalElevationMap loadDigitalElevationMap(String file, AltitudeMode altitudeMode, Coordinates2D southWestCorner, Coordinates2D northEastCorner) throws Exception {
        return this.internalLoadDigitalElevationMap(file, altitudeMode, southWestCorner, northEastCorner);
    }

    @Override
    public DigitalElevationMap loadDigitalElevationMap(String file, AltitudeMode altitudeMode, Coordinates2D southWestCorner, Coordinates2D northEastCorner, double targetResolution) throws Exception {
        DigitalElevationMap dem = this.internalLoadDigitalElevationMap(file, altitudeMode, southWestCorner, northEastCorner);
        DigitalElevationMapSampler sampler = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMapSampler();
        sampler.setTargetResolution(targetResolution);
        return (DigitalElevationMap)sampler.process((Object)dem);
    }

    @Override
    public CartesianTriangularMesh loadTriangularMesh(String file, AltitudeMode altitudeMode) throws Exception {
        return this.internalLoadTriangularMesh(file, altitudeMode, null, null);
    }

    @Override
    public CartesianTriangularMesh loadTriangularMesh(String file, AltitudeMode altitudeMode, double targetResolution) throws Exception {
        DigitalElevationMap digitalElevationMap = this.loadDigitalElevationMap(file, altitudeMode, targetResolution);
        DigitalElevationMapMesher mesher = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMapMesher();
        CartesianTriangularMesh mesh = (CartesianTriangularMesh)mesher.process((Object)digitalElevationMap);
        return mesh;
    }

    @Override
    public CartesianTriangularMesh loadTriangularMesh(String file, AltitudeMode altitudeMode, Coordinates2D southWestCorner, Coordinates2D northEastCorner) throws Exception {
        return this.internalLoadTriangularMesh(file, altitudeMode, southWestCorner, northEastCorner);
    }

    @Override
    public CartesianTriangularMesh loadTriangularMesh(String file, AltitudeMode altitudeMode, Coordinates2D southWestCorner, Coordinates2D northEastCorner, double targetResolution) throws Exception {
        DigitalElevationMap digitalElevationMap = this.loadDigitalElevationMap(file, altitudeMode, southWestCorner, northEastCorner, targetResolution);
        DigitalElevationMapMesher mesher = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMapMesher();
        CartesianTriangularMesh mesh = (CartesianTriangularMesh)mesher.process((Object)digitalElevationMap);
        return mesh;
    }

    protected ASCHeaderData extractHeader(BufferedReader bufferedReader) throws Exception {
        ASCHeaderData header = ApogyCommonGeometryData3DASCFactory.eINSTANCE.createASCHeaderData();
        String headerLine1 = bufferedReader.readLine();
        int numberRow = Integer.parseInt(headerLine1.substring(headerLine1.indexOf("nrows") + "nrows".length()).trim());
        header.setNumberOfRow(numberRow);
        String headerLine2 = bufferedReader.readLine();
        int numberColumns = Integer.parseInt(headerLine2.substring(headerLine2.indexOf("ncols") + "ncols".length()).trim());
        header.setNumberOfColumns(numberColumns);
        String headerLine3 = bufferedReader.readLine();
        double xllCenter = Double.parseDouble(headerLine3.substring(headerLine3.indexOf("xllcenter") + "xllcenter".length()).trim());
        header.setXllCenter(xllCenter);
        String headerLine4 = bufferedReader.readLine();
        double yllCenter = Double.parseDouble(headerLine4.substring(headerLine4.indexOf("yllcenter") + "yllcenter".length()).trim());
        header.setYllCenter(yllCenter);
        String headerLine5 = bufferedReader.readLine();
        double cellSize = Double.parseDouble(headerLine5.substring(headerLine5.indexOf("cellsize") + "cellsize".length()).trim());
        header.setCellSize(cellSize);
        String headerLine6 = bufferedReader.readLine();
        double noDataValue = Double.parseDouble(headerLine6.substring(headerLine6.indexOf("NODATA_value") + "NODATA_value".length()).trim());
        header.setNoDataValue(noDataValue);
        return header;
    }

    protected DigitalElevationMap internalLoadDigitalElevationMap(String file, AltitudeMode altitudeMode, Coordinates2D southWestCorner, Coordinates2D northEastCorner) throws Exception {
        if (southWestCorner != null && northEastCorner != null && (southWestCorner.getX() == northEastCorner.getX() || southWestCorner.getY() == northEastCorner.getY())) {
            throw new IllegalArgumentException("Specified rectangle has zero area!");
        }
        File fileHandle = new File(file);
        FileInputStream fileInputStream = new FileInputStream(fileHandle);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        ASCHeaderData header = this.extractHeader(bufferedReader);
        double[][] heights = this.loadHeightMap(bufferedReader, header.getNumberOfRow(), header.getNumberOfColumns());
        bufferedReader.close();
        int[] fromCorner = null;
        fromCorner = southWestCorner == null ? new int[2] : this.findIndexes(southWestCorner.getX(), southWestCorner.getY(), header.getNumberOfRow(), header.getNumberOfColumns(), header.getCellSize());
        int[] toCorner = null;
        toCorner = northEastCorner == null ? new int[]{header.getNumberOfColumns() - 1, header.getNumberOfRow() - 1} : this.findIndexes(northEastCorner.getX(), northEastCorner.getY(), header.getNumberOfRow(), header.getNumberOfColumns(), header.getCellSize());
        int fromXindex = fromCorner[0];
        int fromYindex = fromCorner[1];
        int toXindex = toCorner[0];
        int toYindex = toCorner[1];
        double[][] subArrayHeights = this.extractSubArray(heights, fromXindex, fromYindex, toXindex, toYindex);
        double[][] correctedHeights = this.applyAltitudeMode(subArrayHeights, altitudeMode);
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>(subArrayHeights.length * subArrayHeights[0].length);
        int i = 0;
        while (i < correctedHeights.length) {
            double x = (double)i * header.getCellSize();
            int j = 0;
            while (j < correctedHeights[0].length) {
                double y = (double)j * header.getCellSize();
                double z = correctedHeights[i][j];
                CartesianPositionCoordinates position = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                points.add(position);
                ++j;
            }
            ++i;
        }
        DigitalElevationMap digitalElevationMap = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMap();
        digitalElevationMap.setXDimension(correctedHeights.length);
        digitalElevationMap.setYDimension(correctedHeights[0].length);
        digitalElevationMap.getPoints().addAll(points);
        return digitalElevationMap;
    }

    protected CartesianTriangularMesh internalLoadTriangularMesh(String file, AltitudeMode altitudeMode, Coordinates2D southWestCorner, Coordinates2D northEastCorner) throws Exception {
        DigitalElevationMap digitalElevationMap = this.internalLoadDigitalElevationMap(file, altitudeMode, southWestCorner, northEastCorner);
        DigitalElevationMapMesher mesher = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMapMesher();
        CartesianTriangularMesh mesh = (CartesianTriangularMesh)mesher.process((Object)digitalElevationMap);
        return mesh;
    }

    protected int[] findIndexes(double x, double y, int numberRow, int numberColumns, double cellSize) {
        int xIndex = (int)Math.floor(x / ((double)numberColumns * cellSize) * (double)numberColumns) - 1;
        int yIndex = (int)Math.floor(y / ((double)numberRow * cellSize) * (double)numberRow) - 1;
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (xIndex > numberColumns - 1) {
            xIndex = numberColumns - 1;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (yIndex > numberRow - 1) {
            yIndex = numberRow - 1;
        }
        return new int[]{xIndex, yIndex};
    }

    protected double[][] loadHeightMap(BufferedReader bufferedReader, int numberRow, int numberColumns) {
        double[][] heights = new double[numberColumns][numberRow];
        int xIndex = 0;
        int yIndex = numberRow - 1;
        try {
            String lineOfData = bufferedReader.readLine();
            while (lineOfData != null && yIndex < numberRow) {
                String[] values;
                String[] stringArray = values = lineOfData.split(" ");
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (value != null && value.length() > 0) {
                        double z;
                        heights[xIndex][yIndex] = z = Double.parseDouble(value);
                        if (++xIndex > numberColumns - 1) {
                            xIndex = 0;
                            --yIndex;
                        }
                    }
                    ++n2;
                }
                lineOfData = bufferedReader.readLine();
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return heights;
    }

    protected double[][] extractSubArray(double[][] originalHeights, int fromX, int fromY, int toX, int toY) {
        int xLength = toX - fromX + 1;
        int yLength = toY - fromY + 1;
        double[][] subArray = new double[xLength][yLength];
        int i = 0;
        while (i < xLength) {
            int j = 0;
            while (j < yLength) {
                subArray[i][j] = originalHeights[fromX + i][fromY + j];
                ++j;
            }
            ++i;
        }
        return subArray;
    }

    protected double[][] applyAltitudeMode(double[][] originalHeights, AltitudeMode altitudeMode) {
        double[][] processedHeights = null;
        switch (altitudeMode.getValue()) {
            case 0: {
                processedHeights = originalHeights;
                break;
            }
            case 1: {
                double averageAltitude = this.findAverageAltitude(originalHeights);
                processedHeights = this.applyAltitudeOffset(originalHeights, -averageAltitude);
                Logger.info("Applying average altitude offset of <" + -averageAltitude + "m >.");
                break;
            }
            case 3: {
                double southWestCornerHeight = originalHeights[0][0];
                Logger.info("Applying South-West corner relative altitude offset of <" + -southWestCornerHeight + "m >.");
                processedHeights = this.applyAltitudeOffset(originalHeights, -southWestCornerHeight);
                break;
            }
            case 4: {
                int i = originalHeights.length - 1;
                int j = originalHeights[0].length - 1;
                double northEastCornerHeight = originalHeights[i][j];
                Logger.info("Applying North-East corner relative altitude offset of <" + -northEastCornerHeight + "m >.");
                processedHeights = this.applyAltitudeOffset(originalHeights, -northEastCornerHeight);
                break;
            }
            case 2: {
                int centerCoordX = (int)Math.floor((double)originalHeights.length * 0.5);
                int centerCoordY = (int)Math.floor((double)originalHeights[0].length * 0.5);
                double centerHeight = originalHeights[centerCoordX][centerCoordY];
                Logger.info("Applying center relative altitude offset of <" + -centerHeight + "m >.");
                processedHeights = this.applyAltitudeOffset(originalHeights, -centerHeight);
                break;
            }
        }
        return processedHeights;
    }

    protected double findAverageAltitude(double[][] originalHeights) {
        long count = 0L;
        double average = 0.0;
        int i = 0;
        while (i < originalHeights.length) {
            int j = 0;
            while (j < originalHeights[0].length) {
                average += originalHeights[i][j];
                ++count;
                ++j;
            }
            ++i;
        }
        return average / (double)count;
    }

    protected double[][] applyAltitudeOffset(double[][] originalHeights, double altitudeOffset) {
        double[][] offsetedAltitude = new double[originalHeights.length][originalHeights[0].length];
        int i = 0;
        while (i < originalHeights.length) {
            int j = 0;
            while (j < originalHeights[0].length) {
                offsetedAltitude[i][j] = originalHeights[i][j] + altitudeOffset;
                ++j;
            }
            ++i;
        }
        return offsetedAltitude;
    }
}

