/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.GMatrix;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.PointLocator;
import org.eclipse.apogy.common.geometry.data3d.impl.Data3DUtilsImpl;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.emf.common.util.EList;

public class Data3DUtilsCustomImpl
extends Data3DUtilsImpl {
    @Override
    public List<Vector3d> computeNormals(CartesianTriangularMesh mesh) {
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>();
        for (CartesianPositionCoordinates vertex : mesh.getPoints()) {
            Vector3d normal = this.computeNormalAtVertex(mesh, vertex);
            normals.add(normal);
        }
        return normals;
    }

    @Override
    public Vector3d computeNormalAtVertex(CartesianTriangularMesh mesh, CartesianPositionCoordinates vertex) {
        Vector3d normal = new Vector3d();
        EList polygons = mesh.getPolygonsSharingPoint(vertex);
        for (CartesianTriangle polygon : polygons) {
            double area = polygon.getSurface();
            Vector3d polygonNormal = polygon.getNormal();
            polygonNormal.scale(area);
            normal.add((Tuple3d)polygonNormal);
        }
        normal.normalize();
        return normal;
    }

    @Override
    public CartesianPositionCoordinates computeCentroid(List<CartesianPositionCoordinates> points) {
        Point3d centroid = new Point3d(0.0, 0.0, 0.0);
        for (CartesianPositionCoordinates point : points) {
            centroid.add((Tuple3d)point.asPoint3d());
        }
        centroid.scale(1.0 / (double)points.size());
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(centroid.x, centroid.y, centroid.z);
    }

    @Override
    public CartesianPositionCoordinates computeCentroid(CartesianCoordinatesSet points) {
        return this.computeCentroid((List<CartesianPositionCoordinates>)points.getPoints());
    }

    @Override
    public void computeMinMaxValues(Point3d min, Point3d max, CartesianCoordinatesSet data) {
        if (min == null || max == null || data == null) {
            throw new IllegalArgumentException();
        }
        int size = data.getPoints().size();
        if (size > 0) {
            min.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            max.set(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
            for (CartesianPositionCoordinates point : data.getPoints()) {
                if (point.getX() < min.x) {
                    min.x = point.getX();
                }
                if (point.getY() < min.y) {
                    min.y = point.getY();
                }
                if (point.getZ() < min.z) {
                    min.z = point.getZ();
                }
                if (point.getX() > max.x) {
                    max.x = point.getX();
                }
                if (point.getY() > max.y) {
                    max.y = point.getY();
                }
                if (!(point.getZ() > max.z)) continue;
                max.z = point.getZ();
            }
        } else {
            min.set(0.0, 0.0, 0.0);
            max.set(0.0, 0.0, 0.0);
        }
    }

    @Override
    public double computeCurvatureChange(PointLocator pointLocator, int centerPoint, double radius) {
        double cc = 0.0;
        List<CartesianPositionCoordinates> data = pointLocator.getPoints();
        CartesianPositionCoordinates pCenter = data.get(centerPoint);
        List<CartesianPositionCoordinates> result = pointLocator.findPointsWithinRadius(pCenter, radius);
        GMatrix res = new GMatrix(3, 3);
        res.setZero();
        Vector3d v = new Vector3d();
        GMatrix tmpMat = new GMatrix(3, 3);
        Vector3d o = new Vector3d((Tuple3d)data.get(centerPoint).asPoint3d());
        for (CartesianPositionCoordinates point : result) {
            v.set((Tuple3d)point.asPoint3d());
            v.sub((Tuple3d)o);
            GeometricUtils.outerProduct((Vector3d)v, (Vector3d)v, (GMatrix)tmpMat);
            res.add(tmpMat);
        }
        Matrix cov = new Matrix(3, 3);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                cov.set(i, j, res.getElement(i, j));
                ++j;
            }
            ++i;
        }
        EigenvalueDecomposition eig = new EigenvalueDecomposition(cov);
        Matrix d = eig.getD();
        double l1 = d.get(0, 0);
        double l2 = d.get(1, 1);
        double l3 = d.get(2, 2);
        cc = l1 / (l1 + l2 + l3);
        return cc;
    }

    @Override
    public CartesianTriangularMesh extrude(List<CartesianPositionCoordinates> profilePoints, CartesianAxis extrusionAxis, double extrusionWidth, boolean closeMesh) {
        CartesianPositionCoordinates v3;
        CartesianPositionCoordinates v1;
        CartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        ArrayList<CartesianPositionCoordinates> edgePositive = new ArrayList<CartesianPositionCoordinates>();
        ArrayList<CartesianPositionCoordinates> edgeNegative = new ArrayList<CartesianPositionCoordinates>();
        double halfExtrusionWidth = extrusionWidth / 2.0;
        for (CartesianPositionCoordinates point : profilePoints) {
            double x = point.getX();
            double y = point.getY();
            double z = point.getZ();
            CartesianPositionCoordinates positivePoint = null;
            CartesianPositionCoordinates negativePoint = null;
            switch (extrusionAxis.getValue()) {
                case 0: {
                    positivePoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(halfExtrusionWidth, y, z);
                    negativePoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(-halfExtrusionWidth, y, z);
                    break;
                }
                case 1: {
                    positivePoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, halfExtrusionWidth, z);
                    negativePoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, -halfExtrusionWidth, z);
                    break;
                }
                case 2: {
                    positivePoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, halfExtrusionWidth);
                    negativePoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, -halfExtrusionWidth);
                    break;
                }
            }
            edgePositive.add(positivePoint);
            edgeNegative.add(negativePoint);
        }
        for (CartesianPositionCoordinates p : edgePositive) {
            mesh.getPoints().add((Object)p);
        }
        for (CartesianPositionCoordinates p : edgeNegative) {
            mesh.getPoints().add((Object)p);
        }
        int i = 0;
        while (i < edgeNegative.size() - 1) {
            v1 = (CartesianPositionCoordinates)edgeNegative.get(i);
            CartesianPositionCoordinates v2 = (CartesianPositionCoordinates)edgeNegative.get(i + 1);
            v3 = (CartesianPositionCoordinates)edgePositive.get(i);
            CartesianTriangle triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(v1, v2, v3);
            mesh.getPolygons().add((Object)triangle);
            ++i;
        }
        i = 0;
        while (i < edgeNegative.size() - 1) {
            v1 = (CartesianPositionCoordinates)edgePositive.get(i);
            CartesianPositionCoordinates v2 = (CartesianPositionCoordinates)edgeNegative.get(i + 1);
            v3 = (CartesianPositionCoordinates)edgePositive.get(i + 1);
            CartesianTriangle triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(v1, v2, v3);
            mesh.getPolygons().add((Object)triangle);
            ++i;
        }
        if (closeMesh) {
            CartesianPositionCoordinates v12 = (CartesianPositionCoordinates)edgeNegative.get(edgeNegative.size() - 1);
            CartesianPositionCoordinates v2 = (CartesianPositionCoordinates)edgeNegative.get(0);
            CartesianPositionCoordinates v32 = (CartesianPositionCoordinates)edgePositive.get(edgeNegative.size() - 1);
            CartesianTriangle triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(v12, v2, v32);
            mesh.getPolygons().add((Object)triangle);
            v12 = (CartesianPositionCoordinates)edgePositive.get(edgeNegative.size() - 1);
            v2 = (CartesianPositionCoordinates)edgeNegative.get(0);
            v32 = (CartesianPositionCoordinates)edgePositive.get(0);
            triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(v12, v2, v32);
            mesh.getPolygons().add((Object)triangle);
        }
        return mesh;
    }
}

