/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.ui.composites;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.provider.MathEditUtils;
import org.eclipse.apogy.common.math.ui.composites.RotationMatrixSlidersComposite;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class RotationMatrixComposite
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Matrix3x3 matrix;
    private final Tuple3dComposite rotationComposite;
    private Tuple3d orientationTuple3d;
    private final RotationMatrixSlidersComposite rotationMatrixSlidersComposite;
    private Adapter matrixAdapter;
    private boolean disableEvent = false;
    private Adapter orientationTuple3dAdapter;
    private final EditingDomain editingDomain;

    public RotationMatrixComposite(Composite parent, int style, EditingDomain editingDomain) {
        super(parent, style);
        this.editingDomain = editingDomain;
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Section rotationSection = this.toolkit.createSection((Composite)this, 320);
        rotationSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        rotationSection.setText("Rotation (rx,ry,rz)");
        this.rotationComposite = new Tuple3dComposite((Composite)rotationSection, 0);
        this.rotationComposite.setBackground(this.getDisplay().getSystemColor(1));
        rotationSection.setClient((Control)this.rotationComposite);
        Section rotationSliderSection = this.toolkit.createSection((Composite)this, 320);
        rotationSliderSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        rotationSliderSection.setText("Rotation (rx,ry,rz)");
        this.rotationMatrixSlidersComposite = new RotationMatrixSlidersComposite((Composite)rotationSliderSection, 0, this.editingDomain);
        this.rotationMatrixSlidersComposite.setBackground(this.getDisplay().getSystemColor(1));
        rotationSliderSection.setClient((Control)this.rotationMatrixSlidersComposite);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RotationMatrixComposite.this.setMatrix3x3(null);
                RotationMatrixComposite.this.toolkit.dispose();
            }
        });
    }

    public RotationMatrixComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public void setMatrix3x3(Matrix3x3 matrix) {
        this.getOrientationTuple3d().eAdapters().remove((Object)this.getOrientationTuple3dAdapter());
        if (this.getMatrix() != null) {
            this.getMatrix().eAdapters().remove((Object)this.getMatrixAdapter());
        }
        this.matrix = matrix;
        if (this.getMatrix() != null) {
            this.rotationComposite.setTuple3d(this.getOrientationTuple3d());
            this.rotationMatrixSlidersComposite.setMatrix3x3(matrix);
            this.updateOrientationTuples(this.getMatrix(), this.getOrientationTuple3d());
            this.getMatrix().eAdapters().add((Object)this.getMatrixAdapter());
            this.getOrientationTuple3d().eAdapters().add((Object)this.getOrientationTuple3dAdapter());
        }
    }

    private Adapter getMatrixAdapter() {
        if (this.matrixAdapter == null) {
            this.matrixAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!RotationMatrixComposite.this.disableEvent) {
                        RotationMatrixComposite.this.updateOrientationTuples(RotationMatrixComposite.this.getMatrix(), RotationMatrixComposite.this.getOrientationTuple3d());
                    }
                }
            };
        }
        return this.matrixAdapter;
    }

    public Matrix3x3 getMatrix() {
        return this.matrix;
    }

    private void updateOrientationTuples(Matrix3x3 matrix, Tuple3d orientation) {
        this.disableEvent = true;
        Vector3d rotationVector = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)matrix.asMatrix3d());
        orientation.setX(Math.toDegrees(rotationVector.x));
        orientation.setY(Math.toDegrees(rotationVector.y));
        orientation.setZ(Math.toDegrees(rotationVector.z));
        this.disableEvent = false;
    }

    protected void checkSubclass() {
    }

    private Tuple3d getOrientationTuple3d() {
        if (this.orientationTuple3d == null) {
            this.orientationTuple3d = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        }
        return this.orientationTuple3d;
    }

    private Adapter getOrientationTuple3dAdapter() {
        if (this.orientationTuple3dAdapter == null) {
            this.orientationTuple3dAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (!RotationMatrixComposite.this.disableEvent) {
                        RotationMatrixComposite.this.disableEvent = true;
                        if (msg.getEventType() == 1) {
                            Matrix3d matrix3d = GeometricUtils.packXYZ((double)Math.toRadians(RotationMatrixComposite.this.getOrientationTuple3d().getX()), (double)Math.toRadians(RotationMatrixComposite.this.getOrientationTuple3d().getY()), (double)Math.toRadians(RotationMatrixComposite.this.getOrientationTuple3d().getZ()));
                            MathEditUtils.updateOrientation((Matrix3x3)RotationMatrixComposite.this.getMatrix(), (Matrix3x3)ApogyCommonMathFacade.INSTANCE.createMatrix3x3(matrix3d), (EditingDomain)RotationMatrixComposite.this.editingDomain);
                        }
                        RotationMatrixComposite.this.disableEvent = false;
                    }
                }
            };
        }
        return this.orientationTuple3dAdapter;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

