/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.composites.AbstractNodeSearchComposite;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class NodeListSearchComposite
extends AbstractNodeSearchComposite {
    protected List<Node> nodeList = null;

    public NodeListSearchComposite(Composite parent, int style) {
        super(parent, style);
    }

    public NodeListSearchComposite(Composite parent, int style, List<Node> nodes) {
        super(parent, style);
        this.setNodeList(nodes);
    }

    @Override
    protected AdapterFactoryContentProvider createContentProvider() {
        return new NodeContentProvider((AdapterFactory)this.adapterFactory);
    }

    @Override
    protected AdapterFactoryLabelProvider createLabelProvider() {
        return new NodeLabelProvider((AdapterFactory)this.adapterFactory);
    }

    public void setNodeList(List<Node> nodes) {
        this.nodeList = nodes;
        this.selectedNode = null;
        this.nodeSelectedChanged(null);
        this.applyFilters();
    }

    @Override
    protected Set<Node> getUnfilteredNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        if (this.nodeList != null) {
            nodes.addAll(this.nodeList);
        }
        return nodes;
    }

    private class NodeContentProvider
    extends AdapterFactoryContentProvider {
        public NodeContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            if (object instanceof Collection) {
                return ((Collection)object).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return false;
        }
    }

    private class NodeLabelProvider
    extends AdapterFactoryLabelProvider {
        public NodeLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            switch (columnIndex) {
                case 0: {
                    if (!(object instanceof Node)) break;
                    str = ((Node)object).getNodeId();
                    break;
                }
                case 1: {
                    if (!(object instanceof Node)) break;
                    str = ((Node)object).getDescription();
                    break;
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (columnIndex == 0) {
                return super.getColumnImage(object, columnIndex);
            }
            return null;
        }
    }
}

