/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NodeTypeComboComposite
extends Composite {
    protected static Collection<EClass> availableNodeTypes = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(ApogyCommonTopologyPackage.Literals.NODE);
    private final ComboViewer comboViewer;

    public NodeTypeComboComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.comboViewer = this.createCombo(this, 8);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    NodeTypeComboComposite.this.typeSelected(null);
                } else if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    if (iStructuredSelection.getFirstElement() instanceof EClass) {
                        NodeTypeComboComposite.this.typeSelected((EClass)iStructuredSelection.getFirstElement());
                    } else {
                        NodeTypeComboComposite.this.typeSelected(null);
                    }
                }
            }
        });
    }

    public void clearSelection() {
        this.comboViewer.setSelection(null);
        this.typeSelected(null);
    }

    public void selectType(EClass eClass) {
        if (eClass != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)eClass));
            this.typeSelected(eClass);
        } else {
            this.comboViewer.setSelection(null);
            this.typeSelected(null);
        }
    }

    public void typeSelected(EClass eClass) {
    }

    protected String getTypeNameForEClass(EClass eClass) {
        return eClass.getName();
    }

    protected SortedSet<EClass> getSortedEClass() {
        TreeSet<EClass> sortedEClass = new TreeSet<EClass>(new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                String s1 = NodeTypeComboComposite.this.getTypeNameForEClass(o1);
                String s2 = NodeTypeComboComposite.this.getTypeNameForEClass(o2);
                return s1.compareTo(s2);
            }
        });
        sortedEClass.addAll(availableNodeTypes);
        return sortedEClass;
    }

    private ComboViewer createCombo(Composite parent, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, 12);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EClass) {
                    EClass eClass = (EClass)element;
                    return NodeTypeComboComposite.this.getTypeNameForEClass(eClass);
                }
                return "";
            }
        });
        comboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                EClass eClass1 = (EClass)e1;
                EClass eClass2 = (EClass)e2;
                String string1 = NodeTypeComboComposite.this.getTypeNameForEClass(eClass1);
                String string2 = NodeTypeComboComposite.this.getTypeNameForEClass(eClass2);
                return string1.compareTo(string2);
            }
        });
        SortedSet<EClass> sortedEClass = this.getSortedEClass();
        String[] proposals = new String[sortedEClass.size()];
        int i = 0;
        for (EClass eClass : sortedEClass) {
            proposals[i] = this.getTypeNameForEClass(eClass);
            ++i;
        }
        comboViewer.setInput(availableNodeTypes);
        return comboViewer;
    }
}

