/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.birt.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.ui.birt.composites.ValueVsTimeBIRTChartComposite;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractEObjectValueVsTimeComposite<RootObject extends EObject>
extends ValueVsTimeBIRTChartComposite {
    protected static final String RESOLUTION_ERROR_MESSAGE = "RUNTIME ERROR!!! Unable to resolve:\n-RootObject: %s\n-FeaturePath: %s\n-Class: %s";
    private AdapterImpl resolvedObjectAdapter;
    private EObject resolvedObject = null;
    private WritableValue<RootObject> writableValue = new WritableValue();

    public AbstractEObjectValueVsTimeComposite(Composite parent, int style) {
        super(parent, style);
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(new Date());
        ArrayList<Double> yValues = new ArrayList<Double>();
        yValues.add(new Double(0.0));
        this.updateValues(dates, yValues);
        this.setChartTitle(this.createChartTitle());
        this.setTimeAxisName("Time");
        this.setYAxisFormatString(this.getValuesFormatString());
        if (this.getDisplayUnits() != null) {
            this.setYAxisName(String.valueOf(this.createValueName()) + " (" + this.getDisplayUnits().toString() + ")");
        } else {
            this.setYAxisName(this.createValueName());
        }
        this.writableValue.addValueChangeListener(s -> {
            this.updateRootObject(this.getRootObject());
            this.newRootObject(this.getRootObject());
        });
    }

    public RootObject getRootObject() {
        return (RootObject)((EObject)this.writableValue.getValue());
    }

    public void setRootObject(RootObject rootObject) {
        this.writableValue.setValue(rootObject);
        this.updateRootObject(rootObject);
        this.newRootObject(this.getRootObject());
    }

    public Unit<?> getDisplayUnits() {
        ETypedElement eTypedElement = this.getDisplayedETypedElement();
        if (eTypedElement != null) {
            return ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(eTypedElement);
        }
        return null;
    }

    public Unit<?> getNativeUnits() {
        ETypedElement eTypedElement = this.getDisplayedETypedElement();
        if (eTypedElement != null) {
            return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        }
        return null;
    }

    protected abstract FeaturePath getFeaturePath();

    protected String createChartTitle() {
        String title = String.valueOf(this.createValueName()) + " vs Time";
        return title;
    }

    protected String createValueName() {
        return this.getDisplayedETypedElement().getName();
    }

    protected String getValuesFormatString() {
        DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(this.getDisplayedETypedElement());
        return format.toLocalizedPattern();
    }

    protected Number getResolvedValue() {
        Number number = null;
        if (this.getRootObject() != null) {
            EObject owner = this.resolveOwner((EObject)this.getRootObject(), this.getFeaturePath());
            Object value = owner.eGet(this.getFeaturePath().getFeaturePath()[this.getFeaturePath().getFeaturePath().length - 1]);
            if (value instanceof Number) {
                number = (Number)value;
            } else if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                number = boolValue != false ? new Double(1.0) : new Double(1.0);
            }
        }
        return number;
    }

    protected double convertToDisplayedValue(double nativeUnitsValue) {
        Unit<?> displayUnits = this.getDisplayUnits();
        Unit<?> nativeUnits = this.getNativeUnits();
        if (displayUnits != null && nativeUnits != null) {
            return nativeUnits.getConverterTo(displayUnits).convert(nativeUnitsValue);
        }
        return nativeUnitsValue;
    }

    protected ETypedElement getDisplayedETypedElement() {
        return this.getFeaturePath().getFeaturePath()[this.getFeaturePath().getFeaturePath().length - 1];
    }

    protected WritableValue<RootObject> getWritableValue() {
        return this.writableValue;
    }

    protected void updateRootObject(RootObject rootObject) {
        if (this.resolvedObject != null) {
            this.resolvedObject.eAdapters().remove((Object)this.getResolvedObjectAdapter());
        }
        this.resolvedObject = rootObject == null ? null : this.resolve(rootObject, this.getFeaturePath());
        if (this.resolvedObject != null) {
            this.resolvedObject.eAdapters().add((Object)this.getResolvedObjectAdapter());
        }
    }

    protected void newRootObject(RootObject rootObject) {
        Date now = new Date();
        Number newValue = this.getResolvedValue();
        if (newValue != null) {
            this.addValue(now, this.convertToDisplayedValue(newValue.doubleValue()));
        }
    }

    protected EObject resolve(RootObject rootObject, FeaturePath featurePath) {
        EObject result = null;
        EObject eObject = this.resolveOwner((EObject)rootObject, featurePath);
        String errorMessage = null;
        if (eObject == null) {
            errorMessage = "ResolvedObject is Null: " + String.format(RESOLUTION_ERROR_MESSAGE, this.getRootObject(), AbstractEObjectValueVsTimeComposite.toString(featurePath), ((Object)((Object)this)).getClass().getName());
        } else {
            try {
                result = eObject;
            }
            catch (ClassCastException e) {
                errorMessage = "Inconsistent FeaturePath: " + String.format(RESOLUTION_ERROR_MESSAGE, this.getRootObject(), AbstractEObjectValueVsTimeComposite.toString(featurePath), ((Object)((Object)this)).getClass().getName());
            }
        }
        if (errorMessage != null) {
            System.err.println("AbstractEListComposite.resolve(RootObject, FeaturePath): " + errorMessage);
        }
        return result;
    }

    private Adapter getResolvedObjectAdapter() {
        if (this.resolvedObjectAdapter == null) {
            this.resolvedObjectAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    AbstractEObjectValueVsTimeComposite.this.getWritableValue().getRealm().asyncExec(() -> AbstractEObjectValueVsTimeComposite.this.setRootObject(AbstractEObjectValueVsTimeComposite.this.getRootObject()));
                }
            };
        }
        return this.resolvedObjectAdapter;
    }

    protected EObject resolveOwner(EObject root, FeaturePath featurePath) {
        EObject result = null;
        Object currentOwner = root;
        if (root != null) {
            if (featurePath == null || featurePath.getFeaturePath().length == 0) {
                result = root;
            } else {
                int i = 0;
                EStructuralFeature[] features = featurePath.getFeaturePath();
                boolean isConsistent = true;
                while (i < features.length && isConsistent) {
                    EStructuralFeature currentFeature = features[i];
                    if (currentOwner != null && currentOwner instanceof EObject) {
                        if (currentFeature instanceof EAttribute) {
                            result = currentOwner;
                        } else {
                            currentOwner = currentOwner.eGet(currentFeature, true);
                            if (i < features.length && currentOwner != null && currentOwner instanceof EObject) {
                                result = currentOwner;
                            }
                        }
                    } else {
                        isConsistent = false;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    protected static String toString(FeaturePath featurePath) {
        StringBuffer result = new StringBuffer();
        if (featurePath != null) {
            result.append("[");
            int i = 0;
            while (i < featurePath.getFeaturePath().length) {
                EStructuralFeature feature = featurePath.getFeaturePath()[i];
                result.append(feature.getName());
                if (i < featurePath.getFeaturePath().length - 1) {
                    result.append(", ");
                }
                ++i;
            }
        }
        result.append("]");
        return result.toString();
    }
}

