/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.birt.composites;

import com.ibm.icu.util.Calendar;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.apogy.common.ui.birt.composites.AbstractBIRTChartComposite;
import org.eclipse.apogy.common.ui.birt.composites.ApogyBIRTUtilities;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.SeriesValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class ValueVsTimeBIRTChartComposite
extends AbstractBIRTChartComposite {
    public static long DEFAULT_UPDATE_PERIOD_MS = 500L;
    public static int DEFAULT_HISTORY_SIZE = 200;
    public static int DEFAULT_HISTORY_TIME_LENGTH_MS = 60000;
    public static TextAlignment DEFAULT_TIME_AXIS_FONT_ALIGNEMENT = TextAlignmentImpl.createDefault();
    public static FontDefinition DEFAULT_TIME_AXIS_FONT = FontDefinitionImpl.create((String)"", (float)10.0f, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (double)90.0, (TextAlignment)DEFAULT_TIME_AXIS_FONT_ALIGNEMENT);
    public static TextAlignment DEFAULT_VALUES_AXIS_FONT_ALIGNEMENT = TextAlignmentImpl.createDefault();
    public static FontDefinition DEFAULT_VALUES_AXIS_FONT = FontDefinitionImpl.create((String)"", (float)10.0f, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (TextAlignment)DEFAULT_VALUES_AXIS_FONT_ALIGNEMENT);
    public static String DEFAULT_TIME_AXIS_FORMAT_STRING = "HH:mm:ss.SSS";
    public static String DEFAULT_Y_AXIS_FORMAT_STRING = "0.0";
    public static RGB DEFAULT_TIME_AXIS_COLOR = new RGB(0, 255, 0);
    public static RGB DEFAULT_VALUES_AXIS_COLOR = new RGB(0, 255, 0);
    protected int historySize = DEFAULT_HISTORY_SIZE;
    protected int historyTimeLength = DEFAULT_HISTORY_TIME_LENGTH_MS;
    protected String timeAxisName = null;
    protected String yAxisName = null;
    protected Axis timeAxisPrimary;
    protected Axis yAxisPrimary;
    protected String timeFormatString = DEFAULT_TIME_AXIS_FORMAT_STRING;
    protected String yAxisFormatString = DEFAULT_Y_AXIS_FORMAT_STRING;
    protected Series timeSeries;
    protected LineSeries yValuesLineSeries;
    protected SeriesDefinition ySeriesDefinition;
    protected SortedMap<CDateTime, Double> currentSeriesData = new TreeMap<CDateTime, Double>();
    protected SortedMap<CDateTime, Double> bufferedSeriesData = new TreeMap<CDateTime, Double>();
    protected RGB timeAxisColor = DEFAULT_TIME_AXIS_COLOR;
    protected RGB valuesAxisColor = DEFAULT_VALUES_AXIS_COLOR;
    protected DateTimeDataSet xValuesDataSet;
    protected NumberDataSet yValuesDataSet;
    private boolean dataUpdated = false;
    private boolean stopRequested = false;
    private UIJob uiJob = null;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public ValueVsTimeBIRTChartComposite(Composite parent, int style) {
        super(parent, style);
        this.getUiJob().schedule();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ValueVsTimeBIRTChartComposite.this.stopRequested = true;
                ValueVsTimeBIRTChartComposite.this.getUiJob().cancel();
            }
        });
    }

    @Override
    public void setPlotGridColor(RGB plotGridColor) {
        super.setPlotGridColor(plotGridColor);
        if (plotGridColor != null && this.chart instanceof ChartWithAxes) {
            this.chart.getTitle().getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.timeAxisPrimary.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.timeAxisPrimary.getMinorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.yAxisPrimary.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.yAxisPrimary.getMinorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
        }
    }

    public void setTimeAxisColor(RGB timeAxisColor) {
        if (timeAxisColor != null) {
            this.timeAxisColor = timeAxisColor;
            this.timeAxisPrimary.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(timeAxisColor));
            this.timeAxisPrimary.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(timeAxisColor));
            this.timeAxisPrimary.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(timeAxisColor));
            this.timeAxisPrimary.getMajorGrid().getTickAttributes().setVisible(true);
            this.timeAxisPrimary.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(timeAxisColor));
            this.timeAxisPrimary.getMinorGrid().getTickAttributes().setVisible(false);
        }
    }

    public void setValuesAxisColor(RGB valuesAxisColor) {
        if (this.timeAxisColor != null) {
            this.valuesAxisColor = valuesAxisColor;
            this.yAxisPrimary.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(valuesAxisColor));
            this.yAxisPrimary.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(valuesAxisColor));
            this.yAxisPrimary.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(valuesAxisColor));
            this.yAxisPrimary.getMajorGrid().getTickAttributes().setVisible(true);
            this.yAxisPrimary.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(valuesAxisColor));
            this.yAxisPrimary.getMinorGrid().getTickAttributes().setVisible(false);
        }
    }

    public String getTimeAxisName() {
        return this.timeAxisName;
    }

    public void setTimeAxisName(String timeAxisName) {
        this.timeAxisName = timeAxisName;
        if (this.chart != null && this.timeAxisPrimary != null) {
            if (timeAxisName != null && timeAxisName.length() > 0) {
                this.timeAxisPrimary.getTitle().setVisible(true);
                this.timeAxisPrimary.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
                this.timeAxisPrimary.getTitle().getCaption().setValue(timeAxisName);
            } else {
                this.timeAxisPrimary.getTitle().setVisible(false);
            }
        }
    }

    public String getYAxisName() {
        return this.yAxisName;
    }

    public void setYAxisName(String yAxisName) {
        this.yAxisName = yAxisName;
        if (this.chart != null && this.yAxisPrimary != null) {
            if (yAxisName != null && yAxisName.length() > 0) {
                this.yAxisPrimary.getTitle().setVisible(true);
                this.yAxisPrimary.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
                this.yAxisPrimary.getTitle().getCaption().setValue(yAxisName);
                this.yAxisPrimary.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.valuesAxisColor));
                this.yAxisPrimary.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.valuesAxisColor));
                this.yAxisPrimary.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.valuesAxisColor));
                this.yAxisPrimary.getMajorGrid().getTickAttributes().setVisible(true);
                this.yAxisPrimary.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.valuesAxisColor));
                this.yAxisPrimary.getMinorGrid().getTickAttributes().setVisible(false);
            } else {
                this.yAxisPrimary.getTitle().setVisible(false);
            }
        }
    }

    public String getTimeFormatString() {
        return this.timeFormatString;
    }

    public void setTimeFormatString(String timeFormatString) {
        this.timeFormatString = timeFormatString;
        if (this.timeAxisPrimary != null) {
            JavaDateFormatSpecifier xAxisFormatSpecifier = JavaDateFormatSpecifierImpl.create((String)timeFormatString);
            this.timeAxisPrimary.setFormatSpecifier((FormatSpecifier)xAxisFormatSpecifier);
            this.updateChart();
        }
    }

    public String getYAxisFormatString() {
        return this.yAxisFormatString;
    }

    public void setYAxisFormatString(String yAxisFormatString) {
        this.yAxisFormatString = yAxisFormatString;
        if (this.yAxisPrimary != null) {
            JavaNumberFormatSpecifier yAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)yAxisFormatString);
            this.yAxisPrimary.setFormatSpecifier((FormatSpecifier)yAxisFormatSpecifier);
            this.updateChart();
        }
    }

    @Override
    public void setSeriesColor(RGB seriesColor) {
        super.setSeriesColor(seriesColor);
        if (seriesColor != null) {
            if (this.ySeriesDefinition != null) {
                this.ySeriesDefinition.getSeriesPalette().update((Fill)ApogyBIRTUtilities.convertToColorDefinition(seriesColor));
            }
        } else {
            throw new InvalidParameterException("seriesColor cannot be null!");
        }
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        if (historySize <= 0) {
            throw new InvalidParameterException("historySize must be greater than 0 !");
        }
        this.historySize = historySize;
    }

    public int getHistoryTimeLength() {
        return this.historyTimeLength;
    }

    public void setHistoryTimeLength(int historyTimeLength) {
        if (historyTimeLength != 0) {
            this.historyTimeLength = historyTimeLength;
        }
    }

    public void addValue(Date date, double value) {
        this.lock.writeLock().lock();
        try {
            this.dataUpdated = true;
            this.bufferedSeriesData.put(new CDateTime(date), value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void updateValuesAndChart() {
        if (this.dataUpdated) {
            this.lock.readLock().lock();
            try {
                this.currentSeriesData.putAll(this.bufferedSeriesData);
                this.bufferedSeriesData.clear();
                while (this.currentSeriesData.size() > this.getHistorySize()) {
                    this.currentSeriesData.remove(this.currentSeriesData.firstKey());
                }
                if (this.getHistoryTimeLength() > 0) {
                    CDateTime latest = this.currentSeriesData.lastKey();
                    CDateTime start = latest.backward(14, this.getHistoryTimeLength());
                    TreeMap<CDateTime, Double> toKeep = new TreeMap<CDateTime, Double>();
                    toKeep.putAll(this.currentSeriesData.tailMap(start));
                    this.currentSeriesData.clear();
                    this.currentSeriesData.putAll(toKeep);
                }
                if (this.currentSeriesData.isEmpty()) {
                    this.currentSeriesData.put(new CDateTime(new Date()), new Double(0.0));
                }
                this.xValuesDataSet = DateTimeDataSetImpl.create(this.currentSeriesData.keySet());
                this.yValuesDataSet = NumberDataSetImpl.create(this.currentSeriesData.values());
                this.timeSeries.setDataSet((DataSet)this.xValuesDataSet);
                this.yValuesLineSeries.setDataSet((DataSet)this.yValuesDataSet);
                this.updateChart();
                this.dataUpdated = false;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    public void updateValues(List<Date> dates, List<Double> yValues) {
        if (dates.size() == yValues.size()) {
            this.lock.writeLock().lock();
            try {
                this.dataUpdated = true;
                this.bufferedSeriesData.clear();
                int i = 0;
                while (i < dates.size()) {
                    this.bufferedSeriesData.put(new CDateTime(dates.get(i)), yValues.get(i));
                    ++i;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            System.err.println("Invalid size");
        }
    }

    @Override
    protected Chart createChart() {
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.getBlock().setBackground((Fill)ColorDefinitionImpl.BLACK());
        chart.getTitle().getLabel().getCaption().setValue("");
        chart.getTitle().getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        Plot plot = chart.getPlot();
        plot.setBackground((Fill)ColorDefinitionImpl.BLACK());
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.BLACK());
        chart.setUnitSpacing(20.0);
        Legend lg = chart.getLegend();
        LineAttributes lia = lg.getOutline();
        lg.getText().getFont().setSize(16.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        lg.getInsets().set(10.0, 5.0, 0.0, 0.0);
        lg.getOutline().setVisible(false);
        lg.setAnchor(Anchor.NORTH_LITERAL);
        lg.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEDOWN_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.TOGGLE_VISIBILITY_LITERAL, (ActionValue)SeriesValueImpl.create((String)"not-used"))));
        this.timeAxisPrimary = chart.getPrimaryBaseAxes()[0];
        this.timeAxisPrimary.setType(AxisType.DATE_TIME_LITERAL);
        this.timeAxisPrimary.setAligned(true);
        this.timeAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.timeAxisPrimary.setCategoryAxis(false);
        this.timeAxisPrimary.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_TIME_AXIS_COLOR));
        this.timeAxisPrimary.getLabel().getCaption().setFont(DEFAULT_TIME_AXIS_FONT);
        this.timeAxisPrimary.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_TIME_AXIS_COLOR));
        this.timeAxisPrimary.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_TIME_AXIS_COLOR));
        this.timeAxisPrimary.getMajorGrid().getTickAttributes().setVisible(true);
        this.timeAxisPrimary.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_TIME_AXIS_COLOR));
        this.timeAxisPrimary.getMinorGrid().getTickAttributes().setVisible(false);
        JavaDateFormatSpecifier xAxisFormatSpecifier = JavaDateFormatSpecifierImpl.create((String)DEFAULT_TIME_AXIS_FORMAT_STRING);
        this.timeAxisPrimary.setFormatSpecifier((FormatSpecifier)xAxisFormatSpecifier);
        this.yAxisPrimary = chart.getPrimaryOrthogonalAxis(this.timeAxisPrimary);
        this.yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.yAxisPrimary.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_VALUES_AXIS_COLOR));
        this.yAxisPrimary.getLabel().getCaption().setFont(DEFAULT_VALUES_AXIS_FONT);
        this.yAxisPrimary.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_VALUES_AXIS_COLOR));
        this.yAxisPrimary.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_VALUES_AXIS_COLOR));
        this.yAxisPrimary.getMajorGrid().getTickAttributes().setVisible(true);
        this.yAxisPrimary.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_VALUES_AXIS_COLOR));
        this.yAxisPrimary.getMinorGrid().getTickAttributes().setVisible(false);
        JavaNumberFormatSpecifier yAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)DEFAULT_Y_AXIS_FORMAT_STRING);
        this.yAxisPrimary.setFormatSpecifier((FormatSpecifier)yAxisFormatSpecifier);
        this.timeAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        this.timeAxisPrimary.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_PLOT_GRID_COLOR));
        this.timeAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        this.timeAxisPrimary.getMinorGrid().getLineAttributes().setVisible(false);
        this.yAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        this.yAxisPrimary.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_PLOT_GRID_COLOR));
        this.yAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        this.yAxisPrimary.getMinorGrid().getLineAttributes().setVisible(false);
        ArrayList<Double> ys = new ArrayList<Double>();
        ys.add(0.0);
        this.xValuesDataSet = DateTimeDataSetImpl.create((Object)Calendar.getInstance());
        this.yValuesDataSet = NumberDataSetImpl.create(ys);
        this.timeSeries = SeriesImpl.create();
        this.timeSeries.setDataSet((DataSet)this.xValuesDataSet);
        this.yValuesLineSeries = (LineSeries)LineSeriesImpl.create();
        this.yValuesLineSeries.setStacked(true);
        this.yValuesLineSeries.getLabel().setVisible(false);
        this.yValuesLineSeries.setDataSet((DataSet)this.yValuesDataSet);
        this.yValuesLineSeries.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_PLOT_GRID_COLOR));
        int i = 0;
        while (i < this.yValuesLineSeries.getMarkers().size()) {
            ((Marker)this.yValuesLineSeries.getMarkers().get(i)).setType(MarkerType.CIRCLE_LITERAL);
            ((Marker)this.yValuesLineSeries.getMarkers().get(i)).setSize(1);
            ((Marker)this.yValuesLineSeries.getMarkers().get(i)).setVisible(false);
            ++i;
        }
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xSeriesDefinition.getSeriesPalette().shift(0);
        this.timeAxisPrimary.getSeriesDefinitions().add((Object)xSeriesDefinition);
        this.ySeriesDefinition = SeriesDefinitionImpl.create();
        this.ySeriesDefinition.getSeriesPalette().update((Fill)ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_SERIES_COLOR));
        this.yAxisPrimary.getSeriesDefinitions().add((Object)this.ySeriesDefinition);
        xSeriesDefinition.getSeries().add((Object)this.timeSeries);
        this.ySeriesDefinition.getSeries().add((Object)this.yValuesLineSeries);
        chart.getLegend().setVisible(false);
        this.setTimeFormatString(DEFAULT_TIME_AXIS_FORMAT_STRING);
        this.setYAxisFormatString(DEFAULT_Y_AXIS_FORMAT_STRING);
        ArrayList<CDateTime> cDateTimes = new ArrayList<CDateTime>();
        cDateTimes.add(new CDateTime(new Date()));
        ArrayList<Double> v = new ArrayList<Double>();
        v.add(new Double(0.0));
        this.xValuesDataSet = DateTimeDataSetImpl.create(cDateTimes);
        this.yValuesDataSet = NumberDataSetImpl.create(v);
        this.timeSeries.setDataSet((DataSet)this.xValuesDataSet);
        this.yValuesLineSeries.setDataSet((DataSet)this.yValuesDataSet);
        return chart;
    }

    public UIJob getUiJob() {
        if (this.uiJob == null) {
            this.uiJob = new UIJob("ValuesVsTime Update."){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    try {
                        ValueVsTimeBIRTChartComposite.this.updateValuesAndChart();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!ValueVsTimeBIRTChartComposite.this.stopRequested) {
                        this.schedule(DEFAULT_UPDATE_PERIOD_MS);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.uiJob;
    }
}

