/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.composites;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.apogy.common.databinding.converters.DoubleToStringConverter;
import org.eclipse.apogy.common.databinding.converters.StringToDoubleConverter;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.Positioned;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthPackage;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.ui.databindings.DegreeStringToRadiansConverter;
import org.eclipse.apogy.core.environment.earth.surface.ui.databindings.RadiansToDegreesStringConverter;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CoordinateConversionComposite
extends Composite {
    private static final String GEO_COORD_SECT_TITLE = "Geographic Coordinates";
    private static final String XYZ_COORD_SECT_TITLE = "Positional Coordinates";
    private static final String DEGREE_SYM = "\u00b0";
    private static final DecimalFormat ANGLE_DEC_FORMAT = new DecimalFormat("0.0000000");
    private static final DecimalFormat POS_DEC_FORMAT = new DecimalFormat("0.000");
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private EObject boundObj;
    private DataBindingContext dbContext;
    private EditingDomain editingDomain;
    private DoubleValueVerifyAndUpdateListener lstnAllTexts;
    private Text txtLat;
    private Text txtLong;
    private Text txtElev;
    private Text txtX;
    private Text txtY;
    private Text txtZ;

    public CoordinateConversionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CoordinateConversionComposite.this.disposeOfBindingContext();
            }
        });
        this.lstnAllTexts = new DoubleValueVerifyAndUpdateListener();
        Section sctnGeoCoords = this.formToolkit.createSection((Composite)this, 256);
        sctnGeoCoords.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.formToolkit.paintBordersFor((Composite)sctnGeoCoords);
        sctnGeoCoords.setText(GEO_COORD_SECT_TITLE);
        Composite compGeoCoords = this.formToolkit.createComposite((Composite)sctnGeoCoords, 0);
        this.formToolkit.paintBordersFor(compGeoCoords);
        compGeoCoords.setLayout((Layout)new GridLayout(3, true));
        sctnGeoCoords.setClient((Control)compGeoCoords);
        Label lblLat = this.formToolkit.createLabel(compGeoCoords, "Latitude (\u00b0)", 0x1000000);
        lblLat.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblLong = this.formToolkit.createLabel(compGeoCoords, "Longitude (\u00b0)", 0x1000000);
        lblLong.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblElev = this.formToolkit.createLabel(compGeoCoords, "Elevation (m)", 0x1000000);
        lblElev.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtLat = this.formToolkit.createText(compGeoCoords, "0.0", 0x1000000);
        this.txtLat.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtLat.addVerifyListener((VerifyListener)this.lstnAllTexts);
        this.txtLong = this.formToolkit.createText(compGeoCoords, "0.0", 0x1000000);
        this.txtLong.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtLong.addVerifyListener((VerifyListener)this.lstnAllTexts);
        this.txtElev = this.formToolkit.createText(compGeoCoords, "0.0", 0x1000000);
        this.txtElev.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtElev.addVerifyListener((VerifyListener)this.lstnAllTexts);
        Section sctnXYZCoords = this.formToolkit.createSection((Composite)this, 256);
        sctnXYZCoords.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.formToolkit.paintBordersFor((Composite)sctnXYZCoords);
        sctnXYZCoords.setText(XYZ_COORD_SECT_TITLE);
        Composite compXYZCoords = this.formToolkit.createComposite((Composite)sctnXYZCoords, 0);
        this.formToolkit.paintBordersFor(compXYZCoords);
        compXYZCoords.setLayout((Layout)new GridLayout(3, true));
        sctnXYZCoords.setClient((Control)compXYZCoords);
        Label lblX = this.formToolkit.createLabel(compXYZCoords, "X (m)", 0x1000000);
        lblX.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblY = this.formToolkit.createLabel(compXYZCoords, "Y (m)", 0x1000000);
        lblY.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblZ = this.formToolkit.createLabel(compXYZCoords, "Z (m)", 0x1000000);
        lblZ.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtX = this.formToolkit.createText(compXYZCoords, "0.0", 0x1000000);
        this.txtX.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtX.addVerifyListener((VerifyListener)this.lstnAllTexts);
        this.txtY = this.formToolkit.createText(compXYZCoords, "0.0", 0x1000000);
        this.txtY.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtY.addVerifyListener((VerifyListener)this.lstnAllTexts);
        this.txtZ = this.formToolkit.createText(compXYZCoords, "0.0", 0x1000000);
        this.txtZ.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtZ.addVerifyListener((VerifyListener)this.lstnAllTexts);
    }

    private DataBindingContext createBinding(Object obj, EditingDomain objDomain) {
        Positioned position;
        DataBindingContext newContext = null;
        if (obj instanceof GeographicCoordinates) {
            GeographicCoordinates coordinates = (GeographicCoordinates)obj;
            newContext = new DataBindingContext();
            ISWTObservableValue txtLatObsVal = WidgetProperties.text((int)24).observe((Widget)this.txtLat);
            IObservableValue modelLatObsVal = objDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE).observe((Object)coordinates) : EMFEditProperties.value((EditingDomain)objDomain, (EStructuralFeature)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE).observe((Object)coordinates);
            UpdateValueStrategy txtToModelLatUpdateStrategy = new UpdateValueStrategy();
            txtToModelLatUpdateStrategy.setConverter((IConverter)new DegreeStringToRadiansConverter());
            UpdateValueStrategy modelToTxtLatUpdateStrategy = new UpdateValueStrategy();
            modelToTxtLatUpdateStrategy.setConverter((IConverter)new RadiansToDegreesStringConverter(ANGLE_DEC_FORMAT));
            newContext.bindValue((IObservableValue)txtLatObsVal, modelLatObsVal, txtToModelLatUpdateStrategy, modelToTxtLatUpdateStrategy);
            ISWTObservableValue txtLongObsVal = WidgetProperties.text((int)24).observe((Widget)this.txtLong);
            IObservableValue modelLongObsVal = objDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE).observe((Object)coordinates) : EMFEditProperties.value((EditingDomain)objDomain, (EStructuralFeature)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE).observe((Object)coordinates);
            UpdateValueStrategy txtToModelLongUpdateStrategy = new UpdateValueStrategy();
            txtToModelLongUpdateStrategy.setConverter((IConverter)new DegreeStringToRadiansConverter());
            UpdateValueStrategy modelToTxtLongUpdateStrategy = new UpdateValueStrategy();
            modelToTxtLongUpdateStrategy.setConverter((IConverter)new RadiansToDegreesStringConverter(ANGLE_DEC_FORMAT));
            newContext.bindValue((IObservableValue)txtLongObsVal, modelLongObsVal, txtToModelLongUpdateStrategy, modelToTxtLongUpdateStrategy);
            ISWTObservableValue txtElevObsVal = WidgetProperties.text((int)24).observe((Widget)this.txtElev);
            IObservableValue modelElevObsVal = objDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION).observe((Object)coordinates) : EMFEditProperties.value((EditingDomain)objDomain, (EStructuralFeature)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION).observe((Object)coordinates);
            UpdateValueStrategy txtToModelElevUpdateStrategy = new UpdateValueStrategy();
            txtToModelElevUpdateStrategy.setConverter((IConverter)new StringToDoubleConverter());
            UpdateValueStrategy modelToTxtElevUpdateStrategy = new UpdateValueStrategy();
            modelToTxtElevUpdateStrategy.setConverter((IConverter)new DoubleToStringConverter((NumberFormat)POS_DEC_FORMAT));
            newContext.bindValue((IObservableValue)txtElevObsVal, modelElevObsVal, txtToModelElevUpdateStrategy, modelToTxtElevUpdateStrategy);
        } else if (obj instanceof Positioned && (position = (Positioned)obj).getPose() != null) {
            newContext = new DataBindingContext();
            ISWTObservableValue txtXObsVal = WidgetProperties.text((int)24).observe((Widget)this.txtX);
            IObservableValue modelXObsVal = objDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCommonMathPackage.Literals.MATRIX4X4__M03).observe((Object)position.getPose()) : EMFEditProperties.value((EditingDomain)objDomain, (EStructuralFeature)ApogyCommonMathPackage.Literals.MATRIX4X4__M03).observe((Object)position.getPose());
            UpdateValueStrategy txtToModelXUpdateStrategy = new UpdateValueStrategy();
            txtToModelXUpdateStrategy.setConverter((IConverter)new StringToDoubleConverter());
            UpdateValueStrategy modelToTxtXUpdateStrategy = new UpdateValueStrategy();
            modelToTxtXUpdateStrategy.setConverter((IConverter)new DoubleToStringConverter((NumberFormat)POS_DEC_FORMAT));
            newContext.bindValue((IObservableValue)txtXObsVal, modelXObsVal, txtToModelXUpdateStrategy, modelToTxtXUpdateStrategy);
            ISWTObservableValue txtYObsVal = WidgetProperties.text((int)24).observe((Widget)this.txtY);
            IObservableValue modelYObsVal = objDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCommonMathPackage.Literals.MATRIX4X4__M13).observe((Object)position.getPose()) : EMFEditProperties.value((EditingDomain)objDomain, (EStructuralFeature)ApogyCommonMathPackage.Literals.MATRIX4X4__M13).observe((Object)position.getPose());
            UpdateValueStrategy txtToModelYUpdateStrategy = new UpdateValueStrategy();
            txtToModelYUpdateStrategy.setConverter((IConverter)new StringToDoubleConverter());
            UpdateValueStrategy modelToTxtYUpdateStrategy = new UpdateValueStrategy();
            modelToTxtYUpdateStrategy.setConverter((IConverter)new DoubleToStringConverter((NumberFormat)POS_DEC_FORMAT));
            newContext.bindValue((IObservableValue)txtYObsVal, modelYObsVal, txtToModelYUpdateStrategy, modelToTxtYUpdateStrategy);
            ISWTObservableValue txtZObsVal = WidgetProperties.text((int)24).observe((Widget)this.txtZ);
            IObservableValue modelZObsVal = objDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCommonMathPackage.Literals.MATRIX4X4__M23).observe((Object)position.getPose()) : EMFEditProperties.value((EditingDomain)objDomain, (EStructuralFeature)ApogyCommonMathPackage.Literals.MATRIX4X4__M23).observe((Object)position.getPose());
            UpdateValueStrategy txtToModelZUpdateStrategy = new UpdateValueStrategy();
            txtToModelZUpdateStrategy.setConverter((IConverter)new StringToDoubleConverter());
            UpdateValueStrategy modelToTxtZUpdateStrategy = new UpdateValueStrategy();
            modelToTxtZUpdateStrategy.setConverter((IConverter)new DoubleToStringConverter((NumberFormat)POS_DEC_FORMAT));
            newContext.bindValue((IObservableValue)txtZObsVal, modelZObsVal, txtToModelZUpdateStrategy, modelToTxtZUpdateStrategy);
        }
        return newContext;
    }

    private void disposeOfBindingContext() {
        if (this.dbContext != null) {
            this.dbContext.dispose();
            this.dbContext = null;
            this.boundObj = null;
            this.editingDomain = null;
        }
    }

    public void setBoundObject(Object obj) {
        if (this.boundObj == obj) {
            return;
        }
        this.disposeOfBindingContext();
        this.lstnAllTexts.updateESW((EObject)obj);
        if (obj instanceof GeographicCoordinates || obj instanceof Positioned) {
            this.boundObj = (EObject)obj;
            this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)obj);
            this.dbContext = this.createBinding(obj, this.editingDomain);
        }
    }

    protected void checkSubclass() {
    }

    private class DoubleValueVerifyAndUpdateListener
    implements VerifyListener {
        private EarthSurfaceWorksite earthSurfaceWorksite;
        private boolean updating = false;

        public DoubleValueVerifyAndUpdateListener() {
            this.updateESW(null);
        }

        public void updateESW(EObject selected) {
            EarthSurfaceWorksite esw = null;
            if (selected != null) {
                EObject container = selected.eContainer();
                while (esw == null && container != null) {
                    if (container instanceof EarthSurfaceWorksite) {
                        esw = (EarthSurfaceWorksite)container;
                        continue;
                    }
                    if (container instanceof InvocatorSession) {
                        ApogyEnvironment se;
                        InvocatorSession session = (InvocatorSession)container;
                        if (!(session.getEnvironment() instanceof ApogyEnvironment) || !((se = (ApogyEnvironment)session.getEnvironment()).getActiveWorksite() instanceof EarthSurfaceWorksite)) continue;
                        esw = (EarthSurfaceWorksite)se.getActiveWorksite();
                        continue;
                    }
                    container = container.eContainer();
                }
            }
            this.earthSurfaceWorksite = esw;
        }

        public void verifyText(VerifyEvent e) {
            Text text = (Text)e.widget;
            String oldStr = text.getText();
            String newStr = String.valueOf(oldStr.substring(0, e.start)) + e.text + oldStr.substring(e.end);
            try {
                if (!newStr.equals("")) {
                    Double.parseDouble(newStr);
                }
                if (!this.updating) {
                    this.updating = true;
                    if (text == CoordinateConversionComposite.this.txtX || text == CoordinateConversionComposite.this.txtY || text == CoordinateConversionComposite.this.txtZ) {
                        String xStrVal = "";
                        String yStrVal = "";
                        String zStrVal = "";
                        if (text == CoordinateConversionComposite.this.txtX) {
                            xStrVal = newStr;
                            yStrVal = CoordinateConversionComposite.this.txtY.getText();
                            zStrVal = CoordinateConversionComposite.this.txtZ.getText();
                        } else if (text == CoordinateConversionComposite.this.txtY) {
                            xStrVal = CoordinateConversionComposite.this.txtX.getText();
                            yStrVal = newStr;
                            zStrVal = CoordinateConversionComposite.this.txtZ.getText();
                        } else {
                            xStrVal = CoordinateConversionComposite.this.txtX.getText();
                            yStrVal = CoordinateConversionComposite.this.txtY.getText();
                            zStrVal = newStr;
                        }
                        if (!(xStrVal.equals("") || yStrVal.equals("") || zStrVal.equals(""))) {
                            double xVal = Double.parseDouble(xStrVal);
                            double yVal = Double.parseDouble(yStrVal);
                            double zVal = Double.parseDouble(zStrVal);
                            Tuple3d tuple = ApogyCommonMathFacade.INSTANCE.createTuple3d(xVal, yVal, zVal);
                            GeographicCoordinates coords = this.earthSurfaceWorksite.convertToGeographicCoordinates(tuple);
                            double latVal = Math.toDegrees(coords.getLatitude());
                            double longVal = Math.toDegrees(coords.getLongitude());
                            double elevVal = coords.getElevation();
                            CoordinateConversionComposite.this.txtLat.setText(ANGLE_DEC_FORMAT.format(latVal));
                            CoordinateConversionComposite.this.txtLong.setText(ANGLE_DEC_FORMAT.format(longVal));
                            CoordinateConversionComposite.this.txtElev.setText(POS_DEC_FORMAT.format(elevVal));
                        }
                    } else if (text == CoordinateConversionComposite.this.txtLat || text == CoordinateConversionComposite.this.txtLong || text == CoordinateConversionComposite.this.txtElev) {
                        String latStrVal = "";
                        String longStrVal = "";
                        String elevStrVal = "";
                        if (text == CoordinateConversionComposite.this.txtLat) {
                            latStrVal = newStr;
                            longStrVal = CoordinateConversionComposite.this.txtLong.getText();
                            elevStrVal = CoordinateConversionComposite.this.txtElev.getText();
                        } else if (text == CoordinateConversionComposite.this.txtLong) {
                            latStrVal = CoordinateConversionComposite.this.txtLat.getText();
                            longStrVal = newStr;
                            elevStrVal = CoordinateConversionComposite.this.txtElev.getText();
                        } else {
                            latStrVal = CoordinateConversionComposite.this.txtLat.getText();
                            longStrVal = CoordinateConversionComposite.this.txtLong.getText();
                            elevStrVal = newStr;
                        }
                        if (!(latStrVal.equals("") || longStrVal.equals("") || elevStrVal.equals(""))) {
                            double latVal = Double.parseDouble(latStrVal);
                            double longVal = Double.parseDouble(longStrVal);
                            double elevVal = Double.parseDouble(elevStrVal);
                            latVal = Math.toRadians(latVal);
                            longVal = Math.toRadians(longVal);
                            GeographicCoordinates coords = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createGeographicCoordinates();
                            coords.setLatitude(latVal);
                            coords.setLongitude(longVal);
                            coords.setElevation(elevVal);
                            Tuple3d tuple = this.earthSurfaceWorksite.convertToXYZPosition(coords);
                            CoordinateConversionComposite.this.txtX.setText(POS_DEC_FORMAT.format(tuple.getX()));
                            CoordinateConversionComposite.this.txtY.setText(POS_DEC_FORMAT.format(tuple.getY()));
                            CoordinateConversionComposite.this.txtZ.setText(POS_DEC_FORMAT.format(tuple.getZ()));
                        }
                    }
                    this.updating = false;
                }
            }
            catch (NumberFormatException ex) {
                e.text = "";
                e.doit = false;
            }
        }
    }
}

