/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.databindings;

import java.text.NumberFormat;
import java.util.Date;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.AtmosphereUtils;
import org.eclipse.core.databinding.conversion.Converter;

public class DateToSunIntensityStringConverter
extends Converter {
    private NumberFormat numberFormat = null;
    private GeographicCoordinates geographicCoordinates = null;

    public DateToSunIntensityStringConverter() {
        super(Date.class, String.class);
    }

    public DateToSunIntensityStringConverter(NumberFormat numberFormat, GeographicCoordinates geographicCoordinates) {
        super(Date.class, String.class);
        this.setNumberFormat(numberFormat);
        this.setGeographicCoordinates(geographicCoordinates);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public GeographicCoordinates getGeographicCoordinates() {
        return this.geographicCoordinates;
    }

    public void setGeographicCoordinates(GeographicCoordinates geographicCoordinates) {
        this.geographicCoordinates = geographicCoordinates;
    }

    public Object convert(Object fromObject) {
        Date date = (Date)fromObject;
        HorizontalCoordinates sunCoordinates = AstronomyUtils.INSTANCE.getHorizontalSunPosition(date, this.getGeographicCoordinates().getLongitude(), this.getGeographicCoordinates().getLatitude());
        Double value = AtmosphereUtils.INSTANCE.getDirectSunIntensity(sunCoordinates.getAltitude(), this.getGeographicCoordinates().getElevation());
        if (this.getNumberFormat() != null) {
            return this.getNumberFormat().format(value);
        }
        return value.toString();
    }
}

