/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import java.awt.Color;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.impl.LastSelectionWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LastSelectionWorldWindLayerCustomImpl
extends LastSelectionWorldWindLayerImpl {
    private Adapter earthViewConfigurationAdapter;

    @Override
    public void initialise() {
        super.initialise();
        this.getEarthViewConfiguration().eAdapters().add((Object)this.getEarthViewConfigurationAdapter());
    }

    @Override
    public void dispose() {
        this.getEarthViewConfiguration().eAdapters().remove((Object)this.getEarthViewConfigurationAdapter());
        super.dispose();
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                Color color = WorldWindUtils.convertFrom(this.getColor());
                Position position = WorldWindUtils.convertToPosition(this.getCoordinates());
                BasicShapeAttributes fovAttributes = new BasicShapeAttributes();
                fovAttributes.setDrawInterior(true);
                fovAttributes.setOutlineOpacity(0.95);
                fovAttributes.setDrawOutline(true);
                Material interiorMat = new Material(WorldWindUtils.convertFrom(this.getColor()));
                fovAttributes.setInteriorMaterial(interiorMat);
                fovAttributes.setDrawInterior(true);
                fovAttributes.setInteriorOpacity(0.5);
                Material outlineMat = new Material(WorldWindUtils.convertFrom(this.getColor()));
                fovAttributes.setOutlineMaterial(outlineMat);
                SurfaceCircle visibilityCircle = new SurfaceCircle((ShapeAttributes)fovAttributes, (LatLon)position, this.getDisplayedRadius() * 1000.0, 36);
                visibilityCircle.setVisible(true);
                layer.addRenderable((Renderable)visibilityCircle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Adapter getEarthViewConfigurationAdapter() {
        if (this.earthViewConfigurationAdapter == null) {
            this.earthViewConfigurationAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    block12: {
                        block11: {
                            if (!(msg.getNotifier() instanceof EarthViewConfiguration)) break block11;
                            int featureID = msg.getFeatureID(EarthViewConfiguration.class);
                            switch (featureID) {
                                case 3: {
                                    GeographicCoordinates oldGeographicCoordinates = (GeographicCoordinates)msg.getOldValue();
                                    if (oldGeographicCoordinates != null) {
                                        oldGeographicCoordinates.eAdapters().remove((Object)LastSelectionWorldWindLayerCustomImpl.this.getEarthViewConfigurationAdapter());
                                    }
                                    GeographicCoordinates newGeographicCoordinates = (GeographicCoordinates)msg.getNewValue();
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)LastSelectionWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.LAST_SELECTION_WORLD_WIND_LAYER__COORDINATES, (Object)newGeographicCoordinates);
                                    if (newGeographicCoordinates != null) {
                                        newGeographicCoordinates.eAdapters().add((Object)LastSelectionWorldWindLayerCustomImpl.this.getEarthViewConfigurationAdapter());
                                    }
                                    if (LastSelectionWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        try {
                                            LastSelectionWorldWindLayerCustomImpl.this.update();
                                        }
                                        catch (Exception exception) {}
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block12;
                        }
                        if (msg.getNotifier() instanceof GeographicCoordinates && LastSelectionWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                            try {
                                LastSelectionWorldWindLayerCustomImpl.this.update();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
        }
        return this.earthViewConfigurationAdapter;
    }
}

