/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Color3f;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.impl.LongitudeLattitudeGridWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongitudeLattitudeGridWorldWindLayerCustomImpl
extends LongitudeLattitudeGridWorldWindLayerImpl {
    public static final short GROUND_TRACE_STIPPLE_PATTERN = 255;
    public static final int GROUND_TRACE_STIPPLE_FACTOR = 1;
    private static double EPSILON = 1.0E-4;
    private static double MAX_LONGITUDE = 180.0 - EPSILON;
    private static double MIN_LONGITUDE = -180.0 + EPSILON;
    private static final Logger Logger = LoggerFactory.getLogger(LongitudeLattitudeGridWorldWindLayerCustomImpl.class);

    @Override
    public void setLongitudeLinesInterval(double newLongitudeLinesInterval) {
        if (newLongitudeLinesInterval != 0.0) {
            super.setLongitudeLinesInterval(newLongitudeLinesInterval);
            if (this.isAutoUpdateEnabled()) {
                try {
                    this.update();
                }
                catch (Exception e) {
                    Logger.error("Error ocurred while updating the longitude line interval. ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setDisplayLongitudeLines(boolean newDisplayLongitudeLines) {
        super.setDisplayLongitudeLines(newDisplayLongitudeLines);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the longitude line visibility. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setLongitudeLineColor(Color3f newLongitudeLineColor) {
        super.setLongitudeLineColor(newLongitudeLineColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the longitude line color. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setLatitudeLinesInterval(double newLatitudeLinesInterval) {
        if (newLatitudeLinesInterval != 0.0) {
            super.setLatitudeLinesInterval(newLatitudeLinesInterval);
            if (this.isAutoUpdateEnabled()) {
                try {
                    this.update();
                }
                catch (Exception e) {
                    Logger.error("Error ocurred while updating the latitude line interval. ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setDisplayLatitudeLines(boolean newDisplayLatitudeLines) {
        super.setDisplayLatitudeLines(newDisplayLatitudeLines);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the latitude line visibility. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setLatitudeLineColor(Color3f newLatitudeLineColor) {
        super.setLatitudeLineColor(newLatitudeLineColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the latitude line color. ", (Throwable)e);
            }
        }
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                Polyline groundTrace;
                List<Polyline> polylines;
                if (this.isDisplayLongitudeLines()) {
                    Color longitudeColor = WorldWindUtils.convertFrom(this.getLongitudeLineColor());
                    List<List<GeographicCoordinates>> longitudeSegments = this.generateLongitudeLines(Math.abs(this.getLongitudeLinesInterval()));
                    for (List<GeographicCoordinates> segment : longitudeSegments) {
                        polylines = WorldWindUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(segment);
                        for (Polyline line : polylines) {
                            groundTrace = new Polyline(line.getPositions());
                            groundTrace.setFollowTerrain(true);
                            groundTrace.setColor(longitudeColor);
                            groundTrace.setStippleFactor(1);
                            groundTrace.setStipplePattern((short)255);
                            layer.addRenderable((Renderable)groundTrace);
                        }
                    }
                }
                if (this.isDisplayLatitudeLines()) {
                    Color latitudeColor = WorldWindUtils.convertFrom(this.getLatitudeLineColor());
                    List<List<GeographicCoordinates>> latitudeSegments = this.generateLatitudeLines(Math.abs(this.getLatitudeLinesInterval()));
                    for (List<GeographicCoordinates> segment : latitudeSegments) {
                        polylines = WorldWindUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(segment);
                        for (Polyline line : polylines) {
                            groundTrace = new Polyline(line.getPositions());
                            groundTrace.setFollowTerrain(true);
                            groundTrace.setColor(latitudeColor);
                            groundTrace.setStippleFactor(1);
                            groundTrace.setStipplePattern((short)255);
                            layer.addRenderable((Renderable)groundTrace);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }

    protected List<List<GeographicCoordinates>> generateLongitudeLines(double longitudeLinesInterval) {
        GeographicCoordinates geographicCoordinates2;
        GeographicCoordinates geographicCoordinates1;
        ArrayList<GeographicCoordinates> segment;
        ArrayList<List<GeographicCoordinates>> coords = new ArrayList<List<GeographicCoordinates>>();
        double longitude = 0.0;
        while (longitude <= 180.0) {
            segment = new ArrayList<GeographicCoordinates>();
            geographicCoordinates1 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(longitude), Math.toRadians(90.0), 0.0);
            geographicCoordinates2 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(longitude), Math.toRadians(-90.0), 0.0);
            segment.add(geographicCoordinates1);
            segment.add(geographicCoordinates2);
            coords.add(segment);
            longitude += longitudeLinesInterval;
        }
        longitude = -longitudeLinesInterval;
        while (longitude >= -180.0) {
            segment = new ArrayList();
            geographicCoordinates1 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(longitude), Math.toRadians(90.0), 0.0);
            geographicCoordinates2 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(longitude), Math.toRadians(-90.0), 0.0);
            segment.add(geographicCoordinates1);
            segment.add(geographicCoordinates2);
            coords.add(segment);
            longitude -= longitudeLinesInterval;
        }
        return coords;
    }

    protected List<List<GeographicCoordinates>> generateLatitudeLines(double latitudeLinesInterval) {
        GeographicCoordinates geographicCoordinates1;
        ArrayList<GeographicCoordinates> segment;
        ArrayList<List<GeographicCoordinates>> coords = new ArrayList<List<GeographicCoordinates>>();
        double longitude = MIN_LONGITUDE;
        double latitude = 0.0;
        while (latitude < 90.0) {
            longitude = MIN_LONGITUDE;
            segment = new ArrayList<GeographicCoordinates>();
            while (longitude <= MAX_LONGITUDE) {
                geographicCoordinates1 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(longitude), Math.toRadians(latitude), 0.0);
                segment.add(geographicCoordinates1);
                longitude += 2.0;
            }
            if (longitude >= MAX_LONGITUDE) {
                geographicCoordinates1 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(MAX_LONGITUDE), Math.toRadians(latitude), 0.0);
                segment.add(geographicCoordinates1);
            }
            latitude += latitudeLinesInterval;
            coords.add(segment);
        }
        longitude = MIN_LONGITUDE;
        latitude = -latitudeLinesInterval;
        while (latitude > -90.0) {
            longitude = MIN_LONGITUDE;
            segment = new ArrayList();
            while (longitude <= MAX_LONGITUDE) {
                geographicCoordinates1 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(longitude), Math.toRadians(latitude), 0.0);
                segment.add(geographicCoordinates1);
                longitude += 2.0;
            }
            if (longitude >= MAX_LONGITUDE) {
                geographicCoordinates1 = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(MAX_LONGITUDE), Math.toRadians(latitude), 0.0);
                segment.add(geographicCoordinates1);
            }
            latitude -= latitudeLinesInterval;
            coords.add(segment);
        }
        return coords;
    }
}

