/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.utils;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.ogc.kml.KMLAbstractContainer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLDocument;
import gov.nasa.worldwind.render.Polyline;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Color3f;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;

public class WorldWindUtils {
    public static GeographicCoordinates convertToGeographicCoordinates(Position position) {
        GeographicCoordinates coordinates = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(position.getLongitude().radians, position.getLatitude().radians, position.getAltitude());
        return coordinates;
    }

    public static Position convertToPosition(GeographicCoordinates geographicCoordinates) {
        Angle latitude = Angle.fromRadiansLatitude((double)geographicCoordinates.getLatitude());
        Angle longitude = Angle.fromRadiansLongitude((double)geographicCoordinates.getLongitude());
        double elevation = geographicCoordinates.getElevation();
        Position position = new Position(latitude, longitude, elevation);
        return position;
    }

    public static Position convertToPosition(double longitudeDegrees, double latitudeDegrees, double elevationMeters) {
        Angle latitude = Angle.fromDegreesLatitude((double)latitudeDegrees);
        Angle longitude = Angle.fromDegreesLongitude((double)longitudeDegrees);
        Position position = new Position(latitude, longitude, elevationMeters);
        return position;
    }

    public static List<Polyline> createPolyLineFromGeographicCoordinatesListNoWrapAround(List<GeographicCoordinates> coordinatesList) {
        LinkedList<Position> positions = new LinkedList<Position>();
        for (GeographicCoordinates coord : coordinatesList) {
            Position position = WorldWindUtils.convertToPosition(coord);
            positions.add(position);
        }
        return WorldWindUtils.removeWrapAround(positions);
    }

    public static List<Polyline> createPolyLineFromGeographicCoordinatesListNoWrapAroundOLD(List<GeographicCoordinates> coordinatesList) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        LinkedList<Position> positions = new LinkedList<Position>();
        for (GeographicCoordinates coord : coordinatesList) {
            Position position = WorldWindUtils.convertToPosition(coord);
            if (positions.size() > 0) {
                double currentLongitude = position.longitude.getDegrees();
                double lastLongitude = ((Position)positions.getLast()).longitude.getDegrees();
                if (Math.signum(currentLongitude) != Math.signum(lastLongitude) && Math.abs(currentLongitude) > 90.0 && Math.abs(lastLongitude) > 90.0) {
                    Polyline polyline = new Polyline(positions);
                    polylines.add(polyline);
                    positions.clear();
                }
            }
            positions.add(position);
        }
        if (!positions.isEmpty()) {
            Polyline polyline = new Polyline(positions);
            polylines.add(polyline);
        }
        return polylines;
    }

    public static Color convertFrom(Color3f color3f) {
        return new Color(color3f.x, color3f.y, color3f.z);
    }

    private static void getAllKMLAbstractFeatureOfType(Class<?> kmlAbstractFeatureClass, KMLAbstractFeature root, List<KMLAbstractFeature> featureList) {
        if (kmlAbstractFeatureClass.isAssignableFrom(root.getClass())) {
            featureList.add(root);
        }
        if (root instanceof KMLAbstractContainer) {
            KMLAbstractContainer container = (KMLAbstractContainer)root;
            for (KMLAbstractFeature feature : container.getFeatures()) {
                WorldWindUtils.getAllKMLAbstractFeatureOfType(kmlAbstractFeatureClass, feature, featureList);
            }
        }
    }

    public static List<KMLAbstractFeature> getAllKMLAbstractFeatureOfType(Class<?> kmlAbstractFeatureClass, KMLDocument kmlDocument) {
        ArrayList<KMLAbstractFeature> features = new ArrayList<KMLAbstractFeature>();
        WorldWindUtils.getAllKMLAbstractFeatureOfType(kmlAbstractFeatureClass, (KMLAbstractFeature)kmlDocument, features);
        return features;
    }

    public static List<Polyline> removeWrapAround(List<Position> originalPositions) {
        double epsilon = 1.0E-4;
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        Position p0 = null;
        Position p1 = null;
        LinkedList<Position> positions = new LinkedList<Position>();
        Iterator<Position> it = originalPositions.iterator();
        while (it.hasNext()) {
            p1 = it.next();
            if (p0 != null) {
                if (Math.signum(p1.longitude.degrees) != Math.signum(p0.longitude.degrees)) {
                    if (Math.abs(p1.longitude.degrees) > 90.0 && Math.abs(p0.longitude.degrees) > 90.0) {
                        double deltaLongitude = 0.0;
                        double latitudeSlope = 0.0;
                        double lattitudeCrossing = 0.0;
                        double deltaP0Longitude = 0.0;
                        double deltaLattitude = 0.0;
                        double elevationCrossing = 0.0;
                        double elevationSlope = 0.0;
                        double deltaElevation = 0.0;
                        double p01Lattitude = 0.0;
                        double p01Longitude = 0.0;
                        double p01Elevation = 0.0;
                        double p11Lattitude = 0.0;
                        double p11Longitude = 0.0;
                        double p11Elevation = 0.0;
                        if (p1.longitude.degrees < p0.longitude.degrees) {
                            deltaLongitude = 180.0 - p0.longitude.degrees + (180.0 - Math.abs(p1.longitude.degrees));
                            latitudeSlope = (p1.latitude.degrees - p0.latitude.degrees) / deltaLongitude;
                            deltaP0Longitude = 180.0 - p0.longitude.degrees;
                            lattitudeCrossing = deltaP0Longitude * latitudeSlope + p0.latitude.degrees;
                            elevationSlope = p1.elevation - p0.elevation;
                            elevationCrossing = deltaP0Longitude * elevationSlope + p0.elevation;
                            p01Longitude = 180.0 - epsilon;
                            p01Lattitude = (p01Longitude - p0.longitude.degrees) * latitudeSlope + p0.latitude.degrees;
                            p01Elevation = Math.abs(p01Longitude - p0.longitude.degrees) * elevationSlope + p0.elevation;
                            deltaLattitude = lattitudeCrossing - p01Lattitude;
                            deltaElevation = elevationCrossing - p01Elevation;
                            p11Longitude = -180.0 + epsilon;
                            p11Lattitude = lattitudeCrossing + deltaLattitude;
                            p11Elevation = elevationCrossing + deltaElevation;
                        } else if (p1.longitude.degrees > p0.longitude.degrees) {
                            deltaLongitude = 180.0 - p1.longitude.degrees + (180.0 - Math.abs(p0.longitude.degrees));
                            latitudeSlope = (p1.latitude.degrees - p0.latitude.degrees) / deltaLongitude;
                            deltaP0Longitude = Math.abs(180.0 + p0.longitude.degrees);
                            lattitudeCrossing = deltaP0Longitude * latitudeSlope + p0.latitude.degrees;
                            elevationSlope = p1.elevation - p0.elevation;
                            elevationCrossing = deltaP0Longitude * elevationSlope + p0.elevation;
                            p01Longitude = -180.0 + epsilon;
                            p01Lattitude = Math.abs(p01Longitude - p0.longitude.degrees) * latitudeSlope + p0.latitude.degrees;
                            p01Elevation = Math.abs(p01Longitude - p0.longitude.degrees) * elevationSlope + p0.elevation;
                            deltaLattitude = lattitudeCrossing - p01Lattitude;
                            deltaElevation = elevationCrossing - p01Elevation;
                            p11Longitude = 180.0 - epsilon;
                            p11Lattitude = lattitudeCrossing + deltaLattitude;
                            p11Elevation = elevationCrossing + deltaElevation;
                        }
                        Position p01 = WorldWindUtils.convertToPosition(p01Longitude, p01Lattitude, p01Elevation);
                        positions.add(p01);
                        Polyline polyline = new Polyline(positions);
                        polylines.add(polyline);
                        positions.clear();
                        Position p11 = WorldWindUtils.convertToPosition(p11Longitude, p11Lattitude, p11Elevation);
                        positions.add(p11);
                        positions.add(p1);
                    }
                } else {
                    positions.add(p1);
                }
            } else {
                positions.add(p1);
            }
            p0 = p1;
            if (it.hasNext() || positions.isEmpty()) continue;
            Polyline polyline = new Polyline(positions);
            polylines.add(polyline);
        }
        return polylines;
    }
}

