/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.KMLWorldWindLayer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class KMLWorldWindLayerURLWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.ui.wizards.KMLWorldWindLayerURLWizardPage";
    private final KMLWorldWindLayer kmlWorldWindLayer;
    private String urlString;
    private URLSelectionComposite urlSelectionComposite;

    public KMLWorldWindLayerURLWizardPage(KMLWorldWindLayer surfacePolygonWorldWindLayer) {
        super(WIZARD_PAGE_ID);
        this.kmlWorldWindLayer = surfacePolygonWorldWindLayer;
        this.setTitle("URL to the KML/KMZ file.");
        this.setDescription("Set the URL.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.urlSelectionComposite = new URLSelectionComposite(top, 0, new String[]{"*.kmz", "*.kml"}, true, true, true){

            protected void urlStringSelected(String newURLString) {
                KMLWorldWindLayerURLWizardPage.this.urlString = newURLString;
                KMLWorldWindLayerURLWizardPage.this.validate();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)KMLWorldWindLayerURLWizardPage.this.kmlWorldWindLayer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.KML_WORLD_WIND_LAYER__URL, (Object)newURLString);
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.kmlWorldWindLayer != null && this.kmlWorldWindLayer.getUrl() != null) {
            this.urlSelectionComposite.setUrlString(this.kmlWorldWindLayer.getUrl());
        }
        this.setControl((Control)top);
        this.urlSelectionComposite.setFocus();
    }

    protected void validate() {
        boolean urlValid;
        this.setErrorMessage(null);
        boolean bl = urlValid = this.urlString != null && this.urlString.length() > 0;
        if (!urlValid) {
            this.setErrorMessage("Invalid URL specified !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

