/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.impl.ApogyCoreEnvironmentEarthFacadeImpl;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;

public class ApogyCoreEnvironmentEarthFacadeCustomImpl
extends ApogyCoreEnvironmentEarthFacadeImpl {
    private Adapter activeWorksiteAdapter = null;

    protected ApogyCoreEnvironmentEarthFacadeCustomImpl() {
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getWorksiteAdapter());
    }

    @Override
    public Tuple3d getMoonVector(Node node, Environment environment) {
        if (environment instanceof ApogyEnvironment) {
            Node universeRoot = null;
            EList moons = ApogyCommonTopologyFacade.INSTANCE.findNodesByID("MOON", universeRoot);
            if (moons.size() > 0) {
                Node moon = (Node)moons.get(0);
                Matrix4d matrix = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(moon, node);
                Vector3d v = new Vector3d();
                matrix.get(v);
                v.normalize();
                return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)v);
            }
            return null;
        }
        return null;
    }

    @Override
    public GeographicCoordinates createGeographicCoordinates(double longitude, double latitude, double altitude) {
        GeographicCoordinates coord = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createGeographicCoordinates();
        coord.setLongitude(longitude);
        coord.setLatitude(latitude);
        coord.setElevation(altitude);
        return coord;
    }

    @Override
    public EarthSurfaceLocation createEarthSurfaceLocation(String name, String description, double longitude, double latitude, double elevation) {
        EarthSurfaceLocation loc = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createEarthSurfaceLocation();
        loc.setName(name);
        loc.setDescription(description);
        loc.setLatitude(latitude);
        loc.setLongitude(longitude);
        loc.setElevation(elevation);
        return loc;
    }

    @Override
    public List<GeographicCoordinates> loadGeographicCoordinatesFromURL(String urlString) throws Exception {
        ArrayList<GeographicCoordinates> coords = new ArrayList<GeographicCoordinates>();
        URL url = new URL(urlString);
        File tempFile = this.copyURLContent(url);
        BufferedReader reader = new BufferedReader(new FileReader(tempFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            GeographicCoordinates coord = this.parserCSVLine(line);
            coords.add(coord);
        }
        reader.close();
        return coords;
    }

    @Override
    public Tuple3d getMoonVector(ApogySystem apogySystem, String nodeID, Environment environment) {
        EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByID(nodeID, apogySystem.getTopologyRoot().getOriginNode());
        if (!nodes.isEmpty()) {
            Node node = (Node)nodes.get(0);
            return this.getMoonVector(node, environment);
        }
        return null;
    }

    private File copyURLContent(URL url) throws Exception {
        File tempFile = null;
        String fileName = this.getFileName(url);
        String fileExtension = this.getFileExtension(url);
        tempFile = File.createTempFile(fileName, fileExtension);
        url.openConnection();
        InputStream reader = url.openStream();
        FileOutputStream writer = new FileOutputStream(tempFile);
        byte[] buffer = new byte[153600];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, bytesRead);
            buffer = new byte[153600];
        }
        writer.close();
        reader.close();
        if (tempFile != null) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        int startIndex = fileName.lastIndexOf(File.separator);
        int endIndex = fileName.lastIndexOf(".");
        if (startIndex > 0 && endIndex > 0) {
            fileName = fileName.substring(startIndex + 1, endIndex);
        }
        return fileName;
    }

    private String getFileExtension(URL url) {
        String fileExtension = url.getFile();
        int index = fileExtension.lastIndexOf(".");
        if (index > 0) {
            fileExtension = fileExtension.substring(index);
        }
        return fileExtension;
    }

    private GeographicCoordinates parserCSVLine(String line) throws Exception {
        GeographicCoordinates coords = null;
        String[] entries = line.split(",");
        if (entries.length < 3) {
            throw new Exception("Line <" + line + "> contains too few entries !");
        }
        double longitude = Math.toRadians(Double.parseDouble(entries[0]));
        double lattitude = Math.toRadians(Double.parseDouble(entries[1]));
        double altitude = Double.parseDouble(entries[2]);
        coords = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createGeographicCoordinates();
        coords.setElevation(altitude);
        coords.setLatitude(lattitude);
        coords.setLongitude(longitude);
        return coords;
    }

    private Adapter getWorksiteAdapter() {
        if (this.activeWorksiteAdapter == null) {
            this.activeWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreEnvironmentFacade) {
                        int featureID = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                        switch (featureID) {
                            case 1: {
                                if (msg.getNewValue() instanceof EarthWorksite) {
                                    ApogyCoreEnvironmentEarthFacadeCustomImpl.this.setActiveEarthWorksite((EarthWorksite)msg.getNewValue());
                                    break;
                                }
                                ApogyCoreEnvironmentEarthFacadeCustomImpl.this.setActiveEarthWorksite(null);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeWorksiteAdapter;
    }
}

