/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.apogy.common.ui.composites.Color3fComposite;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.apogy.core.environment.surface.FixedPositionLineOfSightImageMapLayer;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.ui.ImageMapLayerUISettings;
import org.eclipse.apogy.core.environment.surface.ui.composites.ImageMapLayerPreviewComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FixedPositionLineOfSightImageMapLayerWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.LineOfSightImageMapLayerWizardPage";
    private final FixedPositionLineOfSightImageMapLayer lineOfSightImageMapLayer;
    private final ImageMapLayerUISettings uiSettings;
    private Color3fComposite lineOfSightColor3fComposite;
    private Color3fComposite noLineOfSightColor3fComposite;
    private Tuple3dComposite positionComposite;
    private Text txtTargetHeightAboveGround;
    private Button btnUseHeightPerpendicularToGround;
    private ImageMapLayerPreviewComposite imagePreviewComposite;
    private DataBindingContext m_bindingContext;

    public FixedPositionLineOfSightImageMapLayerWizardPage(FixedPositionLineOfSightImageMapLayer lineOfSightImageMapLayer, ImageMapLayerUISettings uiSettings) {
        super(WIZARD_PAGE_ID);
        this.lineOfSightImageMapLayer = lineOfSightImageMapLayer;
        this.uiSettings = uiSettings;
        this.setTitle("Line Of Sight Image Layer");
        this.setDescription("Configure the line of sight colors and position settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Group colorGroup = new Group(container, 2048);
        colorGroup.setLayout((Layout)new GridLayout(2, false));
        colorGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        colorGroup.setText("Colors");
        Label lblLineOfSightColor = new Label((Composite)colorGroup, 0);
        lblLineOfSightColor.setAlignment(131072);
        lblLineOfSightColor.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLineOfSightColor.setText("Line Of Sight Color :");
        this.lineOfSightColor3fComposite = new Color3fComposite((Composite)colorGroup, 0, "", true, (EObject)this.lineOfSightImageMapLayer, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.ABSTRACT_LINE_OF_SIGHT_IMAGE_MAP_LAYER__LINE_OF_SIGHT_AVAILABLE_COLOR);
        Label lblNoLineOfSightColor = new Label((Composite)colorGroup, 0);
        lblNoLineOfSightColor.setAlignment(131072);
        lblNoLineOfSightColor.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNoLineOfSightColor.setText("No Line Of Sight Color :");
        this.noLineOfSightColor3fComposite = new Color3fComposite((Composite)colorGroup, 0, "", true, (EObject)this.lineOfSightImageMapLayer, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.ABSTRACT_LINE_OF_SIGHT_IMAGE_MAP_LAYER__LINE_OF_SIGHT_NOT_AVAILABLE_COLOR);
        Group positionGroup = new Group(container, 2048);
        positionGroup.setLayout((Layout)new GridLayout(2, false));
        positionGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        positionGroup.setText("Position and Target Height");
        Label lblObserverPosition = new Label((Composite)positionGroup, 0);
        lblObserverPosition.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblObserverPosition.setText("Observer Position (m):");
        this.positionComposite = new Tuple3dComposite((Composite)positionGroup, 2048, (EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.lineOfSightImageMapLayer));
        this.positionComposite.setTuple3d(this.lineOfSightImageMapLayer.getObserverPosition());
        Label lblTargetHeightAboveGround = new Label((Composite)positionGroup, 0);
        lblTargetHeightAboveGround.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTargetHeightAboveGround.setText("Target Height Above Ground (m):");
        this.txtTargetHeightAboveGround = new Text((Composite)positionGroup, 2048);
        GridData gd_txtTargetHeightAboveGround = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtTargetHeightAboveGround.minimumWidth = 100;
        gd_txtTargetHeightAboveGround.widthHint = 100;
        this.txtTargetHeightAboveGround.setLayoutData((Object)gd_txtTargetHeightAboveGround);
        this.txtTargetHeightAboveGround.setToolTipText("The height of the target above ground.");
        Label lblAutoScale = new Label((Composite)positionGroup, 0);
        lblAutoScale.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAutoScale.setText("Height Perpendicular To Ground :");
        this.btnUseHeightPerpendicularToGround = new Button((Composite)positionGroup, 32);
        this.btnUseHeightPerpendicularToGround.setAlignment(131072);
        this.btnUseHeightPerpendicularToGround.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnUseHeightPerpendicularToGround.setText("");
        this.btnUseHeightPerpendicularToGround.setToolTipText("Whether or not to find each target position using the local normal. Using the local normal requires more processing time.");
        Group imageGroup = new Group(container, 2048);
        imageGroup.setLayout((Layout)new GridLayout(1, false));
        imageGroup.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        imageGroup.setText("Derived Image");
        this.imagePreviewComposite = new ImageMapLayerPreviewComposite((Composite)imageGroup, 0, (ImageMapLayer)this.lineOfSightImageMapLayer);
        GridData gd_imagePreviewComposite = new GridData(4, 4, true, true, 1, 1);
        gd_imagePreviewComposite.widthHint = 200;
        gd_imagePreviewComposite.heightHint = 200;
        gd_imagePreviewComposite.minimumHeight = 200;
        gd_imagePreviewComposite.minimumWidth = 200;
        this.imagePreviewComposite.setLayoutData(gd_imagePreviewComposite);
        this.imagePreviewComposite.setImageMapLayer((ImageMapLayer)this.lineOfSightImageMapLayer);
        this.setControl((Control)container);
        this.m_bindingContext = this.initDataBindingsCustom();
        this.validate();
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FixedPositionLineOfSightImageMapLayerWizardPage.this.m_bindingContext != null) {
                    FixedPositionLineOfSightImageMapLayerWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeTargetHeightAboveGround = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.lineOfSightImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.ABSTRACT_LINE_OF_SIGHT_IMAGE_MAP_LAYER__TARGET_HEIGHT_ABOVE_GROUND})).observe((Object)this.lineOfSightImageMapLayer);
        ISWTObservableValue observeTargetHeightAboveGroundText = WidgetProperties.text((int)24).observe((Widget)this.txtTargetHeightAboveGround);
        bindingContext.bindValue((IObservableValue)observeTargetHeightAboveGroundText, observeTargetHeightAboveGround, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        IObservableValue observeHeightPerpendicular = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.lineOfSightImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.ABSTRACT_LINE_OF_SIGHT_IMAGE_MAP_LAYER__USE_HEIGHT_PERPENDICULAR_TO_GROUND})).observe((Object)this.lineOfSightImageMapLayer);
        ISWTObservableValue observeHeightPerpendicularButtton = WidgetProperties.selection().observe((Widget)this.btnUseHeightPerpendicularToGround);
        bindingContext.bindValue((IObservableValue)observeHeightPerpendicularButtton, observeHeightPerpendicular, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }

    public class CompositeFilterContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Map) {
                Map map = (Map)element;
                return !this.filterMap(map).isEmpty();
            }
            return false;
        }

        protected List<CartesianTriangularMeshMapLayer> filterMap(Map map) {
            ArrayList<CartesianTriangularMeshMapLayer> imageMapLayers = new ArrayList<CartesianTriangularMeshMapLayer>();
            for (AbstractMapLayer layer : map.getLayers()) {
                if (!(layer instanceof CartesianTriangularMeshMapLayer)) continue;
                imageMapLayers.add((CartesianTriangularMeshMapLayer)layer);
            }
            return imageMapLayers;
        }
    }
}

