/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.javascript.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.infer.InferEngine;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;

public class ApogyInferEngine
extends InferEngine {
    private CompilationUnitDeclaration compUnit;
    private Registry registry;

    public ApogyInferEngine(InferrenceProvider inferenceProvider) {
        this.inferenceProvider = inferenceProvider;
    }

    public void setCompilationUnit(CompilationUnitDeclaration cu) {
        super.setCompilationUnit(cu);
        this.compUnit = cu;
    }

    public void initialize() {
        super.initialize();
        this.registry = new Registry();
    }

    public void doInfer() {
        String sessionProject;
        String compilationUnitProject = ApogyInferEngine.getCompilationUnitProject(this.compUnit);
        if (compilationUnitProject.equals(sessionProject = ApogyInferEngine.getProjectOfActiveInvocatorSession())) {
            EList variables = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getVariablesList().getVariables();
            for (Variable variable : variables) {
                this.visit(variable);
            }
        }
        super.doInfer();
    }

    private InferredType visit(Variable variable) {
        InferredType type = this.registry.getType(variable.getVariableType().getInterfaceClass());
        if (type != null) {
            return type;
        }
        type = this.registry.addType(variable.getVariableType().getInterfaceClass(), variable.getVariableType().getInterfaceClass().getInstanceTypeName());
        for (EOperation op : ApogyCommonEMFFacade.INSTANCE.getAllAvailableEOperations(variable.getVariableType().getInterfaceClass())) {
            MethodDeclaration method = this.visit(op);
            type.addMethod(op.getName().toCharArray(), (IFunctionDeclaration)method, 0);
        }
        for (TypeMember typeMember : variable.getVariableType().getMembers()) {
            type.addAttribute(this.visit(typeMember, type));
        }
        for (EStructuralFeature structuralFeature : variable.getVariableType().getInterfaceClass().getEAllStructuralFeatures()) {
            if (type.findAttribute(structuralFeature.getName().toCharArray()) != null) continue;
            type.addAttribute(this.visit(structuralFeature, type));
        }
        return type;
    }

    private MethodDeclaration visit(EOperation operation) {
        MethodDeclaration method = new MethodDeclaration(null);
        method.setInferredType(this.visit(operation.getEType()));
        if (method.getInferredType() == null) {
            method.setInferredType(new InferredType(InferredType.VOID_NAME));
        }
        EList params = operation.getEParameters();
        Argument[] args = new Argument[params.size()];
        int i = 0;
        while (i < args.length) {
            Argument arg;
            EParameter param = (EParameter)params.get(i);
            SingleTypeReference typeReference = new SingleTypeReference(param.getEType().getName().toCharArray(), 0L);
            typeReference.resolvedType = null;
            args[i] = arg = new Argument(param.getName().toCharArray(), 0L, (TypeReference)typeReference, 0);
            ++i;
        }
        method.setArguments((IArgument[])args);
        return method;
    }

    private InferredType visit(EClass clazz) {
        InferredType type = this.registry.getType(clazz);
        if (type != null) {
            return type;
        }
        type = this.registry.addType(clazz, clazz.getInstanceTypeName());
        for (EOperation op : ApogyCommonEMFFacade.INSTANCE.getAllAvailableEOperations(clazz)) {
            MethodDeclaration method = this.visit(op);
            type.addMethod(op.getName().toCharArray(), (IFunctionDeclaration)method, 0);
        }
        for (EStructuralFeature structuralFeature : clazz.getEAllStructuralFeatures()) {
            InferredAttribute attribute = this.visit(structuralFeature, type);
            type.addAttribute(attribute);
        }
        return type;
    }

    private InferredType visit(EDataType dataType) {
        InferredType type = this.registry.getType(dataType);
        if (type != null) {
            return type;
        }
        type = this.registry.addType(dataType, dataType.getInstanceTypeName());
        return type;
    }

    private InferredType visit(EClassifier classifier) {
        if (classifier instanceof EClass) {
            return this.visit((EClass)classifier);
        }
        if (classifier instanceof EDataType) {
            return this.visit((EDataType)classifier);
        }
        return null;
    }

    private InferredAttribute visit(EStructuralFeature feature, InferredType parent) {
        InferredAttribute attribute = new InferredAttribute(feature.getName().toCharArray(), parent, 0, 0);
        attribute.type = this.visit(feature.getEType());
        if (ApogyInferEngine.isArray(feature.getLowerBound(), feature.getUpperBound())) {
            InferredType type = attribute.type;
            attribute.type = new InferredType(InferredType.ARRAY_NAME);
            attribute.type.referenceClass = type;
        }
        return attribute;
    }

    private InferredAttribute visit(TypeMember typeMember, InferredType parent) {
        InferredAttribute attribute = new InferredAttribute(typeMember.getName().toCharArray(), parent, 0, 0);
        InferredType type = this.registry.getType(typeMember);
        if (type != null) {
            attribute.type = type;
            return attribute;
        }
        type = this.registry.addType(typeMember, typeMember.getMemberType().getInterfaceClass().getInstanceTypeName());
        type.setIsGlobal(true);
        attribute.type = type;
        for (EOperation op : ApogyCommonEMFFacade.INSTANCE.getAllAvailableEOperations(typeMember.getMemberType().getInterfaceClass())) {
            MethodDeclaration method = this.visit(op);
            type.addMethod(op.getName().toCharArray(), (IFunctionDeclaration)method, 0);
        }
        for (TypeMember tm : typeMember.getMemberType().getMembers()) {
            type.addAttribute(this.visit(tm, type));
        }
        for (EStructuralFeature structuralFeature : typeMember.getMemberType().getInterfaceClass().getEAllStructuralFeatures()) {
            if (type.findAttribute(structuralFeature.getName().toCharArray()) != null) continue;
            InferredAttribute att = this.visit(structuralFeature, type);
            type.addAttribute(att);
        }
        return attribute;
    }

    private static boolean isArray(int lowerBound, int upperBound) {
        return upperBound == -1 || lowerBound > 0 && lowerBound < upperBound;
    }

    private static String getCompilationUnitProject(CompilationUnitDeclaration compUnit) {
        String fileName = new String(compUnit.getFileName());
        File file = new File(fileName);
        while (file.getParentFile() != null && file.getParentFile().getParentFile() != null) {
            file = file.getParentFile();
        }
        return file.getName();
    }

    private static String getProjectOfActiveInvocatorSession() {
        InvocatorSession session = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (session == null) {
            return null;
        }
        Resource resource = session.eResource();
        URI uri = resource.getURI();
        if (!uri.isPlatformResource() || uri.segmentCount() < 2) {
            return null;
        }
        return uri.segment(1);
    }

    private class Registry {
        private final Map<Object, InferredType> types = new HashMap<Object, InferredType>();

        private Registry() {
        }

        public InferredType addType(Object object, String name) {
            if (this.types.containsKey(object)) {
                return this.types.get(object);
            }
            InferredType type = ApogyInferEngine.this.addType(name.toCharArray(), true);
            type.isAnonymous = true;
            type.setNameStart(((ApogyInferEngine)ApogyInferEngine.this).compUnit.sourceEnd + 1);
            this.types.put(object, type);
            return type;
        }

        public InferredType getType(Object object) {
            return this.types.get(object);
        }
    }
}

