/**
 * *******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Steve Monnier OBEO - Initial API and implementation
 *         
 * SPDX-License-Identifier: EPL-1.0    
 * *******************************************************************************
 */
package org.eclipse.apogy.core.programs.javascript;

import org.eclipse.apogy.core.invocator.OperationCallContainer;
import org.eclipse.apogy.core.invocator.ScriptBasedProgram;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Java Script Program</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A JavaScriptProgram is an entity that invokes Operation Calls on Variables through a JavaScript program file.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.apogy.core.programs.javascript.JavaScriptProgram#getScriptPath <em>Script Path</em>}</li>
 * </ul>
 *
 * @see org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage#getJavaScriptProgram()
 * @model annotation="http://www.eclipse.org/apogy hasCustomItemProvider='true'"
 * @generated
 */
public interface JavaScriptProgram extends ScriptBasedProgram, OperationCallContainer {
	/**
	 * Returns the value of the '<em><b>Script Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Script Path</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Script Path</em>' attribute.
	 * @see #setScriptPath(String)
	 * @see org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage#getJavaScriptProgram_ScriptPath()
	 * @model unique="false"
	 * @generated
	 */
	String getScriptPath();

	/**
	 * Sets the value of the '{@link org.eclipse.apogy.core.programs.javascript.JavaScriptProgram#getScriptPath <em>Script Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Script Path</em>' attribute.
	 * @see #getScriptPath()
	 * @generated
	 */
	void setScriptPath(String value);

	
} // JavaScriptProgram
