/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.util.BufferUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.AbstractTransformationJME3SceneObject;
import org.eclipse.apogy.core.PositionedResult;
import org.eclipse.apogy.core.ResultNode;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.ui.ResultNodeSceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultNodeJME3Object
extends AbstractTransformationJME3SceneObject<ResultNode>
implements ResultNodeSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(ResultNodeJME3Object.class);
    public static final float DEFAULT_FLAG_POLE_HEIGHT = 1.0f;
    public static final float FLAG_SIZE_PER_PIXEL = 0.005f;
    public static final ColorRGBA FLAG_POLE_COLOR = ColorRGBA.Yellow;
    public static final ColorRGBA FLAG_BACKGROUND_COLOR = ColorRGBA.Black;
    public static final ColorRGBA FLAG_TEXT_COLOR = ColorRGBA.Yellow;
    private boolean flagVisible = false;
    private float flagPoleHeight = 1.0f;
    private AssetManager assetManager = this.jme3Application.getAssetManager();
    private com.jme3.scene.Node pole = null;
    private Geometry poleGeometry = null;
    private com.jme3.scene.Node flag = null;
    private Geometry flagGeometry = null;
    private BillboardControl billboardControl;

    public ResultNodeJME3Object(ResultNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        Job job = new Job("ResultNodeJME3Object : Updating Geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                ResultNodeJME3Object.this.updateGeometry();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.poleGeometry != null) {
            geometries.add(this.poleGeometry);
        }
        if (this.flagGeometry != null) {
            geometries.add(this.flagGeometry);
        }
        geometries.addAll(super.getGeometries());
        return geometries;
    }

    public void dispose() {
        if (this.billboardControl != null) {
            this.billboardControl.setEnabled(false);
            this.billboardControl.setSpatial(null);
        }
        if (this.pole != null) {
            this.pole.detachAllChildren();
            if (this.pole.getParent() != null) {
                this.pole.getParent().detachChild((Spatial)this.pole);
            }
        }
        super.dispose();
    }

    public void setFlagPoleHeight(float poleHeight) {
        Logger.info("Setting Flag Pole Height to <" + poleHeight + ">.");
        if (poleHeight > 0.0f) {
            this.flagPoleHeight = poleHeight;
            this.updateGeometry();
        }
    }

    public float getFlagPoleHeight() {
        return this.flagPoleHeight;
    }

    public void setFlagVisible(boolean visible) {
        Logger.info("Setting Flag Visible to <" + visible + ">.");
        this.flagVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ResultNodeJME3Object.this.flagVisible) {
                    if (ResultNodeJME3Object.this.pole != null && !ResultNodeJME3Object.this.getAttachmentNode().getChildren().contains(ResultNodeJME3Object.this.pole)) {
                        ResultNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)ResultNodeJME3Object.this.pole);
                    }
                } else if (ResultNodeJME3Object.this.pole != null) {
                    ResultNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)ResultNodeJME3Object.this.pole);
                }
                return null;
            }
        });
    }

    public boolean isFlagVisible() {
        return this.flagVisible;
    }

    private void updateGeometry() {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ResultNodeJME3Object.this.pole != null) {
                    ResultNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)ResultNodeJME3Object.this.pole);
                }
                if (ResultNodeJME3Object.this.flag != null) {
                    ResultNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)ResultNodeJME3Object.this.flag);
                }
                ResultNodeJME3Object.this.getBillboardControl().setSpatial(null);
                ResultNodeJME3Object.this.pole = ResultNodeJME3Object.this.createPole(ResultNodeJME3Object.this.flagPoleHeight);
                if (ResultNodeJME3Object.this.flagVisible) {
                    ResultNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)ResultNodeJME3Object.this.pole);
                }
                ResultNodeJME3Object.this.flag = ResultNodeJME3Object.this.createFlag(ResultNodeJME3Object.this.getFlagText(), 16);
                ResultNodeJME3Object.this.pole.attachChild((Spatial)ResultNodeJME3Object.this.flag);
                return null;
            }
        });
    }

    private com.jme3.scene.Node createPole(float poleHeight) {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        Vector3f p0 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f p1 = new Vector3f(0.0f, 0.0f, poleHeight);
        verticesList.add(p0);
        verticesList.add(p1);
        indexesList.add(verticesList.indexOf(p0));
        indexesList.add(verticesList.indexOf(p1));
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        this.poleGeometry = new Geometry("Pole", mesh);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", FLAG_POLE_COLOR.clone());
        this.poleGeometry.setMaterial(mat);
        com.jme3.scene.Node node = new com.jme3.scene.Node("Pole.");
        node.setShadowMode(RenderQueue.ShadowMode.Off);
        node.attachChild((Spatial)this.poleGeometry);
        return node;
    }

    private String getFlagText() {
        String text = "?";
        if (this.getTopologyNode() != null) {
            if (((ResultNode)this.getTopologyNode()).getDescription() != null) {
                text = ((ResultNode)this.getTopologyNode()).getDescription();
            } else if (((ResultNode)this.getTopologyNode()).getResult() != null && ((ResultNode)this.getTopologyNode()).getResult().getTime() != null) {
                text = ((ResultNode)this.getTopologyNode()).getResult().getTime().toString();
            }
        }
        return text;
    }

    private com.jme3.scene.Node createFlag(String text, int fontSize) {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Flag");
        node.setShadowMode(RenderQueue.ShadowMode.Off);
        com.jme3.scene.Node flagAttachmentPoint = new com.jme3.scene.Node("Flag Attachment Point");
        flagAttachmentPoint.setLocalTranslation(0.0f, 0.0f, this.flagPoleHeight);
        node.attachChild((Spatial)flagAttachmentPoint);
        Font font = new Font("Serif", 1, fontSize);
        BufferedImage bufferedImage = this.createTextImage(text, font, 2);
        float flagWidth = 0.005f * (float)bufferedImage.getWidth();
        float flagHeight = 0.005f * (float)bufferedImage.getHeight();
        Mesh flagMesh = this.createFlagMesh(flagWidth, flagHeight);
        this.flagGeometry = new Geometry("Flag Geometry", flagMesh);
        Material mat = JME3Utilities.createMaterial((BufferedImage)bufferedImage, (AssetManager)this.assetManager);
        this.flagGeometry.setMaterial(mat);
        flagAttachmentPoint.addControl((Control)this.getBillboardControl());
        flagAttachmentPoint.attachChild((Spatial)this.flagGeometry);
        return node;
    }

    private Mesh createFlagMesh(float flagWidth, float flagHeight) {
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(flagWidth, 0.0f, 0.0f), new Vector3f(0.0f, flagHeight, 0.0f), new Vector3f(flagWidth, flagHeight, 0.0f)};
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        int[] indexes = nArray;
        Vector2f[] texCoord = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])texCoord));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])indexes));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private BillboardControl getBillboardControl() {
        if (this.billboardControl == null) {
            this.billboardControl = new BillboardControl();
            this.billboardControl.setAlignment(BillboardControl.Alignment.Screen);
        }
        return this.billboardControl;
    }

    private boolean isResultHasError() {
        OperationCallResult operationCallResult;
        PositionedResult positionedResult;
        return this.getTopologyNode() != null && ((ResultNode)this.getTopologyNode()).getResult() instanceof PositionedResult && (positionedResult = ((ResultNode)this.getTopologyNode()).getResult()) instanceof OperationCallResult && (operationCallResult = (OperationCallResult)positionedResult).getExceptionContainer() != null && operationCallResult.getExceptionContainer().getException() != null;
    }

    private ColorRGBA getFlagBackgroundColor() {
        if (this.isResultHasError()) {
            return ColorRGBA.Red;
        }
        return ColorRGBA.Black;
    }

    private ColorRGBA getTextColor() {
        if (this.isResultHasError()) {
            return ColorRGBA.Black;
        }
        return ColorRGBA.Green;
    }

    private BufferedImage createTextImage(String text, Font font, int borderWidth) {
        Color textColor = JME3Utilities.convertToAWTColor((ColorRGBA)this.getTextColor());
        Color backgroundColor = JME3Utilities.convertToAWTColor((ColorRGBA)this.getFlagBackgroundColor());
        AbstractEImage original = EImagesUtilities.INSTANCE.createTextImage(text, font, textColor, backgroundColor, borderWidth);
        int[] borderColor = JME3Utilities.convertToColorIntRGBA((ColorRGBA)FLAG_POLE_COLOR);
        AbstractEImage imageWithBorder = EImagesUtilities.INSTANCE.addBorder(original, borderWidth, borderColor[0], borderColor[1], borderColor[2]);
        return imageWithBorder.asBufferedImage();
    }
}

