/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOfInterestsListsComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(FeatureOfInterestsListsComposite.class);
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNewFOIList;
    private final Button btnNewFOI;
    private final Button btnDelete;
    private final List<FeatureOfInterestList> featureOfInterestLists = new ArrayList<FeatureOfInterestList>();
    private ISelectionChangedListener treeViewerSelectionChangedListener;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public FeatureOfInterestsListsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new SessionFeatureOfInterestsContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNewFOIList = new Button(composite, 0);
        this.btnNewFOIList.setSize(74, 29);
        this.btnNewFOIList.setText("New FOI List");
        this.btnNewFOIList.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNewFOIList.setEnabled(true);
        this.btnNewFOIList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.btnNewFOI = new Button(composite, 0);
        this.btnNewFOI.setSize(74, 29);
        this.btnNewFOI.setText("New FOI");
        this.btnNewFOI.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNewFOI.setEnabled(false);
        this.btnNewFOI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<FeatureOfInterestList> foiListList;
                String deleteMessage = "";
                List<FeatureOfInterest> foiList = FeatureOfInterestsListsComposite.this.getSelectedFeatureOfInterests();
                if (!foiList.isEmpty()) {
                    Iterator<FeatureOfInterest> it = foiList.iterator();
                    while (it.hasNext()) {
                        FeatureOfInterest foi = it.next();
                        deleteMessage = String.valueOf(deleteMessage) + foi.getName();
                        if (!it.hasNext()) continue;
                        deleteMessage = String.valueOf(deleteMessage) + ", ";
                    }
                    MessageDialog dialog = new MessageDialog(null, "Delete the selected FOI", null, "Are you sure to delete these FOI: " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                    int result = dialog.open();
                    if (result == 0) {
                        for (FeatureOfInterest foi : foiList) {
                            try {
                                if (!(foi.eContainer() instanceof FeatureOfInterestList)) continue;
                                FeatureOfInterestList foiContainer = (FeatureOfInterestList)foi.eContainer();
                                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)foiContainer, (EStructuralFeature)ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, (Object)foi);
                            }
                            catch (Exception ex) {
                                Logger.error("Unable to delete the FOI <" + foi.getName() + ">.", (Throwable)ex);
                            }
                        }
                        if (!FeatureOfInterestsListsComposite.this.treeViewer.isBusy()) {
                            FeatureOfInterestsListsComposite.this.treeViewer.refresh();
                        }
                    }
                }
                if (!(foiListList = FeatureOfInterestsListsComposite.this.getSelectedFeatureOfInterestsList()).isEmpty()) {
                    Iterator<FeatureOfInterestList> it = foiListList.iterator();
                    while (it.hasNext()) {
                        FeatureOfInterestList foi = it.next();
                        deleteMessage = String.valueOf(deleteMessage) + foi.getName();
                        if (!it.hasNext()) continue;
                        deleteMessage = String.valueOf(deleteMessage) + ", ";
                    }
                    MessageDialog dialog = new MessageDialog(null, "Delete the selected FOI Lists", null, "Are you sure to delete these FOI Lists: " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                    int result = dialog.open();
                    if (result == 0) {
                        for (FeatureOfInterestList featureOfInterestList : foiListList) {
                            try {
                                EObject eContainer = featureOfInterestList.eContainer();
                                EStructuralFeature eFeature = featureOfInterestList.eContainingFeature();
                                if (eFeature.isMany()) {
                                    ApogyCommonTransactionFacade.INSTANCE.basicRemove(eContainer, eFeature, (Object)featureOfInterestList);
                                } else {
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet(eContainer, eFeature, null);
                                }
                                FeatureOfInterestsListsComposite.this.featureOfInterestLists.remove(featureOfInterestList);
                            }
                            catch (Exception ex) {
                                Logger.error("Unable to delete the FOI List <" + featureOfInterestList.getName() + ">.", (Throwable)ex);
                            }
                        }
                        if (!FeatureOfInterestsListsComposite.this.treeViewer.isBusy()) {
                            FeatureOfInterestsListsComposite.this.treeViewer.setInput((Object)FeatureOfInterestsListsComposite.this.featureOfInterestLists);
                            FeatureOfInterestsListsComposite.this.treeViewer.refresh();
                        }
                    }
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FeatureOfInterestsListsComposite.this.treeViewer.removeSelectionChangedListener(FeatureOfInterestsListsComposite.this.getTreeViewerSelectionChangedListener());
            }
        });
    }

    public void setFeatureOfInterestsLists(List<FeatureOfInterestList> featureOfInterestLists) {
        this.featureOfInterestLists.clear();
        if (featureOfInterestLists != null && !featureOfInterestLists.isEmpty()) {
            this.featureOfInterestLists.addAll(featureOfInterestLists);
        }
        this.treeViewer.removeSelectionChangedListener(this.getTreeViewerSelectionChangedListener());
        this.treeViewer.setInput(this.featureOfInterestLists);
        this.treeViewer.addSelectionChangedListener(this.getTreeViewerSelectionChangedListener());
    }

    public void setSelectedFeatureOfInterest(FeatureOfInterest selectedFOI) {
        if (selectedFOI != null && selectedFOI.eContainer() instanceof FeatureOfInterestList) {
            FeatureOfInterestList featureOfInterestList = (FeatureOfInterestList)selectedFOI.eContainer();
            Object[] objects = new Object[]{featureOfInterestList, selectedFOI};
            TreePath treePath = new TreePath(objects);
            TreeSelection treeSelection = new TreeSelection(treePath);
            this.treeViewer.setSelection((ISelection)treeSelection, true);
        }
    }

    protected void newSelection(TreeSelection selection) {
    }

    public FeatureOfInterest getSelectedFeatureOfInterest() {
        StructuredSelection structuredSelection;
        if (this.treeViewer.getSelection() instanceof StructuredSelection && (structuredSelection = (StructuredSelection)this.treeViewer.getSelection()).getFirstElement() instanceof FeatureOfInterest) {
            return (FeatureOfInterest)structuredSelection.getFirstElement();
        }
        return null;
    }

    public List<FeatureOfInterest> getSelectedFeatureOfInterests() {
        ArrayList<FeatureOfInterest> list = new ArrayList<FeatureOfInterest>();
        if (this.treeViewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)this.treeViewer.getSelection();
            List elements = structuredSelection.toList();
            for (Object object : elements) {
                if (!(object instanceof FeatureOfInterest)) continue;
                list.add((FeatureOfInterest)object);
            }
        }
        return list;
    }

    public List<FeatureOfInterestList> getSelectedFeatureOfInterestsList() {
        ArrayList<FeatureOfInterestList> list = new ArrayList<FeatureOfInterestList>();
        if (this.treeViewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)this.treeViewer.getSelection();
            List elements = structuredSelection.toList();
            for (Object object : elements) {
                if (!(object instanceof FeatureOfInterestList)) continue;
                list.add((FeatureOfInterestList)object);
            }
        }
        return list;
    }

    private ISelectionChangedListener getTreeViewerSelectionChangedListener() {
        if (this.treeViewerSelectionChangedListener == null) {
            this.treeViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TreeSelection treeSelection = (TreeSelection)event.getSelection();
                    if (treeSelection.getFirstElement() instanceof FeatureOfInterestList) {
                        FeatureOfInterestsListsComposite.this.btnNewFOI.setEnabled(true);
                    } else {
                        FeatureOfInterestsListsComposite.this.btnNewFOI.setEnabled(false);
                    }
                    if (treeSelection.isEmpty()) {
                        FeatureOfInterestsListsComposite.this.btnDelete.setEnabled(false);
                    } else {
                        FeatureOfInterestsListsComposite.this.btnDelete.setEnabled(true);
                    }
                    FeatureOfInterestsListsComposite.this.newSelection(treeSelection);
                }
            };
        }
        return this.treeViewerSelectionChangedListener;
    }

    private class SessionFeatureOfInterestsContentProvider
    implements ITreeContentProvider {
        private SessionFeatureOfInterestsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = null;
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return elements;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = null;
            if (parentElement instanceof FeatureOfInterestList) {
                FeatureOfInterestList featureOfInterestList = (FeatureOfInterestList)parentElement;
                children = featureOfInterestList.getFeaturesOfInterest().toArray();
            }
            return children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof FeatureOfInterestList) {
                FeatureOfInterestList featureOfInterestList = (FeatureOfInterestList)element;
                return !featureOfInterestList.getFeaturesOfInterest().isEmpty();
            }
            return false;
        }
    }
}

