/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.robotic_arm.ui.composites;

import org.eclipse.apogy.common.emf.ui.emfforms.composites.TypedElementSimpleUnitsComposite;
import org.eclipse.apogy.examples.robotic_arm.ApogyExamplesRoboticArmPackage;
import org.eclipse.apogy.examples.robotic_arm.MoveSpeedLevel;
import org.eclipse.apogy.examples.robotic_arm.RoboticArm;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoboticArmControlComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(RoboticArmControlComposite.class);
    private static final String DEGREE_SYM = "\u00b0";
    private static final String MOVING_STR = "Moving";
    private static final String STOPPED_STR = "Stopped";
    private static final String READY_STR = "Ready";
    private static final String NOT_READY_STR = "Not Ready";
    private DataBindingContext m_bindingContext;
    private RoboticArm roboticArm;
    private final Text txtInitialized;
    private final Text txtMoving;
    private final Text txtWristEditValue;
    private final Text txtTurretEditValue;
    private final Text txtShoulderEditValue;
    private final Text txtElbowEditValue;
    private final TypedElementSimpleUnitsComposite lblTurretValue;
    private final TypedElementSimpleUnitsComposite lblElbowValue;
    private final TypedElementSimpleUnitsComposite lblShoulderValue;
    private final TypedElementSimpleUnitsComposite lblWristValue;
    private final Button btnInitialized;
    private final Button btnStow;
    private final Button btnMoveTo;
    private final Combo cmbSpeedMode;

    public RoboticArmControlComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RoboticArmControlComposite.this.m_bindingContext.dispose();
            }
        });
        Group compositeStatus = new Group((Composite)this, 2048);
        compositeStatus.setText("Status");
        compositeStatus.setLayout((Layout)new GridLayout(2, true));
        this.txtInitialized = new Text((Composite)compositeStatus, 0x1080000);
        this.txtInitialized.setEditable(false);
        this.txtInitialized.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.txtMoving = new Text((Composite)compositeStatus, 0x1080000);
        this.txtMoving.setEditable(false);
        this.txtMoving.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.txtMoving.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RoboticArmControlComposite.this.txtMoving.getText().equals(RoboticArmControlComposite.MOVING_STR)) {
                    RoboticArmControlComposite.this.txtMoving.setBackground(Display.getCurrent().getSystemColor(5));
                } else if (RoboticArmControlComposite.this.txtMoving.getText().equals(RoboticArmControlComposite.STOPPED_STR)) {
                    RoboticArmControlComposite.this.txtMoving.setBackground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
        this.txtMoving.setText(STOPPED_STR);
        Group composite = new Group((Composite)this, 2048);
        composite.setText("High Level Commands");
        composite.setLayout((Layout)new GridLayout(3, false));
        this.btnInitialized = new Button((Composite)composite, 0);
        this.btnInitialized.setText("Initialize");
        this.btnInitialized.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RoboticArmControlComposite.this.roboticArm != null) {
                    InitJob initJob = new InitJob();
                    initJob.schedule();
                }
            }
        });
        this.btnInitialized.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        this.btnStow = new Button((Composite)composite, 0);
        this.btnStow.setText("Stow");
        this.btnStow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RoboticArmControlComposite.this.roboticArm != null) {
                    StowJob stowJob = new StowJob();
                    stowJob.schedule();
                }
            }
        });
        this.cmbSpeedMode = new Combo((Composite)composite, 8);
        this.cmbSpeedMode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbSpeedMode.add(MoveSpeedLevel.SLOW.getLiteral());
        this.cmbSpeedMode.add(MoveSpeedLevel.MEDIUM.getLiteral());
        this.cmbSpeedMode.add(MoveSpeedLevel.FAST.getLiteral());
        this.cmbSpeedMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RoboticArmControlComposite.this.roboticArm != null) {
                    String newSpeedMode = RoboticArmControlComposite.this.cmbSpeedMode.getText();
                    MoveSpeedLevel newSpeedLevel = MoveSpeedLevel.get((String)newSpeedMode);
                    SpeedModeJob speedJob = new SpeedModeJob(newSpeedLevel);
                    speedJob.schedule();
                }
            }
        });
        Group compositeJoints = new Group((Composite)this, 0);
        compositeJoints.setText("Joints");
        compositeJoints.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        compositeJoints.setLayout((Layout)new GridLayout(6, true));
        new Label((Composite)compositeJoints, 0);
        Label lblTurret = new Label((Composite)compositeJoints, 0);
        lblTurret.setText("Turret (\u00b0)");
        lblTurret.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        Label lblShoulder = new Label((Composite)compositeJoints, 0);
        lblShoulder.setText("Shoulder (\u00b0)");
        lblShoulder.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        Label lblElbow = new Label((Composite)compositeJoints, 0);
        lblElbow.setText("Elbow (\u00b0)");
        lblElbow.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        Label lblWrist = new Label((Composite)compositeJoints, 0);
        lblWrist.setText("Wrist (\u00b0)");
        lblWrist.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        Label lblNewLabel = new Label((Composite)compositeJoints, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblActuals = new Label((Composite)compositeJoints, 0);
        lblActuals.setText("Actuals");
        lblActuals.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblTurretValue = new TypedElementSimpleUnitsComposite((Composite)compositeJoints, 2048, false, true, "N/A");
        this.lblTurretValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblTurretValue.setBackground(Display.getCurrent().getSystemColor(5));
        this.lblShoulderValue = new TypedElementSimpleUnitsComposite((Composite)compositeJoints, 2048, false, true, "N/A");
        this.lblShoulderValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblShoulderValue.setBackground(Display.getCurrent().getSystemColor(5));
        this.lblElbowValue = new TypedElementSimpleUnitsComposite((Composite)compositeJoints, 2048, false, true, "N/A");
        this.lblElbowValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblElbowValue.setBackground(Display.getCurrent().getSystemColor(5));
        this.lblWristValue = new TypedElementSimpleUnitsComposite((Composite)compositeJoints, 2048, false, true, "N/A");
        this.lblWristValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblWristValue.setBackground(Display.getCurrent().getSystemColor(5));
        Button btnLoad = new Button((Composite)compositeJoints, 0);
        btnLoad.setText("Load");
        btnLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RoboticArmControlComposite.this.getRoboticArm() != null) {
                    RoboticArmControlComposite.this.txtTurretEditValue.setText(Double.toString(RoboticArmControlComposite.this.getRoboticArm().getTurretAngle()));
                    RoboticArmControlComposite.this.txtShoulderEditValue.setText(Double.toString(RoboticArmControlComposite.this.getRoboticArm().getShoulderAngle()));
                    RoboticArmControlComposite.this.txtElbowEditValue.setText(Double.toString(RoboticArmControlComposite.this.getRoboticArm().getElbowAngle()));
                    RoboticArmControlComposite.this.txtWristEditValue.setText(Double.toString(RoboticArmControlComposite.this.getRoboticArm().getWristAngle()));
                }
            }
        });
        btnLoad.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        Label lblCommanded = new Label((Composite)compositeJoints, 0);
        lblCommanded.setText("Commanded");
        lblCommanded.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtTurretEditValue = new Text((Composite)compositeJoints, 0x1000000);
        this.txtTurretEditValue.setText("0.0");
        this.txtTurretEditValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtTurretEditValue.addVerifyListener((VerifyListener)new AngleValueVerifyListener());
        this.txtShoulderEditValue = new Text((Composite)compositeJoints, 0x1000000);
        this.txtShoulderEditValue.setText("0.0");
        this.txtShoulderEditValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtShoulderEditValue.addVerifyListener((VerifyListener)new AngleValueVerifyListener());
        this.txtElbowEditValue = new Text((Composite)compositeJoints, 0x1000000);
        this.txtElbowEditValue.setText("0.0");
        this.txtElbowEditValue.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.txtElbowEditValue.addVerifyListener((VerifyListener)new AngleValueVerifyListener());
        this.txtWristEditValue = new Text((Composite)compositeJoints, 0x1000000);
        this.txtWristEditValue.setText("0.0");
        this.txtWristEditValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtWristEditValue.addVerifyListener((VerifyListener)new AngleValueVerifyListener());
        this.btnMoveTo = new Button((Composite)compositeJoints, 0);
        this.btnMoveTo.setText("MoveTo");
        this.btnMoveTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RoboticArmControlComposite.this.roboticArm != null) {
                    double turret = Math.toRadians(Double.parseDouble(RoboticArmControlComposite.this.txtTurretEditValue.getText()));
                    double shoulder = Math.toRadians(Double.parseDouble(RoboticArmControlComposite.this.txtShoulderEditValue.getText()));
                    double elbow = Math.toRadians(Double.parseDouble(RoboticArmControlComposite.this.txtElbowEditValue.getText()));
                    double wrist = Math.toRadians(Double.parseDouble(RoboticArmControlComposite.this.txtWristEditValue.getText()));
                    MoveToJob moveToJob = new MoveToJob(turret, shoulder, elbow, wrist);
                    moveToJob.schedule();
                }
            }
        });
        this.btnMoveTo.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.txtInitialized.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RoboticArmControlComposite.this.txtInitialized.getText().equals(RoboticArmControlComposite.READY_STR)) {
                    RoboticArmControlComposite.this.txtInitialized.setBackground(Display.getCurrent().getSystemColor(5));
                    RoboticArmControlComposite.this.btnInitialized.setEnabled(false);
                    RoboticArmControlComposite.this.btnStow.setEnabled(true);
                    RoboticArmControlComposite.this.btnMoveTo.setEnabled(true);
                    RoboticArmControlComposite.this.cmbSpeedMode.setEnabled(true);
                } else if (RoboticArmControlComposite.this.txtInitialized.getText().equals(RoboticArmControlComposite.NOT_READY_STR)) {
                    RoboticArmControlComposite.this.txtInitialized.setBackground(Display.getCurrent().getSystemColor(3));
                    RoboticArmControlComposite.this.btnInitialized.setEnabled(true);
                    RoboticArmControlComposite.this.btnStow.setEnabled(false);
                    RoboticArmControlComposite.this.btnMoveTo.setEnabled(false);
                    RoboticArmControlComposite.this.cmbSpeedMode.setEnabled(false);
                }
            }
        });
        this.txtInitialized.setText(NOT_READY_STR);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RoboticArmControlComposite.this.m_bindingContext != null) {
                    RoboticArmControlComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public void setRoboticArm(RoboticArm newRoboticArm) {
        this.roboticArm = newRoboticArm;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        if (newRoboticArm != null && !this.isDisposed()) {
            this.m_bindingContext = this.initDataBindings();
        }
    }

    public RoboticArm getRoboticArm() {
        return this.roboticArm;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        this.m_bindingContext = new DataBindingContext();
        try {
            this.lblTurretValue.setTypedElement((EStructuralFeature)ApogyExamplesRoboticArmPackage.Literals.ROBOTIC_ARM__TURRET_ANGLE, (EObject)this.getRoboticArm());
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        try {
            this.lblShoulderValue.setTypedElement((EStructuralFeature)ApogyExamplesRoboticArmPackage.Literals.ROBOTIC_ARM__SHOULDER_ANGLE, (EObject)this.getRoboticArm());
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        try {
            this.lblElbowValue.setTypedElement((EStructuralFeature)ApogyExamplesRoboticArmPackage.Literals.ROBOTIC_ARM__ELBOW_ANGLE, (EObject)this.getRoboticArm());
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        try {
            this.lblWristValue.setTypedElement((EStructuralFeature)ApogyExamplesRoboticArmPackage.Literals.ROBOTIC_ARM__WRIST_ANGLE, (EObject)this.getRoboticArm());
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        IObservableValue observeInitializedValue = EMFProperties.value((EStructuralFeature)ApogyExamplesRoboticArmPackage.Literals.ROBOTIC_ARM__INITIALIZED).observe((Object)this.getRoboticArm());
        ISWTObservableValue observeBtnStowEnable = WidgetProperties.enabled().observe((Widget)this.btnStow);
        bindingContext.bindValue((IObservableValue)observeBtnStowEnable, observeInitializedValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
        ISWTObservableValue observeCmbSpeedModeEnable = WidgetProperties.enabled().observe((Widget)this.cmbSpeedMode);
        bindingContext.bindValue((IObservableValue)observeCmbSpeedModeEnable, observeInitializedValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
        ISWTObservableValue observeBtnMoveToEnable = WidgetProperties.enabled().observe((Widget)this.btnMoveTo);
        bindingContext.bindValue((IObservableValue)observeBtnMoveToEnable, observeInitializedValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
        ISWTObservableValue observeTextTxtMovingObserveWidget = WidgetProperties.text().observe((Widget)this.txtMoving);
        IObservableValue roboticArmArmMovingObserveValue = EMFProperties.value((EStructuralFeature)ApogyExamplesRoboticArmPackage.Literals.ROBOTIC_ARM__ARM_MOVING).observe((Object)this.getRoboticArm());
        this.m_bindingContext.bindValue((IObservableValue)observeTextTxtMovingObserveWidget, roboticArmArmMovingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Boolean.TYPE, String.class){

            public Object convert(Object arg0) {
                return (Boolean)arg0 != false ? RoboticArmControlComposite.MOVING_STR : RoboticArmControlComposite.STOPPED_STR;
            }
        }));
        ISWTObservableValue observeTxtInitializedEnabled = WidgetProperties.enabled().observe((Widget)this.txtInitialized);
        bindingContext.bindValue((IObservableValue)observeTxtInitializedEnabled, observeInitializedValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
        ISWTObservableValue observeTxtInitializedObserveWidget = WidgetProperties.text().observe((Widget)this.txtInitialized);
        this.m_bindingContext.bindValue((IObservableValue)observeTxtInitializedObserveWidget, observeInitializedValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Boolean.TYPE, String.class){

            public Object convert(Object arg0) {
                return (Boolean)arg0 != false ? RoboticArmControlComposite.READY_STR : RoboticArmControlComposite.NOT_READY_STR;
            }
        }));
        ISWTObservableValue observeTextCmdMoveSpeedObserveWidget = WidgetProperties.singleSelectionIndex().observe((Widget)this.cmbSpeedMode);
        IObservableValue roboticArmMoveSpeedObserveValue = EMFProperties.value((EStructuralFeature)ApogyExamplesRoboticArmPackage.Literals.ROBOTIC_ARM__SPEED).observe((Object)this.getRoboticArm());
        this.m_bindingContext.bindValue((IObservableValue)observeTextCmdMoveSpeedObserveWidget, roboticArmMoveSpeedObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(MoveSpeedLevel.class, Integer.class){

            public Object convert(Object obj) {
                String literal = ((MoveSpeedLevel)obj).getLiteral();
                int index = 0;
                while (index < RoboticArmControlComposite.this.cmbSpeedMode.getItemCount()) {
                    if (literal.equals(RoboticArmControlComposite.this.cmbSpeedMode.getItems()[index])) {
                        return new Integer(index);
                    }
                    ++index;
                }
                return new Integer(-1);
            }
        }));
        return bindingContext;
    }

    private class AngleValueVerifyListener
    implements VerifyListener {
        private AngleValueVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            String oldText = ((Text)e.widget).getText();
            String newText = String.valueOf(oldText.substring(0, e.start)) + e.text + oldText.substring(e.end);
            try {
                Double.parseDouble(newText);
            }
            catch (NumberFormatException ex) {
                e.text = "";
                e.doit = false;
            }
        }
    }

    public class InitJob
    extends Job {
        public InitJob() {
            super("Robotic Arm - Initialize");
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor arg0) {
            try {
                RoboticArmControlComposite.this.roboticArm.init();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }

    private class MoveToJob
    extends Job {
        private final double turretValue;
        private final double shoulderValue;
        private final double elbowValue;
        private final double wristValue;

        public MoveToJob(double turret, double shoulder, double elbow, double wrist) {
            super("Robotic Arm - Move To");
            this.turretValue = turret;
            this.shoulderValue = shoulder;
            this.elbowValue = elbow;
            this.wristValue = wrist;
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                RoboticArmControlComposite.this.roboticArm.moveTo(this.turretValue, this.shoulderValue, this.elbowValue, this.wristValue);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }

    private class SpeedModeJob
    extends Job {
        private final MoveSpeedLevel speedModeLevel;

        public SpeedModeJob(MoveSpeedLevel level) {
            super("Robotic Arm - Speed Mode Change");
            this.speedModeLevel = level;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor arg0) {
            try {
                RoboticArmControlComposite.this.roboticArm.cmdMoveSpeedLevel(this.speedModeLevel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }

    public class StowJob
    extends Job {
        public StowJob() {
            super("Robotic Arm - Stow");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor arg0) {
            try {
                RoboticArmControlComposite.this.roboticArm.stow();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }
}

