/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.addons.geometry.paths.SplineEndControlPointGenerationMode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SplinesUtilities {
    public static final int AUTO_CTRL_POINTS_NONE = 0;
    public static final int AUTO_CTRL_POINTS_DUPLICATE_ENDNODES = 1;
    public static final int AUTO_CTRL_POINTS_REFLECTION = 2;
    public static final int AUTO_CTRL_POINTS_CLOSE_LOOPS = 3;
    private static SortedMap<Integer, SortedMap<Double, Double>> segmentsArcLengths;
    private static double[] segmentChordLength;

    public static List<Point3d> generateCatMullSplineUniformParam(List<Point3d> controlPoints, double nbrOfPointsBetweenEachCtrlPts, SplineEndControlPointGenerationMode splineEndControlPointGenerationMode, double tension, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        ArrayList<Point3d> catMullRomPoints = new ArrayList<Point3d>();
        List<Object> modifiedControlPoints = new ArrayList();
        try {
            modifiedControlPoints = SplinesUtilities.generateExtraControlPoints(controlPoints, splineEndControlPointGenerationMode);
            int nbrOfSegments = modifiedControlPoints.size() - 3;
            if (nbrOfPointsBetweenEachCtrlPts < 0.0) {
                nbrOfPointsBetweenEachCtrlPts = 0.0;
            }
            internalMonitor.beginTask(String.valueOf(SplinesUtilities.class.getSimpleName()) + ".generateCatMullSplineUniformParam() : Generating points...", (int)Math.round(nbrOfPointsBetweenEachCtrlPts) * (modifiedControlPoints.size() - 3));
            int i = 0;
            while (i < nbrOfSegments) {
                Point3d p0 = (Point3d)modifiedControlPoints.get(i);
                Point3d p1 = (Point3d)modifiedControlPoints.get(i + 1);
                Point3d p2 = (Point3d)modifiedControlPoints.get(i + 2);
                Point3d p3 = (Point3d)modifiedControlPoints.get(i + 3);
                int j = 0;
                while ((double)j < nbrOfPointsBetweenEachCtrlPts + 1.0) {
                    double t = nbrOfPointsBetweenEachCtrlPts >= 1.0 ? (double)j / (nbrOfPointsBetweenEachCtrlPts + 1.0) : 0.0;
                    Point3d curveCurveDot = SplinesUtilities.curvePositionCatmull(t, p0, p1, p2, p3, tension);
                    catMullRomPoints.add(curveCurveDot);
                    internalMonitor.worked(1);
                    ++j;
                }
                if (i == nbrOfSegments - 1) {
                    catMullRomPoints.add(SplinesUtilities.curvePositionCatmull(1.0, p0, p1, p2, p3, tension));
                }
                ++i;
            }
        }
        finally {
            internalMonitor.done();
        }
        return catMullRomPoints;
    }

    public static List<Point3d> generateCatMullSplineChordLengthParam(List<Point3d> controlPoints, int nbrOfPointsOnSpline, SplineEndControlPointGenerationMode splineEndControlPointGenerationMode, double tension, IProgressMonitor monitor) {
        ArrayList<Point3d> catMullRomPoints = new ArrayList<Point3d>();
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        try {
            int nbrOfSegments;
            List<Object> modifiedControlPoints = new ArrayList();
            double totalChordLength = 0.0;
            modifiedControlPoints = SplinesUtilities.generateExtraControlPoints(controlPoints, splineEndControlPointGenerationMode);
            if (nbrOfPointsOnSpline < 0) {
                nbrOfPointsOnSpline = 0;
            }
            if ((nbrOfSegments = modifiedControlPoints.size() - 3) < 0) {
                nbrOfSegments = 0;
            }
            int intermediatePointsTotal = nbrOfPointsOnSpline;
            double[] segmentChordLength = SplinesUtilities.getEachSegmentsChordLength(modifiedControlPoints);
            totalChordLength = SplinesUtilities.getTotalChordLength(segmentChordLength);
            internalMonitor.beginTask(String.valueOf(SplinesUtilities.class.getSimpleName()) + ".generateCatMullSplineChordLengthParam() : Generating points...", nbrOfPointsOnSpline);
            int i = 0;
            while (i < nbrOfSegments) {
                int nbrPointsSegment = (int)Math.round((double)intermediatePointsTotal * (segmentChordLength[i] / totalChordLength));
                Point3d p0 = (Point3d)modifiedControlPoints.get(i);
                Point3d p1 = (Point3d)modifiedControlPoints.get(i + 1);
                Point3d p2 = (Point3d)modifiedControlPoints.get(i + 2);
                Point3d p3 = (Point3d)modifiedControlPoints.get(i + 3);
                int j = 0;
                while (j < nbrPointsSegment + 1) {
                    double t = nbrPointsSegment >= 1 ? (double)j / (double)(nbrPointsSegment + 1) : 0.0;
                    Point3d curveCurveDot = SplinesUtilities.curvePositionCatmull(t, p0, p1, p2, p3, tension);
                    catMullRomPoints.add(curveCurveDot);
                    ++j;
                }
                if (i == nbrOfSegments - 1) {
                    catMullRomPoints.add(SplinesUtilities.curvePositionCatmull(1.0, p0, p1, p2, p3, tension));
                }
                internalMonitor.worked(1);
                ++i;
            }
        }
        finally {
            internalMonitor.done();
        }
        return catMullRomPoints;
    }

    public static List<Point3d> generateCatMullSplineArcLengthParam(List<Point3d> controlPoints, double distanceBetweenSplinePoints, SplineEndControlPointGenerationMode splineEndControlPointGenerationMode, double tension, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        ArrayList<Point3d> catMullRomPoints = new ArrayList<Point3d>();
        ArrayList<Point3d> modifiedControlPoints = new ArrayList();
        try {
            if (distanceBetweenSplinePoints <= 0.0) {
                ArrayList<Point3d> arrayList = catMullRomPoints;
                return arrayList;
            }
            modifiedControlPoints = SplinesUtilities.generateExtraControlPoints(controlPoints, splineEndControlPointGenerationMode);
            SplinesUtilities.createCTMRArcLengthTable(modifiedControlPoints, tension, distanceBetweenSplinePoints);
            double distance = 0.0;
            double distanceRemaining = 0.0;
            int nbrOfSegments = segmentChordLength.length;
            internalMonitor.beginTask(String.valueOf(SplinesUtilities.class.getSimpleName()) + ".generateCatMullSplineArcLengthParam() : Generating points...", nbrOfSegments);
            int i = 0;
            while (i < nbrOfSegments) {
                Point3d p0 = (Point3d)modifiedControlPoints.get(i);
                Point3d p1 = (Point3d)modifiedControlPoints.get(i + 1);
                Point3d p2 = (Point3d)modifiedControlPoints.get(i + 2);
                Point3d p3 = (Point3d)modifiedControlPoints.get(i + 3);
                double arcLength = 0.0;
                SortedMap segmentArcLengthAndT = (SortedMap)segmentsArcLengths.get(i);
                arcLength = (Double)segmentArcLengthAndT.lastKey();
                distance = 0.0 + distanceRemaining;
                do {
                    double t = SplinesUtilities.findAssociatedTvalue(i, distance);
                    Point3d curveCurveDot = SplinesUtilities.curvePositionCatmull(t, p0, p1, p2, p3, tension);
                    catMullRomPoints.add(curveCurveDot);
                } while ((distanceRemaining = (distance += distanceBetweenSplinePoints) - arcLength) <= 0.0);
                internalMonitor.worked(1);
                ++i;
            }
        }
        finally {
            internalMonitor.done();
        }
        return catMullRomPoints;
    }

    public static List<Point3d> generateCatMullSplineDegreeParam(List<Point3d> controlPoints, double degreeBetweenSplinePoints, SplineEndControlPointGenerationMode splineEndControlPointGenerationMode, double tension, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        ArrayList<Point3d> catMullRomPoints = new ArrayList<Point3d>();
        List<Object> modifiedControlPoints = new ArrayList();
        try {
            if (degreeBetweenSplinePoints == 0.0) {
                ArrayList<Point3d> arrayList = catMullRomPoints;
                return arrayList;
            }
            modifiedControlPoints = SplinesUtilities.generateExtraControlPoints(controlPoints, splineEndControlPointGenerationMode);
            double tStepValue = 0.01;
            int numberOfStep = (int)Math.ceil(1.0 / tStepValue) + 1;
            int nbrOfSegment = modifiedControlPoints.size() - 3;
            double lastDegree = 0.0;
            Point3d position = null;
            internalMonitor.beginTask(String.valueOf(SplinesUtilities.class.getSimpleName()) + ".generateCatMullSplineDegreeParam() : Generating points...", nbrOfSegment);
            int i = 0;
            while (i < nbrOfSegment) {
                Point3d p0 = (Point3d)modifiedControlPoints.get(i);
                Point3d p1 = (Point3d)modifiedControlPoints.get(i + 1);
                Point3d p2 = (Point3d)modifiedControlPoints.get(i + 2);
                Point3d p3 = (Point3d)modifiedControlPoints.get(i + 3);
                double t = 0.0;
                Point3d lastPosition = SplinesUtilities.curvePositionCatmull(t, p0, p1, p2, p3, tension);
                int j = 0;
                while (j < numberOfStep) {
                    position = SplinesUtilities.curvePositionCatmull(t += tStepValue, p0, p1, p2, p3, tension);
                    Point3d speed = SplinesUtilities.curveSpeedCatmull(t, p0, p1, p2, p3, tension);
                    double degree = Math.toDegrees(Math.atan2(speed.y, speed.x));
                    if (Math.abs(lastDegree - degree) >= degreeBetweenSplinePoints) {
                        catMullRomPoints.add(position);
                        lastDegree = degree;
                    }
                    ++j;
                }
                if (i == nbrOfSegment - 1) {
                    catMullRomPoints.add(position);
                }
                internalMonitor.worked(1);
                ++i;
            }
        }
        finally {
            internalMonitor.done();
        }
        return catMullRomPoints;
    }

    public static List<Point3d> generateBezierSplineUniformParam(Point3d p1, Point3d c1, Point3d c2, Point3d p2, double nbrOfPoints, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        ArrayList<Point3d> bezierPoints = new ArrayList<Point3d>();
        ArrayList controlPoints = new ArrayList();
        try {
            if (p1 == null || c1 == null || c2 == null || p2 == null) {
                ArrayList<Point3d> arrayList = bezierPoints;
                return arrayList;
            }
            if (nbrOfPoints < 0.0) {
                nbrOfPoints = 0.0;
            }
            internalMonitor.beginTask(String.valueOf(SplinesUtilities.class.getSimpleName()) + ".generateBezierSplineUniformParam() : Generating points...", (int)Math.round(nbrOfPoints));
            int j = 0;
            while ((double)j < nbrOfPoints + 1.0) {
                double t = nbrOfPoints >= 1.0 ? (double)j / (nbrOfPoints + 1.0) : 0.0;
                Point3d curveCurveDot = SplinesUtilities.curvePositionBezier(t, p1, c1, c2, p2);
                bezierPoints.add(curveCurveDot);
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++j;
            }
            bezierPoints.add(SplinesUtilities.curvePositionBezier(1.0, p1, c1, c2, p2));
        }
        finally {
            internalMonitor.done();
        }
        return bezierPoints;
    }

    public static List<Point3d> generateBezierSplineDegreeParam(Point3d point1, Point3d ctrl1, Point3d ctrl2, Point3d point2, double degreeBetweenSplinePoints, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        ArrayList<Point3d> bezierPoints = new ArrayList<Point3d>();
        try {
            if (point1 == null || ctrl1 == null || ctrl2 == null || point2 == null) {
                ArrayList<Point3d> arrayList = bezierPoints;
                return arrayList;
            }
            if (degreeBetweenSplinePoints == 0.0) {
                ArrayList<Point3d> arrayList = bezierPoints;
                return arrayList;
            }
            double tStepValue = 0.01;
            int numberOfStep = (int)Math.ceil(1.0 / tStepValue) + 1;
            double lastDegree = 0.0;
            Point3d position = null;
            double t = 0.0;
            Point3d lastPosition = SplinesUtilities.curvePositionBezier(t, point1, ctrl1, ctrl2, point2);
            internalMonitor.beginTask(String.valueOf(SplinesUtilities.class.getSimpleName()) + ".generateBezierSplineDegreeParam() : Generating points...", numberOfStep);
            int j = 0;
            while (j < numberOfStep) {
                position = SplinesUtilities.curvePositionBezier(t, point1, ctrl1, ctrl2, point2);
                Point3d speed = SplinesUtilities.curveSpeedBezier(t, point1, ctrl1, ctrl2, point2);
                double degree = Math.toDegrees(Math.atan2(speed.y, speed.x));
                if (Math.abs(lastDegree - degree) >= degreeBetweenSplinePoints || j == 0) {
                    bezierPoints.add(position);
                    lastDegree = degree;
                }
                t += tStepValue;
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++j;
            }
            bezierPoints.add(position);
        }
        finally {
            internalMonitor.done();
        }
        return bezierPoints;
    }

    public static List<Point3d> generateBezierSplineArcLengthParam(Point3d point1, Point3d ctrl1, Point3d ctrl2, Point3d point2, double distanceBetweenSplinePoints, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        ArrayList<Point3d> bezierPoints = new ArrayList<Point3d>();
        try {
            if (point1 == null || ctrl1 == null || ctrl2 == null || point2 == null) {
                ArrayList<Point3d> arrayList = bezierPoints;
                return arrayList;
            }
            if (distanceBetweenSplinePoints <= 0.0) {
                ArrayList<Point3d> arrayList = bezierPoints;
                return arrayList;
            }
            ArrayList<Point3d> ctrlPoints = new ArrayList<Point3d>();
            ctrlPoints.add(point1);
            ctrlPoints.add(ctrl1);
            ctrlPoints.add(ctrl2);
            ctrlPoints.add(point2);
            SplinesUtilities.createBezierArcLengthTable(ctrlPoints, distanceBetweenSplinePoints);
            double distance = 0.0;
            double distanceRemaining = 0.0;
            int nbrOfSegments = segmentChordLength.length;
            internalMonitor.beginTask(String.valueOf(SplinesUtilities.class.getSimpleName()) + ".generateBezierSplineArcLengthParam() : Generating points...", nbrOfSegments);
            int i = 0;
            while (i < nbrOfSegments) {
                Point3d p1 = (Point3d)ctrlPoints.get(i * 3);
                Point3d c1 = (Point3d)ctrlPoints.get(i * 3 + 1);
                Point3d c2 = (Point3d)ctrlPoints.get(i * 3 + 2);
                Point3d p2 = (Point3d)ctrlPoints.get(i * 3 + 3);
                double arcLength = 0.0;
                SortedMap segmentArcLengthAndT = (SortedMap)segmentsArcLengths.get(i);
                arcLength = (Double)segmentArcLengthAndT.lastKey();
                distance = 0.0 + distanceRemaining;
                do {
                    double t = SplinesUtilities.findAssociatedTvalue(i, distance);
                    Point3d curveCurveDot = SplinesUtilities.curvePositionBezier(t, p1, c1, c2, p2);
                    bezierPoints.add(curveCurveDot);
                } while ((distanceRemaining = (distance += distanceBetweenSplinePoints) - arcLength) <= 0.0);
                internalMonitor.worked(1);
                ++i;
            }
        }
        finally {
            internalMonitor.done();
        }
        return bezierPoints;
    }

    private static List<Point3d> generateExtraControlPoints(List<Point3d> controlPoints, SplineEndControlPointGenerationMode splineEndControlPointGenerationMode) {
        if (controlPoints == null) {
            return new ArrayList<Point3d>();
        }
        if (controlPoints.size() < 2) {
            return controlPoints;
        }
        ArrayList<Point3d> modifiedControlPoints = new ArrayList<Point3d>();
        modifiedControlPoints.addAll(controlPoints);
        if (splineEndControlPointGenerationMode == SplineEndControlPointGenerationMode.AUTO_CTRL_POINTS_DUPLICATE_ENDNODES) {
            modifiedControlPoints.add(0, (Point3d)((Point3d)modifiedControlPoints.get(0)).clone());
            modifiedControlPoints.add((Point3d)((Point3d)modifiedControlPoints.get(modifiedControlPoints.size() - 1)).clone());
        }
        if (splineEndControlPointGenerationMode == SplineEndControlPointGenerationMode.AUTO_CTRL_POINTS_REFLECTION) {
            double x = 2.0 * (((Point3d)modifiedControlPoints.get((int)0)).x - ((Point3d)modifiedControlPoints.get((int)1)).x);
            double y = 2.0 * (((Point3d)modifiedControlPoints.get((int)0)).y - ((Point3d)modifiedControlPoints.get((int)1)).y);
            double z = 2.0 * (((Point3d)modifiedControlPoints.get((int)0)).z - ((Point3d)modifiedControlPoints.get((int)1)).z);
            modifiedControlPoints.add(0, new Point3d(x, y, z));
            int last = controlPoints.size() - 1;
            x = 2.0 * (((Point3d)modifiedControlPoints.get((int)last)).x - ((Point3d)modifiedControlPoints.get((int)(last - 1))).x);
            y = 2.0 * (((Point3d)modifiedControlPoints.get((int)last)).y - ((Point3d)modifiedControlPoints.get((int)(last - 1))).y);
            z = 2.0 * (((Point3d)modifiedControlPoints.get((int)last)).z - ((Point3d)modifiedControlPoints.get((int)(last - 1))).z);
            modifiedControlPoints.add(new Point3d(x, y, z));
        }
        if (splineEndControlPointGenerationMode == SplineEndControlPointGenerationMode.AUTO_CTRL_POINTS_CLOSE_LOOPS) {
            double distance = controlPoints.get(1).distance(controlPoints.get(0));
            int lastCtrlPointIndex = controlPoints.size() - 1;
            double dX = controlPoints.get((int)lastCtrlPointIndex).x - controlPoints.get((int)(lastCtrlPointIndex - 1)).x;
            double dY = controlPoints.get((int)lastCtrlPointIndex).y - controlPoints.get((int)(lastCtrlPointIndex - 1)).y;
            double theta = Math.atan2(dY, dX);
            double newDX = -distance * Math.cos(theta);
            double newDY = -distance * Math.sin(theta);
            Point3d firstAuxCtrlPts = new Point3d(newDX + controlPoints.get((int)0).x, newDY + controlPoints.get((int)0).y, 0.0);
            modifiedControlPoints.add(0, firstAuxCtrlPts);
            lastCtrlPointIndex = controlPoints.size() - 1;
            distance = controlPoints.get(lastCtrlPointIndex).distance(controlPoints.get(lastCtrlPointIndex - 1));
            dX = controlPoints.get((int)1).x - controlPoints.get((int)0).x;
            dY = controlPoints.get((int)1).y - controlPoints.get((int)0).y;
            theta = Math.atan2(dY, dX);
            newDX = distance * Math.cos(theta);
            newDY = distance * Math.sin(theta);
            Point3d lastAuxCtrlPts = new Point3d(newDX + controlPoints.get((int)lastCtrlPointIndex).x, newDY + controlPoints.get((int)lastCtrlPointIndex).y, 0.0);
            modifiedControlPoints.add(lastAuxCtrlPts);
            lastCtrlPointIndex = modifiedControlPoints.size() - 1;
        }
        return modifiedControlPoints;
    }

    private static void createCTMRArcLengthTable(List<Point3d> controlPoints, double tension, double maximumDistanceBetweenPoints) {
        segmentChordLength = SplinesUtilities.getEachSegmentsChordLength(controlPoints);
        int nbrOfSegments = segmentChordLength.length;
        double chordLength = SplinesUtilities.getTotalChordLength(segmentChordLength);
        double tStepValue = maximumDistanceBetweenPoints / chordLength * (double)nbrOfSegments / 4.0;
        int numberOfStep = (int)Math.ceil(1.0 / tStepValue) + 1;
        segmentsArcLengths = new TreeMap<Integer, SortedMap<Double, Double>>();
        int i = 0;
        while (i < nbrOfSegments) {
            int ctrlPtsIndex = i;
            Point3d lastPoint = null;
            TreeMap<Double, Double> arcLengthUDistanceMap = new TreeMap<Double, Double>();
            double t = 0.0;
            double segmentArcLength = 0.0;
            int j = 0;
            while (j < numberOfStep) {
                Point3d p1 = SplinesUtilities.curvePositionCatmull(t, controlPoints.get(ctrlPtsIndex), controlPoints.get(ctrlPtsIndex + 1), controlPoints.get(ctrlPtsIndex + 2), controlPoints.get(ctrlPtsIndex + 3), tension);
                if (lastPoint == null) {
                    arcLengthUDistanceMap.put(new Double(0.0), new Double(0.0));
                } else {
                    double distance = p1.distance(lastPoint);
                    segmentArcLength = distance + segmentArcLength;
                    arcLengthUDistanceMap.put(segmentArcLength, t);
                }
                lastPoint = (Point3d)p1.clone();
                t += tStepValue;
                if (t > 1.0) {
                    t = 1.0;
                }
                ++j;
            }
            segmentsArcLengths.put(i, arcLengthUDistanceMap);
            ++i;
        }
    }

    private static void createBezierArcLengthTable(List<Point3d> controlPoints, double maximumDistanceBetweenPoints) {
        Point3d p1;
        int nbrOfSegments = (controlPoints.size() - 1) / 3;
        segmentChordLength = new double[nbrOfSegments];
        int i = 0;
        while (i < nbrOfSegments) {
            p1 = controlPoints.get(i * 3);
            Point3d p2 = controlPoints.get(i * 3 + 3);
            SplinesUtilities.segmentChordLength[i] = p1.distance(p2);
            ++i;
        }
        double chordLength = SplinesUtilities.getTotalChordLength(segmentChordLength);
        double tStepValue = maximumDistanceBetweenPoints / chordLength * (double)nbrOfSegments / 4.0;
        int numberOfStep = (int)Math.ceil(1.0 / tStepValue) + 1;
        segmentsArcLengths = new TreeMap<Integer, SortedMap<Double, Double>>();
        i = 0;
        while (i < nbrOfSegments) {
            p1 = controlPoints.get(i * 3);
            Point3d c1 = controlPoints.get(i * 3 + 1);
            Point3d c2 = controlPoints.get(i * 3 + 2);
            Point3d p2 = controlPoints.get(i * 3 + 3);
            Point3d lastPoint = null;
            TreeMap<Double, Double> arcLengthUDistanceMap = new TreeMap<Double, Double>();
            double t = 0.0;
            double segmentArcLength = 0.0;
            int j = 0;
            while (j < numberOfStep) {
                Point3d curvePoint = SplinesUtilities.curvePositionBezier(t, p1, c1, c2, p2);
                if (lastPoint == null) {
                    arcLengthUDistanceMap.put(new Double(0.0), new Double(0.0));
                } else {
                    double distance = curvePoint.distance(lastPoint);
                    segmentArcLength = distance + segmentArcLength;
                    arcLengthUDistanceMap.put(segmentArcLength, t);
                }
                lastPoint = (Point3d)curvePoint.clone();
                t += tStepValue;
                if (t > 1.0) {
                    t = 1.0;
                }
                ++j;
            }
            segmentsArcLengths.put(i, arcLengthUDistanceMap);
            ++i;
        }
    }

    private static double getTotalArcLength() {
        double arcLength = 0.0;
        int i = 0;
        while (i < segmentsArcLengths.size()) {
            arcLength += SplinesUtilities.getSegmentArcLength(i);
            ++i;
        }
        return arcLength;
    }

    private static double getSegmentArcLength(int segmentIndex) {
        double arcLength = 0.0;
        arcLength = (Double)((SortedMap)segmentsArcLengths.get(segmentIndex)).lastKey();
        return arcLength;
    }

    private static double getTotalChordLength(List<Point3d> controlPoints) {
        double chordLength = 0.0;
        double[] segmentLength = SplinesUtilities.getEachSegmentsChordLength(controlPoints);
        int nbrOfSegments = segmentLength.length;
        int i = 0;
        while (i < nbrOfSegments) {
            chordLength += segmentLength[i];
            ++i;
        }
        return chordLength;
    }

    private static double getTotalChordLength(double[] segmentLength) {
        double chordLength = 0.0;
        int nbrOfSegments = segmentLength.length;
        int i = 0;
        while (i < nbrOfSegments) {
            chordLength += segmentLength[i];
            ++i;
        }
        return chordLength;
    }

    private static double[] getEachSegmentsChordLength(List<Point3d> controlPoints) {
        int nbrOfSegment = controlPoints.size() - 3;
        if (nbrOfSegment < 0) {
            nbrOfSegment = 0;
        }
        double[] segmentlength = new double[nbrOfSegment];
        int i = 0;
        while (i < nbrOfSegment) {
            segmentlength[i] = controlPoints.get(i + 1).distance(controlPoints.get(i + 2));
            ++i;
        }
        return segmentlength;
    }

    private static Point3d curvePositionCatmull(double t, Point3d p0, Point3d p1, Point3d p2, Point3d p3, double tension) {
        Point3d Zero = new Point3d();
        Point3d A = new Point3d();
        A.scaleAdd(-1.0 * tension, (Tuple3d)p0, (Tuple3d)Zero);
        A.scaleAdd(2.0 - tension, (Tuple3d)p1, (Tuple3d)A);
        A.scaleAdd(tension - 2.0, (Tuple3d)p2, (Tuple3d)A);
        A.scaleAdd(tension, (Tuple3d)p3, (Tuple3d)A);
        Point3d B = new Point3d();
        B.scaleAdd(2.0 * tension, (Tuple3d)p0, (Tuple3d)Zero);
        B.scaleAdd(tension - 3.0, (Tuple3d)p1, (Tuple3d)B);
        B.scaleAdd(3.0 - 2.0 * tension, (Tuple3d)p2, (Tuple3d)B);
        B.scaleAdd(-tension, (Tuple3d)p3, (Tuple3d)B);
        Point3d C = new Point3d();
        C.scaleAdd(-tension, (Tuple3d)p0, (Tuple3d)C);
        C.scaleAdd(tension, (Tuple3d)p2, (Tuple3d)C);
        Point3d D = new Point3d(p1);
        Point3d curve = new Point3d(A);
        curve.scaleAdd(t, (Tuple3d)B);
        curve.scaleAdd(t, (Tuple3d)C);
        curve.scaleAdd(t, (Tuple3d)D);
        return curve;
    }

    private static Point3d curveSpeedCatmull(double t, Point3d p0, Point3d p1, Point3d p2, Point3d p3, double tension) {
        Point3d Zero = new Point3d();
        Point3d A = new Point3d();
        A.scaleAdd(-1.0 * tension, (Tuple3d)p0, (Tuple3d)Zero);
        A.scaleAdd(2.0 - tension, (Tuple3d)p1, (Tuple3d)A);
        A.scaleAdd(tension - 2.0, (Tuple3d)p2, (Tuple3d)A);
        A.scaleAdd(tension, (Tuple3d)p3, (Tuple3d)A);
        Point3d B = new Point3d();
        B.scaleAdd(2.0 * tension, (Tuple3d)p0, (Tuple3d)Zero);
        B.scaleAdd(tension - 3.0, (Tuple3d)p1, (Tuple3d)B);
        B.scaleAdd(3.0 - 2.0 * tension, (Tuple3d)p2, (Tuple3d)B);
        B.scaleAdd(-tension, (Tuple3d)p3, (Tuple3d)B);
        Point3d C = new Point3d();
        C.scaleAdd(-tension, (Tuple3d)p0, (Tuple3d)C);
        C.scaleAdd(tension, (Tuple3d)p2, (Tuple3d)C);
        Point3d D = new Point3d(p1);
        Point3d curve = new Point3d();
        curve.scaleAdd(3.0 * t, (Tuple3d)A, (Tuple3d)B);
        curve.add((Tuple3d)B);
        curve.scaleAdd(t, (Tuple3d)C);
        return curve;
    }

    private static Point3d curvePositionBezier(double t, Point3d p1, Point3d c1, Point3d c2, Point3d p2) {
        Point3d Zero = new Point3d();
        Point3d A = new Point3d();
        A.scaleAdd(-1.0, (Tuple3d)p1, (Tuple3d)Zero);
        A.scaleAdd(3.0, (Tuple3d)c1, (Tuple3d)A);
        A.scaleAdd(-3.0, (Tuple3d)c2, (Tuple3d)A);
        A.scaleAdd(1.0, (Tuple3d)p2, (Tuple3d)A);
        Point3d B = new Point3d();
        B.scaleAdd(3.0, (Tuple3d)p1, (Tuple3d)Zero);
        B.scaleAdd(-6.0, (Tuple3d)c1, (Tuple3d)B);
        B.scaleAdd(3.0, (Tuple3d)c2, (Tuple3d)B);
        Point3d C = new Point3d();
        C.scaleAdd(-3.0, (Tuple3d)p1, (Tuple3d)C);
        C.scaleAdd(3.0, (Tuple3d)c1, (Tuple3d)C);
        Point3d D = new Point3d(p1);
        Point3d curve = new Point3d(A);
        curve.scaleAdd(t, (Tuple3d)B);
        curve.scaleAdd(t, (Tuple3d)C);
        curve.scaleAdd(t, (Tuple3d)D);
        return curve;
    }

    private static Point3d curveSpeedBezier(double t, Point3d p1, Point3d c1, Point3d c2, Point3d p2) {
        Point3d Zero = new Point3d();
        Point3d A = new Point3d();
        A.scaleAdd(-1.0, (Tuple3d)p1, (Tuple3d)Zero);
        A.scaleAdd(3.0, (Tuple3d)c1, (Tuple3d)A);
        A.scaleAdd(-3.0, (Tuple3d)c2, (Tuple3d)A);
        A.scaleAdd(1.0, (Tuple3d)p2, (Tuple3d)A);
        Point3d B = new Point3d();
        B.scaleAdd(3.0, (Tuple3d)p1, (Tuple3d)Zero);
        B.scaleAdd(-6.0, (Tuple3d)c1, (Tuple3d)B);
        B.scaleAdd(3.0, (Tuple3d)c2, (Tuple3d)B);
        Point3d C = new Point3d();
        C.scaleAdd(-3.0, (Tuple3d)p1, (Tuple3d)C);
        C.scaleAdd(3.0, (Tuple3d)c1, (Tuple3d)C);
        Point3d D = new Point3d(p1);
        Point3d curve = new Point3d();
        curve.scaleAdd(3.0 * t, (Tuple3d)A, (Tuple3d)B);
        curve.add((Tuple3d)B);
        curve.scaleAdd(t, (Tuple3d)C);
        return curve;
    }

    private static Point3d curvePositionBezier(double t, List<Point3d> controlPoints) {
        Point3d pos = new Point3d();
        int nbrOfControlPoints = controlPoints.size();
        double n = nbrOfControlPoints - 1;
        String equation = "";
        int i = 0;
        while (i < nbrOfControlPoints) {
            double a = Math.min((double)i * n, (n - (double)i) * n);
            a = Math.max(a, 1.0);
            Point3d p = (Point3d)controlPoints.get(i).clone();
            p.scale(a);
            p.scale(Math.pow(t, i));
            equation = String.valueOf(equation) + a + " * P" + i + " * t^" + i + "*(1-t)^" + (n - (double)i);
            if (i != nbrOfControlPoints - 1) {
                equation = String.valueOf(equation) + " + ";
            }
            p.scale(Math.pow(1.0 - t, n - (double)i));
            pos.add((Tuple3d)p);
            ++i;
        }
        return pos;
    }

    private static double findAssociatedTvalue(int segmentIndex, double arcLength) {
        double a = arcLength;
        double t = 0.0;
        double t0 = 0.0;
        double t1 = 0.0;
        double a0 = 0.0;
        double a1 = 0.0;
        SortedMap segmentArcLengthAndT = (SortedMap)segmentsArcLengths.get(segmentIndex);
        SortedMap downInterval = segmentArcLengthAndT.headMap(arcLength);
        SortedMap upInterval = segmentArcLengthAndT.tailMap(arcLength);
        if (!downInterval.isEmpty()) {
            a0 = downInterval.lastKey();
            t0 = (Double)downInterval.get(downInterval.lastKey());
        } else {
            a0 = 0.0;
            t0 = 0.0;
        }
        if (!upInterval.isEmpty()) {
            a1 = upInterval.firstKey();
            t1 = (Double)upInterval.get(upInterval.firstKey());
        } else {
            a1 = 0.0;
            t1 = 1.0;
        }
        t = a1 != 0.0 && a1 - a0 != 0.0 ? t0 + (a - a0) / (a1 - a0) * (t1 - t0) : t0;
        return t;
    }
}

