/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.AzimuthDirection;
import org.eclipse.apogy.addons.sensors.imaging.ElevationDirection;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.FOVOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.DrawnCameraOverlayPreviewComposite;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.ui.composites.Color3fComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class FOVOverlayComposite
extends Composite {
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private FOVOverlay fovOverlay;
    private final ComboViewer fontComboViewer;
    private final Combo fontCombo;
    private final Spinner fontSizeSpinner;
    private final Color3fComposite positiveColorComposite;
    private final Color3fComposite negativeColorComposite;
    private final ComboViewer azimuthDirectionComboViewer;
    private final ComboViewer elevationDirectionComboViewer;
    private final Spinner angleIntervalSpinner;
    private final Spinner lineWidthSpinner;
    private final DrawnCameraOverlayPreviewComposite drawnCameraOverlayPreviewComposite;
    private DataBindingContext m_bindingContext;

    public FOVOverlayComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Group grpFontSettings = new Group((Composite)this, 0);
        grpFontSettings.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpFontSettings.setText("Font Settings");
        grpFontSettings.setLayout((Layout)new GridLayout(4, false));
        Label lblFont = new Label((Composite)grpFontSettings, 0);
        lblFont.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFont.setText("Font:");
        this.fontComboViewer = new ComboViewer((Composite)grpFontSettings, 0);
        this.fontCombo = this.fontComboViewer.getCombo();
        GridData gd_fontCombo = new GridData(16384, 0x1000000, true, false, 3, 1);
        gd_fontCombo.widthHint = 250;
        gd_fontCombo.minimumWidth = 250;
        this.fontCombo.setLayoutData((Object)gd_fontCombo);
        this.fontComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fontComboViewer.setInput(this.getAvailableFonts());
        this.fontComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iStructuredSelection;
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof String) {
                    String fontName = (String)iStructuredSelection.getFirstElement();
                    if (FOVOverlayComposite.this.fovOverlay != null) {
                        if (ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)FOVOverlayComposite.this.getFovOverlay()) == null) {
                            ApogyCommonTransactionFacade.INSTANCE.addInTempTransactionalEditingDomain((EObject)FOVOverlayComposite.this.getFovOverlay());
                        }
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)FOVOverlayComposite.this.getFovOverlay(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__FONT_NAME, (Object)fontName);
                    }
                    FOVOverlayComposite.this.fontNameSelected(fontName);
                }
            }
        });
        Label lblFontSize = new Label((Composite)grpFontSettings, 0);
        lblFontSize.setText("Font Size:");
        this.fontSizeSpinner = new Spinner((Composite)grpFontSettings, 2048);
        GridData gd_fontSizeSpinner = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_fontSizeSpinner.minimumWidth = 50;
        gd_fontSizeSpinner.widthHint = 50;
        this.fontSizeSpinner.setLayoutData((Object)gd_fontSizeSpinner);
        Group grpColorSettings = new Group((Composite)this, 0);
        grpColorSettings.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpColorSettings.setText("Color Settings");
        grpColorSettings.setLayout((Layout)new GridLayout(2, false));
        Label lblPositiveValuesColors = new Label((Composite)grpColorSettings, 0);
        lblPositiveValuesColors.setText("Positive Values Color:");
        this.positiveColorComposite = new Color3fComposite((Composite)grpColorSettings, 0);
        this.positiveColorComposite.setFeature((EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__POSITIVE_VALUES_COLOR);
        Label lblNegativeValuesColor = new Label((Composite)grpColorSettings, 0);
        lblNegativeValuesColor.setText("Negative Values Color:");
        this.negativeColorComposite = new Color3fComposite((Composite)grpColorSettings, 0);
        this.negativeColorComposite.setFeature((EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__NEGATIVE_VALUE_COLOR);
        Group grpDirectionSettings = new Group((Composite)this, 0);
        grpDirectionSettings.setLayout((Layout)new GridLayout(2, false));
        grpDirectionSettings.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpDirectionSettings.setText("Direction Settings");
        Label lblAzimuthDirection = new Label((Composite)grpDirectionSettings, 0);
        lblAzimuthDirection.setText("Azimuth Direction:");
        this.azimuthDirectionComboViewer = new ComboViewer((Composite)grpDirectionSettings, 0);
        GridData gd_imageSizePolicyComboViewer = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_imageSizePolicyComboViewer.minimumWidth = 200;
        gd_imageSizePolicyComboViewer.widthHint = 200;
        this.azimuthDirectionComboViewer.getCombo().setLayoutData((Object)gd_imageSizePolicyComboViewer);
        this.azimuthDirectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.azimuthDirectionComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.azimuthDirectionComboViewer.setInput((Object)AzimuthDirection.values());
        Label lblElevationDirection = new Label((Composite)grpDirectionSettings, 0);
        lblElevationDirection.setText("Elevation Direction:");
        this.elevationDirectionComboViewer = new ComboViewer((Composite)grpDirectionSettings, 0);
        GridData gd_elevationDirectionComboViewer = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_elevationDirectionComboViewer.minimumWidth = 200;
        gd_elevationDirectionComboViewer.widthHint = 200;
        this.elevationDirectionComboViewer.getCombo().setLayoutData((Object)gd_elevationDirectionComboViewer);
        this.elevationDirectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.elevationDirectionComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.elevationDirectionComboViewer.setInput((Object)ElevationDirection.values());
        Group grpCrosshairSettings = new Group((Composite)this, 0);
        grpCrosshairSettings.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpCrosshairSettings.setText("Cross-Hair Settings");
        grpCrosshairSettings.setLayout((Layout)new GridLayout(2, false));
        Label lblAngleIntervaldeg = new Label((Composite)grpCrosshairSettings, 0);
        lblAngleIntervaldeg.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAngleIntervaldeg.setText("Angle Interval (deg):");
        this.angleIntervalSpinner = new Spinner((Composite)grpCrosshairSettings, 2048);
        this.angleIntervalSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.angleIntervalSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FOVOverlayComposite.this.angleIntervalSelected(FOVOverlayComposite.this.angleIntervalSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblLineWidthpixels = new Label((Composite)grpCrosshairSettings, 0);
        lblLineWidthpixels.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLineWidthpixels.setText("Line Width (pixels):");
        this.lineWidthSpinner = new Spinner((Composite)grpCrosshairSettings, 2048);
        this.lineWidthSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lineWidthSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FOVOverlayComposite.this.lineWidthSelected(FOVOverlayComposite.this.lineWidthSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group grpPreview = new Group((Composite)this, 0);
        grpPreview.setLayout((Layout)new GridLayout(1, false));
        grpPreview.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        grpPreview.setText("Preview");
        this.drawnCameraOverlayPreviewComposite = new DrawnCameraOverlayPreviewComposite((Composite)grpPreview, 2048);
        GridData gd_imagePreviewComposite = new GridData(4, 4, true, true, 1, 1);
        gd_imagePreviewComposite.minimumWidth = 160;
        gd_imagePreviewComposite.minimumHeight = 320;
        this.drawnCameraOverlayPreviewComposite.setLayoutData(gd_imagePreviewComposite);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FOVOverlayComposite.this.m_bindingContext != null) {
                    FOVOverlayComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public FOVOverlay getFovOverlay() {
        return this.fovOverlay;
    }

    public void setFovOverlay(FOVOverlay fovOverlay) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.fovOverlay = fovOverlay;
        if (fovOverlay != null) {
            this.drawnCameraOverlayPreviewComposite.setDrawnCameraOverlay(fovOverlay);
            this.m_bindingContext = this.customInitDataBindings();
        }
    }

    protected void lineWidthSelected(int lineWidth) {
    }

    protected void angleIntervalSelected(int angleInterval) {
    }

    protected void fontNameSelected(String fontName) {
    }

    protected List<String> getAvailableFonts() {
        ArrayList<String> fonts = new ArrayList<String>();
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fontNames.length) {
            fonts.add(fontNames[i]);
            ++i;
        }
        return fonts;
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeFontName = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.fovOverlay), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__FONT_NAME})).observe((Object)this.fovOverlay);
        ISWTObservableValue observeFontComboViewer = WidgetProperties.selection().observe((Widget)this.fontComboViewer.getCombo());
        bindingContext.bindValue((IObservableValue)observeFontComboViewer, observeFontName, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeFontSize = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.fovOverlay), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__FONT_SIZE})).observe((Object)this.fovOverlay);
        ISWTObservableValue observeFontSizeSpinner = WidgetProperties.selection().observe((Widget)this.fontSizeSpinner);
        bindingContext.bindValue((IObservableValue)observeFontSizeSpinner, observeFontSize, new UpdateValueStrategy(), new UpdateValueStrategy());
        this.positiveColorComposite.setOwner((EObject)this.fovOverlay);
        this.negativeColorComposite.setOwner((EObject)this.fovOverlay);
        IObservableValue observeAzimuthDirection = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.fovOverlay), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__AZIMUTH_DIRECTION})).observe((Object)this.fovOverlay);
        IViewerObservableValue observeAzimuthDirectionCombViewer = ViewerProperties.singleSelection().observe((Viewer)this.azimuthDirectionComboViewer);
        bindingContext.bindValue((IObservableValue)observeAzimuthDirectionCombViewer, observeAzimuthDirection, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeElevationDirection = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.fovOverlay), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__ELEVATION_DIRECTION})).observe((Object)this.fovOverlay);
        IViewerObservableValue observeElevationDirectionCombViewer = ViewerProperties.singleSelection().observe((Viewer)this.elevationDirectionComboViewer);
        bindingContext.bindValue((IObservableValue)observeElevationDirectionCombViewer, observeElevationDirection, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeLineWidth = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.fovOverlay), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__LINE_WIDTH})).observe((Object)this.fovOverlay);
        ISWTObservableValue observeLineWidthSpinner = WidgetProperties.selection().observe((Widget)this.lineWidthSpinner);
        bindingContext.bindValue((IObservableValue)observeLineWidthSpinner, observeLineWidth, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeAngleInterval = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.fovOverlay), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.FOV_OVERLAY__ANGLE_INTERVAL})).observe((Object)this.fovOverlay);
        ISWTObservableValue observeAngleIntervalText = WidgetProperties.selection().observe((Widget)this.angleIntervalSpinner);
        bindingContext.bindValue((IObservableValue)observeAngleIntervalText, observeAngleInterval, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }
}

