/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.ImageSizePolicy;
import org.eclipse.apogy.addons.sensors.imaging.camera.URLImageOverlay;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.URLEImage;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLImageOverlayComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(URLImageOverlayComposite.class);
    private URLImageOverlay urlImageOverlay;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final ComboViewer imageSizePolicyComboViewer;
    private final URLSelectionComposite urlSelectionComposite;
    private final Label imageWidthValue;
    private final Label imageHeightValue;
    private final ImageDisplayComposite imageDisplayComposite;
    private DataBindingContext m_bindingContext;

    public URLImageOverlayComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblImageSizePolicy = new Label((Composite)this, 0);
        lblImageSizePolicy.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblImageSizePolicy.setText("Image Resize Policy :");
        this.imageSizePolicyComboViewer = new ComboViewer((Composite)this, 0);
        GridData gd_imageSizePolicyComboViewer = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_imageSizePolicyComboViewer.minimumWidth = 200;
        gd_imageSizePolicyComboViewer.widthHint = 200;
        this.imageSizePolicyComboViewer.getCombo().setLayoutData((Object)gd_imageSizePolicyComboViewer);
        this.imageSizePolicyComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.imageSizePolicyComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.imageSizePolicyComboViewer.setInput((Object)ImageSizePolicy.values());
        this.urlSelectionComposite = new URLSelectionComposite(this, 0, new String[]{"*.gif", "*.jpg", "*.jpeg"}, true, true, true){

            protected void urlStringSelected(String newURLString) {
                if (URLImageOverlayComposite.this.urlImageOverlay != null) {
                    if (ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)URLImageOverlayComposite.this.urlImageOverlay) == null) {
                        ApogyCommonTransactionFacade.INSTANCE.addInTempTransactionalEditingDomain((EObject)URLImageOverlayComposite.this.urlImageOverlay);
                    }
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)URLImageOverlayComposite.this.urlImageOverlay, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.URL_IMAGE_OVERLAY__URL, (Object)newURLString);
                    URLImageOverlayComposite.this.updateImagePreview(newURLString);
                    URLImageOverlayComposite.this.newURLSelected(newURLString);
                }
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Group grpImagePreview = new Group((Composite)this, 2048);
        grpImagePreview.setText("Image Preview");
        grpImagePreview.setLayout((Layout)new GridLayout(2, false));
        grpImagePreview.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite imageSizeComposite = new Composite((Composite)grpImagePreview, 0);
        imageSizeComposite.setLayout((Layout)new GridLayout(2, false));
        imageSizeComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        Label lblimageWidthInMeters = new Label(imageSizeComposite, 0);
        lblimageWidthInMeters.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblimageWidthInMeters.setText("Image width (pixels):");
        this.imageWidthValue = new Label(imageSizeComposite, 2048);
        GridData gd_imageWidthValue = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_imageWidthValue.minimumWidth = 100;
        gd_imageWidthValue.widthHint = 100;
        this.imageWidthValue.setLayoutData((Object)gd_imageWidthValue);
        Label lblimageHeightInMeters = new Label(imageSizeComposite, 0);
        lblimageHeightInMeters.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblimageHeightInMeters.setText("Image height (pixels):");
        this.imageHeightValue = new Label(imageSizeComposite, 2048);
        GridData gd_imageHeightValue = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_imageHeightValue.minimumWidth = 100;
        gd_imageHeightValue.widthHint = 100;
        this.imageHeightValue.setLayoutData((Object)gd_imageHeightValue);
        new Label((Composite)grpImagePreview, 0);
        this.imageDisplayComposite = new ImageDisplayComposite((Composite)grpImagePreview, 2048);
        GridData gd_imageDisplayComposite = new GridData(4, 4, true, true, 2, 1);
        gd_imageDisplayComposite.heightHint = 200;
        gd_imageDisplayComposite.minimumHeight = 200;
        gd_imageDisplayComposite.widthHint = 200;
        gd_imageDisplayComposite.minimumWidth = 200;
        this.imageDisplayComposite.setLayoutData((Object)gd_imageDisplayComposite);
        this.imageDisplayComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                URLImageOverlayComposite.this.imageDisplayComposite.fitImage();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (URLImageOverlayComposite.this.m_bindingContext != null) {
                    URLImageOverlayComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public URLImageOverlay getUrlImageOverlay() {
        return this.urlImageOverlay;
    }

    public void setUrlImageOverlay(URLImageOverlay urlImageOverlay) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.urlImageOverlay = urlImageOverlay;
        if (urlImageOverlay != null) {
            if (ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)urlImageOverlay) == null) {
                ApogyCommonTransactionFacade.INSTANCE.addInTempTransactionalEditingDomain((EObject)urlImageOverlay);
            }
            this.m_bindingContext = this.customInitDataBindings();
        }
    }

    protected void newURLSelected(String newURL) {
    }

    protected void updateImagePreview(String urlString) {
        try {
            URLEImage urlEImage = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
            urlEImage.setUrl(urlString);
            this.imageWidthValue.setText(Integer.toString(urlEImage.getWidth()));
            this.imageHeightValue.setText(Integer.toString(urlEImage.getHeight()));
            ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(urlEImage.asBufferedImage());
            this.imageDisplayComposite.setImageData(imageData);
            this.imageDisplayComposite.fitImage();
        }
        catch (Exception e) {
            this.imageDisplayComposite.setImageData(null);
            this.imageWidthValue.setText("0");
            this.imageHeightValue.setText("0");
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.urlImageOverlay.getUrl() != null) {
            this.urlSelectionComposite.setUrlString(this.urlImageOverlay.getUrl());
        }
        IObservableValue observeImageSizePolicy = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.URL_IMAGE_OVERLAY__IMAGE_SIZE_POLICY})).observe((Object)this.urlImageOverlay);
        IViewerObservableValue observeImageSizePolicyCombViewer = ViewerProperties.singleSelection().observe((Viewer)this.imageSizePolicyComboViewer);
        bindingContext.bindValue((IObservableValue)observeImageSizePolicyCombViewer, observeImageSizePolicy, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }
}

