/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.awt.Graphics2D;
import java.awt.Image;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.camera.ImageSizePolicy;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.URLImageOverlayImpl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.URLEImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLImageOverlayCustomImpl
extends URLImageOverlayImpl {
    private static final Logger Logger = LoggerFactory.getLogger(URLImageOverlayImpl.class);

    @Override
    public void setUrl(String newUrl) {
        super.setUrl(newUrl);
        try {
            URLEImage urlEImage = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
            urlEImage.setUrl(newUrl);
            this.setImage((AbstractEImage)urlEImage);
        }
        catch (Throwable t) {
            this.setImage(null);
            Logger.error(t.getMessage(), t);
        }
    }

    @Override
    public AbstractEImage getOverlay(AbstractCamera camera, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        AbstractEImage image = EImagesUtilities.INSTANCE.createTransparentImage(overlayWidth, overlayHeight);
        AbstractEImage resizedImage = null;
        if (this.getImageSizePolicy() != ImageSizePolicy.FIXED_SIZE) {
            double widthScaleFactor = 1.0;
            double heightScaleFactor = 1.0;
            switch (this.getImageSizePolicy().getValue()) {
                case 3: {
                    widthScaleFactor = (double)overlayWidth / (double)this.getImage().getWidth();
                    break;
                }
                case 2: {
                    heightScaleFactor = (double)overlayHeight / (double)this.getImage().getHeight();
                    break;
                }
                case 4: {
                    widthScaleFactor = (double)overlayWidth / (double)this.getImage().getWidth();
                    heightScaleFactor = (double)overlayHeight / (double)this.getImage().getHeight();
                    break;
                }
            }
            resizedImage = EImagesUtilities.INSTANCE.resize(this.getImage(), widthScaleFactor, heightScaleFactor);
        } else {
            resizedImage = EImagesUtilities.INSTANCE.copy(this.getImage());
        }
        int x = 0;
        int y = 0;
        switch (overlayAlignment.getValue()) {
            case 1: {
                x = (int)Math.floor((double)(overlayWidth - resizedImage.getWidth()) * 0.5);
                y = (int)Math.floor((double)(overlayHeight - resizedImage.getHeight()) * 0.5);
                break;
            }
            case 2: {
                x = 0;
                y = overlayHeight - resizedImage.getHeight();
                break;
            }
            case 4: {
                x = overlayWidth - Math.round(resizedImage.getWidth());
                y = overlayHeight - Math.round(resizedImage.getHeight());
                break;
            }
            case 3: {
                x = 0;
                y = 0;
                break;
            }
            case 5: {
                x = overlayWidth - Math.round(resizedImage.getWidth());
                y = 0;
                break;
            }
        }
        Graphics2D g2d = image.asBufferedImage().createGraphics();
        g2d.drawImage((Image)resizedImage.asBufferedImage(), x, y, null);
        g2d.dispose();
        return image;
    }
}

