/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.ui.views;

import org.eclipse.apogy.addons.sensors.pose.PoseSensor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class PoseSensorView
extends ViewPart
implements ISelectionListener {
    private Label tx;
    private Label ty;
    private Label tz;
    private Label rx;
    private Label rz;
    private Label ry;
    private Label status;
    private PoseSensor poseSensor;
    private Adapter poseSensorListener;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        Label lTx = new Label(parent, 0);
        lTx.setText("Tx: ");
        this.tx = new Label(parent, 0);
        this.tx.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lTy = new Label(parent, 0);
        lTy.setText("Ty: ");
        this.ty = new Label(parent, 0);
        this.ty.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lTz = new Label(parent, 0);
        lTz.setText("Tz: ");
        this.tz = new Label(parent, 0);
        this.tz.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lRx = new Label(parent, 0);
        lRx.setText("Rx: ");
        this.rx = new Label(parent, 0);
        this.rx.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lRy = new Label(parent, 0);
        lRy.setText("Ry: ");
        this.ry = new Label(parent, 0);
        this.ry.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lRz = new Label(parent, 0);
        lRz.setText("Rz: ");
        this.rz = new Label(parent, 0);
        this.rz.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lStatus = new Label(parent, 0);
        lStatus.setText("Status: ");
        this.status = new Label(parent, 0);
        this.status.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void setFocus() {
    }

    private Adapter getPoseSensorListener() {
        if (this.poseSensorListener == null) {
            this.poseSensorListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(PoseSensor.class);
                    if (featureId == 5 || featureId == 6 || featureId == 7) {
                        PoseSensorView.this.updateView();
                    }
                }
            };
        }
        return this.poseSensorListener;
    }

    private void updateView() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PoseSensorView.this.tx.setText(String.valueOf(PoseSensorView.this.poseSensor.getPose().getX()));
                PoseSensorView.this.rx.setText(String.valueOf(PoseSensorView.this.poseSensor.getPose().getXRotation()));
                PoseSensorView.this.ty.setText(String.valueOf(PoseSensorView.this.poseSensor.getPose().getY()));
                PoseSensorView.this.ry.setText(String.valueOf(PoseSensorView.this.poseSensor.getPose().getYRotation()));
                PoseSensorView.this.tz.setText(String.valueOf(PoseSensorView.this.poseSensor.getPose().getZ()));
                PoseSensorView.this.rz.setText(String.valueOf(PoseSensorView.this.poseSensor.getPose().getZRotation()));
                PoseSensorView.this.status.setText(PoseSensorView.this.poseSensor.getStatus().toString());
            }
        };
        this.getSite().getShell().getDisplay().asyncExec(run);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (this.poseSensor != null) {
                this.poseSensor.eAdapters().remove((Object)this.getPoseSensorListener());
            }
            if (sel.getFirstElement() instanceof PoseSensor) {
                this.poseSensor = (PoseSensor)sel.getFirstElement();
                this.poseSensor.eAdapters().add((Object)this.getPoseSensorListener());
            }
        }
    }
}

