/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.vehicle.impl.VehicleTrajectoryPickingToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data.ApogyCommonGeometryDataPackage;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.viewer.MouseButton;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class VehicleTrajectoryPickingToolCustomImpl
extends VehicleTrajectoryPickingToolImpl {
    @Override
    public WayPointPath getLocalPath() {
        if (this.getActivePath() != null) {
            Matrix4d vehiculePose = this.getVehiculePose();
            Matrix4d inv = new Matrix4d(vehiculePose);
            inv.invert();
            WayPointPath localPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
            for (CartesianPositionCoordinates point : this.getActivePath().getPoints()) {
                Vector3d pointPosition = new Vector3d((Tuple3d)point.asPoint3d());
                Matrix4d pointPose = new Matrix4d();
                pointPose.setIdentity();
                pointPose.setTranslation(pointPosition);
                pointPose.invert();
                pointPose.mul(vehiculePose);
                pointPose.invert();
                Vector3d pointRelativePosition = new Vector3d();
                pointPose.get(pointRelativePosition);
                CartesianPositionCoordinates localPoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(pointRelativePosition.x, pointRelativePosition.y, pointRelativePosition.z);
                localPath.getPoints().add((Object)localPoint);
            }
            return localPath;
        }
        return null;
    }

    public void setActive(boolean newActive) {
        try {
            super.setActive(newActive);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (newActive && this.getActivePath() != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this.getActivePath(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Collection)this.getActivePath().getPoints());
        }
    }

    public void selectionChanged(NodeSelection nodeSelection) {
        if (this.getActivePath() != null && this.getActivePath().getPoints().isEmpty()) {
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.getActivePath(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Object)this.getVechiculeCurrentPosition());
        }
        super.selectionChanged(nodeSelection);
    }

    public void mouseButtonClicked(MouseButton mouseButtonClicked) {
        if (mouseButtonClicked == MouseButton.RIGHT && this.getActivePath() != null && this.getActivePath().getPoints().size() > 1) {
            CartesianPositionCoordinates coord = (CartesianPositionCoordinates)this.getActivePath().getPoints().get(this.getActivePath().getPoints().size() - 1);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this.getActivePath(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Object)coord);
        }
    }

    protected Matrix4d getVehiculePose() {
        ApogySystemApiAdapter apogySystemApiAdapter;
        TypeApiAdapter apiAdapter;
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        if (this.getVehiculeVariableFeatureReference() != null && (apiAdapter = ApogyCoreInvocatorFacade.INSTANCE.getTypeApiAdapter(this.getVehiculeVariableFeatureReference())) instanceof ApogySystemApiAdapter && (apogySystemApiAdapter = (ApogySystemApiAdapter)apiAdapter).getPoseTransform() != null) {
            m = apogySystemApiAdapter.getPoseTransform().asMatrix4d();
        }
        return m;
    }

    protected CartesianPositionCoordinates getVechiculeCurrentPosition() {
        Matrix4d vehiclePose = this.getVehiculePose();
        Vector3d position = new Vector3d();
        vehiclePose.get(position);
        CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(position.x, position.y, position.z);
        return point;
    }
}

