/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.atmosphere.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.atmosphere.EarthAtmosphereWorksite;
import org.eclipse.apogy.core.environment.earth.atmosphere.EarthAtmosphereWorksiteNode;
import org.eclipse.apogy.core.environment.earth.atmosphere.ui.jme3.utils.AtmosphereJME3Utilities;
import org.eclipse.apogy.core.environment.earth.atmosphere.ui.scene_objects.EarthAtmosphereWorksiteSceneObject;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksiteNode;
import org.eclipse.apogy.core.environment.earth.surface.ui.jme3.EarthSurfaceEnvironmentJMEConstants;
import org.eclipse.apogy.core.environment.earth.surface.ui.jme3.EnvironmentUIJME3Utilities;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthAtmosphereWorksiteNodeJME3Object
extends DefaultJME3SceneObject<EarthAtmosphereWorksiteNode>
implements EarthAtmosphereWorksiteSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(EarthAtmosphereWorksiteNodeJME3Object.class);
    public static long IMAGE_RETRY_WAIT_TIME_MS = 60000L;
    public static float CUTTOFF_HEIGHT_METERS = 250.0f;
    private static ColorRGBA HORIZON_COLOR = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    private final AWTLoader awtLoader = new AWTLoader();
    private Adapter adapter;
    private boolean axisVisible = false;
    private float axisLength = 1.0f;
    private boolean planeVisible = true;
    private float gridSize = 10.0f;
    private float planeSize = 100.0f;
    private boolean azimuthVisible = true;
    private boolean azimuthLinesVisible = true;
    private boolean elevationLinesVisible = true;
    private float altitude = 0.0f;
    private final AssetManager assetManager = this.jme3Application.getAssetManager();
    private final Geometry horizonGeometry = null;
    private Geometry gridGeometry = null;
    private Geometry axisGeometry = null;
    private com.jme3.scene.Node skyNode = null;
    private com.jme3.scene.Node azimuthDisplayNode = null;
    private com.jme3.scene.Node azimuthDisplayCirclesNode = null;
    private com.jme3.scene.Node elevationDisplayCirclesNode = null;
    private com.jme3.scene.Node horizon;
    private long lastImageTryTime = -1L;

    public EarthAtmosphereWorksiteNodeJME3Object(EarthAtmosphereWorksiteNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.requestUpdate();
        node.eAdapters().add((Object)this.getAdapter());
        if (node.getWorksite() instanceof EarthAtmosphereWorksite) {
            EarthAtmosphereWorksite earthAtmosphereWorksite = (EarthAtmosphereWorksite)node.getWorksite();
            earthAtmosphereWorksite.eAdapters().add((Object)this.getAdapter());
        }
    }

    public void updateGeometry(float tpf) {
        if (this.horizon != null) {
            this.getAttachmentNode().detachChild((Spatial)this.horizon);
        }
        if (this.gridGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.gridGeometry);
        }
        if (this.axisGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.axisGeometry);
        }
        if (this.skyNode != null) {
            this.getAttachmentNode().detachChild((Spatial)this.skyNode);
        }
        this.axisGeometry = JME3Utilities.createAxis3D((float)this.axisLength, (AssetManager)this.assetManager);
        if (this.axisVisible) {
            this.getAttachmentNode().attachChild((Spatial)this.axisGeometry);
        }
        this.gridGeometry = this.createGridGeometry();
        if (this.planeVisible) {
            this.getAttachmentNode().attachChild((Spatial)this.gridGeometry);
        }
        this.skyNode = this.createSkyNode();
        this.getAttachmentNode().attachChild((Spatial)this.skyNode);
        this.horizon = this.createHorizon(this.altitude);
        this.getAttachmentNode().attachChild((Spatial)this.horizon);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.gridGeometry);
        geometries.add(this.axisGeometry);
        geometries.add(this.horizonGeometry);
        return geometries;
    }

    public void setAxisVisible(final boolean newAxisVisible) {
        this.axisVisible = newAxisVisible;
        Logger.info("Setting Axis visibility to <" + newAxisVisible + ">");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthAtmosphereWorksiteNodeJME3Object.this.axisGeometry != null) {
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.axisVisible) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.axisGeometry);
                    } else {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.axisGeometry);
                    }
                } else {
                    Logger.error("Failed to set Axis visibility to <" + newAxisVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double newLength) {
        this.axisLength = (float)newLength;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Logger.info("Setting Axis Length to <" + newLength + ">.");
                try {
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.axisGeometry != null) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.axisGeometry);
                    }
                    EarthAtmosphereWorksiteNodeJME3Object.this.axisGeometry = JME3Utilities.createAxis3D((float)EarthAtmosphereWorksiteNodeJME3Object.this.axisLength, (AssetManager)EarthAtmosphereWorksiteNodeJME3Object.this.assetManager);
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.axisVisible) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.axisGeometry);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to setAxisLength(" + newLength + ").", t);
                }
                return null;
            }
        });
    }

    public void setPlaneVisible(boolean newPlaneVisible) {
        this.planeVisible = newPlaneVisible;
        Logger.info("Setting Plane visibility to <" + newPlaneVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry != null) {
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.planeVisible) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry);
                    } else {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry);
                    }
                }
                return null;
            }
        });
    }

    public void setPlaneParameters(double newGridSize, double newPlaneSize) {
        Logger.info("Setting Plane grid size to <" + newGridSize + "> and grid size to <" + newPlaneSize + ">.");
        if (newGridSize > 0.0 && newPlaneSize > 0.0) {
            this.gridSize = (float)newGridSize;
            this.planeSize = (float)newPlaneSize;
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry != null) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry);
                    }
                    EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry = EarthAtmosphereWorksiteNodeJME3Object.this.createGridGeometry();
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.planeVisible) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry);
                    } else {
                        EarthAtmosphereWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.gridGeometry);
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Failed to set Plane grid size to <" + newGridSize + "> and grid size to <" + newPlaneSize + ">.");
        }
    }

    public void setAzimuthVisible(final boolean newAzimuthVisible) {
        this.azimuthVisible = newAzimuthVisible;
        Logger.info("Setting Azimuth visibility to <" + newAzimuthVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthAtmosphereWorksiteNodeJME3Object.this.skyNode != null) {
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.azimuthVisible) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.skyNode.attachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.azimuthDisplayNode);
                    } else {
                        EarthAtmosphereWorksiteNodeJME3Object.this.skyNode.detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.azimuthDisplayNode);
                    }
                } else {
                    Logger.error("Failed to set Azimuth visibility to <" + newAzimuthVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setElevationLinesVisible(final boolean newElevationLinesVisible) {
        this.elevationLinesVisible = newElevationLinesVisible;
        Logger.info("Setting Elevation Lines visibility to <" + newElevationLinesVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthAtmosphereWorksiteNodeJME3Object.this.skyNode != null) {
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.elevationLinesVisible) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.skyNode.attachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.elevationDisplayCirclesNode);
                    } else {
                        EarthAtmosphereWorksiteNodeJME3Object.this.skyNode.detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.elevationDisplayCirclesNode);
                    }
                } else {
                    Logger.error("Failed to set Elevation Lines visibility to <" + newElevationLinesVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setAzimuthLinesVisible(final boolean newAzimuthLinesVisible) {
        this.azimuthLinesVisible = newAzimuthLinesVisible;
        Logger.info("Setting Azimuth Lines visibility to <" + newAzimuthLinesVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthAtmosphereWorksiteNodeJME3Object.this.skyNode != null) {
                    if (EarthAtmosphereWorksiteNodeJME3Object.this.azimuthLinesVisible) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.skyNode.attachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.azimuthDisplayCirclesNode);
                    } else {
                        EarthAtmosphereWorksiteNodeJME3Object.this.skyNode.detachChild((Spatial)EarthAtmosphereWorksiteNodeJME3Object.this.azimuthDisplayCirclesNode);
                    }
                } else {
                    Logger.error("Failed to set Azimuth Lines visibility to <" + newAzimuthLinesVisible + ">.");
                }
                return null;
            }
        });
    }

    private com.jme3.scene.Node createSkyNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Worksite Sky");
        this.azimuthDisplayNode = EnvironmentUIJME3Utilities.createAzimuthDisplay((AssetManager)this.assetManager);
        node.attachChild((Spatial)this.azimuthDisplayNode);
        this.azimuthDisplayCirclesNode = EnvironmentUIJME3Utilities.createAzimuthCirclesDisplay((AssetManager)this.assetManager);
        node.attachChild((Spatial)this.azimuthDisplayCirclesNode);
        this.elevationDisplayCirclesNode = EnvironmentUIJME3Utilities.createElevationCirclesDisplay((AssetManager)this.assetManager);
        node.attachChild((Spatial)this.elevationDisplayCirclesNode);
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        node.setLocalTransform(JME3Utilities.createTransform((Matrix4d)m));
        return node;
    }

    private Geometry createGridGeometry() {
        Mesh gridMesh = EnvironmentUIJME3Utilities.createGrid((float)this.gridSize, (float)this.planeSize);
        Geometry geometry = new Geometry("Grid", gridMesh);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", EarthSurfaceEnvironmentJMEConstants.DEFAULT_GRID_COLOR.clone());
        geometry.setMaterial(mat);
        return geometry;
    }

    private com.jme3.scene.Node createHorizon(float altitude) {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Worksite Earth Surface");
        node.attachChild((Spatial)this.createCurvedHorizonGeometry(altitude));
        return node;
    }

    private com.jme3.scene.Node createCurvedHorizonGeometry(float altitude) {
        double gamma = AtmosphereJME3Utilities.getHorizonAngle(altitude);
        double a = CUTTOFF_HEIGHT_METERS;
        double b = a * Math.tan(Math.toRadians(90.0) - Math.abs(gamma));
        List<Vector3f> profile = AtmosphereJME3Utilities.getHyperbola(a, b, 15000.0);
        Mesh mesh = AtmosphereJME3Utilities.getParabolaGeometry(profile);
        Geometry geometry = new Geometry("Horizon", mesh);
        geometry.setMaterial(this.createHorizonMaterial());
        geometry.setShadowMode(RenderQueue.ShadowMode.Off);
        geometry.getMaterial().getAdditionalRenderState().setWireframe(false);
        com.jme3.scene.Node node = new com.jme3.scene.Node("Curved Horizon");
        node.attachChild((Spatial)geometry);
        return node;
    }

    private Material createHorizonMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        AbstractEImage textureImage = null;
        if (this.lastImageTryTime != -1L) {
            long now = System.currentTimeMillis();
            if (now - this.lastImageTryTime > IMAGE_RETRY_WAIT_TIME_MS) {
                textureImage = this.getTextureImage();
            }
        } else {
            textureImage = this.getTextureImage();
        }
        if (textureImage != null) {
            Texture2D texture = this.createTexture(textureImage);
            mat.setTexture("ColorMap", (Texture)texture);
        } else {
            mat.setColor("Color", HORIZON_COLOR.clone());
        }
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        return mat;
    }

    private AbstractEImage getTextureImage() {
        try {
            EarthAtmosphereWorksite earthAtmosphereWorksite;
            if (this.getTopologyNode() != null && ((EarthAtmosphereWorksiteNode)this.getTopologyNode()).getWorksite() instanceof EarthAtmosphereWorksite && (earthAtmosphereWorksite = (EarthAtmosphereWorksite)((EarthAtmosphereWorksiteNode)this.getTopologyNode()).getWorksite()).getGeographicalCoordinates() != null) {
                AbstractEImage image = AtmosphereJME3Utilities.getImageFromWMS((EarthAtmosphereWorksiteNode)this.getTopologyNode(), earthAtmosphereWorksite.getGeographicalCoordinates(), 50000.0);
                this.lastImageTryTime = image != null ? -1L : System.currentTimeMillis();
                return image;
            }
        }
        catch (Exception e) {
            this.lastImageTryTime = System.currentTimeMillis();
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Texture2D createTexture(AbstractEImage textureImage) {
        int width = textureImage.getWidth();
        int height = textureImage.getHeight();
        RGB rgb = new RGB(255, 255, 255);
        AbstractEImage background = EImagesUtilities.INSTANCE.createUniformColorImage(width, height, rgb.red, rgb.green, rgb.blue, 255);
        AbstractEImage newImage = EImagesUtilities.INSTANCE.applyOverlay(background, textureImage, false);
        AbstractEImage rotatedImage = EImagesUtilities.INSTANCE.rotate(newImage, 1.5707963267948966, false);
        Image img = this.awtLoader.load(rotatedImage.asBufferedImage(), true);
        Texture2D texture = new Texture2D(img);
        return texture;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    GeographicCoordinates coord;
                    if (msg.getNotifier() instanceof EarthSurfaceWorksiteNode) {
                        if (msg.getFeatureID(EarthSurfaceWorksiteNode.class) == 5) {
                            if (msg.getOldValue() instanceof Worksite) {
                                Worksite oldWorksite = (Worksite)msg.getOldValue();
                                oldWorksite.eAdapters().remove((Object)EarthAtmosphereWorksiteNodeJME3Object.this.getAdapter());
                            }
                            if (msg.getNewValue() instanceof Worksite) {
                                Worksite newWorksite = (Worksite)msg.getNewValue();
                                newWorksite.eAdapters().add((Object)EarthAtmosphereWorksiteNodeJME3Object.this.getAdapter());
                                if (newWorksite instanceof EarthAtmosphereWorksite) {
                                    EarthAtmosphereWorksiteNodeJME3Object.this.requestUpdate();
                                }
                            }
                        }
                    } else if (msg.getNotifier() instanceof EarthAtmosphereWorksite && msg.getFeatureID(EarthSurfaceWorksite.class) == 7 && (coord = (GeographicCoordinates)msg.getNewValue()) != null) {
                        EarthAtmosphereWorksiteNodeJME3Object.this.altitude = (float)coord.getElevation();
                        EarthAtmosphereWorksiteNodeJME3Object.this.requestUpdate();
                    }
                }
            };
        }
        return this.adapter;
    }
}

