/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.util.ArrayList;
import javax.vecmath.Color3f;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.impl.AirspaceWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirspaceWorldWindLayerCustomImpl
extends AirspaceWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AirspaceWorldWindLayerImpl.class);
    protected Airspace airspace;

    @Override
    public void setLowerAltitude(double newLowerAltitude) {
        super.setLowerAltitude(newLowerAltitude);
        this.updateRenderableLayer();
    }

    @Override
    public void setUpperAltitude(double newUpperAltitude) {
        super.setUpperAltitude(newUpperAltitude);
        this.updateRenderableLayer();
    }

    @Override
    public void setUrl(String newUrl) {
        super.setUrl(newUrl);
        this.loadFile();
    }

    @Override
    public void setColor(Color3f newColor) {
        super.setColor(newColor);
        this.updateRenderableLayer();
    }

    @Override
    public void setOpacity(double newOpacity) {
        if (newOpacity > 1.0) {
            super.setOpacity(1.0);
        } else if (newOpacity < 0.0) {
            super.setOpacity(0.0);
        } else {
            super.setOpacity(newOpacity);
        }
        this.updateRenderableLayer();
    }

    @Override
    public boolean isCoordinatesInside(GeographicCoordinates coordinates) {
        if (this.airspace != null && coordinates.getElevation() >= this.getLowerAltitude() && coordinates.getElevation() <= this.getUpperAltitude()) {
            Position position = WorldWindUtils.convertToPosition(coordinates);
            Polygon polygon = (Polygon)this.airspace;
            return WWMath.isLocationInside((LatLon)position, (Iterable)polygon.getLocations());
        }
        return false;
    }

    @Override
    public void initialise() {
        this.loadFile();
        super.initialise();
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                this.addRenderable(layer);
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }

    protected void addRenderable(RenderableLayer layer) {
        try {
            if (!this.getGeographicCoordinatesList().isEmpty()) {
                this.airspace = this.createAirspace(this.getWorldWindow());
                layer.addRenderable((Renderable)this.airspace);
            } else {
                this.airspace = null;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    protected Airspace createAirspace(WorldWindow wwd) {
        Polygon poly = new Polygon();
        poly.setAttributes(this.getDefaultAirspaceAttributes());
        poly.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)this.getName());
        poly.setAltitudes(0.0, 0.0);
        poly.setTerrainConforming(true, false);
        this.initializePolygon(wwd, poly);
        return poly;
    }

    protected void initializePolygon(WorldWindow wwd, Polygon polygon) {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (GeographicCoordinates coords : this.getGeographicCoordinatesList()) {
            Position position = WorldWindUtils.convertToPosition(coords);
            positions.add(position);
        }
        if (this.getLowerAltitude() <= 0.0) {
            polygon.setAltitudes(0.0, this.getUpperAltitude());
            polygon.setTerrainConforming(true, false);
        } else {
            polygon.setAltitudes(this.getLowerAltitude(), this.getUpperAltitude());
            polygon.setTerrainConforming(false, false);
        }
        polygon.setLocations(positions);
    }

    protected AirspaceAttributes getDefaultAirspaceAttributes() {
        BasicAirspaceAttributes attributes = new BasicAirspaceAttributes();
        Color color = WorldWindUtils.convertFrom(this.getColor());
        attributes.setMaterial(new Material(color, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.BLACK, 0.0f));
        attributes.setOutlineMaterial(new Material(color, color, color, color, 0.0f));
        attributes.setDrawOutline(true);
        attributes.setOpacity(this.getOpacity());
        attributes.setOutlineOpacity(0.95);
        attributes.setOutlineWidth(2.0);
        return attributes;
    }
}

