/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.util.BufferUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.AbstractTransformationJME3SceneObject;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestNode;
import org.eclipse.apogy.core.environment.surface.ui.scene_objects.FeatureOfInterestSceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOfInterestNodeJME3Object
extends AbstractTransformationJME3SceneObject<FeatureOfInterestNode>
implements FeatureOfInterestSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(FeatureOfInterestNodeJME3Object.class);
    public static final float DEFAULT_FLAG_POLE_HEIGHT = 1.0f;
    public static final int DEFAULT_FONT_SIZE = 16;
    public static final float FLAG_SIZE_PER_PIXEL = 0.005f;
    public static final ColorRGBA FLAG_POLE_COLOR = ColorRGBA.Cyan;
    public static final ColorRGBA FLAG_BACKGROUND_COLOR = ColorRGBA.Black;
    public static final ColorRGBA FLAG_TEXT_COLOR = ColorRGBA.Cyan;
    private float flagPoleHeight = 1.0f;
    private int fontSize = 16;
    private Adapter featureOfInterestNodeAdapter = null;
    private FeatureOfInterestNode featureOfInterestNode = null;
    private AssetManager assetManager;
    private com.jme3.scene.Node pole = null;
    private com.jme3.scene.Node flag = null;
    private Geometry poleGeometry = null;
    private Geometry flagGeometry = null;
    private BillboardControl billboardControl;
    private ColorRGBA flagPoleColor = FLAG_POLE_COLOR;
    private ColorRGBA flagTextColor = FLAG_TEXT_COLOR;
    private final ColorRGBA flagBackgroundColor = FLAG_BACKGROUND_COLOR;

    public FeatureOfInterestNodeJME3Object(FeatureOfInterestNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.featureOfInterestNode = node;
        this.featureOfInterestNode.eAdapters().add((Object)this.getFeatureOfInterestNodeAdapter());
        if (this.featureOfInterestNode.getFeatureOfInterest() != null) {
            this.featureOfInterestNode.getFeatureOfInterest().eAdapters().add((Object)this.getFeatureOfInterestNodeAdapter());
        }
        Job job = new Job("FeatureOfInterestNodeJME3Object : Updating Geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                FeatureOfInterestNodeJME3Object.this.requestUpdate();
                FeatureOfInterestNodeJME3Object.this.setAxisVisible(false);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.poleGeometry != null) {
            geometries.add(this.poleGeometry);
        }
        if (this.flagGeometry != null) {
            geometries.add(this.flagGeometry);
        }
        geometries.addAll(super.getGeometries());
        return geometries;
    }

    public void updateGeometry(float tpf) {
        super.updateGeometry(tpf);
        if (this.pole != null) {
            this.getAttachmentNode().detachChild((Spatial)this.pole);
        }
        if (this.flag != null) {
            this.getAttachmentNode().detachChild((Spatial)this.flag);
        }
        this.poleGeometry = null;
        this.flagGeometry = null;
        this.getBillboardControl().setSpatial(null);
        this.pole = this.createPole(this.flagPoleHeight);
        this.getAttachmentNode().attachChild((Spatial)this.pole);
        this.flag = this.createFlag(this.getFlagText(), this.fontSize);
        this.pole.attachChild((Spatial)this.flag);
    }

    public void setColor(RGB rgb) {
        if (rgb != null) {
            Logger.info("setColor(" + rgb + ")");
            this.flagPoleColor = JME3Utilities.convertToColorRGBA((RGB)rgb);
            this.flagTextColor = JME3Utilities.convertToColorRGBA((RGB)rgb);
            this.requestUpdate();
        } else {
            Logger.error("Cannot set color to null.");
        }
    }

    public void setFlagPoleHeight(float poleHeight) {
        if (poleHeight > 0.0f) {
            Logger.info("Setting flag pole height <" + poleHeight + ">.");
            this.flagPoleHeight = poleHeight;
            this.requestUpdate();
        } else {
            Logger.error("Cannot set flag pole height.");
        }
    }

    public void setFlagVisible(boolean visible) {
        this.setVisible(visible);
    }

    public void setFontSize(int fontSize) {
        if (fontSize > 0) {
            Logger.info("Setting the font size to <" + fontSize + ">.");
            this.fontSize = fontSize;
            this.requestUpdate();
        } else {
            Logger.info("Cannot set the font size to <" + fontSize + ">.");
        }
    }

    private com.jme3.scene.Node createPole(float poleHeight) {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        Vector3f p0 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f p1 = new Vector3f(0.0f, 0.0f, poleHeight);
        verticesList.add(p0);
        verticesList.add(p1);
        indexesList.add(verticesList.indexOf(p0));
        indexesList.add(verticesList.indexOf(p1));
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        this.poleGeometry = new Geometry("Pole", mesh);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", this.flagPoleColor.clone());
        this.poleGeometry.setMaterial(mat);
        com.jme3.scene.Node node = new com.jme3.scene.Node("Pole.");
        node.setShadowMode(RenderQueue.ShadowMode.Off);
        node.attachChild((Spatial)this.poleGeometry);
        return node;
    }

    private String getFlagText() {
        FeatureOfInterest foi;
        String text = "?";
        if (this.getTopologyNode() != null && (foi = ((FeatureOfInterestNode)this.getTopologyNode()).getFeatureOfInterest()) != null && foi.getName() != null && foi.getName().length() > 0) {
            text = foi.getName();
        }
        return text;
    }

    private com.jme3.scene.Node createFlag(String text, int fontSize) {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Flag");
        node.setShadowMode(RenderQueue.ShadowMode.Off);
        com.jme3.scene.Node flagAttachmentPoint = new com.jme3.scene.Node("Flag Attachment Point");
        flagAttachmentPoint.setLocalTranslation(0.0f, 0.0f, this.flagPoleHeight);
        node.attachChild((Spatial)flagAttachmentPoint);
        Font font = new Font("Serif", 1, fontSize);
        BufferedImage bufferedImage = this.createTextImage(text, font, 2);
        float flagWidth = 0.005f * (float)bufferedImage.getWidth();
        float flagHeight = 0.005f * (float)bufferedImage.getHeight();
        Mesh flagMesh = this.createFlagMesh(flagWidth, flagHeight);
        this.flagGeometry = new Geometry("Flag Geometry", flagMesh);
        Material mat = JME3Utilities.createMaterial((BufferedImage)bufferedImage, (AssetManager)this.assetManager);
        this.flagGeometry.setMaterial(mat);
        flagAttachmentPoint.addControl((Control)this.getBillboardControl());
        flagAttachmentPoint.attachChild((Spatial)this.flagGeometry);
        return node;
    }

    private Mesh createFlagMesh(float flagWidth, float flagHeight) {
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(flagWidth, 0.0f, 0.0f), new Vector3f(0.0f, flagHeight, 0.0f), new Vector3f(flagWidth, flagHeight, 0.0f)};
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        int[] indexes = nArray;
        Vector2f[] texCoord = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])texCoord));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])indexes));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private BillboardControl getBillboardControl() {
        if (this.billboardControl == null) {
            this.billboardControl = new BillboardControl();
            this.billboardControl.setAlignment(BillboardControl.Alignment.Screen);
        }
        return this.billboardControl;
    }

    private Adapter getFeatureOfInterestNodeAdapter() {
        if (this.featureOfInterestNodeAdapter == null) {
            this.featureOfInterestNodeAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId;
                    if (msg.getNotifier() instanceof FeatureOfInterestNode) {
                        int featureId2 = msg.getFeatureID(FeatureOfInterestNode.class);
                        if (featureId2 == 5 || featureId2 == 6) {
                            FeatureOfInterestNodeJME3Object.this.requestUpdate();
                        } else if (featureId2 == 7) {
                            if (msg.getOldValue() instanceof FeatureOfInterest) {
                                FeatureOfInterest oldFeatureOfInterest = (FeatureOfInterest)msg.getOldValue();
                                oldFeatureOfInterest.eAdapters().remove((Object)FeatureOfInterestNodeJME3Object.this.getFeatureOfInterestNodeAdapter());
                            }
                            if (msg.getNewValue() instanceof FeatureOfInterest) {
                                FeatureOfInterest newFeatureOfInterest = (FeatureOfInterest)msg.getNewValue();
                                newFeatureOfInterest.eAdapters().add((Object)FeatureOfInterestNodeJME3Object.this.getFeatureOfInterestNodeAdapter());
                                FeatureOfInterestNodeJME3Object.this.requestUpdate();
                            }
                        }
                    } else if (msg.getNotifier() instanceof FeatureOfInterest && (featureId = msg.getFeatureID(FeatureOfInterest.class)) == 2) {
                        FeatureOfInterestNodeJME3Object.this.requestUpdate();
                    }
                }
            };
        }
        return this.featureOfInterestNodeAdapter;
    }

    private BufferedImage createTextImage(String text, Font font, int borderWidth) {
        Color textColor = JME3Utilities.convertToAWTColor((ColorRGBA)this.flagTextColor);
        Color backgroundColor = JME3Utilities.convertToAWTColor((ColorRGBA)this.flagBackgroundColor);
        AbstractEImage original = EImagesUtilities.INSTANCE.createTextImage(text, font, textColor, backgroundColor, borderWidth);
        int[] borderColor = JME3Utilities.convertToColorIntRGBA((ColorRGBA)this.flagPoleColor);
        AbstractEImage imageWithBorder = EImagesUtilities.INSTANCE.addBorder(original, borderWidth, borderColor[0], borderColor[1], borderColor[2]);
        return imageWithBorder.asBufferedImage();
    }
}

