/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.impl;

import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.apogy.core.environment.surface.ui.impl.DefaultVariableTrajectoryProviderImpl;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class DefaultVariableTrajectoryProviderCustomImpl
extends DefaultVariableTrajectoryProviderImpl {
    private Adapter poseProviderAdapter = null;
    private Point3d previousPosition = null;
    private double previousAzimuth = Double.NaN;

    @Override
    public void setPoseProvider(PoseProvider newPoseProvider) {
        if (this.poseProvider != null) {
            this.poseProvider.eAdapters().remove((Object)this.getPoseProviderAdapter());
        }
        super.setPoseProvider(newPoseProvider);
        if (newPoseProvider != null) {
            newPoseProvider.eAdapters().add((Object)this.getPoseProviderAdapter());
        }
    }

    @Override
    public void initialize() {
        if (this.getVariableAnnotation() != null && this.getVariableAnnotation().getVariable() != null) {
            try {
                AbstractTypeImplementation abstractTypeImplementation = ApogyCoreInvocatorFacade.INSTANCE.getTypeImplementation(this.getVariableAnnotation().getVariable());
                if (abstractTypeImplementation.getAdapterInstance() instanceof ApogySystemApiAdapter) {
                    ApogySystemApiAdapter apogySystemApiAdapter = (ApogySystemApiAdapter)abstractTypeImplementation.getAdapterInstance();
                    this.setPoseProvider((PoseProvider)apogySystemApiAdapter);
                    this.previousPosition = null;
                    this.previousAzimuth = Double.NaN;
                    if (apogySystemApiAdapter.getPoseTransform() != null) {
                        this.updatePose(apogySystemApiAdapter.getPoseTransform());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setTrajectoryLength(0.0);
    }

    protected void updatePosition(Tuple3d newPosition) {
        XYDataItem xyDataItem = new XYDataItem(newPosition.getX(), newPosition.getY());
        this.getXYSeries().add(xyDataItem);
        this.setLatestPosition(xyDataItem);
        this.previousPosition = new Point3d(newPosition.asTuple3d());
    }

    protected void updateAzimuth(double newAzimuth) {
        this.setAzimuthAngle(newAzimuth);
        this.previousAzimuth = newAzimuth;
    }

    protected void updatePose(Matrix4x4 newPose) {
        Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractPosition(newPose);
        Tuple3d orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(newPose);
        if (this.previousPosition == null) {
            this.updatePosition(position);
        } else {
            Point3d currentPosition = new Point3d(position.asTuple3d());
            double distance = this.previousPosition.distance(currentPosition);
            if (distance >= this.getDistanceThreshold()) {
                this.setTrajectoryLength(this.getTrajectoryLength() + distance);
                this.updatePosition(position);
            }
        }
        double currentAzimuth = orientation.getZ();
        if (Double.isNaN(this.previousAzimuth) || Math.abs(this.previousAzimuth - currentAzimuth) > Math.abs(this.getAzimuthThreshold())) {
            this.updateAzimuth(currentAzimuth);
        }
    }

    protected Adapter getPoseProviderAdapter() {
        if (this.poseProviderAdapter == null) {
            this.poseProviderAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(PoseProvider.class) == 0 && msg.getNewValue() instanceof Matrix4x4) {
                        Matrix4x4 newPose = (Matrix4x4)msg.getNewValue();
                        DefaultVariableTrajectoryProviderCustomImpl.this.updatePose(newPose);
                    }
                }
            };
        }
        return this.poseProviderAdapter;
    }

    @Override
    public void clear() {
    }

    @Override
    public List<Point2d> asListOfPoint2d() {
        return null;
    }

    @Override
    public XYSeries getXYSeries() {
        return null;
    }
}

