/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshHeightImageMapLayer;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.ui.ImageMapLayerUISettings;
import org.eclipse.apogy.core.environment.surface.ui.composites.ImageMapLayerPreviewComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CartesianTriangularMeshHeightImageMapLayerWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.CartesianTriangularMeshHeightImageMapLayerWizardPage";
    private final CartesianTriangularMeshHeightImageMapLayer cartesianTriangularMeshHeightImageMapLayer;
    private final ImageMapLayerUISettings uiSettings;
    private Button btnAutoScale;
    private Text txtMinimumHeight;
    private Text txtMaximumHeight;
    private ImageMapLayerPreviewComposite imagePreviewComposite;
    private DataBindingContext m_bindingContext;

    public CartesianTriangularMeshHeightImageMapLayerWizardPage(CartesianTriangularMeshHeightImageMapLayer cartesianTriangularMeshHeightImageMapLayer, ImageMapLayerUISettings uiSettings) {
        super(WIZARD_PAGE_ID);
        this.setTitle("Mesh Height Image Layer Settings.");
        this.cartesianTriangularMeshHeightImageMapLayer = cartesianTriangularMeshHeightImageMapLayer;
        this.uiSettings = uiSettings;
        this.setTitle("Height Image Layer");
        this.setDescription("Configure the height image generation settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblMinimumSlope = new Label(container, 0);
        lblMinimumSlope.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMinimumSlope.setText("Minimum Height (m):");
        this.txtMinimumHeight = new Text(container, 2048);
        GridData gd_txtMinimumSlope = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMinimumSlope.minimumWidth = 100;
        gd_txtMinimumSlope.widthHint = 100;
        this.txtMinimumHeight.setLayoutData((Object)gd_txtMinimumSlope);
        this.txtMinimumHeight.setToolTipText("The minimum height to use to generate the color scale. This is applicable only if autoScale is enabled.");
        this.txtMinimumHeight.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                CartesianTriangularMeshHeightImageMapLayerWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                CartesianTriangularMeshHeightImageMapLayerWizardPage.this.validate();
            }
        });
        Label lblMaximumSlope = new Label(container, 0);
        lblMaximumSlope.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMaximumSlope.setText("Maximum Height (m):");
        this.txtMaximumHeight = new Text(container, 2048);
        GridData gd_txtMaximumSlope = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtMaximumSlope.minimumWidth = 100;
        gd_txtMaximumSlope.widthHint = 100;
        this.txtMaximumHeight.setLayoutData((Object)gd_txtMaximumSlope);
        this.txtMaximumHeight.setToolTipText("The maximum height to use to generate the color scale. This is applicable only if autoScale is enabled.");
        this.txtMaximumHeight.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                CartesianTriangularMeshHeightImageMapLayerWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                CartesianTriangularMeshHeightImageMapLayerWizardPage.this.validate();
            }
        });
        Label lblAutoScale = new Label(container, 0);
        lblAutoScale.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAutoScale.setText("Auto Scale:");
        this.btnAutoScale = new Button(container, 32);
        this.btnAutoScale.setAlignment(131072);
        this.btnAutoScale.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnAutoScale.setText("");
        this.btnAutoScale.setToolTipText("Whether or not to use autoscalling to generate the color scale.");
        Group imageGroup = new Group(container, 2048);
        imageGroup.setLayout((Layout)new GridLayout(1, false));
        imageGroup.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        imageGroup.setText("Derived Image");
        this.imagePreviewComposite = new ImageMapLayerPreviewComposite((Composite)imageGroup, 0, (ImageMapLayer)this.cartesianTriangularMeshHeightImageMapLayer);
        GridData gd_imagePreviewComposite = new GridData(4, 4, true, true, 1, 1);
        gd_imagePreviewComposite.widthHint = 500;
        gd_imagePreviewComposite.heightHint = 350;
        gd_imagePreviewComposite.minimumHeight = 350;
        gd_imagePreviewComposite.minimumWidth = 500;
        this.imagePreviewComposite.setLayoutData(gd_imagePreviewComposite);
        this.imagePreviewComposite.setImageMapLayer((ImageMapLayer)this.cartesianTriangularMeshHeightImageMapLayer);
        this.setControl((Control)container);
        new Label(container, 0);
        new Label(container, 0);
        this.m_bindingContext = this.initDataBindingsCustom();
        this.validate();
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CartesianTriangularMeshHeightImageMapLayerWizardPage.this.m_bindingContext != null) {
                    CartesianTriangularMeshHeightImageMapLayerWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.cartesianTriangularMeshHeightImageMapLayer.getMinimumHeight() >= this.cartesianTriangularMeshHeightImageMapLayer.getMaximumHeight()) {
            this.setErrorMessage("Maximum height must be greater than the minimum height !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeMinimumSlope = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.cartesianTriangularMeshHeightImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_HEIGHT_IMAGE_MAP_LAYER__MINIMUM_HEIGHT})).observe((Object)this.cartesianTriangularMeshHeightImageMapLayer);
        ISWTObservableValue observeMinimumSlopeText = WidgetProperties.text((int)24).observe((Widget)this.txtMinimumHeight);
        bindingContext.bindValue((IObservableValue)observeMinimumSlopeText, observeMinimumSlope, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        IObservableValue observeMaximumSlope = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.cartesianTriangularMeshHeightImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_HEIGHT_IMAGE_MAP_LAYER__MAXIMUM_HEIGHT})).observe((Object)this.cartesianTriangularMeshHeightImageMapLayer);
        ISWTObservableValue observeMaximumSlopeText = WidgetProperties.text((int)24).observe((Widget)this.txtMaximumHeight);
        bindingContext.bindValue((IObservableValue)observeMaximumSlopeText, observeMaximumSlope, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        IObservableValue observeAutoscale = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.cartesianTriangularMeshHeightImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_HEIGHT_IMAGE_MAP_LAYER__AUTO_SCALE})).observe((Object)this.cartesianTriangularMeshHeightImageMapLayer);
        ISWTObservableValue observeAutoscaleButtton = WidgetProperties.selection().observe((Widget)this.btnAutoScale);
        bindingContext.bindValue((IObservableValue)observeAutoscaleButtton, observeAutoscale, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }

    public class CompositeFilterContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Map) {
                Map map = (Map)element;
                return !this.filterMap(map).isEmpty();
            }
            return false;
        }

        protected List<CartesianTriangularMeshMapLayer> filterMap(Map map) {
            ArrayList<CartesianTriangularMeshMapLayer> imageMapLayers = new ArrayList<CartesianTriangularMeshMapLayer>();
            for (AbstractMapLayer layer : map.getLayers()) {
                if (!(layer instanceof CartesianTriangularMeshMapLayer)) continue;
                imageMapLayers.add((CartesianTriangularMeshMapLayer)layer);
            }
            return imageMapLayers;
        }
    }
}

