/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSetExtent;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.ImageMapLayerPresentation;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.RectangularRegion;
import org.eclipse.apogy.core.environment.surface.RectangularRegionImage;
import org.eclipse.apogy.core.environment.surface.RectangularRegionProvider;
import org.eclipse.apogy.core.environment.surface.RectangularVolumeRegion;
import org.eclipse.apogy.core.environment.surface.impl.ApogySurfaceEnvironmentFacadeImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySurfaceEnvironmentFacadeCustomImpl
extends ApogySurfaceEnvironmentFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySurfaceEnvironmentFacadeImpl.class);

    @Override
    public AbstractEImage createEImage(List<? extends RectangularRegionImage> rectangularRegionImages) {
        AbstractEImage result = null;
        if (!rectangularRegionImages.isEmpty()) {
            Tuple3d lowerLeftCorner = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
            Tuple3d upperRightCorner = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
            this.getRectangularRegionImageExtent(rectangularRegionImages, lowerLeftCorner, upperRightCorner);
            Tuple3d upperLeftCorner = ApogyCommonMathFacade.INSTANCE.createTuple3d(lowerLeftCorner.getX(), upperRightCorner.getY(), 0.0);
            double terrainWidth = upperRightCorner.getX() - lowerLeftCorner.getX();
            double terrainHeight = upperRightCorner.getY() - lowerLeftCorner.getY();
            RectangularRegionImage bestResolutionLayer = this.getBestResolutionRectangularRegionImage(rectangularRegionImages);
            double bestResolution = bestResolutionLayer.getResolution();
            int width = (int)Math.round(terrainWidth / bestResolution);
            int height = (int)Math.round(terrainHeight / bestResolution);
            result = EImagesUtilities.INSTANCE.createTransparentImage(width, height);
            for (RectangularRegionImage rectangularRegionImage : rectangularRegionImages) {
                try {
                    List<Tuple3d> corners = this.getAbsoluteRectangularRegionCorners(rectangularRegionImage.getRegion());
                    Tuple3d layerUpperLeftCorner = corners.get(3);
                    int x = (int)Math.round((layerUpperLeftCorner.getX() - upperLeftCorner.getX()) / bestResolution);
                    int y = (int)Math.round((upperLeftCorner.getY() - layerUpperLeftCorner.getY()) / bestResolution);
                    AbstractEImage eImage = EImagesUtilities.INSTANCE.copy(rectangularRegionImage.getRegionImage());
                    double scaleFactor = rectangularRegionImage.getResolution() / bestResolution;
                    eImage = EImagesUtilities.INSTANCE.resize(eImage, scaleFactor);
                    double zRotation = 0.0;
                    if (rectangularRegionImage.getRegion().getTransformation() != null) {
                        Tuple3d orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(rectangularRegionImage.getRegion().getTransformation());
                        zRotation = orientation.getZ();
                    }
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(x, y);
                    affineTransform.rotate(-zRotation);
                    Graphics2D g = result.asBufferedImage().createGraphics();
                    g.drawImage(eImage.asBufferedImage(), affineTransform, null);
                    g.dispose();
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        } else {
            result = EImagesUtilities.INSTANCE.createTransparentImage(1, 1);
        }
        return result;
    }

    @Override
    public List<Tuple3d> getAbsoluteRectangularRegionCorners(RectangularRegion rectangularRegion) {
        Point3d[] corners = new Point3d[]{new Point3d(rectangularRegion.getLowerLeftCorner().asTuple3d()), new Point3d(rectangularRegion.getLowerRightCorner().asTuple3d()), new Point3d(rectangularRegion.getUpperRightCorner().asTuple3d()), new Point3d(rectangularRegion.getUpperLeftCorner().asTuple3d())};
        Matrix4x4 matrix4x4 = rectangularRegion.getTransformation();
        Matrix4d m = null;
        if (matrix4x4 != null) {
            m = matrix4x4.asMatrix4d();
        } else {
            m = new Matrix4d();
            m.setIdentity();
        }
        int i = 0;
        while (i < corners.length) {
            m.transform(corners[i]);
            ++i;
        }
        ArrayList<Tuple3d> results = new ArrayList<Tuple3d>();
        int i2 = 0;
        while (i2 < corners.length) {
            Tuple3d p = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)corners[i2]);
            results.add(p);
            ++i2;
        }
        return results;
    }

    @Override
    public RectangularRegionImage getBestResolutionRectangularRegionImage(List<? extends RectangularRegionImage> rectangularRegionImages) {
        RectangularRegionImage best = null;
        for (RectangularRegionImage rectangularRegionImage : rectangularRegionImages) {
            if (best != null && !(rectangularRegionImage.getResolution() < best.getResolution())) continue;
            best = rectangularRegionImage;
        }
        return best;
    }

    @Override
    public void getRectangularRegionExtent(RectangularRegionProvider rectangularRegionProvider, Tuple3d lowerLeftCorner, Tuple3d upperRightCorner) {
        RectangularRegion rectangularRegion = rectangularRegionProvider.getRegion();
        List<Tuple3d> corners = this.getAbsoluteRectangularRegionCorners(rectangularRegion);
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        for (Tuple3d p : corners) {
            if (p.getX() < xMin) {
                xMin = p.getX();
            }
            if (p.getX() > xMax) {
                xMax = p.getX();
            }
            if (p.getY() < yMin) {
                yMin = p.getY();
            }
            if (!(p.getY() > yMax)) continue;
            yMax = p.getY();
        }
        lowerLeftCorner.setX(xMin);
        lowerLeftCorner.setY(yMin);
        lowerLeftCorner.setZ(0.0);
        upperRightCorner.setX(xMax);
        upperRightCorner.setY(yMax);
        upperRightCorner.setZ(0.0);
    }

    @Override
    public void getRectangularRegionImageExtent(RectangularRegionImage rectangularRegionImage, Tuple3d lowerLeftCorner, Tuple3d upperRightCorner) {
        RectangularRegion rectangularRegion = rectangularRegionImage.getRegion();
        List<Tuple3d> corners = this.getAbsoluteRectangularRegionCorners(rectangularRegion);
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        for (Tuple3d p : corners) {
            if (p.getX() < xMin) {
                xMin = p.getX();
            }
            if (p.getX() > xMax) {
                xMax = p.getX();
            }
            if (p.getY() < yMin) {
                yMin = p.getY();
            }
            if (!(p.getY() > yMax)) continue;
            yMax = p.getY();
        }
        lowerLeftCorner.setX(xMin);
        lowerLeftCorner.setY(yMin);
        lowerLeftCorner.setZ(0.0);
        upperRightCorner.setX(xMax);
        upperRightCorner.setY(yMax);
        upperRightCorner.setZ(0.0);
    }

    @Override
    public void getRectangularRegionExtent(List<? extends RectangularRegionProvider> rectangularRegionProviders, Tuple3d lowerLeftCorner, Tuple3d upperRightCorner) {
        if (!rectangularRegionProviders.isEmpty()) {
            double xMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (RectangularRegionProvider rectangularRegionProvider : rectangularRegionProviders) {
                Tuple3d tmpLowerLeftCorner = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
                Tuple3d tmpUpperRightCorner = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
                this.getRectangularRegionExtent(rectangularRegionProvider, tmpLowerLeftCorner, tmpUpperRightCorner);
                if (tmpLowerLeftCorner.getX() < xMin) {
                    xMin = tmpLowerLeftCorner.getX();
                }
                if (tmpLowerLeftCorner.getY() < yMin) {
                    yMin = tmpLowerLeftCorner.getY();
                }
                if (tmpUpperRightCorner.getX() > xMax) {
                    xMax = tmpUpperRightCorner.getX();
                }
                if (!(tmpUpperRightCorner.getY() > yMax)) continue;
                yMax = tmpUpperRightCorner.getY();
            }
            lowerLeftCorner.setX(xMin);
            lowerLeftCorner.setY(yMin);
            upperRightCorner.setX(xMax);
            upperRightCorner.setY(yMax);
        } else {
            lowerLeftCorner.setX(0.0);
            lowerLeftCorner.setY(0.0);
            upperRightCorner.setX(0.0);
            upperRightCorner.setY(0.0);
        }
    }

    @Override
    public void getRectangularRegionImageExtent(List<? extends RectangularRegionImage> rectangularRegionImages, Tuple3d lowerLeftCorner, Tuple3d upperRightCorner) {
        if (!rectangularRegionImages.isEmpty()) {
            double xMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (RectangularRegionImage rectangularRegionImage : rectangularRegionImages) {
                Tuple3d tmpLowerLeftCorner = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
                Tuple3d tmpUpperRightCorner = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
                this.getRectangularRegionImageExtent(rectangularRegionImage, tmpLowerLeftCorner, tmpUpperRightCorner);
                if (tmpLowerLeftCorner.getX() < xMin) {
                    xMin = tmpLowerLeftCorner.getX();
                }
                if (tmpLowerLeftCorner.getY() < yMin) {
                    yMin = tmpLowerLeftCorner.getY();
                }
                if (tmpUpperRightCorner.getX() > xMax) {
                    xMax = tmpUpperRightCorner.getX();
                }
                if (!(tmpUpperRightCorner.getY() > yMax)) continue;
                yMax = tmpUpperRightCorner.getY();
            }
            lowerLeftCorner.setX(xMin);
            lowerLeftCorner.setY(yMin);
            upperRightCorner.setX(xMax);
            upperRightCorner.setY(yMax);
        } else {
            lowerLeftCorner.setX(0.0);
            lowerLeftCorner.setY(0.0);
            upperRightCorner.setX(0.0);
            upperRightCorner.setY(0.0);
        }
    }

    @Override
    public boolean fitsInside(RectangularRegion rectangularRegionA, RectangularRegion rectangularRegionB) {
        Matrix4d transform = new Matrix4d();
        transform.setIdentity();
        if (rectangularRegionA.getTransformation() != null) {
            transform = new Matrix4d(rectangularRegionA.getTransformation().asMatrix4d());
        }
        if (rectangularRegionB.getTransformation() != null) {
            Matrix4d m = new Matrix4d(rectangularRegionB.getTransformation().asMatrix4d());
            m.invert();
            transform.mul(m);
        }
        Point3d[] corners = new Point3d[]{new Point3d(rectangularRegionA.getLowerLeftCorner().asTuple3d()), new Point3d(rectangularRegionA.getLowerRightCorner().asTuple3d()), new Point3d(rectangularRegionA.getUpperRightCorner().asTuple3d()), new Point3d(rectangularRegionA.getUpperLeftCorner().asTuple3d())};
        int i = 0;
        while (i < corners.length) {
            transform.transform(corners[i]);
            ++i;
        }
        boolean inside = true;
        int i2 = 0;
        while (i2 < corners.length && inside) {
            Point3d corner = corners[i2];
            inside = corner.getX() >= rectangularRegionB.getXMin() && corner.getX() <= rectangularRegionB.getXMax() && corner.getY() >= rectangularRegionB.getYMin() && corner.getY() <= rectangularRegionB.getYMax();
            ++i2;
        }
        return inside;
    }

    @Override
    public boolean intersects(RectangularRegion rectangularRegionA, RectangularRegion rectangularRegionB, Matrix4x4 transformAToB) {
        return true;
    }

    @Override
    public void getImageMapLayerPresentationExtent(ImageMapLayerPresentation imageMapLayerPresentation, Tuple3d lowerLeftCorner, Tuple3d upperRightCorner) {
        ApogySurfaceEnvironmentFacade.INSTANCE.getRectangularRegionImageExtent(imageMapLayerPresentation.getImageMapLayer(), lowerLeftCorner, upperRightCorner);
    }

    @Override
    public void getImageMapLayerPresentationExtent(List<ImageMapLayerPresentation> imageMapLayerPresentations, Tuple3d lowerLeftCorner, Tuple3d upperRightCorner) {
        List<ImageMapLayerPresentation> visiblePresentations = this.getVisibleImageMapLayerPresentation(imageMapLayerPresentations);
        ApogySurfaceEnvironmentFacade.INSTANCE.getRectangularRegionImageExtent(visiblePresentations, lowerLeftCorner, upperRightCorner);
    }

    @Override
    public AbstractEImage getImageMapLayerPresentationImage(List<ImageMapLayerPresentation> imageMapLayerPresentations) {
        AbstractEImage result = null;
        if (!imageMapLayerPresentations.isEmpty()) {
            List<ImageMapLayerPresentation> visiblePresentations = this.getVisibleImageMapLayerPresentation(imageMapLayerPresentations);
            result = ApogySurfaceEnvironmentFacade.INSTANCE.createEImage(visiblePresentations);
        }
        return result;
    }

    @Override
    public ImageMapLayerPresentation getBestResolutionMapLayer(List<ImageMapLayerPresentation> imageMapLayerPresentations) {
        List<ImageMapLayerPresentation> visibleLayers = this.getVisibleImageMapLayerPresentation(imageMapLayerPresentations);
        ImageMapLayerPresentation best = null;
        for (ImageMapLayerPresentation layer : visibleLayers) {
            if (layer == null || layer.getImageMapLayer() == null || best != null && !(layer.getImageMapLayer().getResolution() < best.getImageMapLayer().getResolution())) continue;
            best = layer;
        }
        return best;
    }

    @Override
    public List<ImageMapLayerPresentation> getVisibleImageMapLayerPresentation(List<ImageMapLayerPresentation> imageMapLayerPresentations) {
        ArrayList<ImageMapLayerPresentation> visibleLayers = new ArrayList<ImageMapLayerPresentation>();
        for (ImageMapLayerPresentation layer : imageMapLayerPresentations) {
            if (!layer.isVisible() || layer.getImageMapLayer() == null) continue;
            visibleLayers.add(layer);
        }
        return visibleLayers;
    }

    @Override
    public RectangularVolumeRegion getRectangularVolumeRegion(CartesianTriangularMesh mesh) {
        RectangularVolumeRegion rectangularVolumeRegion = ApogySurfaceEnvironmentFactory.eINSTANCE.createRectangularVolumeRegion();
        if (mesh != null) {
            CartesianCoordinatesSetExtent extent = mesh.getExtent();
            rectangularVolumeRegion.setXMin(extent.getXMin());
            rectangularVolumeRegion.setXMax(extent.getXMax());
            rectangularVolumeRegion.setYMin(extent.getYMin());
            rectangularVolumeRegion.setYMax(extent.getYMax());
            rectangularVolumeRegion.setZMin(extent.getZMin());
            rectangularVolumeRegion.setZMax(extent.getZMax());
        } else {
            rectangularVolumeRegion = ApogySurfaceEnvironmentFactory.eINSTANCE.createRectangularVolumeRegion();
        }
        rectangularVolumeRegion.setTransformation(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4());
        return rectangularVolumeRegion;
    }

    @Override
    public void deleteLayerFromMap(Map map, AbstractMapLayer abstractMapLayer) {
        if (abstractMapLayer != null && map.getLayers().contains((Object)abstractMapLayer)) {
            abstractMapLayer.dispose();
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)map, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS, (Object)abstractMapLayer);
        }
    }
}

