/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DisplayedTopology implements Enumerator
{
    ASSEMBLY(1, "ASSEMBLY", "Assembly"),
    SYSTEM(2, "SYSTEM", "System");

    public static final int ASSEMBLY_VALUE = 1;
    public static final int SYSTEM_VALUE = 2;
    private static final DisplayedTopology[] VALUES_ARRAY;
    public static final List<DisplayedTopology> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DisplayedTopology[]{ASSEMBLY, SYSTEM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DisplayedTopology get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DisplayedTopology result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DisplayedTopology getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DisplayedTopology result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DisplayedTopology get(int value) {
        switch (value) {
            case 1: {
                return ASSEMBLY;
            }
            case 2: {
                return SYSTEM;
            }
        }
        return null;
    }

    private DisplayedTopology(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

