/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.URLNodePresentation;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.ConnectionPoint;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFactory;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyPackage;
import org.eclipse.apogy.core.topology.TemporaryAssemblyNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySystem3dUtils {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySystem3dUtils.class);

    public static Node assembleSubSystem(ApogySystem apogySystem) {
        HashMap<Node, Node> originalNodesToCopy = new HashMap<Node, Node>();
        HashMap<AssemblyLink, Node> originalAssemblyLinkGeometryToCopy = new HashMap<AssemblyLink, Node>();
        Map<Object, Node> systemsToRootNodeMap = ApogySystem3dUtils.createSubsystemTopologyCopies(apogySystem, originalNodesToCopy, originalAssemblyLinkGeometryToCopy);
        Node root = systemsToRootNodeMap.get(apogySystem);
        if (apogySystem.getAssemblyLinksList() != null) {
            for (AssemblyLink assemblyLink : apogySystem.getAssemblyLinksList().getAssemblyLinks()) {
                ApogySystem3dUtils.assemble(assemblyLink, originalNodesToCopy, systemsToRootNodeMap, originalAssemblyLinkGeometryToCopy);
            }
        }
        return root;
    }

    public static List<TypeMember> getAllTypeMembers(ApogySystem masterApogySystem) {
        ArrayList<TypeMember> list = new ArrayList<TypeMember>();
        for (TypeMember member : masterApogySystem.getMembers()) {
            list.addAll(ApogySystem3dUtils.recursiveGetAllTypeMembers(masterApogySystem, member));
        }
        return list;
    }

    public static Map<Object, Node> createSubsystemTopologyCopies(ApogySystem apogySystem, Map<Node, Node> originalNodesToCopy, Map<AssemblyLink, Node> originalAssemblyLinkGeometryToCopy) {
        List<TypeMember> typeMembers = ApogySystem3dUtils.getAllTypeMembers(apogySystem);
        HashMap<Object, Node> typeMemberToRootNode = new HashMap<Object, Node>();
        if (apogySystem.getTopologyRoot() != null && apogySystem.getTopologyRoot().getOriginNode() != null) {
            Node originalRoot = apogySystem.getTopologyRoot().getOriginNode();
            Node copyRoot = ApogySystem3dUtils.copyTopology(originalRoot, originalNodesToCopy);
            typeMemberToRootNode.put(apogySystem, copyRoot);
        }
        if (apogySystem.getAssemblyLinksList() != null) {
            for (AssemblyLink assemblyLink : apogySystem.getAssemblyLinksList().getAssemblyLinks()) {
                if (assemblyLink.getGeometryNode() == null) continue;
                Node originalGeometry = assemblyLink.getGeometryNode();
                Node copyGeometry = ApogySystem3dUtils.copyTopology(originalGeometry, originalNodesToCopy);
                originalAssemblyLinkGeometryToCopy.put(assemblyLink, copyGeometry);
            }
        }
        for (TypeMember typeMember : typeMembers) {
            ApogySystem subSystem;
            if (!(typeMember.getMemberType() instanceof ApogySystem) || (subSystem = (ApogySystem)typeMember.getMemberType()).getTopologyRoot() == null || subSystem.getTopologyRoot().getOriginNode() == null) continue;
            Node originalRoot = subSystem.getTopologyRoot().getOriginNode();
            Node copyRoot = ApogySystem3dUtils.copyTopology(originalRoot, originalNodesToCopy);
            typeMemberToRootNode.put(typeMember, copyRoot);
            if (subSystem.getAssemblyLinksList() == null) continue;
            for (AssemblyLink assemblyLink : subSystem.getAssemblyLinksList().getAssemblyLinks()) {
                if (assemblyLink.getGeometryNode() == null) continue;
                Node originalGeometry = assemblyLink.getGeometryNode();
                Node copyGeometry = ApogySystem3dUtils.copyTopology(originalGeometry, originalNodesToCopy);
                originalAssemblyLinkGeometryToCopy.put(assemblyLink, copyGeometry);
            }
        }
        return typeMemberToRootNode;
    }

    public static void assemble(AssemblyLink originalAssemblyLink, Map<Node, Node> originalNodesToCopy, Map<Object, Node> typeMemberToRootNode, Map<AssemblyLink, Node> originalAssemblyLinkGeometryToCopy) {
        ApogySystem subSystem;
        TypeMember subsSystemTypeMember;
        Node subSystemRoot;
        GroupNode copyParentNode;
        GroupNode originalParentNode;
        ConnectionPoint originalConnectionPoint = originalAssemblyLink.getParentConnectionPoint();
        if (originalConnectionPoint != null && (originalParentNode = originalConnectionPoint.getNode()) instanceof GroupNode && (copyParentNode = (GroupNode)originalNodesToCopy.get(originalParentNode)) != null && (subSystemRoot = typeMemberToRootNode.get(subsSystemTypeMember = originalAssemblyLink.getSubSystemTypeMember())) != null) {
            TemporaryAssemblyNode temporaryAssemblyNode = ApogyCoreTopologyFactory.eINSTANCE.createTemporaryAssemblyNode();
            temporaryAssemblyNode.setNodeId(subsSystemTypeMember.getName());
            copyParentNode.getChildren().add((Object)temporaryAssemblyNode);
            TransformNode transformNode = ApogyCommonTopologyFactory.eINSTANCE.createTransformNode();
            transformNode.setNodeId("ASSEMBLY_LINK_" + originalAssemblyLink.getName());
            transformNode.setDescription(originalAssemblyLink.getDescription());
            if (originalAssemblyLink.getTransformationMatrix() != null) {
                transformNode.setTransformation(originalAssemblyLink.getTransformationMatrix().asMatrix4d());
            } else {
                transformNode.setTransformation(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4().asMatrix4d());
            }
            temporaryAssemblyNode.getChildren().add((Object)transformNode);
            if (subSystemRoot != null) {
                transformNode.getChildren().add((Object)subSystemRoot);
            }
            if (originalAssemblyLink.getGeometryNode() != null) {
                Node copyGeometry = originalAssemblyLinkGeometryToCopy.get(originalAssemblyLink);
                temporaryAssemblyNode.getChildren().add((Object)copyGeometry);
            }
        }
        if (originalAssemblyLink.getSubSystemTypeMember().getMemberType() instanceof ApogySystem && (subSystem = (ApogySystem)originalAssemblyLink.getSubSystemTypeMember().getMemberType()).getAssemblyLinksList() != null) {
            for (AssemblyLink assemblyLink : subSystem.getAssemblyLinksList().getAssemblyLinks()) {
                ApogySystem3dUtils.assemble(assemblyLink, originalNodesToCopy, typeMemberToRootNode, originalAssemblyLinkGeometryToCopy);
            }
        }
    }

    public static Type load(Type type, ApogySystem master) {
        if (type != null && type.eIsProxy()) {
            Type loadedType = null;
            ResourceSet resourceSet = master.eResource().getResourceSet();
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map m = reg.getExtensionToFactoryMap();
            m.put("*", new XMIResourceFactoryImpl());
            URI uri = EcoreUtil.getURI((EObject)type);
            Resource resource = resourceSet.createResource(uri);
            try {
                loadedType = (Type)resource.getContents().get(0);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            return loadedType;
        }
        return type;
    }

    public static Node copyTopology(Node originalRoot, Map<Node, Node> originalNodesToCopy) {
        Node copyRoot = null;
        if (originalRoot != null) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copyRoot = (Node)copier.copy((EObject)originalRoot);
            originalNodesToCopy.put(originalRoot, copyRoot);
            for (EObject key : copier.keySet()) {
                EObject value = (EObject)copier.get((Object)key);
                if (!(key instanceof Node) || !(value instanceof Node)) continue;
                Node nodeCopy = (Node)value;
                nodeCopy.setNodeId(nodeCopy.getNodeId());
                originalNodesToCopy.put((Node)key, (Node)value);
            }
        }
        return copyRoot;
    }

    public static void setSubSystemVisibility(Node root, boolean visible) {
        if (root != null) {
            EList temporaryAssemblyNode = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCoreTopologyPackage.Literals.TEMPORARY_ASSEMBLY_NODE, root);
            for (Node node : temporaryAssemblyNode) {
                NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode(node);
                if (nodePresentation == null) continue;
                nodePresentation.setVisible(visible);
            }
        }
    }

    public static void setSubSystemMode(Node root, MeshPresentationMode newMeshPresentationMode) {
        if (root != null) {
            EList temporaryAssemblyNodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCoreTopologyPackage.Literals.TEMPORARY_ASSEMBLY_NODE, root);
            for (Node temporaryAssemblyNode : temporaryAssemblyNodes) {
                EList urlNodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCommonTopologyPackage.Literals.URL_NODE, temporaryAssemblyNode);
                for (Node node : urlNodes) {
                    NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode(node);
                    if (!(nodePresentation instanceof URLNodePresentation)) continue;
                    URLNodePresentation urlNodePresentation = (URLNodePresentation)nodePresentation;
                    urlNodePresentation.setPresentationMode(newMeshPresentationMode);
                }
            }
        }
    }

    protected static List<TypeMember> recursiveGetAllTypeMembers(ApogySystem masterApogySystem, TypeMember typeMember) {
        ArrayList<TypeMember> list = new ArrayList<TypeMember>();
        list.add(typeMember);
        Type type = ApogySystem3dUtils.load(typeMember.getMemberType(), masterApogySystem);
        if (type != null) {
            for (TypeMember member : type.getMembers()) {
                list.addAll(ApogySystem3dUtils.recursiveGetAllTypeMembers(masterApogySystem, member));
            }
        }
        return list;
    }
}

