/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.apogy.core.FeatureOfInterestNode;
import org.eclipse.apogy.core.impl.FeatureOfInterestListNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOfInterestListNodeCustomImpl
extends FeatureOfInterestListNodeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(FeatureOfInterestListNodeImpl.class);
    private final Map<FeatureOfInterest, FeatureOfInterestNode> foiToNodeMap = new HashMap<FeatureOfInterest, FeatureOfInterestNode>();
    private Adapter adapter;

    @Override
    public void setFeatureOfInterestList(FeatureOfInterestList newFeatureOfInterestList) {
        FeatureOfInterestList oldList = this.featureOfInterestList;
        super.setFeatureOfInterestList(newFeatureOfInterestList);
        this.updateFeatureOfInterestList(oldList, newFeatureOfInterestList);
    }

    protected void addFeatureOfInterest(FeatureOfInterest foi) {
        FeatureOfInterestNode featureOfInterestNode = ApogyCoreFactory.eINSTANCE.createFeatureOfInterestNode();
        featureOfInterestNode.setFeatureOfInterest(foi);
        if (foi.getName() != null && foi.getName().length() > 0) {
            featureOfInterestNode.setNodeId(foi.getName());
        } else {
            featureOfInterestNode.setNodeId("FOI_" + System.currentTimeMillis());
        }
        this.foiToNodeMap.put(foi, featureOfInterestNode);
        this.getChildren().add((Object)featureOfInterestNode);
    }

    protected void removeFeatureOfInterest(FeatureOfInterest foi) {
        FeatureOfInterestNode featureOfInterestNode = this.foiToNodeMap.get(foi);
        if (featureOfInterestNode != null) {
            this.getChildren().remove((Object)featureOfInterestNode);
            Logger.info("Removed FeatureOfInterest named <" + foi.getName() + ">.");
        }
    }

    protected void updateFeatureOfInterest(FeatureOfInterest foi) {
    }

    protected void clearTopology() {
        this.getChildren().clear();
        this.foiToNodeMap.clear();
    }

    protected void updateFeatureOfInterestList(FeatureOfInterestList oldList, FeatureOfInterestList newList) {
        this.clearTopology();
        if (oldList != null) {
            oldList.eAdapters().remove((Object)this.getAdapter());
        }
        if (newList != null) {
            newList.eAdapters().add((Object)this.getAdapter());
            for (FeatureOfInterest foi : newList.getFeaturesOfInterest()) {
                this.addFeatureOfInterest(foi);
            }
        }
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof FeatureOfInterestList && msg.getFeatureID(FeatureOfInterestList.class) == 3) {
                        switch (msg.getEventType()) {
                            case 3: {
                                FeatureOfInterest foi = (FeatureOfInterest)msg.getNewValue();
                                FeatureOfInterestListNodeCustomImpl.this.addFeatureOfInterest(foi);
                                break;
                            }
                            case 5: {
                                Collection resultsAdded = (Collection)msg.getNewValue();
                                for (FeatureOfInterest foi : resultsAdded) {
                                    FeatureOfInterestListNodeCustomImpl.this.addFeatureOfInterest(foi);
                                }
                                break;
                            }
                            case 4: {
                                FeatureOfInterest foi = (FeatureOfInterest)msg.getOldValue();
                                FeatureOfInterestListNodeCustomImpl.this.removeFeatureOfInterest(foi);
                                break;
                            }
                            case 6: {
                                Collection resultsRemoved = (Collection)msg.getOldValue();
                                for (FeatureOfInterest foi : resultsRemoved) {
                                    FeatureOfInterestListNodeCustomImpl.this.removeFeatureOfInterest(foi);
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

